﻿#include	<AjxCpp.h>

using namespace AjxControl;

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	チップテキスト	スタティック コントロール																	//
//																												//
//--------------------------------------------------------------------------------------------------------------//

//--- AjcTipCtl.h ---//

//----- マルチスレッドの許可／禁止
BOOL			SAjxTip::EnableMultiThread(BOOL fEnable)
{
	return	AjcTipTextEnableMultiThread	(fEnable);
}

//----- ツールチップ表示位置モードの設定
AJCTIP_POSMODE	SAjxTip::SetTipPosMode (AJCTIP_POSMODE PosMode)
{
	return	AjcTipTextSetTipPosMode		(PosMode);
}

//----- ツールチップの関連付け(ASCII)
BOOL	 		SAjxTip::Add(HWND hCtrl, C_BCP pTxt, int msDelay, int msShow, HFONT hFont, COLORREF TextColor, COLORREF BackGround, COLORREF BorderColor)
{
	return	AjcTipTextAddExA			(hCtrl, pTxt, msDelay, msShow, hFont, TextColor, BackGround, BorderColor);
}
//----- ツールチップの関連付け(UNICODE)
BOOL	 		SAjxTip::Add(HWND hCtrl, C_WCP pTxt, int msDelay, int msShow, HFONT hFont, COLORREF TextColor, COLORREF BackGround, COLORREF BorderColor)
{
	return	AjcTipTextAddExW			(hCtrl, pTxt, msDelay, msShow, hFont, TextColor, BackGround, BorderColor);
}

//----- ツールチップ表示条件の設定
BOOL	 		SAjxTip::SetShowAlways(HWND hCtrl, BOOL fShowAlways)
{
	return	AjcTipTextSetShowAlways		(hCtrl, fShowAlways);
}
//----- ツールチップ表示条件の取得
BOOL	 		SAjxTip::GetShowAlways(HWND hCtrl)
{
	return	AjcTipTextGetShowAlways		(hCtrl);
}

//----- 全ツールチップ表示条件の設定
VO				SAjxTip::SetShowForActive(BOOL fShowForActive)
{
	return	AjcTipTextSetShowForActive	(fShowForActive);
}
//----- 全ツールチップ表示条件の取得
BOOL	 		SAjxTip::GetShowForActive(VO)
{
	return	AjcTipTextGetShowForActive	();
}
//----- チップテキストの表示許可／禁止設定
BOOL			SAjxTip::Enable			(HWND hCtrl, BOOL fEnable)
{
	return	AjcTipTextEnable(hCtrl, fEnable);
}
//----- チップテキストの表示許可／禁止状態取得
BOOL			SAjxTip::GetEnableState	(HWND hCtrl)
{
	return AjcTipTextGetEnableState(hCtrl);
}
//----- 全てのチップテキストの表示許可／禁止設定
VO				SAjxTip::EnableAll		 (BOOL fEnable)
{
	 AjcTipTextEnableAll(fEnable);
}
//----- 全てのチップテキストの表示許可／禁止状態取得
BOOL			SAjxTip::GetEnableAllState(VO)
{
	return AjcTipTextGetEnableAllState();
}
//----- 特定のツールチップの関連付け解除
BOOL	 		SAjxTip::Remove(HWND hCtrl)
{
	return	AjcTipTextRemove			(hCtrl);
}

//----- 全てのツールチップの関連付け解除
BOOL	 		SAjxTip::Remove()
{
	return	AjcTipTextRemoveAll			();
}

//----- ツールチップの関連付け情報取得(ASCII)
UI	 			SAjxTip::GetInfo(HWND hCtrl, PAJCTIPINFO pInfoBuf, BCP pTxtBuf, UI lTxtBuf)
{
	return	AjcTipTextGetInfoA			(hCtrl, pInfoBuf, pTxtBuf, lTxtBuf);
}
//----- ツールチップの関連付け情報取得(UNICODE)
UI	 			SAjxTip::GetInfo(HWND hCtrl, PAJCTIPINFO pInfoBuf, WCP pTxtBuf, UI lTxtBuf)
{
	return	AjcTipTextGetInfoW			(hCtrl, pInfoBuf, pTxtBuf, lTxtBuf);
}

//----- サブクラス化の通知情報設定
BOOL			SAjxTip::SetNtcSubclass(HWND hCtrl, HWND hNtc, UI msg, UX lParam)
{
	return	AjcTipTextSetNtcSubclass	(hCtrl, hNtc, msg, lParam);
}
//----- サブクラス化の通知情報消去
BOOL			SAjxTip::ClrNtcSubclass(HWND hCtrl)
{
	return	AjcTipTextClrNtcSubclass	(hCtrl);
}

//----- コントロール間移動猶予時間設定
VO	 			SAjxTip::SetWindowTime(int msTime)
{
	return	AjcTipTextSetWindowTime		(msTime);
}
//----- コントロール間移動猶予時間取得
int	 			SAjxTip::GetWindowTime()
{
	return	AjcTipTextGetWindowTime		();
}

//----- デフォルトの表示遅延時間の設定
VO	 			SAjxTip::SetDefMsDelay(int msDelay)
{
	return	AjcTipTextSetDefMsDelay		(msDelay);
}
//----- デフォルトの表示遅延時間の取得
int	 			SAjxTip::GetDefMsDelay(VO)
{
	return	AjcTipTextGetDefMsDelay		();
}


//--- AjcTipTxt.h ---//

//----- ツールチップの表示(ASCII)
BOOL	 	SAjxTip::Show(int x, int y, C_BCP pTxt, int msTime, HFONT hFont, COLORREF TextColor, COLORREF BackGround, COLORREF BorderColor)
{
	return	AjcTipTextShowExA			(x, y, 0, 0, pTxt, msTime, hFont, TextColor, BackGround, BorderColor);
}
BOOL	 	SAjxTip::Show(int x, int y, int minWidth, int height, C_BCP pTxt, int msTime, HFONT hFont, COLORREF TextColor, COLORREF BackGround, COLORREF BorderColor)
{
	return	AjcTipTextShowExA			(x, y, minWidth, height, pTxt, msTime, hFont, TextColor, BackGround, BorderColor);
}
//----- ツールチップの表示(UNICODE)
BOOL	 	SAjxTip::Show(int x, int y, C_WCP pTxt, int msTime, HFONT hFont, COLORREF TextColor, COLORREF BackGround, COLORREF BorderColor)
{
	return	AjcTipTextShowExW			(x, y, 0, 0, pTxt, msTime, hFont, TextColor, BackGround, BorderColor);
}
BOOL	 	SAjxTip::Show(int x, int y, int minWidth, int height, C_WCP pTxt, int msTime, HFONT hFont, COLORREF TextColor, COLORREF BackGround, COLORREF BorderColor)
{
	return	AjcTipTextShowExW			(x, y, minWidth, height, pTxt, msTime, hFont, TextColor, BackGround, BorderColor);
}

//----- ツールチップをウインド中央に表示(ASCII)
BOOL	 	SAjxTip::ShowCenter(HWND hwnd,							 C_BCP pTxt, int msTime, HFONT hFont, COLORREF TextColor, COLORREF BackGround, COLORREF BorderColor)
{
	return	AjcTipTextShowCenterExA		(hwnd, 0, 0, pTxt, msTime, hFont, TextColor, BackGround, BorderColor);
}
BOOL	 	SAjxTip::ShowCenter(HWND hwnd, int minWidth, int height, C_BCP pTxt, int msTime, HFONT hFont, COLORREF TextColor, COLORREF BackGround, COLORREF BorderColor)
{
	return	AjcTipTextShowCenterExA		(hwnd, minWidth, height, pTxt, msTime, hFont, TextColor, BackGround, BorderColor);
}
//----- ツールチップをウインド中央に表示(UNICODE)
BOOL	 	SAjxTip::ShowCenter(HWND hwnd,							 C_WCP pTxt, int msTime, HFONT hFont, COLORREF TextColor, COLORREF BackGround, COLORREF BorderColor)
{
	return	AjcTipTextShowCenterExW		(hwnd, 0, 0, pTxt, msTime, hFont, TextColor, BackGround, BorderColor);
}

BOOL	 	SAjxTip::ShowCenter(HWND hwnd, int minWidth, int height, C_WCP pTxt, int msTime, HFONT hFont, COLORREF TextColor, COLORREF BackGround, COLORREF BorderColor)
{
	return	AjcTipTextShowCenterExW		(hwnd, minWidth, height, pTxt, msTime, hFont, TextColor, BackGround, BorderColor);
}

//----- ツールチップの表示サイズ取得(ASCII)
BOOL	 	SAjxTip::GetSize(C_BCP pTxt, HFONT hFont, BOOL fBorder, LPSIZE pBuf)
{
	return	AjcTipTextGetSizeA			(pTxt, hFont, fBorder, pBuf);
}
//----- ツールチップの表示サイズ取得(UNICODE)
BOOL	 	SAjxTip::GetSize(C_WCP pTxt, HFONT hFont, BOOL fBorder, LPSIZE pBuf)
{
	return	AjcTipTextGetSizeW			(pTxt, hFont, fBorder, pBuf);
}

//----- ツールチップウインドを移動
VO	 		SAjxTip::Move(int x, int y)
{
	return	AjcTipTextMove				(x, y);
}

//----- マウスカーソルをツールチップウインド上へ移動
VO	 		SAjxTip::MoveCursor()
{
	return	AjcTipTextMoveCursor(AJCTIP_CM_CENT);
}
VO	 		SAjxTip::MoveCursor(AJCTIP_CURMOVE cm)
{
	return	AjcTipTextMoveCursor		(cm);
}

//----- ツールチップ非表示
VO	 		SAjxTip::Hide()
{
	return	AjcTipTextHide				();
}

//----- ツールチップウインドの矩形情報取得
BOOL	 	SAjxTip::GetRect(LPRECT pRect)
{
	return	AjcTipTextGetRect			(pRect);
}

//----- パレット色の設定
BOOL	 	SAjxTip::SetPalette(int ix, COLORREF color)
{
	return	AjcTipTextSetPalette		(ix, color);
}
//----- パレット色の取得
COLORREF	SAjxTip::GetPalette(int ix)
{
	return	AjcTipTextGetPalette		(ix);
}

//----- デフォルトのテキスト表示色設定
VO	 		SAjxTip::SetDefTextColor  (COLORREF color)
{
	return	AjcTipTextSetDefTextColor	(color);
}
//----- デフォルトのテキスト表示色取得
COLORREF	SAjxTip::GetDefTextColor  ()
{
	return	AjcTipTextGetDefTextColor	();
}

//----- デフォルトの外枠表示色設定
VO	 		SAjxTip::SetDefBorderColor(COLORREF color)
{
	return	AjcTipTextSetDefBorderColor	(color);
}
//----- デフォルトの外枠表示色取得
COLORREF	SAjxTip::GetDefBorderColor()
{
	return	AjcTipTextGetDefBorderColor	();
}

//----- デフォルトの背景表示色設定
VO	 		SAjxTip::SetDefBkColor	  (COLORREF color)
{
	return	AjcTipTextSetDefBkColor		(color);
}
//----- デフォルトの背景表示色取得
COLORREF	SAjxTip::GetDefBkColor	  ()
{
	return	AjcTipTextGetDefBkColor		();
}

//----- デフォルトフォントの設定
VO	 		SAjxTip::SetDefFont		  (HFONT hFont)
{
	return	AjcTipTextSetDefFont	(hFont);
}
//----- デフォルトフォントの取得
HFONT	 	SAjxTip::GetDefFont		  ()
{
	return	AjcTipTextGetDefFont		();
}

//----- デフォルトの表示時間の設定
VO	 		SAjxTip::SetDefMsShow	  (int msShow)
{
	return	AjcTipTextSetDefMsShow	(msShow);
}
//----- デフォルトの表示時間の取得
int	 		SAjxTip::GetDefMsShow	  ()
{
	return	AjcTipTextGetDefMsShow	();
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	状況依存チップテキスト	コントロール 																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//

//--------------------------------------------------------------------------------------------------------------//
//	コールバック（カーソル位置チェック）																		//
//--------------------------------------------------------------------------------------------------------------//
static	int CALLBACK cbChkCursor(HWND hCtrl, LPPOINT ptClient, UX cbp)
{
	CAjxTip*	p = (CAjxTip*)cbp;
	return p->OnChkCursor(hCtrl, ptClient);
}
//--------------------------------------------------------------------------------------------------------------//
//	コールバック（チップテキスト取得要求）																		//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
static	C_BCP CALLBACK cbGetTextA(HWND hCtrl, BCP pBuf, UI lBuf, UX cbp)
{
	CAjxTip*	p = (CAjxTip*)cbp;
	p->OnNeedText(hCtrl, pBuf, lBuf);
	return pBuf;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
static	C_WCP CALLBACK cbGetTextW(HWND hCtrl, WCP pBuf, UI lBuf, UX cbp)
{
	CAjxTip*	p = (CAjxTip*)cbp;
	p->OnNeedText(hCtrl, pBuf, lBuf);
	return pBuf;
}


//	コンストラクタ
CAjxTip::CAjxTip(BOOL fUnicode)
{
	m_fUnicode = fUnicode;
}
//	デストラクタ
CAjxTip::~CAjxTip()
{
}
//	アタッチ（コントロールハンドル充当）
VO		CAjxTip::Attach(HWND hCtrl)
{
	m_hCtrl = hCtrl;
	if (m_fUnicode) {	//	UNICODE
		AjcTipTextAddW		  (hCtrl, L"");
		AjcTipTextSetCallBackW(hCtrl, (UX)this, cbChkCursor, cbGetTextW);
	}
	else {				//	ASCII
		AjcTipTextAddA		  (hCtrl, "");
		AjcTipTextSetCallBackA(hCtrl, (UX)this, cbChkCursor, cbGetTextA);
	}
}
//	カーソル位置チェック
BOOL	CAjxTip::OnChkCursor(HWND hCtrl, LPPOINT ptClient)
{
	return TRUE;
}
//	ツールチップテキスト取得要求(ASCII)
VO		CAjxTip::OnNeedText (HWND hCtrl, BCP pBuf, UI lBuf)
{
	*pBuf = 0;
}
//	ツールチップテキスト取得要求(UNICODE)
VO		CAjxTip::OnNeedText (HWND hCtrl, WCP pBuf, UI lBuf)
{
	*pBuf = 0;
}

