﻿#include	<AjxCpp.h>

#define	PROP_NAME_PARENT	"_AjcVthSubClassed_"
#define	PROP_NAME_CTRL		"_AjcVthWndProp_"

using namespace AjxControl;

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	親ウインドのサブクラス・プロシージャ																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_VTH, WM_COMMAND			)
{
	CAjxVth*	p = (CAjxVth*)::GetPropA((HWND)lParam, PROP_NAME_CTRL);

	if (p != NULL) {
		HWND	hCtrl = (HWND)lParam;
		switch (HIWORD(wParam)) {
			case AJCVTHN_DBLCLK:		p->OnNtcDblClk	(AjcVthGetNtcDblClk (hCtrl) 						  ); break;	//	ダブルクリック通知
			case AJCVTHN_KEYIN:			p->OnNtcKeyIn	(AjcVthGetNtcKey	(hCtrl), AjcVthGetNtcKeyRep(hCtrl)); break;	//	キー入力通知
			case AJCVTHN_VKEYIN: 		p->OnNtcVKeyIn	(AjcVthGetNtcKey	(hCtrl), AjcVthGetNtcKeyRep(hCtrl)); break;	//	拡張キー押下通知
			case AJCVTHN_VKEYOUT:		p->OnNtcVKeyOut	(AjcVthGetNtcKey	(hCtrl) 						  ); break;	//	拡張キー離し通知
			case AJCVTHN_DROPFILE:		p->OnNtcDropFile(AjcVthGetNtcFiles	(hCtrl) 						  ); break;	//	ファイルドロップ通知
			case AJCVTHN_DROPDIR:		p->OnNtcDropDir	(AjcVthGetNtcDirs	(hCtrl) 						  ); break;	//	フォルダドロップ通知
			case AJCVTHN_CHARINFO:		p->OnNtcCharInfo(AjcVthGetNtcCyLine (hCtrl) 						  ); break;	//	文字情報変化通知
			case AJCVTHN_HSCROLL:		p->OnNtcHScroll	(AjcVthGetNtcLeft	(hCtrl) 						  ); break;	//	横スクロール通知
			case AJCVTHN_VSCROLL:		p->OnNtcVScroll	(AjcVthGetNtcTop	(hCtrl) 						  ); break;	//	縦スクロール通知
			case AJCVTHN_RCLICK:		p->OnNtcRClick	(AjcVthGetNtcRClk	(hCtrl) 						  ); break;	//	右クリック通知
			case AJCVTHN_CLEAR:			p->OnNtcClear	(													  ); break;	//	画面クリアー通知
		}
	}
	return MAjcMmpCallOrgWndProc(SBC_VTH);
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(SBC_VTH, WM_DESTROY			)
{
	//	親ウインドのプロパティ消去
	if (::GetPropA(hwnd, PROP_NAME_PARENT) != NULL) {
		::RemovePropA(hwnd, PROP_NAME_PARENT);
	}
	return MAjcMmpCallOrgWndProc(SBC_VTH);
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SBC_VTH)
	AJC_WNDMAP_MSG(SBC_VTH, WM_COMMAND	   )
	AJC_WNDMAP_MSG(SBC_VTH, WM_DESTROY	   )
AJC_WNDMAP_END

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxVth::CAjxVth(BOOL fUnicode)
{
	m_fUnicode = fUnicode;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxVth::~CAjxVth()
{
	//	コントロールウインドのプロパティ削除
	if (::GetPropA(m_hCtrl, PROP_NAME_CTRL) != NULL) ::RemovePropA(m_hCtrl, PROP_NAME_CTRL);
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	メンバ関数																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- プロパティ設定 -----------------------------------------------------------------------------------------//
BOOL		CAjxVth::SetProp 			(PCAJCVTHPROP pProp)
{
	return AjcVthSetProp		(m_hCtrl, pProp);
}
//----- プロパティ取得 -----------------------------------------------------------------------------------------//
BOOL		CAjxVth::GetProp 			(PAJCVTHPROP  pBuf )
{
	return AjcVthGetProp		(m_hCtrl, pBuf);
}
//----- ＶＲＡＭにフィットしたウインドサイズ取得 ---------------------------------------------------------------//
BOOL		CAjxVth::GetVramFitSize		(UIP pWidth, UIP pHeight)
{
	return AjcVthGetVramFitSize	(m_hCtrl, pWidth, pHeight);
}

//----- １文字描画(ASCII) --------------------------------------------------------------------------------------//
BOOL		CAjxVth::PutChar			(BC c)
{
	return AjcVthPutCharA		(m_hCtrl, c);
}
//----- １文字描画(UNICODE) ------------------------------------------------------------------------------------//
BOOL		CAjxVth::PutChar			(WC c)
{
	return AjcVthPutCharW		(m_hCtrl, c);
}

//----- マルチバイト文字コードを自動判別してテキスト描画(ASCII) ------------------------------------------------//
BOOL		CAjxVth::PutTextAuto		(C_BCP pTxt, UI lTxt)
{
	return AjcVthPutTextAuto	(m_hCtrl, pTxt, lTxt);
}
//----- 日本語ＥＵＣコードテキスト描画					(ASCII) ------------------------------------------------//
BOOL		CAjxVth::PutTextEUC			(C_BCP pTxt, UI lTxt)
{
	return AjcVthPutTextEUC		(m_hCtrl, pTxt, lTxt);
}
//----- ＵＴＦ－８コードテキスト描画					(ASCII) ------------------------------------------------//
BOOL		CAjxVth::PutTextUTF8		(C_BCP pTxt, UI lTxt)
{
	return AjcVthPutTextUTF8	(m_hCtrl, pTxt, lTxt);
}

//----- テキスト描画(ASCII) ------------------------------------------------------------------------------------//
BOOL		CAjxVth::PutText			(C_BCP pTxt, UI lTxt)
{
	return AjcVthPutTextA		(m_hCtrl, pTxt, lTxt);
}
//----- テキスト描画(UNICODE) ----------------------------------------------------------------------------------//
BOOL		CAjxVth::PutText			(C_WCP pTxt, UI lTxt)
{
	return AjcVthPutTextW		(m_hCtrl, pTxt, lTxt);
}

//----- 書式テキスト描画(ASCII) --------------------------------------------------------------------------------//
BOOL		CAjxVth::PrintF 			(C_BCP pFmt, ...)
{
	va_list 	 vls;
	BC			 txt[1024] = {0};

	va_start(vls, pFmt);
	AjcVSnPrintFA(txt, 1024, pFmt, vls);
	txt[1023] = 0;
	va_end	(vls);

	return AjcVthPutTextA		(m_hCtrl, txt, -1);
}
//----- 書式テキスト描画(UNICODE) ------------------------------------------------------------------------------//
BOOL		CAjxVth::PrintF 			(C_WCP pFmt, ...)
{
	va_list 	 vls;
	WC			 txt[1024] = {0};

	va_start(vls, pFmt);
	AjcVSnPrintFW(txt, 1024, pFmt, vls);
	txt[1023] = 0;
	va_end	(vls);

	return AjcVthPutTextW		(m_hCtrl, txt, -1);
}

//----- タイムスタンプ描画 -------------------------------------------------------------------------------------//
BOOL		CAjxVth::TimeStamp			()
{
	return AjcVthTimeStamp		(m_hCtrl);
}
//----- バイナリデータの１６進ダンプ描画 -----------------------------------------------------------------------//
BOOL		CAjxVth::HexDump 			(C_VOP pDat, UI lDat)
{
	return AjcVthHexDump		(m_hCtrl, pDat, lDat);
}

//----- カーソル位置設定 ---------------------------------------------------------------------------------------//
BOOL		CAjxVth::Locate				(UI line, UI col)
{
	return AjcVthLocate			(m_hCtrl, line, col);
}
//----- テキスト描画用パレット設定 -----------------------------------------------------------------------------//
BOOL		CAjxVth::SetColor			(UI PaletteNo)
{
	return AjcVthSetColor		(m_hCtrl, PaletteNo);
}
//----- 文字背景描画用パレット設定 -----------------------------------------------------------------------------//
BOOL		CAjxVth::SetBkColor			(UI PaletteNo)
{
	return AjcVthSetBkColor		(m_hCtrl, PaletteNo);
}
//----- パレットの色コード設定 ---------------------------------------------------------------------------------//
BOOL		CAjxVth::SetPalette			(UI PaletteNo, COLORREF rgb)
{
	return AjcVthSetPalette		(m_hCtrl, PaletteNo, rgb);
}

//----- カーソル位置取得 ---------------------------------------------------------------------------------------//
UI			CAjxVth::GetCursorPos		(UIP pLine, UIP pCol)
{
	return AjcVthGetCursorPos	(m_hCtrl, pLine, pCol);
}
//----- テキスト描画用パレット番号取得 -------------------------------------------------------------------------//
UI			CAjxVth::GetColor			()
{
	return AjcVthGetColor		(m_hCtrl);
}
//----- 文字背景描画用パレット番号取得 -------------------------------------------------------------------------//
UI			CAjxVth::GetBkColor			()
{
	return AjcVthGetBkColor		(m_hCtrl);
}
//----- パレットの色コード取得 ---------------------------------------------------------------------------------//
COLORREF	CAjxVth::GetPalette			(UI PaletteNo)
{
	return AjcVthGetPalette		(m_hCtrl, PaletteNo);
}

//----- 部分テキストを選択 -------------------------------------------------------------------------------------//
BOOL		CAjxVth::Select				(UI slp, UI scp, UI elp, UI ecp)
{
	return AjcVthSelect			(m_hCtrl, slp, scp, elp, ecp);
}
//----- 全てのテキストを選択 -----------------------------------------------------------------------------------//
BOOL		CAjxVth::SelectAll			()
{
	return AjcVthSelectAll		(m_hCtrl);
}
//----- 選択テキストをクリップボードへコピー -------------------------------------------------------------------//
BOOL		CAjxVth::CopyText			()
{
	return AjcVthCopyText		(m_hCtrl);
}
//----- ダイアログによるフォントの設定 -------------------------------------------------------------------------//
BOOL		CAjxVth::SetFont 			()
{
	return AjcVthSetFont		(m_hCtrl);
}
//----- キャレット表示／非表示 ---------------------------------------------------------------------------------//
BOOL		CAjxVth::ShowCaret			(BOOL fShow)
{
	return AjcVthShowCaret		(m_hCtrl, fShow);
}
//----- 全テキストクリアー -------------------------------------------------------------------------------------//
BOOL		CAjxVth::Clear				()
{
	return AjcVthClear			(m_hCtrl);
}
//----- 全テキストクリアー -------------------------------------------------------------------------------------//
BOOL		CAjxVth::ClearAllText		()
{
	return AjcVthClearAllText	(m_hCtrl);
}

//----- ドロップされたファイル名取得(ASCII) --------------------------------------------------------------------//
BOOL		CAjxVth::GetDroppedFile		(BC buf[MAX_PATH])
{
	return AjcVthGetDroppedFileA(m_hCtrl, buf);
}
//----- ドロップされたファイル名取得(UNICODE) ------------------------------------------------------------------//
BOOL 		CAjxVth::GetDroppedFile		(WC buf[MAX_PATH])
{
	return AjcVthGetDroppedFileW(m_hCtrl, buf);
}

//----- ドロップされたディレクトリ名取得(ASCII) ----------------------------------------------------------------//
BOOL		CAjxVth::GetDroppedDir		(BC buf[MAX_PATH], BOOL fTailIsDelimiter)
{
	return AjcVthGetDroppedDirExA	(m_hCtrl, buf, fTailIsDelimiter);
}
//----- ドロップされたディレクトリ名取得(UNICODE) --------------------------------------------------------------//
BOOL		CAjxVth::GetDroppedDir		(WC buf[MAX_PATH], BOOL fTailIsDelimiter)
{
	return AjcVthGetDroppedDirExW	(m_hCtrl, buf, fTailIsDelimiter);
}

//----- プロファイルからプロパティ値読出し(ASCII) --------------------------------------------------------------//
BOOL		CAjxVth::LoadProp			(C_BCP pProfileSect, PCAJCVTHPROPA pDefProp)
{
	return AjcVthLoadPropA		(m_hCtrl, pProfileSect, pDefProp);
}
//----- プロファイルからプロパティ値読出し(UNICODE) ------------------------------------------------------------//
BOOL		CAjxVth::LoadProp			(C_WCP pProfileSect, PCAJCVTHPROPW pDefProp)
{
	return AjcVthLoadPropW		(m_hCtrl, pProfileSect, pDefProp);
}
//----- プロファイルへプロパティ書き込み(ASCII) ----------------------------------------------------------------//
BOOL		CAjxVth::SaveProp			(C_BCP pProfileSect)
{
	return AjcVthSavePropA		(m_hCtrl, pProfileSect);
}
//----- プロファイルへプロパティ書き込み(UNICODE) --------------------------------------------------------------//
BOOL		CAjxVth::SaveProp			(C_WCP pProfileSect)
{
	return AjcVthSavePropW		(m_hCtrl, pProfileSect);
}

//----- 設定情報の読み出し(ASCII) ------------------------------------------------------------------------------//
BOOL		CAjxVth::LoadPermInfo		(C_BCP pProfileSect, C_BCP pKeyPrefix, UI PermItem)
{
	return AjcVthLoadPermInfoExA(m_hCtrl, pProfileSect, pKeyPrefix, PermItem);
}
//----- 設定情報の読み出し(UNICODE) ----------------------------------------------------------------------------//
BOOL		CAjxVth::LoadPermInfo		(C_WCP pProfileSect, C_WCP pKeyPrefix, UI PermItem)
{
	return AjcVthLoadPermInfoExW(m_hCtrl, pProfileSect, pKeyPrefix, PermItem);
}

//----- 設定情報の書き込み -------------------------------------------------------------------------------------//
BOOL		CAjxVth::SavePermInfo		()
{
	return AjcVthSavePermInfo	(m_hCtrl);
}

//----- 右クリックによるポップアップメニューの許可／禁止 -------------------------------------------------------//
BOOL		CAjxVth::EnablePopupMenu	(BOOL fEnable)
{
	return AjcVthEnablePopupMenu(m_hCtrl, fEnable);
}
//----- 右クリック通知設定 -------------------------------------------------------------------------------------//
BOOL		CAjxVth::SetNtcRClk	   		(BOOL fNtcRClk, UI MsgRBDown, UI MsgRBUp)
{
	return AjcVthSetNtcRClk		(m_hCtrl, fNtcRClk, MsgRBDown, MsgRBUp);
}

//----- テキストの取得(ASCII) ----------------------------------------------------------------------------------//
UI			CAjxVth::GetText			(BCP pBuf, UI lBuf)	
{
	return AjcVthGetTextA		(m_hCtrl, pBuf, lBuf);
}
//----- テキストの取得(UNICODE) --------------------------------------------------------------------------------//
UI			CAjxVth::GetText			(WCP pBuf, UI lBuf)
{
	return AjcVthGetTextW		(m_hCtrl, pBuf, lBuf);
}

//----- 選択されているテキストの取得(ASCII) --------------------------------------------------------------------//
UI			CAjxVth::GetSelectedText	(BCP pBuf, UI lBuf)
{
	return AjcVthGetSelectedTextA(m_hCtrl, pBuf, lBuf);
}
//----- 選択されているテキストの取得(UNICODE) ------------------------------------------------------------------//
UI			CAjxVth::GetSelectedText	(WCP pBuf, UI lBuf)
{
	return AjcVthGetSelectedTextW(m_hCtrl, pBuf, lBuf);
}

//----- ダブルクリックした行位置のテキスト取得(ASCII) ----------------------------------------------------------//
UI			CAjxVth::GetDblClickedLine	(BCP pBuf, UI lBuf)
{
	return AjcVthGetDblClickedLineA(m_hCtrl, pBuf, lBuf);
}
//----- ダブルクリックした行位置のテキスト取得(UNICODE) --------------------------------------------------------//
UI			CAjxVth::GetDblClickedLine	(WCP pBuf, UI lBuf)
{
	return AjcVthGetDblClickedLineW(m_hCtrl, pBuf, lBuf);
}

//----- ダブルクリックした行位置のテキスト取得(ASCII) ----------------------------------------------------------//
UI			CAjxVth::GetDblClickedLine	(BCP pBuf, UI lBuf, UIP pLine, UIP pCol)
{
	return AjcVthGetDblClickedLineExA(m_hCtrl, pBuf, lBuf, pLine, pCol);
}
//----- ダブルクリックした行位置のテキスト取得(UNICODE) --------------------------------------------------------//
UI			CAjxVth::GetDblClickedLine	(WCP pBuf, UI lBuf, UIP pLine, UIP pCol)
{
	return AjcVthGetDblClickedLineExW(m_hCtrl, pBuf, lBuf, pLine, pCol);
}

//----- ツールチップの設定(ASCII) ------------------------------------------------------------------------------//
BOOL		CAjxVth::SetTipText			(C_BCP pTxt)
{
	return AjcVthSetTipTextA	(m_hCtrl, pTxt);
}
//----- ツールチップの設定(UNICODE) ----------------------------------------------------------------------------//
BOOL		CAjxVth::SetTipText			(C_WCP pTxt)
{
	return AjcVthSetTipTextW	(m_hCtrl, pTxt);
}

//----- ツールチップの取得(ASCII) ------------------------------------------------------------------------------//
BOOL		CAjxVth::GetTipText			(BCP pBuf, UI lBuf)
{
	return AjcVthGetTipTextA	(m_hCtrl, pBuf, lBuf);
}
//----- ツールチップの取得(UNICODE) ----------------------------------------------------------------------------//
BOOL		CAjxVth::GetTipText			(WCP pBuf, UI lBuf)
{
	return AjcVthGetTipTextW	(m_hCtrl, pBuf, lBuf);
}

//----- ツールチップ表示条件の設定 -----------------------------------------------------------------------------//
BOOL		CAjxVth::SetTipShowAlways	(BOOL fShowAlways)
{
	return AjcVthSetTipShowAlways(m_hCtrl, fShowAlways);
}
//----- ツールチップ表示条件の取得 -----------------------------------------------------------------------------//
BOOL		CAjxVth::GetTipShowAlways	()
{
	return AjcVthGetTipShowAlways(m_hCtrl);
}
//----- フォント情報の設定(ASCII) ------------------------------------------------------------------------------//
BOOL		CAjxVth::SetFontInfo			(const LOGFONTA *pLogFont)
{
	return AjcVthSetFontInfoA(m_hCtrl, pLogFont, -1);
}
//----- フォント情報の設定(ASCII，行間スペース) ----------------------------------------------------------------//
BOOL		CAjxVth::SetFontInfo			(const LOGFONTA *pLogFont, UI LSpace)
{
	return AjcVthSetFontInfoA(m_hCtrl, pLogFont, LSpace);
}

//----- フォント情報の設定(UNICODE) ----------------------------------------------------------------------------//
BOOL		CAjxVth::SetFontInfo			(const LOGFONTW *pLogFont)
{
	return AjcVthSetFontInfoW(m_hCtrl, pLogFont, -1);
}
//----- フォント情報の設定(UNICODE，行間スペース) --------------------------------------------------------------//
BOOL		CAjxVth::SetFontInfo			(const LOGFONTW *pLogFont, UI LSpace)
{
	return AjcVthSetFontInfoW(m_hCtrl, pLogFont, LSpace);
}

//----- フォント情報の取得(ASCII) ------------------------------------------------------------------------------//
UI			CAjxVth::GetFontInfo			(LPLOGFONTA *pBuf)
{
	UI		rc = 0;
	UI		lsp;
	if (lsp = AjcVthGetFontInfoA(m_hCtrl, pBuf, &lsp)) {
		rc = lsp;
	}
	return rc;
}
//----- フォント情報の取得(UNICODE) ----------------------------------------------------------------------------//
UI			CAjxVth::GetFontInfo			(LPLOGFONTW *pBuf)
{
	UI		rc = 0;
	UI		lsp;
	if (lsp = AjcVthGetFontInfoW(m_hCtrl, pBuf, &lsp)) {
		rc = lsp;
	}
	return rc;
}

//----- 文字サイズ／行の高さ取得 -------------------------------------------------------------------------------//
BOOL		CAjxVth::GetCharInfo 		(UIP pCx, UIP pCy, UIP pLy)
{
	return AjcVthGetCharInfo	(m_hCtrl, pCx, pCy, pLy);
}
//----- ウインドに表示可能な行数の取得 -------------------------------------------------------------------------//
UI			CAjxVth::GetLinesPerWindow	()
{
	return AjcVthGetLinesPerWindow(m_hCtrl);
}
//----- バッファに格納されている有効な行数の取得 ---------------------------------------------------------------//
UI			CAjxVth::GetValidLines		()
{
	return AjcVthGetValidLines	(m_hCtrl);
}
//----- ウインド先頭行の位置取得（０～） -----------------------------------------------------------------------//
UI			CAjxVth::GetIxOfWndTopLine	()
{
	return AjcVthGetIxOfWndTopLine(m_hCtrl);
}

//----- タイトル文字列の設定(ASCII) ----------------------------------------------------------------------------//
BOOL		CAjxVth::SetTitleText		(C_BCP pTitleText, COLORREF TextColor, COLORREF BackColor, HFONT hFont)
{
	return AjcVthSetTitleTextA	(m_hCtrl, pTitleText, TextColor, BackColor, hFont);
}
//----- タイトル文字列の設定(UNICODE) --------------------------------------------------------------------------//
BOOL		CAjxVth::SetTitleText		(C_WCP pTitleText, COLORREF TextColor, COLORREF BackColor, HFONT hFont)
{
	return AjcVthSetTitleTextW	(m_hCtrl, pTitleText, TextColor, BackColor, hFont);
}

//----- テキストをファイルへ書き込み(ASCII) --------------------------------------------------------------------//
BOOL		CAjxVth::SaveTextToFile		(C_BCP pPath, BOOL fAllText, EAJCTEC tec, BOOL fBom)
{
	return AjcVthSaveTextToFileA(m_hCtrl, pPath, fAllText, tec, fBom);
}
//----- テキストをファイルへ書き込み(UNICODE) ------------------------------------------------------------------//
BOOL		CAjxVth::SaveTextToFile		(C_WCP pPath, BOOL fAllText, EAJCTEC tec, BOOL fBom)
{
	return AjcVthSaveTextToFileW(m_hCtrl, pPath, fAllText, tec, fBom);
}

//----- テキストをＨＴＭＬファイルへ書き込み(ASCII) ------------------------------------------------------------//
BOOL		CAjxVth::SaveHtmlToFile		(C_BCP pPath, BOOL fAllText, UI FontSize)
{
	return AjcVthSaveHtmlToFileA(m_hCtrl, pPath, fAllText, FontSize);
}
//----- テキストをＨＴＭＬファイルへ書き込み(UNICODE) ----------------------------------------------------------//
BOOL		CAjxVth::SaveHtmlToFile		(C_WCP pPath, BOOL fAllText, UI FontSize)
{
	return AjcVthSaveHtmlToFileW(m_hCtrl, pPath, fAllText, FontSize);
}

//----- ＥＳＣシーケンスを付加し全テキストをファイルへ書込み(ASCII) --------------------------------------------//
BOOL		CAjxVth::SaveAllTextWithEsc	(C_BCP pPath, EAJCTEC tec, BOOL fBom)
{
	return AjcVthSaveAllTextWithEscA	(m_hCtrl, pPath, tec, fBom);
}
//----- ＥＳＣシーケンスを付加し全テキストをファイルへ書込み(UNICODE) ------------------------------------------//
BOOL		CAjxVth::SaveAllTextWithEsc	(C_WCP pPath, EAJCTEC tec, BOOL fBom)
{
	return AjcVthSaveAllTextWithEscW	(m_hCtrl, pPath, tec, fBom);
}

//----- バッファに格納されている行数の取得 ---------------------------------------------------------------------//
UI			CAjxVth::GetLineCount		()
{
	return AjcVthGetLineCount	(m_hCtrl);
}

//----- カーソル位置の行番号と桁位置取得(ASCII) ----------------------------------------------------------------//
BOOL		CAjxVth::GetCursorPosInfo	(UIP pLine, UIP pCol)
{
	BOOL	rc = FALSE;
	rc = AjcVthGetCursorPosInfo(m_hCtrl, pLine, pCol);
	return rc;
}
//----- 指定行位置の行テキスト取得(ASCII) ----------------------------------------------------------------------//
UI			CAjxVth::GetLineText		(UI pos, BCP pBuf, UI lBuf)
{
	return AjcVthGetLineTextA	(m_hCtrl, pos, pBuf, lBuf);
}
//----- 指定行位置の行テキスト取得(UNICODE) --------------------------------------------------------------------//
UI			CAjxVth::GetLineText		(UI pos, WCP pBuf, UI lBuf)
{
	return AjcVthGetLineTextW	(m_hCtrl, pos, pBuf, lBuf);
}

//----- 縦スクロール位置の取得 ---------------------------------------------------------------------------------//
UI			CAjxVth::GetVScrollPos		()
{
	return AjcVthGetVScrollPos	(m_hCtrl);
}
//----- 横スクロール位置の取得 ---------------------------------------------------------------------------------//
UI			CAjxVth::GetHScrollPos		()
{
	return AjcVthGetHScrollPos	(m_hCtrl);
}

//----- 縦スクロール位置の設定 ---------------------------------------------------------------------------------//
BOOL		CAjxVth::SetVScrollPos		(UI pos)
{
	return AjcVthSetVScrollPos	(m_hCtrl, pos);
}
//----- 横スクロール位置の設定 ---------------------------------------------------------------------------------//
BOOL		CAjxVth::SetHScrollPos		(UI pos)
{
	return AjcVthSetHScrollPos	(m_hCtrl, pos);
}

//----- 表示ウインドサイズ（行数，文字数）取得 -----------------------------------------------------------------//
BOOL		CAjxVth::GetWindowSize		(LPSIZE pSize)
{
	return AjcVthGetWindowSize	(m_hCtrl, pSize);
}

//----- 文字列の後方検索(ASCII) --------------------------------------------------------------------------------//
UI			CAjxVth::SearchBelow		(C_BCP pStr, BC delimiter)
{
	return AjcVthSearchBelowA	(m_hCtrl, pStr, delimiter);
}
//----- 文字列の後方検索(UNICODE) ------------------------------------------------------------------------------//
UI			CAjxVth::SearchBelow		(C_WCP pStr, WC delimiter)
{
	return AjcVthSearchBelowW	(m_hCtrl, pStr, delimiter);
}

//----- 文字列の前方検索(ASCII) --------------------------------------------------------------------------------//
UI			CAjxVth::SearchAbove		(C_BCP pStr, BC delimiter)
{
	return AjcVthSearchAboveA	(m_hCtrl, pStr, delimiter);
}
//----- 文字列の前方検索(UNICODE) ------------------------------------------------------------------------------//
UI			CAjxVth::SearchAbove		(C_WCP pStr, WC delimiter)
{
	return AjcVthSearchAboveW	(m_hCtrl, pStr, delimiter);
}

//----- 画面表示の停止／再開 -----------------------------------------------------------------------------------//
BOOL		CAjxVth::Pause				(BOOL fPause)
{
	return AjcVthPause			(m_hCtrl, fPause);
}

//----- 改行動作の設定をポップアップメニューに含めるか否かの設定 -----------------------------------------------//
BOOL		CAjxVth::SetLFActInPopupMenu(BOOL flag)
{
	return AjcVthSetLFActInPopupMenu(m_hCtrl, flag);
}
//----- 改行動作の設定をポップアップメニューに含めるか否かの取得 -----------------------------------------------//
BOOL		CAjxVth::GetLFActInPopupMenu()
{
	return AjcVthGetLFActInPopupMenu(m_hCtrl);
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	仮想関数																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- アタッチ　----------------------------------------------------------------------------------------------//
VO		CAjxVth::Attach		(HWND hWnd)					//	ハンドルを関連付け
{
	HWND	hParent;
	BC		cname[256];

	m_hCtrl   = NULL;

	if (::IsWindow(hWnd)) {
		::GetClassNameA(hWnd, cname, sizeof cname);
		if (::strcmp(cname, "AjcCtrlVT100") == 0) {
			//	ワーク初期化
			m_hCtrl = hWnd;
			hParent = ::GetParent(hWnd);
			//	コントロールに this ポインタを関連付ける
			::SetPropA(m_hCtrl, PROP_NAME_CTRL, (HANDLE)this);
			//	親ウインドをサブクラス化（重複サブクラス抑止）
			if (::GetPropA(hParent, PROP_NAME_PARENT) == NULL) {
				MAjcMmpSetSubclass(SBC_VTH, hParent);
				::SetPropA(hParent, PROP_NAME_PARENT, (HANDLE)this);
			}
		}
		else throw std::runtime_error("VTH cannot be generated due to an invalid window class.");
	}
	else throw std::runtime_error("VTH cannot be generated due to an invalid window handle.");
}
//----- ダブルクリック通知 -------------------------------------------------------------------------------------//
VO	CAjxVth::OnNtcDblClk	(UI flag)
{
}
//----- キー入力通知 -------------------------------------------------------------------------------------------//
VO	CAjxVth::OnNtcKeyIn		(UI key, UI rep)
{
}
//----- 拡張キー押下通知 ---------------------------------------------------------------------------------------//
VO	CAjxVth::OnNtcVKeyIn	(UI key, UI rep)
{
}
//----- 拡張キー離し通知 ---------------------------------------------------------------------------------------//
VO	CAjxVth::OnNtcVKeyOut	(UI key)
{
}
//----- ファイルドロップ通知 -----------------------------------------------------------------------------------//
VO	CAjxVth::OnNtcDropFile	(UI 			nFiles )
{
}
//----- ディレクトリドロップ通知 -------------------------------------------------------------------------------//
VO	CAjxVth::OnNtcDropDir	(UI 			nDirs  )
{
}
//----- 文字サイズ情報の変化通知 -------------------------------------------------------------------------------//
VO	CAjxVth::OnNtcCharInfo	(UI				heught )
{
}
//----- 横スクロール通知 ---------------------------------------------------------------------------------------//
VO	CAjxVth::OnNtcHScroll	(UI				left   )
{
}
//----- 縦スクロール通知 ---------------------------------------------------------------------------------------//
VO	CAjxVth::OnNtcVScroll	(UI				top    )
{
}
//----- 右クリック通知 -----------------------------------------------------------------------------------------//
VO	CAjxVth::OnNtcRClick	(PCAJCVTHRCLK	pRClk  )
{
}
//----- 画面クリアー通知 ---------------------------------------------------------------------------------------//
VO	CAjxVth::OnNtcClear				()
{
}
