﻿#include	<AjxCpp.h>

using namespace AjxControl;


//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック（イベント通知）																				//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO CALLBACK cbNotice(UI knd, UX Param, UX cbp)
{
	CAjxXym*	p = (CAjxXym*)cbp;
	return p->OnNotice(knd, Param);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック（ファイル情報取得要求）																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
static VO CALLBACK cbGetFileA(PAJCXYMFILEINFOA pBuf, UX cbp)
{
	CAjxXym*	p = (CAjxXym*)cbp;
	p->OnGetFile(pBuf);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
static VO CALLBACK cbGetFileW(PAJCXYMFILEINFOW pBuf, UX cbp)
{
	CAjxXym*	p = (CAjxXym*)cbp;
	p->OnGetFile(pBuf);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック（ファイルデータ取得要求）																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static VO CALLBACK cbGetData(VOP pBuf, UI len, UIP pBytes, UX cbp)
{
	CAjxXym*	p = (CAjxXym*)cbp;
	p->OnGetData(pBuf, len, pBytes);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コールバック（データ送出要求）																				//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static VO  CALLBACK cbSend(C_VOP pTxD, UI len, UX cbp)
{
	CAjxXym*	p = (CAjxXym*)cbp;
	p->OnSend(pTxD, len);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxXym::CAjxXym(BOOL fUnicode) 
{
	m_fUnicode = fUnicode;

	if (fUnicode) {		//	For UNICODE
		m_hXym = AjcXymCreateW((UX)this, cbNotice, cbGetFileW, cbGetData, cbSend);
	}
	else {				//	For ASCII
		m_hXym = AjcXymCreateA((UX)this, cbNotice, cbGetFileA, cbGetData, cbSend);
	}

	if (m_hXym == NULL) {
		throw std::runtime_error("XYM cannot creation.");
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デストラクタ																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
CAjxXym::~CAjxXym()
{
	if (m_hXym != NULL) {
		AjcXymDelete(m_hXym);
		m_hXym = NULL;
	}
}

//----- メンバ関数 ---------------------------------------------------------------------------------------------//
//	送信時タイマ情報取得
VO		CAjxXym::GetTxTimeInfo	(UIP t0, UIP r0, UIP t1, UIP r1)
{
	AjcXymGetTxTimeInfo(m_hXym, t0, r0, t1, r1);
}
//	送信時タイマ情報設定
VO		CAjxXym::SetTxTimeInfo	(UI  t0, UI  r0, UI  t1, UI  r1)
{
	AjcXymSetTxTimeInfo(m_hXym, t0, r0, t1, r1);
}
//	受信時タイマ情報取得
VO		CAjxXym::GetRxTimeInfo	(UIP t0, UIP r0, UIP t1, UIP r1)
{
	AjcXymGetRxTimeInfo(m_hXym, t0, r0, t1, r1);
}
//	受信時タイマ情報設定
VO		CAjxXym::SetRxTimeInfo	(UI  t0, UI  r0, UI  t1, UI  r1)
{
	AjcXymSetRxTimeInfo(m_hXym, t0, r0, t1, r1);
}

//	ファイル送信開始
BOOL	CAjxXym::TxStart		(AJCXYMPROTOCOL Protocol)
{
	return AjcXymTxStart(m_hXym, Protocol);
}
//	ファイル受信開始
BOOL	CAjxXym::RxStart		(AJCXYMPROTOCOL Protocol)
{
	return AjcXymRxStart(m_hXym, Protocol);
}
//	ファイル転送中止
VO		CAjxXym::Stop		()
{
	AjcXymStop(m_hXym);
}
//	シリアル回線からの受信データ投与
VO		CAjxXym::PutRxChar	(UI rxd)
{
	AjcXymPutRxChar(m_hXym, rxd);
}
//	シリアル回線への送信完了を通知（ＹＭＯＤＥＭ－Ｇ専用）
VO		CAjxXym::TxEnd		()
{
	AjcXymTxEnd(m_hXym);
}
//----- 仮想関数 -----------------------------------------------------------------------------------------------//
//	イベント通知
VO		CAjxXym::OnNotice	(UI knd, UX Param				)
{
}
//	ファイル情報取得要求(ASCII)
VO		CAjxXym::OnGetFile	(PAJCXYMFILEINFOA pBuf			)
{
}
//	ファイル情報取得要求(UNICODE)
VO		CAjxXym::OnGetFile	(PAJCXYMFILEINFOW pBuf			)
{
}
//	ファイルデータ取得要求
VO		CAjxXym::OnGetData	(VOP pBuf, UI lBuf, UIP pBytes	)
{
}
//	データ送出要求
VO		CAjxXym::OnSend		(C_VOP pTxD, UI lTxD			)
{
}
