﻿//
//	SW_3dVec.c
//

#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

#define		BLUE		0
#define		RED			1
#define		GREEN		2
#define		YELLOW		5
#define		GRAY		6
#define		BLACK		7

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
HWND			hDlgMain;						//	ダイアログボックスハンドル
HWND			hWndCtrl;						//	３Ｄグラフコントロールのウインドハンドル
int 			CtrlLeft;						//	３Ｄグラフコントロールの上端位置

AJC3DVEC		vs;								//	視点ベクトル

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;
	int 	sty;
	RECT	rect;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	sty = (int)MAjcGetWindowLong(hDlgMain, GWL_STYLE);
	MAjcSetWindowLong(hDlgMain, GWL_STYLE, sty | WS_THICKFRAME);
	//----- ３Ｄグラフコントロール位置初期化 -----------//
	GetWindowRect(hWndCtrl, &rect);
	MapWindowPoints(NULL, hDlgMain, (LPPOINT)&rect, 2);
	CtrlLeft = rect.left;
	GetClientRect(hDlgMain, &rect);
	MoveWindow(hWndCtrl, CtrlLeft, 0, rect.right - rect.left - CtrlLeft, rect.bottom - rect.top, TRUE);
	//----- ダイアログ表示 -----------------------------//
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	AJC3DVEC	lo	= {-1.0, -1.0, -1.0};
	AJC3DVEC	hi	= { 1.0,  1.0,	1.0};
	AJC3DVEC	rot = {  60,   10,	 45};

	hDlgMain = hDlg;
	hWndCtrl = GetDlgItem(hDlgMain, IDC_3DGRAPH);
	AjcG3dSetTipText(hWndCtrl, TEXT("３Ｄグラフィック"));

	//----- ３Ｄグラフモード設定 ------------//
	AjcG3dInitV(hWndCtrl, &lo, &hi, &rot, (AJC3DGS_AXIS));

	//----- 球表示色（グレー）を薄く設定 ----//
	AjcG3dSetColor (hWndCtrl, GRAY, RGB(230, 230, 230), RGB(250, 250, 250));

	//----- ４点の座標値設定 ----------------//
	AjcSetDlgItemReal(hDlg, IDC_TXT_X1,  0.52, 2);
	AjcSetDlgItemReal(hDlg, IDC_TXT_Y1, -0.28, 2);
	AjcSetDlgItemReal(hDlg, IDC_TXT_Z1,  0.55, 2);

	AjcSetDlgItemReal(hDlg, IDC_TXT_X2,  0.45, 2);
	AjcSetDlgItemReal(hDlg, IDC_TXT_Y2,  0.47, 2);
	AjcSetDlgItemReal(hDlg, IDC_TXT_Z2, -0.23, 2);

	AjcSetDlgItemReal(hDlg, IDC_TXT_X3, -0.34, 2);
	AjcSetDlgItemReal(hDlg, IDC_TXT_Y3,  0.59, 2);
	AjcSetDlgItemReal(hDlg, IDC_TXT_Z3,  0.13, 2);

	AjcSetDlgItemReal(hDlg, IDC_TXT_X4, -0.40, 2);
	AjcSetDlgItemReal(hDlg, IDC_TXT_Y4, -0.80, 2);
	AjcSetDlgItemReal(hDlg, IDC_TXT_Z4, -0.50, 2);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	AjcReleaseDlgProps(hDlg);
	PostQuitMessage(0);
	return TRUE;
}
//----- サイズ変更 ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_SIZE			)
{
	int 	w = LOWORD(lParam);
	int 	h = HIWORD(lParam);
	
	MoveWindow	(GetDlgItem(hDlg, IDC_3DGRAPH), CtrlLeft, 0, w - CtrlLeft, h, TRUE);

	return TRUE;
}
//----- 「平面円算出」ボタン -----------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_CIR		)
{
	AJC3DVEC		p1, p2, p3, vc, vh, v1, v2;
	double			r;
	AJC3DCIRINFO	cif;

	//	３点設定
	p1.x = AjcGetDlgItemReal(hDlg, IDC_TXT_X1);
	p1.y = AjcGetDlgItemReal(hDlg, IDC_TXT_Y1);
	p1.z = AjcGetDlgItemReal(hDlg, IDC_TXT_Z1);

	p2.x = AjcGetDlgItemReal(hDlg, IDC_TXT_X2);
	p2.y = AjcGetDlgItemReal(hDlg, IDC_TXT_Y2);
	p2.z = AjcGetDlgItemReal(hDlg, IDC_TXT_Z2);

	p3.x = AjcGetDlgItemReal(hDlg, IDC_TXT_X3);
	p3.y = AjcGetDlgItemReal(hDlg, IDC_TXT_Y3);
	p3.z = AjcGetDlgItemReal(hDlg, IDC_TXT_Z3);

	//	円の中心と半径算出
	r = AjcV3dCalcCircleVEx(&p1, &p2, &p3, &vc, &vh, &cif);

	//	円の中心と半径値表示
	AjcSetDlgItemReal(hDlg, IDC_TXT_CX, vc.x, 2);
	AjcSetDlgItemReal(hDlg, IDC_TXT_CY, vc.y, 2);
	AjcSetDlgItemReal(hDlg, IDC_TXT_CZ, vc.z, 2);
	AjcSetDlgItemReal(hDlg, IDC_TXT_R , r	, 2);

	//	描画クリアー
	AjcG3dClearAllShape(hWndCtrl);
	//	３点描画
	AjcG3dPixelV (hWndCtrl, BLUE, &p1, 3);
	AjcG3dPixelV (hWndCtrl, BLUE, &p2, 3);
	AjcG3dPixelV (hWndCtrl, BLUE, &p3, 3);
	//	円に内接する２つの直線描画
	AjcG3dLineV  (hWndCtrl, BLACK, &cif.lc1.p1, &cif.lc1.p2);
	AjcG3dLineV  (hWndCtrl, BLACK, &cif.lc2.p1, &cif.lc2.p2);
	//	２つの直線の中点からの垂線描画
	AjcG3dLineV  (hWndCtrl, BLACK, &cif.lt1.p1, &cif.lt1.p2);
	AjcG3dLineV  (hWndCtrl, BLACK, &cif.lt2.p1, &cif.lt2.p2);
	//	平面の定義
	AjcG3dDefPlaneV(hWndCtrl, BLACK, &cif.lvc, NULL);
	//	円と円の中心描画
	AjcG2dEllipse(hWndCtrl, BLACK, 0, 0, cif.cr, cif.cr);
	AjcG2dPixel  (hWndCtrl, BLACK, 0, 0, 3);

	//	平面の法線設定
	AjcV3dSub(&p2, &p1, &v1);			//	v1 = p1→p2 ベクトル
	AjcV3dSub(&p3, &p1, &v2);			//	v2 = p1→p3 ベクトル
	AjcV3dOuter(&v1, &v2, &vs);			//	法線算出
	AjcV3dNormal(&vs, &vs);
	AjcV3dMult	(&vs, 0.5, &vs);

	//	平面の法線描画
	AjcV3dAdd(&vs, &cif.lvc.p, &v1);
	AjcG3dArrowV(hWndCtrl, YELLOW, &cif.lvc.p, &v1);


	return TRUE;
}
//----- 「球体算出」ボタン -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SPH		)
{
	AJC3DVEC		p1, p2, p3, p4, vc, v1, v2;
	double			r;
	AJC3DSPHINFO	sif;

	//	４点設定
	p1.x = AjcGetDlgItemReal(hDlg, IDC_TXT_X1);
	p1.y = AjcGetDlgItemReal(hDlg, IDC_TXT_Y1);
	p1.z = AjcGetDlgItemReal(hDlg, IDC_TXT_Z1);

	p2.x = AjcGetDlgItemReal(hDlg, IDC_TXT_X2);
	p2.y = AjcGetDlgItemReal(hDlg, IDC_TXT_Y2);
	p2.z = AjcGetDlgItemReal(hDlg, IDC_TXT_Z2);

	p3.x = AjcGetDlgItemReal(hDlg, IDC_TXT_X3);
	p3.y = AjcGetDlgItemReal(hDlg, IDC_TXT_Y3);
	p3.z = AjcGetDlgItemReal(hDlg, IDC_TXT_Z3);

	p4.x = AjcGetDlgItemReal(hDlg, IDC_TXT_X4);
	p4.y = AjcGetDlgItemReal(hDlg, IDC_TXT_Y4);
	p4.z = AjcGetDlgItemReal(hDlg, IDC_TXT_Z4);

	//	球の中心と半径算出
	r = AjcV3dCalcSphereVEx(&p1, &p2, &p3, &p4, &vc, &sif);

	//	球の中心と半径値表示
	AjcSetDlgItemReal(hDlg, IDC_TXT_CX, vc.x, 2);
	AjcSetDlgItemReal(hDlg, IDC_TXT_CY, vc.y, 2);
	AjcSetDlgItemReal(hDlg, IDC_TXT_CZ, vc.z, 2);
	AjcSetDlgItemReal(hDlg, IDC_TXT_R , r	, 2);

	//	描画クリアー
	AjcG3dClearAllShape(hWndCtrl);
	//	４点描画
	AjcG3dPixelV (hWndCtrl, BLUE, &p1, 3);
	AjcG3dPixelV (hWndCtrl, BLUE, &p2, 3);
	AjcG3dPixelV (hWndCtrl, BLUE, &p3, 3);
	AjcG3dPixelV (hWndCtrl, BLUE, &p4, 3);

	//	２つの円描画
	AjcG3dDefPlaneV(hWndCtrl, RED, &sif.cif1.lvc, NULL);
	AjcG2dEllipse  (hWndCtrl, RED, 0, 0, sif.cif1.cr, sif.cif1.cr);
	AjcG2dPixel    (hWndCtrl, RED, 0, 0, 3);

	AjcG3dDefPlaneV(hWndCtrl, RED, &sif.cif2.lvc, NULL);
	AjcG2dEllipse  (hWndCtrl, RED, 0, 0, sif.cif2.cr, sif.cif2.cr);
	AjcG2dPixel    (hWndCtrl, RED, 0, 0, 3);

	//	２つの円中心からの法線描画
	AjcG3dLineV  (hWndCtrl, BLUE, &sif.ls1.p1, &sif.ls1.p2);
	AjcG3dLineV  (hWndCtrl, BLUE, &sif.ls2.p1, &sif.ls2.p2);

	//	球と球の中心描画
	AjcG3dSphereV(hWndCtrl, GRAY , &vc, r, r, r, 8, 8);
	AjcG3dPixelV (hWndCtrl, GREEN, &vc, 3);

	//	２つの円を真横から見るための法線設定
	AjcV3dSub(&vc			 , &sif.cif1.lvc.p, &v1);		//	v1 = 球中心 →円1中心 ベクトル
	AjcV3dSub(&sif.cif2.lvc.p, &sif.cif1.lvc.p, &v2);		//	v2 = 円1中心→円2中心 ベクトル
	AjcV3dOuter(&v1, &v2, &vs);								//	法線算出
	AjcV3dNormal(&vs, &vs);
	AjcV3dMult	(&vs, 0.5, &v1);

	//	法線描画
	AjcV3dAdd(&vs, &vc, &v1);
	AjcG3dArrowV(hWndCtrl, YELLOW, &vc, &v1);

	return TRUE;
}
//----- 「視点設定ボタン」ボタン -------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_ANGLE		)
{
	AjcG3dSetAngleV(hWndCtrl, &vs);
	return TRUE;
}
//----- キャンセル ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	   )
	AJC_DLGMAP_MSG(Main, WM_SIZE		   )
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_CIR	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_SPH	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_ANGLE	   )
	AJC_DLGMAP_CMD(Main, IDCANCEL		   )
AJC_DLGMAP_END

