﻿//
//	SW_AvlStringC.c
//
#include	<AjrCstXX.h>
#include	<stdio.h>
#include	<conio.h>
#include	<time.h>
#include	<tchar.h>

//----- ワーク -------------------------------------------------------------------------------------------------//
static	HAJCAVL 	hAvl = NULL;

//----- ノード比較コールバック関数 -----------------------------------------------------------------------------//
static int CALLBACK cbComp(UX key1, UX key2, UX cbp)
{
	return _tcscmp((C_UTP)key1, (C_UTP)key2);
}
//----- ノード削除時のコールバック関数 ------------------------------------------------------------------------//
static	VO	 CALLBACK cbRemove(UX key, VOP pData, UI len, UI nest, UX cbp)
{
	AjcPrintF(TEXT("Deleted   - \"%s\", nest=%d\n"), (UTP)key, nest);
}
//----- 全ノード取得（全ノードプリント）用コールバック関数 -----------------------------------------------------//
static BOOL CALLBACK cbPrintNode(UX key, VOP pData, UI len, UI nest, UX cbp)
{
	PAJCAVLNODE pNode = ((PAJCAVLNODE)pData) - 1;
	UX			data;

	AjcAvlGetStrNodeData(hAvl, (UTP)key, &data);
	AjcPrintF(TEXT("%*s \"%s\", d=%lld, %d\n"), nest * 6, TEXT(" "), (UTP)key, (ULL)data, pNode->bal);
	return TRUE;
}
//----- 文字列入力通知 -----------------------------------------------------------------------------------------//
static VO CALLBACK cbNtcArgs(int argc, UT *argv[], C_UTP pTxt, UX cbp)
{
	//	入力テキスト表示
	AjcPrintF(TEXT("%s\n"), pTxt);
	//	コマンド実行
	if (argc >= 1) {
		//	ノード挿入
		if		(_tcsicmp(argv[0], TEXT("I")) == 0) {
			if (argc == 2) {
				if (!AjcAvlInsStrNode(hAvl, argv[1])) {
					AjcPrintF(TEXT("ノードの挿入を失敗しました。\n"));
				}
			}
			else AjcPrintF(TEXT("*** Invalid parameter.\n"));
		}
		//	ノードの挿入／置換
		else if (_tcsicmp(argv[0], TEXT("X")) == 0) {
			if (argc == 2) {
				if (!AjcAvlInsOrGetStrNode(hAvl, argv[1])) {
					AjcPrintF(TEXT("ノードの挿入／置換を失敗しました。\n"));
				}
			}
			else AjcPrintF(TEXT("*** Invalid parameter.\n"));
		}
		//	ノード削除
		else if (_tcsicmp(argv[0], TEXT("D"))  == 0) {
			if (argc == 2) {
				if (!AjcAvlDelStrNode(hAvl, argv[1])) {
					AjcPrintF(TEXT("ノードの削除を失敗しました。\n"));
				}
			}
			else AjcPrintF(TEXT("*** Invalid parameter.\n"));
		}
		//	ノードへデータ関連付け
		else if (_tcsicmp(argv[0], TEXT("M"))  == 0) {
			if (argc == 3) {
				if (!AjcAvlSetStrNodeData(hAvl, argv[1], _ttoi(argv[2]))) {
					AjcPrintF(TEXT("ノードへデータ関連付けを失敗しました。\n"));
				}
			}
			else AjcPrintF(TEXT("*** Invalid parameter.\n"));
		}
		//	全ノード破棄
		else if (_tcsicmp(argv[0], TEXT("A"))  == 0) {
			if (!AjcAvlDelAllNodes(hAvl)) {
				AjcPrintF(TEXT("全ノードの削除を失敗しました。\n"));
			}
		}
		//	全ノード表示
		else if (_tcsicmp(argv[0], TEXT("P"))  == 0) {
			AjcAvlEnumNodes(hAvl, cbPrintNode, TRUE);
		}
		//	その他
		else {
			AjcPrintF(TEXT("*** Invalid command.\n"));
		}
	}
}
//----- コンソール強制終了ハンドラ -----------------------------------------------------------------------------//
static BOOL CALLBACK cbConApExit(DWORD CtrlType)
{
	//	ＡＶＬインスタンス消去
	if (hAvl != NULL) {
		AjcAvlDelete(hAvl);
		hAvl = NULL;
	}
	return FALSE;	//	FALSE : 次のハンドラをコール
}
//==============================================================================================================//
int  AjcMain(int argc, UTP argv[])
{
	AjcSetStdoutMode();

	//----- コンソール強制終了ハンドラ設定 ---------------------------------------------------------------------//
	SetConsoleCtrlHandler(cbConApExit, TRUE);

	//----- インスタンス生成 -----------------------------------------------------------------------------------//
	hAvl = AjcAvlCreate(0, cbComp, cbRemove);

	//	コマンドメニュー
	AjcPrintF(TEXT("\n 以下のコマンドを入力してください。\n\n"));
	AjcPrintF(TEXT("  I   nnn     : ノード挿入, key=nnn\n"));
	AjcPrintF(TEXT("  X   nnn     : ノードの挿入／取得, key=\"nnn\"\n"));
	AjcPrintF(TEXT("  D   nnn     : ノード削除　,  key=\"nnn\"\n"));
	AjcPrintF(TEXT("  M   nnn  d  : データ関連付,  key=\"nnn\", data=d\n"));
	AjcPrintF(TEXT("  A           : 全ノードを破棄\n"));
	AjcPrintF(TEXT("  P           : 全ノード表示\n"));
	AjcPrintF(TEXT("  <ESC>キー   : 終了\n"));
	AjcPrintF(TEXT("\n"));

	//----- 初期ノード登録／表示 -------------------------------------------------------------------------------//
	AjcAvlInsStrNode(hAvl, TEXT("050"));
	AjcAvlInsStrNode(hAvl, TEXT("060"));
	AjcAvlInsStrNode(hAvl, TEXT("070"));
	AjcAvlInsStrNode(hAvl, TEXT("080"));
	AjcAvlInsStrNode(hAvl, TEXT("090"));
	AjcAvlInsStrNode(hAvl, TEXT("100"));
	AjcAvlEnumNodes(hAvl, cbPrintNode, TRUE);

	//----- コマンド処理 ---------------------------------------------------------------------------------------//
	AjcPrintF(TEXT("Input(%2d) : "), AjcAvlGetCount(hAvl));
	while (AjcConInputByNtc(0, cbNtcArgs)) {
		AjcPrintF(TEXT("Input(%2d) : "), AjcAvlGetCount(hAvl));
	}
	if (hAvl != NULL) {
		AjcAvlDelete(hAvl);
		hAvl = NULL;
	}

	return 0;
}
