﻿//
//	SW_AvsTreeC.c
//
#include	<AjrCstXX.h>
#include	<stdio.h>
#include	<conio.h>
#include	<time.h>
#include	<tchar.h>

//----- ワーク -------------------------------------------------------------------------------------------------//
static	HAJCAVS 	hAvs = NULL;

//----- ノードデータ形式 ---------------------------------------------------------------------------------------//
typedef struct {
	UTP 	pTimStr;			//	ヒープ上の時刻文字列へのポインタ
} NODEDATA, *PNODEDATA;

//----- ノード削除時のコールバック関数 -------------------------------------------------------------------------//
static	VO	 CALLBACK cbRemove(C_UTP pKey, VOP pData, UI len, UI nest, UX cbp)
{
	AjcPrintF(TEXT("Deleted   - key='%s', len=%d, nest=%d, data='%s'\n"), pKey, len, nest, ((PNODEDATA)pData)->pTimStr);
	AjcTFree(((PNODEDATA)pData)->pTimStr);
}
//----- 全ノード取得（全ノードプリント）用コールバック関数 -----------------------------------------------------//
static BOOL CALLBACK cbPrintNode(C_UTP pKey, VOP pData, UI len, UI nest, UX cbp)
{
	PAJCAVLNODE pNode = ((PAJCAVLNODE)pData) - 1;

	AjcPrintF(TEXT("%-26s:%*s, %d\n"), ((PNODEDATA)pData)->pTimStr, nest * 6, pKey, pNode->bal);
	return TRUE;
}
//----- 現在時刻文字列生成（現在時刻文字列を格納した、動的メモリへのポインタを返す）----------------------------//
static	UTP		GetTimeStr(VO)
{
	UTP			rc;
	SYSTEMTIME	st;
	UI			len;
	UT			szTim[64];

	GetLocalTime(&st);
	AjcSnPrintF(szTim, AJCTSIZE(szTim), TEXT("%02d:%02d:%02d.%03d"), st.wHour, st.wMinute, st.wSecond, st.wMilliseconds);
	len = (UI)_tcslen(szTim) + 1;
	MAjcStrCpy(rc = AjcTAlloc(len), len, szTim);
	return rc;
}
//----- 文字列入力通知 -----------------------------------------------------------------------------------------//
static VO CALLBACK cbNtcArgs(int argc, UT *argv[], C_UTP pTxt, UX cbp)
{
	NODEDATA	Node;

	//	入力テキスト表示
	AjcPrintF(TEXT("%s\n"), pTxt);
	//	コマンド実行
	if (argc >= 1) {
		//	ノード挿入
		if		(_tcsicmp(argv[0], TEXT("I")) == 0) {
			if (argc == 2) {
				Node.pTimStr = GetTimeStr();
				if (!AjcAvsInsNode(hAvs, argv[1], &Node, sizeof Node)) {
					if (Node.pTimStr != NULL) AjcTFree(Node.pTimStr); Node.pTimStr = NULL;
					AjcPrintF(TEXT("ノードの挿入を失敗しました。\n"));
				}
			}
			else AjcPrintF(TEXT("*** Invalid parameter.\n"));
		}
		//	ノード置換
		else if (_tcsicmp(argv[0], TEXT("R")) == 0) {
			if (argc == 2) {
				Node.pTimStr = GetTimeStr();
				if (!AjcAvsRepNode(hAvs, argv[1], &Node, sizeof Node)) {
					if (Node.pTimStr != NULL) AjcTFree(Node.pTimStr); Node.pTimStr = NULL;
					AjcPrintF(TEXT("ノードの置換を失敗しました。\n"));
				}
			}
			else AjcPrintF(TEXT("*** Invalid parameter.\n"));
		}
		//	ノードの挿入／置換
		else if (_tcsicmp(argv[0], TEXT("X")) == 0) {
			if (argc == 2) {
				Node.pTimStr = GetTimeStr();
				if (!AjcAvsInsOrRepNode(hAvs, argv[1], &Node, sizeof Node)) {
					if (Node.pTimStr != NULL) AjcTFree(Node.pTimStr); Node.pTimStr = NULL;
					AjcPrintF(TEXT("ノードの挿入／置換を失敗しました。\n"));
				}
			}
			else AjcPrintF(TEXT("*** Invalid parameter.\n"));
		}
		//	ノード削除
		else if (_tcsicmp(argv[0], TEXT("D"))  == 0) {
			if (argc == 2) {
				if (!AjcAvsDelNode(hAvs, argv[1])) {
					AjcPrintF(TEXT("ノードの削除を失敗しました。\n"));
				}
			}
			else AjcPrintF(TEXT("*** Invalid parameter.\n"));
		}
		//	全ノード破棄
		else if (_tcsicmp(argv[0], TEXT("A"))  == 0) {
			if (!AjcAvsDelAllNodes(hAvs)) {
				AjcPrintF(TEXT("全ノードの削除を失敗しました。\n"));
			}
		}
		//	全ノード表示
		else if (_tcsicmp(argv[0], TEXT("P"))  == 0) {
			AjcAvsEnumNodes(hAvs, cbPrintNode, TRUE);
		}
		//	その他
		else {
			AjcPrintF(TEXT("*** Invalid command.\n"));
		}
	}
}
//----- コンソール強制終了ハンドラ -----------------------------------------------------------------------------//
static BOOL CALLBACK cbConApExit(DWORD CtrlType)
{
	//	ＡＶＬインスタンス消去
	if (hAvs != NULL) {
		AjcAvsDelete(hAvs);
		hAvs = NULL;
	}
	return FALSE;	//	FALSE : 次のハンドラをコール
}
//==============================================================================================================//
int  AjcMain(int argc, UTP argv[])
{
	NODEDATA	Node;

	AjcSetStdoutMode();

	//----- コンソール強制終了ハンドラ設定 ---------------------------------------------------------------------//
	SetConsoleCtrlHandler(cbConApExit, TRUE);

	//----- インスタンス生成 -----------------------------------------------------------------------------------//
	hAvs = AjcAvsCreate(AJCCMP_ALPHABETIC, 0, cbRemove);

	//	コマンドメニュー
	AjcPrintF(TEXT("\n 以下のコマンドを入力してください。\n\n"));
	AjcPrintF(TEXT("  I   SSSSS  : ノード挿入, key=\"SSSSS\"\n"));
	AjcPrintF(TEXT("  R   SSSSS  : ノード置換, key=\"SSSSS\"\n"));
	AjcPrintF(TEXT("  X   SSSSS  : ノードの挿入／置換, key=\"SSSSS\"\n"));
	AjcPrintF(TEXT("  D   SSSSS  : ノード削除, key=\"SSSSS\"\n"));
	AjcPrintF(TEXT("  A          : 全ノードを破棄\n"));
	AjcPrintF(TEXT("  P          : 全ノード表示\n"));
	AjcPrintF(TEXT("  <ESC>キー  : 終了\n"));
	AjcPrintF(TEXT("\n"));

	//----- 初期ノード登録／表示 -------------------------------------------------------------------------------//
	Node.pTimStr = AjcTAlloc(16); MAjcStrCpy(Node.pTimStr, 16, TEXT("Pre-Inited AAA"));	AjcAvsInsNode(hAvs, TEXT("AAA"), &Node, sizeof Node);
	Node.pTimStr = AjcTAlloc(16); MAjcStrCpy(Node.pTimStr, 16, TEXT("Pre-Inited BBB"));	AjcAvsInsNode(hAvs, TEXT("BBB"), &Node, sizeof Node);
	Node.pTimStr = AjcTAlloc(16); MAjcStrCpy(Node.pTimStr, 16, TEXT("Pre-Inited CCC"));	AjcAvsInsNode(hAvs, TEXT("CCC"), &Node, sizeof Node);
	Node.pTimStr = AjcTAlloc(16); MAjcStrCpy(Node.pTimStr, 16, TEXT("Pre-Inited DDD"));	AjcAvsInsNode(hAvs, TEXT("DDD"), &Node, sizeof Node);
	Node.pTimStr = AjcTAlloc(16); MAjcStrCpy(Node.pTimStr, 16, TEXT("Pre-Inited EEE"));	AjcAvsInsNode(hAvs, TEXT("EEE"), &Node, sizeof Node);
	Node.pTimStr = AjcTAlloc(16); MAjcStrCpy(Node.pTimStr, 16, TEXT("Pre-Inited FFF"));	AjcAvsInsNode(hAvs, TEXT("FFF"), &Node, sizeof Node);
	AjcAvsEnumNodes(hAvs, cbPrintNode, TRUE);

	//----- コマンド処理 ---------------------------------------------------------------------------------------//
	AjcPrintF(TEXT("Input(%2d) : "), AjcAvsGetCount(hAvs));
	while (AjcConInputByNtc(0, cbNtcArgs)) {
		AjcPrintF(TEXT("Input(%2d) : "), AjcAvsGetCount(hAvs));
	}
	if (hAvs != NULL) {
		AjcAvsDelete(hAvs);
		hAvs = NULL;
	}

	return 0;
}


