﻿//
//	SW_Broadcast1.c
//
#include	<AjrCstXX.h>
#include	<tchar.h>

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
HINSTANCE		hInst		= NULL; 				//	インスタンスハンドル
HWND			hWndMain	= NULL; 				//	ウインドハンドル
UI				MsgRwm		= 0;					//	ブロードキャストメッセージコード
UI				TimeCount	= 0;					//	１秒タイマカウンタ
HBRUSH			hBrush		= NULL; 				//	ブラシハンドル

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(Main);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 		msg;
	WNDCLASS	wndclass;

	hInst = hInstance;

	//----- バックウインド生成 -------------------------//
	wndclass.style			= 0;
	wndclass.lpfnWndProc	= AJC_WNDPROC_NAME(Main);
	wndclass.cbClsExtra 	= 0;
	wndclass.cbWndExtra 	= 0;
	wndclass.hInstance		= hInst;
	wndclass.hIcon			= NULL;
	wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
	wndclass.lpszMenuName	= NULL;
	wndclass.lpszClassName	= TEXT("SW_Broadcast1");
	RegisterClass(&wndclass);

	hWndMain = CreateWindow(TEXT("SW_Broadcast1"),					// window class name
							TEXT("SW_Broadcast1"),					// window caption
							WS_OVERLAPPEDWINDOW & ~(WS_THICKFRAME | WS_MAXIMIZEBOX), // window style
							10, 									// initial x position
							10, 									// initial y position
							300,									// initial x size
							100,									// initial y size
							NULL,									// parent window handle
							NULL,									// window menu handle
							hInst,									// program instance handle
							NULL);									// creation parameters

	ShowWindow(hWndMain, iCmdShow);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ウインド・プロシージャ																						//
//																												//
//==============================================================================================================//
//----- WM_CREATE ----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_CREATE 	)
{
	MsgRwm = RegisterWindowMessage(TEXT("SW_Broadcast"));
	hBrush = (HBRUSH)GetStockObject(BLACK_BRUSH);
	SetTimer(hwnd, 1, 1000, NULL);
	return 0;
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_DESTROY	)
{
	KillTimer(hwnd, 1);
	PostQuitMessage(0);
	return 0;
}
//----- WM_TIMER -----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_TIMER		)
{
	TimeCount++;
	if (TimeCount & 1) hBrush = GetStockObject(WHITE_BRUSH);
	else			   hBrush = GetStockObject(BLACK_BRUSH);
	InvalidateRect(hwnd, NULL, FALSE);

	PostMessage(HWND_BROADCAST, MsgRwm, TimeCount, 0);

	return 0;
}
//----- WM_PAINT -----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_PAINT		)
{
	PAINTSTRUCT ps;
	HDC 		hdc;
	RECT		r;
	int 		x, y;

	hdc   = BeginPaint(hwnd, &ps);
	GetClientRect(hwnd, &r);
	x = (r.right - r.left) / 2;
	y = (r.bottom - r.top) / 2;
	SelectObject(hdc, hBrush);
	Ellipse (hdc, x - 15, y - 15, x + 15, y + 15);
	EndPaint(hwnd, &ps);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Main)
	AJC_WNDMAP_MSG(Main, WM_CREATE	)
	AJC_WNDMAP_MSG(Main, WM_DESTROY )
	AJC_WNDMAP_MSG(Main, WM_TIMER	)
	AJC_WNDMAP_MSG(Main, WM_PAINT	)
AJC_WNDMAP_END
