﻿//
//	SW_CPrePro.c
//

#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain;						//	ダイアログボックスハンドル
static	HWND			hVthLog;
static	HWND			hVthMacDef;
static	HWND			hVthMacRef;
static	HWND			hVthOptSym;

static	HAJCPPC			hPpc  = NULL;					//	プリコンパイル インスタンスハンドル
static	BOOL			fBusy = FALSE;					//	プリコンパイル中フラグ
static	BOOL			fExit = FALSE;					//	プログラム終了フラグ
static	UI				CurNest = -1;					//	インクルードネスト値
static	BC				SvFileName[MAX_PATH] = {0};

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
static	VO CALLBACK cbNtcPpcEvent(AJCPPCNOTIFY ntc, UX p1, UX p2, UX p3, UX cbp);
static	VO CALLBACK cbNtcPpcErr  (AJCPPCERROR err, UX p1, UX p2, UX p3, UX cbp);
static	VO		TagJump(BCP pLine);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	BC		path[MAX_PATH];

	hDlgMain   = hDlg;
	hVthLog    = GetDlgItem(hDlg, IDC_VTH_LOG);
	hVthMacDef = GetDlgItem(hDlg, IDC_VTH_MACDEF);
	hVthMacRef = GetDlgItem(hDlg, IDC_VTH_MACREF);
	hVthOptSym = GetDlgItem(hDlg, IDC_VTH_OPTSYM);

	//----- テキストボックスにドロップ可能とする -----------------//
	AjcEnableDlgItemToDrop(hDlg, IDC_TXT_BASE, AJCDROP_DIR);
	AjcEnableDlgItemToDrop(hDlg, IDC_TXT_SRC , AJCDROP_FILE);
	AjcEnableDlgItemToDrop(hDlg, IDC_TXT_OUT , AJCDROP_DIR_AND_FILE);
	//----- チェックボックス初期化 -------------------------------//
	AjcSetDlgItemChk(hDlg, IDC_CHK_OPENOUTFILE, TRUE);
	AjcSetDlgItemChk(hDlg, IDC_CHK_AUTOSRH	  , TRUE);
	AjcSetDlgItemChk(hDlg, IDC_CHK_GENALL	  , TRUE);
	AjcSetDlgItemChk(hDlg, IDC_CHK_EXPINC	  , TRUE);
	AjcSetDlgItemChk(hDlg, IDC_CHK_MACDEF	  , TRUE);
	AjcSetDlgItemChk(hDlg, IDC_CHK_OPTSYM	  , TRUE);
	AjcSetDlgItemChk(hDlg, IDC_CHK_MACREF	  , TRUE);
	//----- サンプル用デフォルト設定 -----------------------------//
	//	入出力ファイル
	AjcGetAppPath(path, MAX_PATH); AjcPathCat(path, "SW_CPreProSample.c", MAX_PATH);
	AjcSetDlgItemStr(hDlg, IDC_TXT_SRC, path);
	GetTempPath(MAX_PATH, path);   AjcPathCat(path, "SW_CPreProOutput.c", MAX_PATH);
	AjcSetDlgItemStr(hDlg, IDC_TXT_OUT, path);
	//	オプションシンボル
	AjcLbxInsertString(GetDlgItem(hDlg, IDC_LBX_OPTSYM), -1, "_MSC_VER=1400"			 );
	AjcLbxInsertString(GetDlgItem(hDlg, IDC_LBX_OPTSYM), -1, "_MSC_FULL_VER=140050727"	 );
	AjcLbxInsertString(GetDlgItem(hDlg, IDC_LBX_OPTSYM), -1, "_INTEGRAL_MAX_BITS=64"	 );
	AjcLbxInsertString(GetDlgItem(hDlg, IDC_LBX_OPTSYM), -1, "_WIN32"					 );
	AjcLbxInsertString(GetDlgItem(hDlg, IDC_LBX_OPTSYM), -1, "_MBCS"					 );
	AjcLbxInsertString(GetDlgItem(hDlg, IDC_LBX_OPTSYM), -1, "_CRTBLD"					 );
	AjcLbxInsertString(GetDlgItem(hDlg, IDC_LBX_OPTSYM), -1, "_M_IX86"					 );
	AjcLbxInsertString(GetDlgItem(hDlg, IDC_LBX_OPTSYM), -1, "__STDC__=0"				 );
	AjcLbxInsertString(GetDlgItem(hDlg, IDC_LBX_OPTSYM), -1, "__STDC_WANT_SECURE_LIB__=0");
	//	インクルードパス
	AjcLbxInsertString(GetDlgItem(hDlg, IDC_LBX_INCPATH), -1, "C:\\Program Files (x86)\\Microsoft Visual Studio*.*");
	AjcLbxInsertString(GetDlgItem(hDlg, IDC_LBX_INCPATH), -1, "C:\\Program Files (x86)\\Microsoft SDKs\\*.*"	   );
	AjcLbxInsertString(GetDlgItem(hDlg, IDC_LBX_INCPATH), -1, "C:\\Program Files (x86)\\Windows Kits\\*.*"		   );
	//----- ツールチップ設定 -------------------------------------//
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_TXT_BASE),	"インクルードファイルのベースフォルダ\n"
													"フォルダをドロップするか、右の「...」ボタンで設定します\n"
													"「インクルードファイル自動検索」をチェックした場合、"
													"このフォルダ下からもインクルードファイルを検索します"		);
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_TXT_BASE),	"ベースフォルダパス\n"
													"フォルダをドロップするか、右の「...」ボタンで設定します"	);
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CMD_BASE),	"ベースパスを設定します"									);

	AjcTipTextAdd(GetDlgItem(hDlg, IDC_TXT_SRC ),	"入力ソースプログラムファイル\n"
													"ファイルをドロップするか、右の「...」ボタンで設定します"	);
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CMD_SRC ),	"ソースファイルを設定します"								);

	AjcTipTextAdd(GetDlgItem(hDlg, IDC_TXT_OUT ),	"プリコンパイル結果の出力ファイル\n"						
													"ファイルをドロップするか、右の「...」ボタンで設定します"	);
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CMD_OUT ),	"プリコンパイル結果の出力ファイルを設定します"				);

	AjcTipTextAdd(GetDlgItem(hDlg, IDC_LBX_OPTSYM ),"プリコンパイル用オプションシンボル群，右クリックで各種操作可");
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_LBX_INCPATH),"インクルードパス群，ドロップ可，右クリックで各種操作可"	);

	//----- 設定値ロード -----------------------------------------//
	AjcLoadAllControlSettings(hDlg, "Settings", AJCCTL_SELACT_ALL | AJCCTL_SELACT_NTCCHK);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//----- 設定値セーブ -----------------------------------------//
	AjcSaveAllControlSettings(hDlg);
	//----- プログラム終了 ---------------------------------------//
	PostQuitMessage(0);
	return TRUE;
}
//----- ベースパス設定ボタン -----------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_BASE		)
{
	BC		path[MAX_PATH];

	AjcGetDlgItemStr(hDlg, IDC_TXT_BASE, path, MAX_PATH);
	if (AjcGetFolderName(hDlg, "ベースパスの設定", path, path, MAX_PATH)) {
		AjcSetDlgItemStr(hDlg, IDC_TXT_BASE, path);
	}
	return TRUE;
}
//----- ソースファイル設定ボタン -------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SRC		)
{
	BC		path[MAX_PATH];

	AjcGetDlgItemStr(hDlg, IDC_TXT_SRC, path, MAX_PATH);
	if (AjcGetOpenFile(hDlg, "ソースファイルの設定", "AllFiles(*.*)/*.*/CLangFiles(*.c)/*.c", "c", path, MAX_PATH)) {
		AjcSetDlgItemStr(hDlg, IDC_TXT_SRC, path);
	}
	return TRUE;
}
//----- 出力ファイル設定ボタン ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_OUT		)
{
	BC		path[MAX_PATH];

	AjcGetDlgItemStr(hDlg, IDC_TXT_OUT, path, MAX_PATH);
	if (AjcGetSaveFile(hDlg, "出力ファイルの設定", "AllFiles(*.*)/*.*/CLangFiles(*.c)/*.c", "c", path, MAX_PATH)) {
		AjcSetDlgItemStr(hDlg, IDC_TXT_OUT, path);
	}
	return TRUE;
}
//----- ベースパス テキスト ------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_TXT_BASE		)
{
	BC		txt[MAX_PATH];

	if (HIWORD(wParam) == EN_CHANGE) {
		AjcGetDlgItemStr(hDlg, IDC_TXT_BASE, txt, AJCTSIZE(txt));
		AjcLbxSetBasePath(GetDlgItem(hDlg, IDC_LBX_INCPATH), txt);
	}
	return TRUE;
}
//----- インクルードファイルを自動検索・チェックボックス -------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CHK_AUTOSRH	)
{
	return TRUE;
}
//----- 実行ボタン ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_EXEC		)
{
	AJCPPCRESULT	rsu = AJCPPCR_OK;
	PAJCPPCTKNNODE	pTkn	 = NULL;
	PAJCLBXITEM		pOptSym  = NULL;
	PAJCLBXITEM		pIncPath = NULL;
	UI				i;
	BC				BasPath[MAX_PATH]	= {0};
	BC				SrcPath[MAX_PATH]	= {0};
	BC				OutPath[MAX_PATH]	= {0};
	BC				fname[MAX_PATH], fext[_MAX_EXT];

	//	ログクリアー
	AjcVthClear(hVthLog);
	AjcVthClear(hVthOptSym);
	AjcVthClear(hVthMacDef);
	AjcVthClear(hVthMacRef);
	//	プリプロセス実行中の旨、設定
	fBusy = TRUE;
	//	インクルードネスト値クリアー
	CurNest = 0;
	//	全コントロールを禁止状態とする（キャンセルボタンを除く）
	AjcEnableCtrlsInWnd(hDlg, FALSE);
	AjcEnableDlgItem(hDlg, IDC_CMD_CANCEL, TRUE);
	//	ログ全体を許可状態とする
	AjcEnableDlgGroup(hDlg, IDC_GRP_LOG, TRUE, TRUE);
	//	ベース，ソース，出力パス設定
	AjcGetDlgItemStr(hDlg, IDC_TXT_BASE, BasPath, MAX_PATH);
	AjcGetDlgItemStr(hDlg, IDC_TXT_SRC , SrcPath, MAX_PATH);
	AjcGetDlgItemStr(hDlg, IDC_TXT_OUT , OutPath, MAX_PATH);

	//	オプションシンボル，インクルードパス設定
	pOptSym  = AjcLbxGetAllItems(GetDlgItem(hDlg, IDC_LBX_OPTSYM ), NULL);
	pIncPath = AjcLbxGetAllItems(GetDlgItem(hDlg, IDC_LBX_INCPATH), NULL);

	//	プリコンパイル実行
	if (hPpc = AjcPpcCreate(BasPath,
							pIncPath,
							pOptSym,
							(UX)hDlg,
							cbNtcPpcEvent,
							cbNtcPpcErr)) {

		//	レベル０のソースファイル表示
		MAjcSplitPath(SrcPath, NULL, NULL, fname, fext);
		strcat_s(fname, MAX_PATH, fext);
		AjcSetDlgItemStr(hDlg, IDC_TXT_F0, fname);
								
		//	オプションフラグ設定
		AjcPpcSetOption(hPpc, 
			(AjcGetDlgItemChk(hDlg, IDC_CHK_AUTOSRH) ? AJCPPC_FLG_AUTO_SEARCH : 0) |	//	インクルードファイル自動検索
			(AjcGetDlgItemChk(hDlg, IDC_CHK_ONCE   ) ? AJCPPC_FLG_ONCE		  : 0) |	//	同一Include-Fileを１回だけ読み出す
			(AjcGetDlgItemChk(hDlg, IDC_CHK_GENALL ) ? AJCPPC_FLG_GENALL	  : 0));	//	非生成部分(偽の部分)もファイル出力する

		//	プリコンパイル実行
		AjcVthTimeStamp(hVthLog);
		AjcVthPutText(hVthLog, " プリコンパイル開始\n", -1);
		rsu = AjcPpcCompile(hPpc, SrcPath);
		AjcSetDlgItemStr(hDlg, IDC_LBL_LNO, "");
		AjcVthPutText(hVthLog, "\r\x1B[2K", -1);
		AjcVthTimeStamp(hVthLog);
		switch (rsu) {
			case AJCPPCR_OK: 	  AjcVthPutText(hVthLog, " プリコンパイル終了\n", -1); break;
			case AJCPPCR_NOFILE:  AjcVthPutText(hVthLog, " ソースファイルなし\n", -1); break;
			case AJCPPCR_MEMERR:  AjcVthPutText(hVthLog, " メモリエラー\n"		, -1); break;
			case AJCPPCR_STOP:	  AjcVthPutText(hVthLog, " 中止しました\n"		, -1); break;
			case AJCPPCR_NOTOKEN: AjcVthPutText(hVthLog, " 内容がありません\n"	, -1); break;
			case AJCPPCR_PARAM:	  AjcVthPutText(hVthLog, " パラメタエラー\n"	, -1); break;
		}
		if (rsu == AJCPPCR_OK) {
			if (pTkn = AjcPpcGetObject (hPpc, NULL)) {
				//	プリコンパイル結果をファイルへ出力（インクルードファイルの内容を含める）
				if (AjcPpcTokenStreamToFile(hPpc,  OutPath, AjcGetDlgItemChk(hDlg, IDC_CHK_EXPINC), AJCPPC_PPK_ALL)) {
					//	出力ファイルを開く
					if (AjcGetDlgItemChk(hDlg, IDC_CHK_OPENOUTFILE)) {
						ShellExecute(NULL, "open", OutPath, NULL, NULL, SW_SHOWNORMAL);
					}
				}
				else {
					AjcVthPutText(hVthLog, "プリコンパイル結果をファイルへ出力できませんでした\n", -1);
				}
			}
		}
		//	レベル０のソースファイルクリアー
		AjcSetDlgItemStr(hDlg, IDC_TXT_F0, "");

		//	プリコンパイルインスタンス消去
		AjcPpcDelete(hPpc);
		hPpc = NULL;
	}

	//	リストボックス項目群の配列解放
	if (pOptSym  != NULL) AjcLbxRelAllItems(pOptSym );
	if (pIncPath != NULL) AjcLbxRelAllItems(pIncPath);

	//	プリコンパイル実行中解除
	fBusy = FALSE;
	//	全コントロール禁止状態を解除
	AjcEnableCtrlsInWnd(hDlg, TRUE);
	AjcEnableDlgItem(hDlg, IDC_CMD_CANCEL, FALSE);
	//	処理中のファイル名クリアー
	for (i = 0; i < 8; i++) {
		AjcSetDlgItemStr(hDlg, IDC_TXT_F0 + i, "");
	}
	//	フォームクローズならば、プログラム終了
	if (fExit) {
		DestroyWindow(hDlg);
	}

	return TRUE;
}
//----- 中止ボタン ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_CANCEL	)
{
	if (hPpc != NULL) {
		AjcEnableDlgItem(hDlg, IDC_CMD_CANCEL, FALSE);
		AjcPpcStop(hPpc);
	}
	return TRUE;
}
//----- ログウインドからの通知 ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_VTH_LOG		)
{
	BC	buf[4096];

	if (HIWORD(wParam) == AJCVTHN_DBLCLK) {
		AjcVthGetDblClickedLine(hVthLog, buf, AJCTSIZE(buf));
		TagJump(buf);
	}
	return TRUE;
}
//----- オプションシンボル参照ウインドからの通知 ---------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_VTH_OPTSYM	)
{
	BC	buf[4096];

	if (HIWORD(wParam) == AJCVTHN_DBLCLK) {
		AjcVthGetDblClickedLine(hVthOptSym, buf, AJCTSIZE(buf));
		TagJump(buf);
	}
	return TRUE;
}
//----- マクロ定義ウインドからの通知 ---------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_VTH_MACDEF	)
{
	BC	buf[4096];

	if (HIWORD(wParam) == AJCVTHN_DBLCLK) {
		AjcVthGetDblClickedLine(hVthMacDef, buf, AJCTSIZE(buf));
		TagJump(buf);
	}
	return TRUE;
}
//----- マクロ参照ウインドからの通知 ---------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_VTH_MACREF	)
{
	BC	buf[4096];

	if (HIWORD(wParam) == AJCVTHN_DBLCLK) {
		AjcVthGetDblClickedLine(hVthMacRef, buf, AJCTSIZE(buf));
		TagJump(buf);
	}
	return TRUE;
}
//----- 「Cancel」ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	if (fBusy) {
		fExit = TRUE;
		AjcPpcStop(hPpc);
	}
	else DestroyWindow(hDlg);

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	   )
	AJC_DLGMAP_MSG(Main, WM_DESTROY		   )

	AJC_DLGMAP_CMD(Main, IDC_TXT_BASE	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_BASE	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_SRC	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_OUT	   )
	AJC_DLGMAP_CMD(Main, IDC_CHK_AUTOSRH   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_EXEC	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_CANCEL	   )
	AJC_DLGMAP_CMD(Main, IDC_VTH_LOG	   )
	AJC_DLGMAP_CMD(Main, IDC_VTH_OPTSYM	   )
	AJC_DLGMAP_CMD(Main, IDC_VTH_MACDEF	   )
	AJC_DLGMAP_CMD(Main, IDC_VTH_MACREF	   )
	AJC_DLGMAP_CMD(Main, IDCANCEL		   )
AJC_DLGMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	ＰＰＣイベント通知																							//
//--------------------------------------------------------------------------------------------------------------//
VO CALLBACK cbNtcPpcEvent(AJCPPCNOTIFY ntc, UX p1, UX p2, UX p3, UX cbp)
{
	HWND	hDlg = (HWND)cbp;
	static	BC	IncName[MAX_PATH] = {0};

	switch (ntc) {
		case AJCPPC_NTC_ANYEVT:			//	いずれかのイベントが発生したことを通知		AJCPPCNOTIFY   , -				, -
			AjcDoEvent();
			break;

		case AJCPPC_NTC_FILE_LNO:		//	ファイル名，行番号通知						"ファイル名"   , 行＃			, ネスト値
		{	C_BCP	pFile = (C_BCP)p1;
			//	現在処理中のファイル名とネスト値表示
			if (MAjcStrCmp(pFile, SvFileName) != 0) {
				if (p3 < 8) {
					if ((UI)p3 < CurNest) AjcSetDlgItemStr(hDlg, IDC_TXT_F0 + CurNest, "");
					AjcSetDlgItemStr(hDlg, IDC_TXT_F0 + (UI)p3, pFile);
					CurNest = (UI)p3;
				}
				MAjcStrCpy(SvFileName, MAX_PATH, pFile);
			}
			AjcSetDlgItemUInt(hDlg, IDC_LBL_LNO, (UI)p2);
			break;
		}
		case AJCPPC_NTC_SRH_START:		//	インクルードファイル検索開始通知			"Incファイル名", "検索フォルダ" , -
			MAjcStrCpy(IncName, MAX_PATH, (BCP)p1);
			break;

		case AJCPPC_NTC_SRH_DIR:		//	インクルードファイル検索中のフォルダ通知	"フォルダパス" , -				, -
			if (AjcGetDlgItemChk(hDlg, IDC_CHK_INCSRH)) {
				AjcVthPutText(hVthLog, "\r\x1B[2K\r", -1);
				AjcVthPrintF (hVthLog, "Search %-20s in %s", IncName, (BCP)p1);
			}
			break;

		case AJCPPC_NTC_SRH_END:		//	インクルードファイル検索終了通知			"Incファイル名", 1:見つかった	, -
			if (AjcGetDlgItemChk(hDlg, IDC_CHK_INCSRH)) {
				AjcVthPutText(hVthLog, p2 ? "  - Find\n" : "  - NotFound\n", -1);
			}
			break;

		case AJCPPC_NTC_OPTSYM:			//	プリプロセス用オプションシンボル通知		PCAJCPPCTKNNODE, -				, -
		{	PCAJCPPCTKNNODE pTkn = (PCAJCPPCTKNNODE)p1;
			if (!(AjcGetDlgItemChk(hDlg, IDC_CHK_OPTSYM) && *(pTkn->pSyl) == '_')) {
				AjcVthPrintF(hVthOptSym, "%-20s : \"%s\" <%d>\n", pTkn->pSyl,
																  pTkn->pFile,
																  pTkn->lno);
			}
			break;
		}
		case AJCPPC_NTC_MACDEF:			//	マクロ定義通知								PCAJCPPCTKNNODE, PCAJCPPCMACINFO, -
		{	PCAJCPPCTKNNODE pTkn = (PCAJCPPCTKNNODE)p1;
			PCAJCPPCMACINFO pMac = (PCAJCPPCMACINFO)p2;
			if (!(AjcGetDlgItemChk(hDlg, IDC_CHK_MACDEF) && *(pMac->pMacName) == '_')) {
				AjcVthPrintF(hVthMacDef, "%-20s : \"%s\" <%d>\n", pMac->pMacName,
																  pTkn->pFile,
																  pTkn->lno);
			}
			break;
		}
		case AJCPPC_NTC_MACREF:			//	マクロ参照通知								PCAJCPPCTKNNODE, CAJCPPCMACINFO , -
		{	PCAJCPPCTKNNODE pTkn = (PCAJCPPCTKNNODE)p1;
			PCAJCPPCMACINFO pMac = (PCAJCPPCMACINFO)p2;
			if (!(AjcGetDlgItemChk(hDlg, IDC_CHK_MACREF) && *(pMac->pMacName) == '_')) {
				AjcVthPrintF(hVthMacRef, "%-20s : \"%s\" <%d>\n", pMac->pMacName,
																  pTkn->pFile,
																  pTkn->lno);
			}
			break;
		}
		case AJCPPC_NTC_OUTLOOP:		//	トークンストリームをファイルへ出力中通知	1:出力終了	   , -				, -
			break;

		case AJCPPC_NTC_SRCTEC:			//	ソースファイルのテキストエンコード通知		ソースパス”   , ﾃｷｽﾄｴﾝｺｰﾄﾞ		, 1:BOM
			AjcVthPutText(hVthLog, "\r\x1B[2K", -1);
			AjcVthPutText(hVthLog, "入力ファイルのテキストエンコード ： ", -1);
			switch (p2) {
				case AJCTEC_MBC:		AjcVthPutText(hVthLog, AJCLNGSEL("S-JIS\n", "MBC\n"), -1);	break;
				case AJCTEC_UTF_8:		AjcVthPutText(hVthLog, "UTF-8\n"	 , -1);					break;
				case AJCTEC_EUC_J:		AjcVthPutText(hVthLog, "EUC-J\n"	 , -1);					break;
				case AJCTEC_UTF_16LE:	AjcVthPutText(hVthLog, "UTF-16(LE)\n", -1);					break;
				case AJCTEC_UTF_16BE:	AjcVthPutText(hVthLog, "UTF-16(BE)\n", -1);					break;
			}
			break;

		case AJCPPC_NTC_TOKEN:			//	トークン通知（ソースから読み出したトークン）トークンコード , “トークン文字列”, -
			break;

	}
}
//--------------------------------------------------------------------------------------------------------------//
//	ＰＰＣエラー通知																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO CALLBACK cbNtcPpcErr  (AJCPPCERROR err, UX p1, UX p2, UX p3, UX cbp)
{
	HWND	hDlg = (HWND)cbp;

	AjcVthPutText(hVthLog, "\r\x1B[2K", -1);
	AjcVthPutText(hVthLog, "\x1B[31m" , -1);
	AjcVthPutText(hVthLog, AjcPpcGetErrMsgText(err, p1, p2, p3), -1);
	AjcVthPutText(hVthLog, "\x1B[0m\n", -1);
}
//--------------------------------------------------------------------------------------------------------------//
//	タグジャンプ（秀丸を起動）																					//
//--------------------------------------------------------------------------------------------------------------//
static	VO	 TagJump(BCP pLine)
{
	BCP		pPath = MAjcStrStr(pLine, "\"");
	BCP		pLno  = MAjcStrStr(pLine, "<");
	int lno   = 0;
	if (pPath != NULL && pLno != NULL) {
		pPath++; MAjcStrTok(pPath, "\"");
		pLno++;  MAjcStrTok(pLno , ">" ); lno = AjcAscToInt(pLno);
		
		if (AjcPathIsFile(pPath) && lno > 0) {
			BC	szOpt[MAX_PATH + 64];
			AjcSnPrintF(szOpt, AJCTSIZE(szOpt), "/J%d /m4 %s", lno, pPath);
			ShellExecute(NULL, NULL, "Hidemaru.exe", szOpt, "C:\\Program Files (x86)\\Hidemaru\\", SW_SHOWNORMAL);
		}
	}
}

