﻿// SW_Ctk01C.c
#include	<AjrCstXX.h>
#include	<stdio.h>
#include	<tchar.h>
#include	<fcntl.h>

//==============================================================================================================//
//	ソーステキスト読み出し																						//
//																												//
//	引　数	：	pBuf	- ソーステキストを格納するバッファのアドレス											//
//				lBif	- ソーステキストを格納するバッファの文字数												//
//				xp		- コールバックパラメタ																	//
//																												//
//	戻り値	：	TRUE  - 有効なテキストを読み出した																//
//				FALSE - ＥＯＦ																					//
//==============================================================================================================//
static BOOL CALLBACK cbGetLine(UTP pBuf, UI lBuf, UX xp)
{
	return AjcFGetS((HAJCFILE)xp, pBuf, lBuf) != NULL;		//	TRUE:継続，FALSE:中止
}

//==============================================================================================================//
//																												//
//	m a i n 																									//
//																												//
//==============================================================================================================//
int  AjcMain(int argc, UTP argv[])
{
	HAJCFILE	hFile;
	HAJCTK		hCtk;
	UI			tc;
	UT			txt[256];

	AjcSetStdoutMode();
	_tsystem(TEXT("cd"));

	do {
		//----- コマンドパラメタ チェック --------------------//
		if (argc <= 1) {
			AjcPrintF(TEXT("No source file name\n"));
			break;
		}
		//----- ソースファイル オープン ----------------------//
		if ((hFile = AjcFOpen(argv[1], AJCTEC_AUTO)) == NULL) {
			AjcPrintF(TEXT("File %s open failure\n"), argv[1]);
			break;
		}
		//----- コメントを取り除いたテキスト出力 -------------//
		hCtk = AjcCtkCreate(AJCTKFLG_CPLUSPLUS | AJCTKFLG_INCSPACE,
											 cbGetLine, (UX)hFile);
		while (AjcCtkGetToken(hCtk, txt, sizeof txt)) {
			tc = AJCTK_TOKEN(hCtk);
			if (tc != EAJCTK_COMMENT && tc != EAJCTK_LINECOMMENT) {
				_tprintf(TEXT("%s"), txt);
			}
		}
		//----- インスタンス消去 -----------------------------//
		AjcCtkDelete(hCtk);
		//----- ソースファイル クローズ ----------------------//
		AjcFClose(hFile);

	} while(0);
	AjcPrintF(TEXT("Hit Enter Key!"));
	getchar();

	return 0;
}
