﻿//
//	S_DIBSect2.c
//
#include	<AjrCstXX.h>
#include	<tchar.h>
#include	<math.h>
#include	"resource.h"

#define ID_BLUE 	0
#define ID_RED		1
#define ID_BLACK	7

#define RGB_BLACK	RGB(  0,   0,	0)
#define RGB_WHITE	RGB(255, 255, 255)
#define RGB_BLUE	RGB(  0,   0, 255)

//--------------------------------------------------------------------------------------------------------------//
//	ポイント・ノード																							//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	AJC2DVEC	c;		//	中心
	double		r;		//	半径
} NODE, *PNODE;

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst		= NULL; 		//	自プログラムのインスタンスハンドル
static	HWND			hDlgMain	= NULL; 		//	ダイアログ・ハンドル
static	HWND			hCtrlG2d	= NULL; 		//	２Ｄグラフィックコントロール・ハンドル
static	HWND			hCtrlPic	= NULL; 		//	ピクチャコントロール・ハンドル
static	HBITMAP 		hBmpG2d 	= NULL; 		//	２ＤグラフィックをコピーするＤＩＢのビットマップ・ハンドル
static	HBITMAP 		hBmpBlue	= NULL; 		//	青い部分を退避コピーするＤＩＢのビットマップハンドル
static	AJCDIBINFO		DibG2d; 					//	２ＤグラフィックをコピーするＤＩＢの情報
static	AJCDIBINFO		DibBlue;					//	青い部分を退避コピーするＤＩＢの情報
static	HAJCFQUE		hFQueNode	= NULL; 		//	ポイント・ノードを蓄積するキューのハンドル

static	BOOL			fDrawing	= FALSE;		//	描画処理中フラグ
static	BOOL			fStop		= FALSE;		//	描画処理・中止フラグ
static	BOOL			fQuit		= FALSE;		//	プログラム終了フラグ

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
static	VO	DoEvent(VO);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 		)
{
	RECT		r;
	int 		w, h;

	hDlgMain = hDlg;
	hCtrlG2d = GetDlgItem(hDlg, IDC_G2D);
	hCtrlPic = GetDlgItem(hDlg, IDC_PIC);

	//----- ２Ｄモード設定 --------------------------//
	AjcG2dInit(hCtrlG2d, -1.0, -1.0, +1.0, +1.0, AJC3DGS_2DMODE);
	//----- ダイアログ項目の初期化 ------------------//
	AjcSetDlgItemUInt(hDlg, IDC_INP_POINTS	,  20);
	AjcSetDlgItemUInt(hDlg, IDC_INP_INTERVAL, 100);
	AjcSetDlgItemUInt(hDlg, IDC_INP_SEED	,	1);
	AjcSetDlgItemReal(hDlg, IDC_INP_RAD_LO	, 0.10, 2);
	AjcSetDlgItemReal(hDlg, IDC_INP_RAD_HI	, 0.16, 2);
	//----- ダイアログ項目の設定値ロード ------------//
	AjcLoadAllControlSettings (hDlg, TEXT("Values"), AJCCTL_SELACT_ALL);
	//----- ウインドサイズ設定 ----------------------//
	GetWindowRect(hCtrlG2d, &r);
	w = r.right - r.left;
	h = r.bottom - r.top;
	SetWindowPos(hCtrlPic, NULL, 0, 0, w, h, SWP_NOMOVE);
	//----- ＤＩＢセクション生成 --------------------//
	hBmpG2d  = AjcDibCreate(w, h, 24, &DibG2d );
	hBmpBlue = AjcDibCreate(w, h, 24, &DibBlue);
	AjcDibClear(&DibBlue, RGB_WHITE);
	//----- ピクチャ表示 ----------------------------//
	SendDlgItemMessage(hDlg, IDC_PIC, STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)hBmpBlue);
	//----- ノードキュー生成 ------------------------//
	hFQueNode = AjcFQueCreate(sizeof(NODE), 0, NULL);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY			)
{
	//----- ノードキュー消去 ------------------------//
	AjcFQueDelete(hFQueNode);
	//----- DIBitmap削除 ----------------------------//
	DeleteObject(hBmpG2d );
	DeleteObject(hBmpBlue);
	//----- ダイアログ項目の設定値セーブ ------------//
	AjcSaveAllControlSettings(hDlg);
	//----- プログラム終了 --------------------------//
	PostQuitMessage(0);
	return TRUE;
}
//----- 点の数 -------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_INP_POINTS		)
{
	return TRUE;
}
//----- 半径範囲（最小）----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_INP_RAD_LO		)
{
	double	lo, hi;

	if (HIWORD(wParam) == AJCIVN_REALVALUE) {
		lo = *((double *)lParam);
		hi = AjcGetDlgItemReal(hDlg, IDC_INP_RAD_HI);
		if (lo > hi) {
			AjcSetDlgItemReal(hDlg, IDC_INP_RAD_HI, lo, 2);
		}
	}
	return TRUE;
}
//----- 半径範囲（最大）----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_INP_RAD_HI		)
{
	double	lo, hi;

	if (HIWORD(wParam) == AJCIVN_REALVALUE) {
		hi = *((double *)lParam);
		lo = AjcGetDlgItemReal(hDlg, IDC_INP_RAD_LO);
		if (lo > hi) {
			AjcSetDlgItemReal(hDlg, IDC_INP_RAD_LO, hi, 2);
		}
	}
	return TRUE;
}
//----- ＳＴＯＰボタン -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_STOP			)
{
	fStop = TRUE;
	return TRUE;
}
//----- ＳＴＡＲＴボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_START 		)
{
	int 	nPoint = AjcGetDlgItemSInt(hDlg, IDC_INP_POINTS);
	double	rlo   = AjcGetDlgItemReal(hDlg, IDC_INP_RAD_LO);
	double	rhi   = AjcGetDlgItemReal(hDlg, IDC_INP_RAD_HI);
	double	rw	  = rhi - rlo;

	int 		i;
	NODE		node;
	PNODE		p1, p2, p3;
	AJC2DVEC	v;
	double		dist, dup;
	HBITMAP 	hBmp;

	//----- フラグ初期化 ------------------------------------//
	fDrawing = TRUE;
	fStop	 = FALSE;
	//----- ＯＫボタン無効化，ＳＴＯＰボタン有効化 ----------//
	EnableWindow(GetDlgItem(hDlg, IDC_CMD_START), FALSE);
	EnableWindow(GetDlgItem(hDlg, IDC_CMD_STOP ), TRUE );
	//----- 乱数系列設定 ------------------------------------//
	srand(AjcGetDlgItemUInt(hDlg, IDC_INP_SEED));
	//----- ポイント・ノード作成 ----------------------------//
	AjcFQuePurge(hFQueNode);
	for (i = 0; i < nPoint; i++) {
		double xlo, xhi, xw, ylo, yhi, yw;
		node.r = rlo + (rw * (double)rand() / (double)RAND_MAX);
		xlo = ylo = -1.0 + node.r;
		xhi = yhi = +1.0 - node.r;
		xw = xhi - xlo;
		yw = yhi - ylo;
		node.c.x = xlo + (xw * (double)rand() / (double)RAND_MAX);
		node.c.y = ylo + (yw * (double)rand() / (double)RAND_MAX);
		AjcFQueEnque(hFQueNode, &node);
	}
	//----- 初期ビットマップ（目盛り）設定 ------------------//
	AjcG2dClearAll(hCtrlG2d);
	UpdateWindow(hCtrlG2d);
	AjcDibClear(&DibBlue, RGB_WHITE);
	hBmp = AjcG2dGetBitmap(hCtrlG2d);
	AjcDibCopyBitmap  (&DibG2d , 0, 0, 0, 0, hBmp, 0, 0, 0, 0, SRCCOPY);
	AjcDibExcludedCopy(&DibBlue, 0, 0, 0, 0, &DibG2d, 0, 0, RGB_WHITE, 0.0);
	SendDlgItemMessage(hDlgMain, IDC_PIC, STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)hBmpBlue);
	DeleteObject(hBmp);
	//----- ２つの円を描画し、重複部分を青で塗りつぶす ------//
	for (p1 = AjcFQueTopNode(hFQueNode); p1 != NULL; p1 = AjcFQueNextNode(hFQueNode, p1)) {
		for (p2 = AjcFQueNextNode(hFQueNode, p1); p2 != NULL; p2 = AjcFQueNextNode(hFQueNode, p2)) {
			//	画面クリアー
			AjcG2dClearAll(hCtrlG2d);
			//	２つの円描画
			AjcG2dEllipse(hCtrlG2d, ID_BLACK, p1->c.x, p1->c.y, p1->r, p1->r);
			AjcG2dEllipse(hCtrlG2d, ID_BLACK, p2->c.x, p2->c.y, p2->r, p2->r);
			//	重複部分を青で塗りつぶし、青い部分のみ退避 --//
			dist = sqrt(pow(p1->c.x - p2->c.x, 2.0) + pow(p1->c.y - p2->c.y, 2.0));
			if (dist < (p1->r + p2->r)) {
				dup = (p1->r + p2->r) - dist;
				v.x = ((p2->c.x - p1->c.x) / dist) * (p1->r - (dup / 2.0));
				v.y = ((p2->c.y - p1->c.y) / dist) * (p1->r - (dup / 2.0));
				AjcG2dFillB(hCtrlG2d, ID_BLUE, ID_BLACK, p1->c.x + v.x, p1->c.y + v.y);
				UpdateWindow(hCtrlG2d);
				Sleep(AjcGetDlgItemSInt(hDlg, IDC_INP_INTERVAL));
				//	青い塗りつぶし部分に点が存在するかチェック
				for (p3 = AjcFQueTopNode(hFQueNode); p3 != NULL; p3 = AjcFQueNextNode(hFQueNode, p3)) {
					if (AjcG2dGetPixel(hCtrlG2d, p3->c.x, p3->c.y) == RGB_BLUE) {
						break;
					}
				}
				//	青い塗りつぶし部分に点が存在しなければ、青色塗りつぶし部分を退避
				if (p3 == NULL) {
					hBmp = AjcG2dGetBitmap(hCtrlG2d);
					AjcDibCopyBitmap   (&DibG2d , 0, 0, 0, 0, hBmp, 0, 0, 0, 0, SRCCOPY);
					AjcDibCorrectedCopy(&DibBlue, 0, 0, 0, 0, &DibG2d, 0, 0, RGB_BLUE, 0.0);
					DeleteObject(hBmp);
					//	ピクチャ（青色収集状況）表示
					SendDlgItemMessage(hDlgMain, IDC_PIC, STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)hBmpBlue);
				}
			}
			DoEvent();
			if (fStop) break;
		}
		if (fStop) break;
	}
	//----- 青部分の割合表示 --------------------------------//
	AjcSetDlgItemReal(hDlg, IDC_TXT_RATIO, (double)AjcDibColorCount(&DibBlue, 0, 0, 0, 0, RGB_BLUE, 0.0) /
										   (double)(DibBlue.width * DibBlue.height) * 100.0, 2);
	//----- 円と中心ポイントを再描画しピクチャへコピー ------//
	AjcG2dClearAll(hCtrlG2d);
	for (p1 = AjcFQueTopNode(hFQueNode); p1 != NULL; p1 = AjcFQueNextNode(hFQueNode, p1)) {
		AjcG2dEllipse(hCtrlG2d, ID_BLACK, p1->c.x, p1->c.y, p1->r, p1->r);
		AjcG2dPixel  (hCtrlG2d, ID_BLACK, p1->c.x, p1->c.y, 2);
	}
	UpdateWindow(hCtrlG2d);
	hBmp = AjcG2dGetBitmap(hCtrlG2d);
	AjcDibCopyBitmap   (&DibG2d , 0, 0, 0, 0, hBmp, 0, 0, 0, 0, SRCCOPY);
	AjcDibCorrectedCopy(&DibBlue, 0, 0, 0, 0, &DibG2d, 0, 0, RGB_BLACK, 0.0);
	DeleteObject(hBmp);
	SendDlgItemMessage(hDlgMain, IDC_PIC, STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)hBmpBlue);
	//----- ＯＫボタン有効化，ＳＴＯＰボタン無効化 ----------//
	EnableWindow(GetDlgItem(hDlg, IDC_CMD_START), TRUE );
	EnableWindow(GetDlgItem(hDlg, IDC_CMD_STOP ), FALSE);
	//----- フラグリセット ----------------------------------//
	fDrawing = FALSE;
	fStop	 = FALSE;
	//----- プログラム終了判定 ------------------------------//
	if (fQuit) {
		fQuit = FALSE;
		DestroyWindow(hDlg);
	}

	return TRUE;
}
//----- ウインドクローズ ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL				)
{
	if (fDrawing) fStop = fQuit = TRUE;
	else		  DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG )
	AJC_DLGMAP_MSG(Main, WM_DESTROY    )

	AJC_DLGMAP_CMD(Main, IDC_INP_POINTS)
	AJC_DLGMAP_CMD(Main, IDC_INP_RAD_LO)
	AJC_DLGMAP_CMD(Main, IDC_INP_RAD_HI)
	AJC_DLGMAP_CMD(Main, IDC_CMD_STOP  )
	AJC_DLGMAP_CMD(Main, IDC_CMD_START )
	AJC_DLGMAP_CMD(Main, IDCANCEL	   )
AJC_DLGMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	Windowsイベント処理 																						//
//--------------------------------------------------------------------------------------------------------------//
static	VO	DoEvent(VO)
{
	MSG 	msg;

	if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}
}
