﻿//
//	SW_FMbxC.c
//
#include	<AjrCstXX.h>
#include	<process.h>

//----- メールデータ種別 ---------------------------------------------------------------------------------------//
typedef enum {
	CMD_TIME	= 1 ,		//	現在時刻
	CMD_END 				//	終了
} CMDCODE;

//----- メールデータ形式 ---------------------------------------------------------------------------------------//
typedef struct {
	CMDCODE 	cmd;		//	メールデータ種別
	SYSTEMTIME	stime;		//	現在時刻
} MAILDATA;


//==============================================================================================================//
//																												//
//	サブスレッド																								//
//																												//
//==============================================================================================================//
VO		SubThread(VOP param)
{
	HAJCFMBX	hFMbx = (HAJCFMBX)param;
	UI			i;
	MAILDATA	MailData;

	//----- １秒周期で現在時刻をメインスレッドに通知（３回）---------//
	for (i = 0; i < 3; i++) {
		MailData.cmd = CMD_TIME;
		GetLocalTime(&MailData.stime);
		AjcFMbxEnque(hFMbx, &MailData);
		Sleep(1000);
	}
	//----- メインスレッドに終了を通知 ------------------------------//
	MailData.cmd = CMD_END;
	AjcFMbxEnque(hFMbx, &MailData);
	//----- サブスレッド終了 ----------------------------------------//
	_endthread();
}

//==============================================================================================================//
//																												//
//	m a i n 																									//
//																												//
//==============================================================================================================//
int 	AjcMain(int argc, UTP argv[])
{
	HAJCFMBX	hFMbx;
	MAILDATA	MailData;

	AjcSetStdoutMode();

	//----- メールボックス・インスタンス生成 ------------------------//
	hFMbx = AjcFMbxCreate(sizeof(MAILDATA), 0, NULL);
	//----- サブスレッド生成 ----------------------------------------//
	_beginthread(SubThread, 0, hFMbx);
	Sleep(1);
	//----- サブスレッドからの通知待ちループ ------------------------//
	MailData.cmd = 0;
	while (MailData.cmd != CMD_END) {
		if (AjcFMbxDeque(hFMbx, &MailData, 300)) {		// サブスレッドからの通知あり？
			switch (MailData.cmd) {
				case CMD_TIME:							//		● 現在時刻通知
					AjcPrintF(TEXT("%d/%02d/%02d %02d:%02d:%02d.%03d\n"),
							MailData.stime.wYear, MailData.stime.wMonth , MailData.stime.wDay,
							MailData.stime.wHour, MailData.stime.wMinute, MailData.stime.wSecond,
							MailData.stime.wMilliseconds);
					break;

				case CMD_END:							//		● 終了通知
					AjcPrintF(TEXT("END\n"));
					break;
			}
		}
		else {											//	サブスレッドからの通知なし（タイムアウト）？
			AjcPrintF(TEXT("Timeout!\n"));
		}
	}
	Sleep(1);

	//----- メールボックス・インスタンス消去 ------------------------//
	AjcFMbxDelete(hFMbx);

	getchar();
	return	0;
}


