﻿//
//	SW_FQueC.c
//
#include	<AjrCstXX.h>
#include	<stdio.h>
#include	<string.h>
#include	<tchar.h>

static	VOP		GetNodeAddr(UI ix);

//------------------------------------------------------------------------------------------//
//	作業領域																				//
//------------------------------------------------------------------------------------------//
static	HAJCFQUE	hQue;

//------------------------------------------------------------------------------------------//
//	ノード削除通知																			//
//------------------------------------------------------------------------------------------//
static VO CALLBACK cbRemove(VOP pDat, UX cbp)
{
	AjcPrintF(TEXT("ノード削除 %p : %s\n"), pDat, *((UTP*)pDat));
	AJCFREE(*((UTP*)pDat));
}
//------------------------------------------------------------------------------------------//
//	テキスト入力通知																		//
//------------------------------------------------------------------------------------------//
static	VO CALLBACK cbNtcInput(int argc, UT *argv[], C_UTP pTxt, UX cbp)
{
	UI		seq;

	//	入力テキスト表示
	AjcPrintF(TEXT("%s\n"), pTxt);
	if (argc >= 1) {
		//	文字列ポインタを持つノードを末尾に挿入
		if		(_tcsicmp(argv[0], TEXT("Q")) == 0) {
			if (argc == 2) {
				UI		stl = ((UI)_tcslen(argv[1]) + 1);
				UI		len = stl * (sizeof(UT));
				UTP		p	= (UTP)AJCMEM(len);
				_tcscpy_s(p, stl, argv[1]);
				AjcFQueEnque(hQue, &p);
			}
			else AjcPrintF(TEXT("*** Invalid parameter.\n"));
		}
		//	文字列ポインタを持つノードを先頭に挿入
		else if (_tcsicmp(argv[0], TEXT("QT")) == 0) {
			if (argc == 2) {
				UI		stl = ((UI)_tcslen(argv[1]) + 1);
				UI		len = stl * (sizeof(UT));
				UTP		p	= (UTP)AJCMEM(len);
				_tcscpy_s(p, stl, argv[1]);
				AjcFQueEnqTop(hQue, &p);
			}
			else AjcPrintF(TEXT("*** Invalid parameter.\n"));
		}
		//	ノードデータ一覧を表示（昇順）
		else if (_tcsicmp(argv[0], TEXT("L")) == 0) {
			UTP		*p;
			seq = 0;
			if (p = (UTP*)AjcFQueTopNode(hQue)) {
				do {
					AjcPrintF(TEXT("%2d - %p -> %p -> %s\n"), seq++, p, *p, *p);
				} while(p = (UTP*)AjcFQueNextNode(hQue, p));
			}
		}
		//	全ノードを取り出して表示
		else if (_tcsicmp(argv[0], TEXT("G")) == 0) {
			UTP		p;
			seq = 0;
			while ((AjcFQueDeque(hQue, &p)) != 0) {
				AjcPrintF(TEXT("%2d - %p -> %s\n"), seq++, p, p);
				AJCFREE(p);
			}
		}
		//	全ノードを破棄
		else if (_tcsicmp(argv[0], TEXT("A"))  == 0) {
			AjcFQuePurge(hQue);
		}
		//	ノードヘッダのダンプ表示
		else if (_tcsicmp(argv[0], TEXT("DMP"))  == 0) {
			UTP		*p;
			seq = 0;
			if (p = (UTP*)AjcFQueTopNode(hQue)) {
				do {
					PAJCFQNODE pH = ((PAJCFQNODE)p) - 1;
					AjcPrintF(TEXT("%2d - %p : next = %p, dat = %p -> %p -> %s\n"), seq++, pH, pH->pNxt, p, *p, *p);
				} while(p = (UTP*)AjcFQueNextNode(hQue, p));
			}
		}
		//	その他
		else {
			AjcPrintF(TEXT("*** Invalid command.\n"));
		}
	}
}
//------------------------------------------------------------------------------------------//
//	ｍ ａ ｉ ｎ 																			//
//------------------------------------------------------------------------------------------//
int  AjcMain(int argc, UTP argv[])
{
	AjcSetStdoutMode();

	AjcSetConsoleBufSize(128, 64);
	AjcSetConsoleWndRect(0, 0, 127, 30);

	AjcPrintF(TEXT("\n 以下のコマンドを入力してください。\n\n"));
	AjcPrintF(TEXT("  Q   <文字列>     : 文字列データを持つノードを末尾に挿入\n"));
	AjcPrintF(TEXT("  QT  <文字列>     : 文字列データを持つノードを先頭に挿入\n"));
	AjcPrintF(TEXT("  L                : ノードデータ一覧を表示（昇順）\n"));
	AjcPrintF(TEXT("  G                : 全ノードを取り出して表示\n"));
	AjcPrintF(TEXT("  A                : 全ノードを破棄\n"));
	AjcPrintF(TEXT("  DMP              : ノードヘッダのダンプ表示\n"));
	AjcPrintF(TEXT("  <ESC>キー        : 終了\n"));
	AjcPrintF(TEXT("\n"));

	//	線形リストインスタンス生成
	hQue = AjcFQueCreate(sizeof(VOP), 0, cbRemove);

	AjcPrintF(TEXT("Input(%3u) - "), AjcFQueGetCount(hQue));
	while (AjcConInputByNtc(0, cbNtcInput)) {
		AjcPrintF(TEXT("Input(%3u) - "), AjcFQueGetCount(hQue));
	}
	//	線形リストインスタンス消去
	AjcFQueDelete(hQue);

	return 0;
}
