﻿//
//	SW_FileDir03.c
//

#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain;						//	ダイアログボックスハンドル
static	HWND			hVth;
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
static	BOOL	fBusy = FALSE;
static	BOOL	fCan  = FALSE;
static	BOOL	fEnd  = FALSE;

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	//----- ダイアログ表示 -----------------------------//
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- コピー状況通知コールバック -----------------------------------------------------------------------------//
static BOOL CALLBACK cbNtcProgress(ULL FileSize, ULL Copied, UX cbp)
{
	BOOL	rc	 = TRUE;
	HWND	hDlg = (HWND)cbp;

	AjcDoEvent();

	if (!(fCan || fEnd)) {
		//	プログレスバー更新
		AjcSetDlgItemPgsPos(hDlg, IDC_PGS, (int)(Copied * 100 / FileSize));
	}
	else {
		//	キャンセル／クローズならば、コピー中止
		rc = FALSE;
	}
	return rc;
}
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	hDlgMain = hDlg;

	AjcSetDlgItemPgsRange(hDlg, IDC_PGS, 0,  100);

	AjcEnableDlgItemToDrop(hDlg, IDC_TXT_PATH1, AJCDROP_FILE);
	AjcEnableDlgItemToDrop(hDlg, IDC_TXT_PATH2, AJCDROP_BOTH);
	AjcLoadAllControlSettings(hDlg, TEXT("Main"), AJCCTL_SELACT_ALL);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	AjcSaveAllControlSettings(hDlg);
	PostQuitMessage(0);
	return TRUE;
}
//----- 「実行」ボタン -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_RUN		)
{
	UT	path1[MAX_PATH];
	UT	path2[MAX_PATH];

	fCan = fEnd = FALSE;
	fBusy = TRUE;
	AjcSetDlgItemPgsPos(hDlg, IDC_PGS, 0);
	AjcGetDlgItemStr(hDlg, IDC_TXT_PATH1, path1, MAX_PATH);
	AjcGetDlgItemStr(hDlg, IDC_TXT_PATH2, path2, MAX_PATH);
	AjcEnableDlgItem(hDlg, IDC_CMD_RUN , FALSE);
	AjcEnableDlgItem(hDlg, IDC_CMD_STOP, TRUE);
	if (AjcCopyFile(path1, path2, AjcGetDlgItemChk(hDlg, IDC_CHK_CREATEALWAYS), (UX)hDlg, cbNtcProgress)) {
		AjcTipTextShowCenter(hDlg , TEXT("\n\x1B[31m コピーを正常に終了しました \n"), 5000, NULL);
	}
	else {
		AjcTipTextShowCenter(hDlg , TEXT("\n\x1B[31m コピーを失敗しました \n"), 5000, NULL);
	}
	AjcEnableDlgItem(hDlg, IDC_CMD_RUN , TRUE);
	AjcEnableDlgItem(hDlg, IDC_CMD_STOP, FALSE);
	fBusy = FALSE;
	if (fCan) AjcTipTextShowCenter(hDlg , TEXT("\n\x1B[31m コピーはキャンセルされました \n"), 5000, NULL);
	if (fEnd) DestroyWindow(hDlg);

	return TRUE;
}
//----- 「中止」ボタン -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_STOP		)
{
	if (fBusy) fCan = TRUE;
	return TRUE;
}
//----- 「Cancel」 ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	if (fBusy) fEnd = TRUE;
	else DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	   )
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	   )
	
	AJC_DLGMAP_CMD(Main, IDC_CMD_RUN	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_STOP	   )
	AJC_DLGMAP_CMD(Main, IDCANCEL		   )
AJC_DLGMAP_END

