﻿//
//	SW_SerialComPort2C.c
//
#define AJCSOCKSERV_H_
#define AJCSOCKCLIENT_H_
#include	<AjrCstXX.h>
#include	<conio.h>

//	ヘルプテキスト
static	UT			HelpText[] = TEXT("起動パラメタの形式\n\n"					)
								 TEXT("  ●ＣＯＭポート指定\n"					)
								 TEXT("      /COMnnn   - COMポート番号\n"		)
								 TEXT("      /Rnnn     - 通信スピード[bps]\n\n"	)
								 TEXT("  ●メールスロット指定\n"				)
								 TEXT("      /T<Name>  - 自スロット名\n"		)
								 TEXT("      /H<Name>  - 相手ホスト名\n"		)
								 TEXT("      /E<Name>  - 相手スロット名\n\n"	)
								 TEXT("  ●ＴＣＰ／ＩＰ指定\n"					)
								 TEXT("      /S<Name>  - TCP/IPサーバ名\n"		)
								 TEXT("      /Pnnn     - TCP/IPポート番号\n"	)
								 TEXT("\n"										)
								 TEXT("↑：以前に入力したパラメタ\n"			)
								 TEXT("↓：次のパラメタ"						);
//	シリアル通信インスタンス
static	HAJCSCP 	hScp = NULL;
//	通信デバイス
typedef enum {COMPORT, MAILSLOT, TCPIP}	COMMDEV;
//	通信パラメタ
static COMMDEV		dev 	= COMPORT;				//	通信デバイス
static UI			ComPort = 1;					//	ＣＯＭポート番号
static UI			Speed	= 115200;				//	ＣＯＭポート速度
static UT			MySlot [256] = TEXT("NoName");	//	自スロット名
static UT			RmtSlot[256] = TEXT("SlotB");	//	相手スロット名
static UT			RmtHost[256] = TEXT("");		//	相手ホスト名
static UT			TcpServ[256] = TEXT("");		//	TCP/IPサーバ名
static UI			TcpPort = 14238;				//	TCP/IPポート番号
//	バイトカウントタ
static	UI			ByteCount = 0;

//----- コンソール入力のコールバック（起動パラメタ解析）--------------------------------------------------------//
static VO	CALLBACK cbNtcArgs(int argc, UT *argv[], C_UTP pTxt, UX cbp)
{
	int		i;

	for (i = 0; i < argc; i++) {
		if		(MAjcStrNICmp(argv[i], TEXT("/COM"), 4) == 0) {dev = COMPORT;  ComPort = AjcAscToInt(	argv[i] + 4);}
		else if (MAjcStrNICmp(argv[i], TEXT("/R"  ), 2) == 0) {dev = COMPORT;  Speed   = AjcAscToInt(	argv[i] + 2);}
		else if (MAjcStrNICmp(argv[i], TEXT("/T"  ), 2) == 0) {dev = MAILSLOT; MAjcStrCpy(MySlot , 256, argv[i] + 2);}
		else if (MAjcStrNICmp(argv[i], TEXT("/H"  ), 2) == 0) {dev = MAILSLOT; MAjcStrCpy(RmtHost, 256, argv[i] + 2);}
		else if (MAjcStrNICmp(argv[i], TEXT("/E"  ), 2) == 0) {dev = MAILSLOT; MAjcStrCpy(RmtSlot, 256, argv[i] + 2);}
		else if (MAjcStrNICmp(argv[i], TEXT("/S"  ), 2) == 0) {dev = TCPIP;	   MAjcStrCpy(TcpServ, 256,	argv[i] + 2);}
		else if (MAjcStrNICmp(argv[i], TEXT("/P"  ), 2) == 0) {dev = TCPIP;	   TcpPort = AjcAscToInt(	argv[i] + 2);}
		else {
			AjcPrintF(TEXT("*** Invalid parameter %s ***\n"), argv[i]);
		}
	}
}

//----- コンソール強制終了ハンドラ -----------------------------------------------------------------------------//
static BOOL CALLBACK cbConApExit(DWORD CtrlType)
{
	//	シリアル通信インスタンス消去
	if (hScp != NULL) {
		AjcScpDelete(hScp);
		hScp = NULL;
	}
	return FALSE;	//	FALSE : 次のハンドラをコール
}
//--------------------------------------------------------------------------------------------------------------//
//	主制御
int  AjcMain(int argc, UTP argv[])
{
	WPARAM		wParam;
	LPARAM		lParam;
	UTP 		pDat;
	UI			lDat;
	UI			param;
	BOOL		rsu;
	BOOL		fExit = FALSE;
	UT			buf[256];

	AjcSetStdoutMode();

	do {
		//	コンソール強制終了ハンドラ設定
		SetConsoleCtrlHandler(cbConApExit, TRUE);
		//	初期メッセージ
		AjcPrintF(TEXT("受信データをエコーバックします。\nＥＳＣキーを押すとプログラムを終了します。\n\n"));
		//	コマンドパラメタ解析／入力
		if (argc >= 2) {
			cbNtcArgs(argc - 1, &argv[1], GetCommandLine(), 0);
		}
		else {
			AjcPrintF(TEXT("\n 起動パラメタを入力してください。(F1, F2 : ヘルプ)\n  "));
			if (!AjcConInputEx(NULL, 256, buf, AJCTSIZE(buf), AJCCIN_ALL, -1, -1, HelpText, 0, cbNtcArgs)) {
				break;
			}
		}
		AjcPrintF(TEXT("\n"));
		//	シリアル通信インスタンス生成
		hScp = AjcScpCreateEx(TEXT("ScpParam"), TRUE, MySlot, RmtHost, RmtSlot);
		//	モード設定（TRUE : 受信チャンクデータをバイナリデータとして扱う）
		AjcScpSetMode(hScp, NULL, 0, AJCSCP_CM_BIN);
		//	使用するイベント設定
		AjcScpSetEvtMask(hScp, AJCSCP_EV_RXCHUNK | AJCSCP_EV_PORTSTATE);

		//	ポートオープン
		switch (dev) {
			case COMPORT:	rsu = AjcScpOpen (hScp, ComPort, Speed, 8, 'N', 1);	break;
			case MAILSLOT:	rsu = AjcScpOpenSlot(hScp, NULL, NULL);				break;
			case TCPIP:		rsu = AjcScpOpenSock(hScp, TcpServ, TcpPort);		break;
		}
		if (rsu) { 																	//	ポート オープン成功？
			while (!fExit) {														//	　キー押下までループ
				if (AjcScpWaitEvent(hScp, &wParam, &lParam, 200)) { 				//	　　イベント待ち，イベントあり？
					C_UTP	pPortName = AjcScpGetPortPathName(hScp);
					AjcScpGetEventData(hScp, lParam, &pDat, &lDat, &param); 		//	　　　イベントデータ取得
					switch (wParam) {
						case AJCSCP_EV_PORTSTATE:									//	　　　●ポート状態通知
							switch (param) {
								case AJCSCP_CLOSED: 	// クローズ状態
									break;
								case AJCSCP_OPENED: 	// オープン状態
									AjcPrintF(TEXT("ポート %s をオープンしました。\n"), pPortName);
									AjcPrintF(TEXT("Received bytes count:\n    \r"));
									break;
								case AJCSCP_OPENFAIL:	// オープン失敗
									AjcPrintF(TEXT("ポート %s のオープンを失敗しました。\n"), pPortName);
									fExit = TRUE;
									break;
							}
							break;
						case AJCSCP_EV_RXCHUNK: 									//	　　　●バイナリチャンク受信通知
							AjcScpSendBinData(hScp, pDat, lDat);					//	　　　　エコーバック送信
							ByteCount += lDat;
							AjcPrintF(TEXT("    %u\r"), ByteCount);
							break;

					}
					AjcScpRelEventData(hScp, lParam);								//	　　　イベントデータ開放
				}
				//	キー入力チェック
				if (_kbhit()) fExit = TRUE;
			}
			AjcScpClose(hScp);														//	　ＣＯＭポートクローズ
		}
		else {																		//	ＣＯＭポート オープン失敗？
			AjcPrintF(TEXT("%s open failure!\n"), AjcScpGetPortPathName(hScp)); 	//		エラーメッセージ
		}
		AjcScpDelete(hScp); 														//	シリアル通信インスタンス消去
	} while(0);

	AjcPrintF(TEXT("\nHit Enter Key!!"));
	getchar();
	return 0;
}
