﻿//
//	SW_SerialComPort3.c
//

#define AJCSOCKSERV_H_
#define AJCSOCKCLIENT_H_
#include	<AjrCstXX.h>
#include	<tchar.h>
#include	"resource.h"

#define WM_SCPEVENT 	(WM_USER + 100)

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;									//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain		= NULL;					//	ダイアログボックスハンドル
static	HWND			hVthLog			= NULL;					//	ログウインド

static	HAJCSCP 		hScp			= NULL;					//	シリアル通信インスタンスハンドル
static	HBITMAP			hBmpProgImage	= NULL;					//	ビットマップハンドル
static	HAJCVQUE		hVQue			= NULL;					//	キューハンドル（入出力パス蓄積）
static	HANDLE			fhInp			= INVALID_HANDLE_VALUE;	//	入力ファイルハンドル
static	HANDLE			fhOut			= INVALID_HANDLE_VALUE;	//	出力ファイルハンドル
static	ULL				FileSize		= 0;					//	入力ファイルサイズ
static	UI				Unmatch			= 0;					//	比較不一致ファイル数
static	UI				ListCount		= 0;					//	全ファイル数
static	UI				TxCount			= 0;					//	送信バイトカウンタ
static	UI				RxCount			= 0;					//	受信バイトカウンタ
static	BOOL			fSendBusy		= FALSE;				//	処理中フラグ
static	UT				InpDir[MAX_PATH];						//	入力ディレクトリパス
static	UT				OutDir[MAX_PATH];						//	出力ディレクトリパス
static	UT				InpFilePath[MAX_PATH];					//	入力ファイルパス
static	UT				OutFilePath[MAX_PATH];					//	出力ファイルパス

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
static	VO		EnableButtons(HWND hDlg, BOOL fbtnParam, BOOL fbtnOpen, BOOL fbtnStart, BOOL fbtnStop);
static	BOOL	SendNextFile(VO);
static	BOOL	FileOpen(VO);
static	VO		FileSend(VO);
static	BOOL CALLBACK cbFind(UI nest, UTP pPath, UTP pName, UI attrib, UI wtime, UX cbp);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG )
{
	hDlgMain   = hDlg;
	hVthLog    = GetDlgItem(hDlg, IDC_VTH);

	//	ウインド位置ロード
	AjcLoadWndPos(hDlg, NULL);

	hScp = AjcScpCreateEx(TEXT("ComPortSect"), TRUE, NULL, NULL, NULL);		//	インスタンス生成
	AjcScpSetMode(hScp, hDlg, WM_SCPEVENT, AJCSCP_CM_BIN);					//	モード設定
	AjcScpSetEvtMask(hScp, AJCSCP_EV_PORTSTATE |							//	イベントマスク設定
						   AJCSCP_EV_RXCHUNK | AJCSCP_EV_RXPKT | AJCSCP_EV_TXEMPTY);
	AjcScpSetPktTimeout(hScp, 60000);	//	パケット受信タイムスト（低速通信用に長めに設定）
	//	ビットマップ表示
	AjcChangeBitmapColor((hBmpProgImage = LoadBitmap(hInst, MAKEINTRESOURCE(IDB_PROGIMAGE ))),
													 RGB(255, 255, 255), GetSysColor(COLOR_BTNFACE));
	SendDlgItemMessage(hDlg, IDC_PIC, STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)hBmpProgImage);
	//	キュー生成
	hVQue = AjcVQueCreate(0, NULL);
	//	ダイアログ項目の関連付け
	MAjcSetDlgPropStr (hDlg, IDC_TXT_INPPATH  , TEXT("" ), NULL , 0);
	MAjcSetDlgPropStr (hDlg, IDC_TXT_OUTPATH  , TEXT("" ), NULL , 0);
	AjcLoadDlgProfiles(hDlg, TEXT("DlgSetting"));
	//	ポート名表示
	AjcSetDlgItemStr(hDlg, IDC_LBL_PORTNAME, AjcScpGetPortName(hScp));

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY	)
{
	//	ウインド位置セーブ
	AjcSaveWndPos(hDlg, NULL);
	//	ダイアログ項目のセーブ
	AjcSaveDlgProfiles(hDlg, TEXT("DlgSetting"));
	AjcReleaseDlgProps(hDlg);
	//	リソース解放
	if (hBmpProgImage != NULL) DeleteObject(hBmpProgImage);
	if (hScp		  != NULL) AjcScpDelete(hScp);
	if (hVQue		  != NULL) AjcVQueDelete(hVQue);
	//	プログラム終了
	PostQuitMessage(0);
	return TRUE;
}
//----- ＳＣＭイベント通知 -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_SCPEVENT	)
{
	static	UI		TotalBytes = 0;
	VOP 	pDat;
	UI		len, param;

	AjcScpGetEventData(hScp, lParam, &pDat, &len, &param);				//	イベントデータ取得
	if(wParam & AJCSCP_EV_RXCHUNK ) {									//	チャンクデータ受信通知？

	}
	if(wParam & AJCSCP_EV_PORTSTATE) {									//	●ポート状態通知
		//	ポート名表示
		AjcSetDlgItemStr(hDlg, IDC_LBL_PORTNAME, (UTP)pDat);
		switch (param) {
			case AJCSCP_OPENED: 	// オープン状態
				AjcSetDlgItemStr(hDlg, IDC_LBL_PORTSTATE, TEXT("Opened"));
				AjcSetDlgItemStr(hDlg, IDC_CMD_OPEN, TEXT("クローズ"));
				EnableButtons(hDlg, FALSE, TRUE, TRUE, FALSE);
				break;

			case AJCSCP_CLOSED: 	// クローズ状態
				if (fSendBusy) {
					SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_CMD_STOP, BN_CLICKED), (LPARAM)hDlg);
				} 
				AjcSetDlgItemStr(hDlg, IDC_LBL_PORTSTATE, TEXT("Closed"));
				AjcSetDlgItemStr(hDlg, IDC_CMD_OPEN, TEXT("オープン"));
				EnableButtons(hDlg, TRUE, TRUE, FALSE, FALSE);
				break;

			case AJCSCP_OPENFAIL:	// オープン失敗
				AjcSetDlgItemStr(hDlg, IDC_LBL_PORTSTATE, TEXT("Open failure"));
				EnableButtons(hDlg, TRUE, TRUE, FALSE, FALSE);
				break;

			case AJCSCP_PORTCHG:	// 通信リソース変化
				AjcSetDlgItemStr(hDlg, IDC_LBL_PORTSTATE, TEXT("Port changed"));
				break;
		}
	}
	else if (wParam & AJCSCP_EV_RXCHUNK) {								//	●バイナリチャンク受信通知
		if (param == 0) {
			RxCount += len;
			AjcSepDlgItemUInt(hDlg, IDC_LBL_BYTES_RX, RxCount);
		}
	}
	else if (wParam & AJCSCP_EV_RXPKT) {								//	●パケット受信通知
		//	空パケット（ファイル終端）以外ならば、受信データをファイルへ出力
		if (len != 0) {
			if (fhOut != INVALID_HANDLE_VALUE) {
				UL	bytes;
				WriteFile(fhOut, pDat, len, &bytes, NULL);
			}
		}
		//	空パケット（ファイル終端）ならば、次のファイル送信へ・・
		else {
			//	出力ファイルクローズ
			if (fhOut != INVALID_HANDLE_VALUE) {CloseHandle(fhOut); fhOut = INVALID_HANDLE_VALUE;}
			//	ファイルコンペア
			if (AjcFileCompare(InpFilePath, OutFilePath)) {
				AjcVthPrintF(hVthLog, TEXT("OK (Match)\n"));
			}
			else {
				Unmatch++;
				AjcVthPrintF(hVthLog, TEXT("\x1B[31mNG (Unmatch)\x1B[0m\n"));
			}
			//	次のファイル送信開始
			SendNextFile();
		}
	}
	else if (wParam & AJCSCP_EV_TXEMPTY) {								//	●送信完了通知
		//	次のファイルデータ送信
		if (fhInp != INVALID_HANDLE_VALUE) {
			FileSend();
		}
	}

	AjcScpRelEventData(hScp, lParam);									//	イベントデータ開放

	return TRUE;
}
//----- キャンセル ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL		)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//----- ポート設定ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_PARAM	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		AjcScpDlgParamEasy(hScp, hDlg);
	}
	return TRUE;
}
//----- オープンボタン -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_OPEN	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		if (AjcScpIsOpened(hScp)) {
			AjcScpClose(hScp);
		}
		else {
			AjcScpOpenDefault(hScp);
			EnableButtons(hDlg, FALSE, FALSE, FALSE, FALSE);
			AjcSetDlgItemStr(hDlg, IDC_LBL_PORTSTATE, TEXT("Open in progress..."));
		}
	}
	return TRUE;
}
//----- 開始ボタン ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_START	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		//	入出力パス設定
		AjcGetDlgItemStr(hDlg, IDC_TXT_INPPATH, InpDir, MAX_PATH);
		AjcGetDlgItemStr(hDlg, IDC_TXT_OUTPATH, OutDir, MAX_PATH);
		if (InpDir[0] != 0 && OutDir[0] != 0) {
			if (MAjcStrICmp(InpDir, OutDir) != 0) {
				//	入出力パスリストクリアー
				AjcVQuePurge(hVQue);
				//	ファイル検索（入出力パスリスト作成）
				ListCount = 0;
				Unmatch	= 0;
				AjcSearchFilesEx(InpDir, TEXT("*.*"), TRUE, FALSE, 0, cbFind);
				//	フォルダ構造コピー
				if (ListCount != 0) {
					UT		txt[MAX_PATH * 64];
					//	出力フォルダ下の全ファイル削除
					AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("%s 下の全ファイルを削除します。よろしいですか？"), OutDir);
					if (MessageBox(hDlg, txt, TEXT("SW_SerialComPort4"), MB_YESNO) == IDYES) {
						//	ファイル番号クリアー
						ListCount = 0;
						//	バイトカウンタクリアー
						AjcSepDlgItemUInt(hDlg, IDC_LBL_BYTES_TX, TxCount = 0);
						AjcSepDlgItemUInt(hDlg, IDC_LBL_BYTES_RX, RxCount = 0);
						//	ログクリアー
						AjcVthClear(hVthLog);
						//	ボタングレー化
						EnableButtons(hDlg, FALSE, FALSE, FALSE, TRUE);
						//	フォルダ下クリアー
						AjcCleanFolder(OutDir, 0, NULL);
						//	フォルダ構造コピー
						AjcCopyFolderStruct(InpDir, OutDir, AJCFSC_FORCETIME);
						//	ファイルをオープンし送信開始
						SendNextFile();
					}
				} else AjcVthPutText(hVthLog, TEXT("\x1B[31m入力フォルダ下にファイルがありません。\x1B[0m"), -1);

			} else AjcVthPutText(hVthLog,TEXT("\x1B[31m入出力フォルダが同じです。\x1B[0m"), -1);

		} else AjcVthPutText(hVthLog, TEXT("\x1B[31m入出力フォルダが設定されていません。\x1B[0m"), -1);
	}
	return TRUE;
}
//----- 中止ボタン ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_STOP	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		//	送信中フラグクリアー
		fSendBusy = FALSE;
		//	ポートクローズ
		AjcScpClose(hScp);
		//	ファイルクローズ
		if (fhInp != INVALID_HANDLE_VALUE) {CloseHandle(fhInp); fhInp = INVALID_HANDLE_VALUE;}
		if (fhOut != INVALID_HANDLE_VALUE) {CloseHandle(fhOut); fhOut = INVALID_HANDLE_VALUE;}
		//	ログメッセージ
		AjcVthPrintF(hVthLog, TEXT("\n\n--- ループバックテストをキャンセルしました ---\n"));
	}
	return TRUE;
}
//----- 入力フォルダ設定ボタン ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_INPPATH)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		UT	path[MAX_PATH];
		AjcGetDlgItemStr(hDlg, IDC_TXT_INPPATH, path, MAX_PATH);
		if (AjcGetFolderName(hDlg, TEXT("入力フォルダ"), path, path, TRUE)) {
			AjcSetDlgItemStr(hDlg, IDC_TXT_INPPATH, path);
		}
	}
	return TRUE;
}
//----- 出力フォルダ設定ボタン ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_OUTPATH)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		UT	path[MAX_PATH];
		AjcGetDlgItemStr(hDlg, IDC_TXT_INPPATH, path, MAX_PATH);
		if (AjcGetFolderName(hDlg, TEXT("出力フォルダ"), path, path, TRUE)) {
			AjcSetDlgItemStr(hDlg, IDC_TXT_OUTPATH, path);
		}
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	)
	AJC_DLGMAP_MSG(Main, WM_SCPEVENT	)
	AJC_DLGMAP_CMD(Main, IDCANCEL		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_PARAM	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_OPEN	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_START	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_STOP	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_INPPATH)
	AJC_DLGMAP_CMD(Main, IDC_CMD_OUTPATH)
AJC_DLGMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	ファイル検索通知																							//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbFind(UI nest, UTP pPath, UTP pName, UI attrib, UI wtime, UX cbp)
{
	UT		out  [MAX_PATH];
	UT		inout[MAX_PATH * 2 + 16];

	if (!(attrib & _A_SUBDIR)) {
		ListCount++;
		//	入出力ファイルパス設定（セミコロン(;)で区切る）
		MAjcStrCpy(out, MAX_PATH, OutDir);
		AjcPathCat(out, pPath + MAjcStrLen(InpDir), MAX_PATH);
		AjcSnPrintF(inout, AJCTSIZE(inout), TEXT("%s;%s"), pPath, out);
		AjcVQueEnque(hVQue, (C_VOP)inout, ((UI)MAjcStrLen(inout) + 1) * sizeof(UT));
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
//	次のファイル送信																							//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SendNextFile(VO)
{
	BOOL	rc = FALSE;

	if (FileOpen()) {
		fSendBusy = TRUE;
		FileSend();
		rc = TRUE;
	}
	else {
		fSendBusy = FALSE;
		AjcScpClose(hScp);
		AjcVthPrintF(hVthLog, TEXT("\n--- ループバックテストを終了しました ---\n"));
		AjcVthPrintF(hVthLog, TEXT("    ループバック不一致数 : %d / %d[files]\n"), Unmatch, ListCount);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ファイルオープン（TRUE:ゼロサイズ以外のファイルオープン，FALSE:ファイルなし）								//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	FileOpen(VO)
{
	BOOL	rc = FALSE;
	UTP		pInp;
	UTP		pOut;
	UT		inout[MAX_PATH * 2 + 16];

	while (AjcVQueDeque(hVQue, (VOP)inout, sizeof(inout))) {
		ListCount++;
		//	入出力パス名設定
		pInp = MAjcStrTok(inout, TEXT(";")); if (pInp != NULL) MAjcStrCpy(InpFilePath, MAX_PATH, pInp);
		pOut = MAjcStrTok(NULL , TEXT(";")); if (pOut != NULL) MAjcStrCpy(OutFilePath, MAX_PATH, pOut);
		//	ログ表示
		AjcVthPrintF(hVthLog, TEXT("\n%3d : %s\n"), ListCount, pInp);
		AjcVthPrintF(hVthLog, TEXT("   -> %s - "), pOut);
		//	入出力ファイルオープン
		fhInp = CreateFile(pInp, GENERIC_READ , 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
		fhOut = CreateFile(pOut, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
		if (fhInp != INVALID_HANDLE_VALUE && fhOut != INVALID_HANDLE_VALUE) {
			//	ファイルサイズ設定
			FileSize = AjcGetFileSize(pInp);
			//	ゼロサイズならば、ファイルクローズ
			if (FileSize == 0) {
				AjcVthPrintF(hVthLog, TEXT("OK (Zero size)\n"));
				CloseHandle(fhInp); fhInp = INVALID_HANDLE_VALUE;
				CloseHandle(fhOut); fhOut = INVALID_HANDLE_VALUE;
			}
			//	ゼロサイズ以外ならば、ファールオープンした旨を返す
			else {
				rc = TRUE;
				break;
			}
		}
		else {
			Unmatch++;
			AjcVthPrintF(hVthLog, TEXT("\x1B[31mNG (Open/Creation failure)\x1B[0m\n"));
			if (fhInp != INVALID_HANDLE_VALUE) {CloseHandle(fhInp); fhInp = INVALID_HANDLE_VALUE;}
			if (fhOut != INVALID_HANDLE_VALUE) {CloseHandle(fhOut); fhOut = INVALID_HANDLE_VALUE;}
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ファイル送信																								//
//--------------------------------------------------------------------------------------------------------------//
static	VO	FileSend()
{
	UL		bytes = 0;
	UB		buf[1024];

	//	バッファサイズを超える残データ有りならば、データ送信し、バイト数減算
	if (FileSize > sizeof buf) {
		ReadFile(fhInp, buf, sizeof buf, &bytes, NULL);
		TxCount  += AjcScpSendPacket(hScp, buf, bytes);
		FileSize -= bytes;
	}
	//	バッファサイズ以下の残データ有りならば、ファイル末尾データ送信
	else if (FileSize != 0) {
		ReadFile(fhInp, buf, (UI)FileSize, &bytes, NULL);
		TxCount  += AjcScpSendPacket(hScp, buf, bytes);
		FileSize -= bytes;
	}
	//	残データ無しならば、ファイル終端を示す空パケットを送信
	else {
		//	空パケット送信
		TxCount += AjcScpSendPacket(hScp, buf, 0);
		//	入力ファイルクローズ
		if (fhInp != INVALID_HANDLE_VALUE) {CloseHandle(fhInp); fhInp = INVALID_HANDLE_VALUE;}
	}
	//	送信バイトカウント表示
	AjcSepDlgItemUInt(hDlgMain, IDC_LBL_BYTES_TX, TxCount);
}
//--------------------------------------------------------------------------------------------------------------//
//	ボタン群許可／禁止																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	EnableButtons(HWND hDlg, BOOL fbtnParam, BOOL fbtnOpen, BOOL fbtnStart, BOOL fbtnStop)
{
	AjcEnableDlgItem(hDlg, IDC_CMD_PARAM, fbtnParam);
	AjcEnableDlgItem(hDlg, IDC_CMD_OPEN , fbtnOpen );
	AjcEnableDlgItem(hDlg, IDC_CMD_START, fbtnStart);
	AjcEnableDlgItem(hDlg, IDC_CMD_STOP , fbtnStop );
}
