﻿//
//	SW_ShowImage.c
//
#include	<AjrCstXX.h>
#include	<tchar.h>

//--------------------------------------------------------------------------------------------------------------//
//	作業領域																									//
//--------------------------------------------------------------------------------------------------------------//
static	HWND			hWndMain	= NULL; 		//	メインウインド
static	AJC_IMGINFO 	ImgInfo;					//	イメージ情報

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(Main);

//==============================================================================================================//
//	W i n M a i n																								//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	WNDCLASS	wndclass;
	MSG 		msg;

	memset(&ImgInfo, 0, sizeof ImgInfo);

	//----- ウインド生成 ---------------------------------------------------------------------------------------//
	wndclass.style			= 0;
	wndclass.lpfnWndProc	= AJC_WNDPROC_NAME(Main);
	wndclass.cbClsExtra 	= 0;
	wndclass.cbWndExtra 	= 0;
	wndclass.hInstance		= hInstance;
	wndclass.hIcon			= NULL;
	wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);;
	wndclass.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
	wndclass.lpszMenuName	= NULL;
	wndclass.lpszClassName	= TEXT("CSW_ShowImage");
	RegisterClass (&wndclass);

	hWndMain = CreateWindow(TEXT("CSW_ShowImage"),	// window class name
							TEXT("SW_ShowImage"),	// window caption
							WS_OVERLAPPEDWINDOW,	// style
							0,						// initial x position
							0,						// initial y position
							512,					// initial x size
							384,					// initial y size
							NULL,					// parent window handle
							NULL,					// window menu handle
							hInstance,				// program instance handle
							NULL) ; 				// creation parameters

	//----- ウインド表示 ---------------------------------------------------------------------------------------//
	ShowWindow(hWndMain, iCmdShow);

	//----- メッセージループ -----------------------------------------------------------------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage (&msg);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ウインド・プロシージャ																						//
//																												//
//==============================================================================================================//
AJC_WNDPROC(Main, WM_CREATE 		)
{
	hWndMain   = hwnd;

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_DESTROY		)
{
	AjcImgFuncRelease(&ImgInfo);								//	読み出し済のイメージ解放
	PostQuitMessage(0);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_SIZE			)
{
	InvalidateRect(hwnd, NULL, FALSE);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_RBUTTONDOWN	)		//	右クリックで、表示するイメージファイルを選択
{
	static	UT	path[MAX_PATH] = {0};
	UT			txt[MAX_PATH + 64];

	if (AjcGetOpenFile(hWndMain, TEXT("イメージファイル設定"),
					TEXT("All Files (*.*)/*.*/Bitmap File (*.bmp)/*.bmp/.jpg File/*.jpg/.png File/*.png/.gif File/*.gif"),
					TEXT("bmp"), path, MAX_PATH)) {

		AjcSnPrintF(txt, MAX_PATH, TEXT("SW_ShowImage (%s)"), path); //  ウインドタイトル表示
		SetWindowText(hwnd, txt);									 //	・
		AjcImgFuncRelease(&ImgInfo);								 //	読み出し済のイメージ解放
		if (AjcImgFuncRead	 (&ImgInfo, path)) {					 //	イメージファイル読み出し
			InvalidateRect(hwnd, NULL, TRUE);						 //	再描画
		}
		else {
			MessageBox(hwnd, TEXT("イメージの読み出しを失敗しました"), TEXT("SW_ShowImage"), MB_ICONERROR);
		}
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_PAINT			)
{
	HDC 		hdc;
	PAINTSTRUCT ps;
	RECT		rcS, rcR, rcB;

	hdc = BeginPaint(hwnd, &ps);
	if (ImgInfo.fValid) {
		SetRect(&rcS, 0, 0, ImgInfo.width, ImgInfo.height);		//	入力側矩形
		SetRect(&rcR, 0, 0, 500 		 , 500			 );		//	出力側矩形
		AjcAspGetZoomedRect(&rcS, &rcR, &rcB);					//	拡大縮小した矩形算出
		AjcImgFuncDraw(&ImgInfo, &rcS, hdc, &rcB);				//	イメージ描画
		AdjustWindowRect(&rcB, WS_OVERLAPPEDWINDOW, FALSE);		//	ウインドサイズをイメージに合わせる
		SetWindowPos(hwnd, NULL, 0, 0, rcB.right - rcB.left, rcB.bottom - rcB.top, SWP_NOMOVE);
	}
	else {
		UTP 	p =  TEXT("右クリックで表示するイメージファイルを選択してください。");
		TextOut(hdc, 10, 10, p,  (UI)MAjcStrLen(p));
	}
	EndPaint(hwnd, &ps);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Main)
	AJC_WNDMAP_MSG(Main, WM_CREATE		)
	AJC_WNDMAP_MSG(Main, WM_DESTROY 	)
	AJC_WNDMAP_MSG(Main, WM_SIZE		)
	AJC_WNDMAP_MSG(Main, WM_RBUTTONDOWN )
	AJC_WNDMAP_MSG(Main, WM_PAINT		)
AJC_WNDMAP_END

