﻿//
//	S_SockClient1.c
//
#define AJCSERIALCOMPORT_H_
#define AJCSOCKSERV_H_
#include	<AjrCstXX.h>
#include	<tchar.h>
#include	"resource.h"

#define WM_SCTEVENT 	(WM_USER + 100)
#define	MAX_TXTBOX_LEN	128

//--------------------------------------------------------------------------------------------------------------//
//	ツールチップ																								//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	int		id;
	C_UTP	pTxt;
} TIPTBL, *PTIPTBL;
typedef const TIPTBL *PCTIPTBL;

static const TIPTBL TipTbl[] = {
	{IDC_TXT_SNDTEXT	, TEXT("Ｃ言語表記のテキストを設定してください。（ex. ABC\\n）")									},
	{IDC_VTH_TXTCHUNK	, TEXT("リアルタイムに受信したデータをテキストデータとして表示します。\n")
						  TEXT("複数バイト文字の場合は、文字が完結するまで次のリアルタイム受信データを待ちます。")			},
	{IDC_VTH_BINCHUNK	, TEXT("リアルタイムに受信したデータをバイナリデータとして表示します。")							},
	{IDC_VTH_INVCHUNK	, TEXT("リアルタイムに受信したテキストデータに不正な制御コードが含まれる場合は、\n")
						  TEXT("テキストチャンクではなく、不正チャンクテキストとしてバイナリ表示します。\n")
						  TEXT("不正な制御コードとは、TAB(0x09)～CR(0x0D)以外の制御コードを意味します。")					},
	{IDC_VTH_TEXT		, TEXT("受信ストリームから制御コード（TAB以外）で区切られたテキストデータを抜き出して表示します。\n")
						  TEXT("\x1B[34mここにファイルをドロップすると、ファイルの内容をバイナリデータとして送信します。")	},
	{IDC_VTH_CTRL		, TEXT("受信ストリームから制御コード（TAB以外）を抜き出して表示します。")							},
	{IDC_VTH_ESC		, TEXT("受信したストリームから、ＥＳＣシーケンス（0x1B～英字）を抜きだして表示します。")			},
	{IDC_VTH_PKT		, TEXT("受信したパケットデータ（DLE・STX～DLE・ETX でサンドイッチされたデータ）をバイナリ表示します。")},
	{IDC_VTH_NOPKT		, TEXT("リアルタイムに受信したデータ内のパケットデータ（DLE・STX～DLE・ETX）以外の部分をテキストとして表示します。\n")
						  TEXT("複数バイト文字の場合は、文字が完結するまで次のリアルタイム受信データを待ちます。")}
};

#define	MAX_TIPTBL	(sizeof TipTbl / sizeof TipTbl[0])

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
HWND			hDlgMain;						//	ダイアログボックスハンドル

HAJCSCT 		hSct;
BOOL			fConnect = FALSE;
HWND			hWndVthTxtChu;
HWND			hWndVthBinChu;
HWND			hWndVthText;
HWND			hWndVthCtrl;
HWND			hWndVthEsc;
HWND			hWndVthPkt;
HWND			hWndVthInvChu;
HWND			hWndVthPkt;
HWND			hWndVthNoPkt;
HWND			hWndVthLog;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);

static	VO		SubSendFile(HWND hDlg, C_UTP pFName);
static	VO		ShowOnConnect(VO);
static	VO		ShowOnDisconnect(VO);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	int		i;

	hDlgMain		= hDlg;
	hWndVthTxtChu	= GetDlgItem(hDlg, IDC_VTH_TXTCHUNK	);
	hWndVthBinChu	= GetDlgItem(hDlg, IDC_VTH_BINCHUNK	);
	hWndVthText		= GetDlgItem(hDlg, IDC_VTH_TEXT		);
	hWndVthCtrl		= GetDlgItem(hDlg, IDC_VTH_CTRL		);
	hWndVthEsc		= GetDlgItem(hDlg, IDC_VTH_ESC		);
	hWndVthInvChu	= GetDlgItem(hDlg, IDC_VTH_INVCHUNK	);
	hWndVthPkt		= GetDlgItem(hDlg, IDC_VTH_PKT		);
	hWndVthNoPkt	= GetDlgItem(hDlg, IDC_VTH_NOPKT	);
	hWndVthLog		= GetDlgItem(hDlg, IDC_VTH_EVTLOG	);

	//----- ラジオボタンのグループ化 ----------------//
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_RXTEC));
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_TXTEC));

	//----- ダイアログ項目の初期化 ------------------//
	AjcSetDlgItemStr (hDlg, IDC_TXT_SNDTEXT  , TEXT("東京都港区赤坂1-2-3\\n"));
	AjcSetDlgItemStr (hDlg, IDC_TXT_SNDESC	 , TEXT("[31m" 					));
	AjcSetDlgItemStr (hDlg, IDC_TXT_SNDBIN	 , TEXT("00 01 02" 				));
	AjcSetDlgItemStr (hDlg, IDC_TXT_SNDPKT	 , TEXT("10 11 12" 				));
	AjcSetDlgItemStr (hDlg, IDC_TXT_SNDWORD14, TEXT("100"					));
	AjcSetDlgItemChk (hDlg, IDC_CHK_RTS		 , TRUE);
	AjcSetDlgItemChk (hDlg, IDC_CHK_DTR		 , TRUE);
	AjcSetDlgItemUInt(hDlg, IDC_GRP_RXTEC	 , 0	);
	AjcSetDlgItemUInt(hDlg, IDC_GRP_TXTEC	 , 0	);
	AjcSetDlgItemStr (hDlg, IDC_TXT_SERV	 , TEXT("127.0.0.1"));
	AjcSetDlgItemUInt(hDlg, IDC_TXT_PORTNO	 , 14238);

	//----- テキストボックス長設定 ------------------//
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_SNDTEXT, MAX_TXTBOX_LEN - 1);
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_SNDESC , MAX_TXTBOX_LEN - 1);
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_SNDBIN , MAX_TXTBOX_LEN - 1);
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_SNDPKT , MAX_TXTBOX_LEN - 1);

	//----- ツールチップ設定 ------------------------//
	for (i = 0; i < MAX_TIPTBL; i++) {
		AjcTipTextAdd(GetDlgItem(hDlg, TipTbl[i].id), TipTbl[i].pTxt);
	}

	//----- ウインド位置ロード ----------------------//
	AjcLoadWndPos(hDlg, NULL);

	//----- ＳＣＴセットアップ ----------------------//
	hSct = AjcSctCreate(); 											//	ＳＣＴインスタンス生成
	AjcSctSetRxTextCode(hSct, AJCSCT_TXT_AUTO);						//	受信テキストコード自動判別
	AjcSctSetTxTextCode(hSct, AJCSCT_TXT_AUTO);						//	送信テキストコード＝受信と同じ
	AjcSctSetEvtMask(hSct,	0 | 									//	イベントマスク設定
							AJCSCT_EV_RXTEXT		|				//		テキスト受信通知
							AJCSCT_EV_RXESC 		|				//		ＥＳＣコード受信通知
							AJCSCT_EV_RXCTRL		|				//		制御コード受信通知
							AJCSCT_EV_RXPKT 		|				//		パケットデータ受信通知
							AJCSCT_EV_RXNOPKT		|				//		パケット外データ受信通知
							AJCSCT_EV_RXCHUNK		|				//		チャンクデータ受信通知
							AJCSCT_EV_INVCHUNK		|				//		不正チャンクテキスト受信通知
							AJCSCT_EV_TXEMPTY		|				//		送信完了
							AJCSCT_EV_CONNECT		|				//		接続通知
							AJCSCT_EV_DISCONNECT	|				//		切断通知
							AJCSCT_EV_CNFAIL		|				//		接続失敗通知
							AJCSCT_EV_RXERR			|				//		受信エラー通知
							AJCSCT_EV_TXERR			|				//		送信エラー通知
							AJCSCT_EV_ERR			|				//		その他のエラー通知
	0);
	//	バイナリチャンク、テキストチャンクとも通知する
	AjcSctSetChunkMode(hSct, AJCSCT_CM_BOTH);

	//----- 初期グレー表示 --------------------------//
	AjcEnableDlgGroup(hDlgMain, IDC_GRP_SETSIG, FALSE, FALSE);
	AjcEnableDlgGroup(hDlgMain, IDC_GRP_SIGSTS, FALSE, FALSE);
	AjcEnableDlgGroup(hDlgMain, IDC_GRP_SEND  , FALSE, FALSE);
	AjcEnableDlgGroup(hDlgMain, IDC_GRP_RECV  , FALSE, FALSE);
	//----- ダイアログ項目のロード ------------------//
	AjcLoadAllControlSettings (hDlg, TEXT("DlgSetting"), AJCOPT2(AJCCTL_SELACT_, ALL, NTCRBT));

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//----- ウインド位置セーブ ----------------------------//
	AjcSaveWndPos(hDlg, NULL);
	//----- ダイアログ項目のセーブ ------------------------//
	AjcSaveAllControlSettings(hDlg);

	AjcSctDelete(hSct); 		//	ＳＣＴインスタンス消去
	PostQuitMessage(0);
	return TRUE;
}
//----- ＳＣＴイベント通知 -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_SCTEVENT		)
{
	UI		time = GetTickCount();
	UI		len, param;
	union {UBP pBin; UWP pWord; UTP pTxt; VOP vp;} u;

	AjcSctGetEventData(hSct, lParam, &u.vp, &len, &param);				//	イベントデータ取得
	if(wParam & AJCSCT_EV_CONNECT) {									//	●接続通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: CONNECT   len=%5d, param=0x%08X\n"), time, len, param);
		fConnect = TRUE;
		ShowOnConnect();
	}
	if(wParam & AJCSCT_EV_DISCONNECT) {									//	●切断通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: DISC.     len=%5d, param=0x%08X\n"), time, len, param);
		fConnect = FALSE;
		ShowOnDisconnect();
	}
	if (wParam & AJCSCT_EV_CNFAIL) {									//	●接続失敗通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: CNERR     len=%5d, param=0x%08X\n"), time, len, param);
		MessageBox(hDlg, TEXT("接続を失敗しました"), TEXT("Error"), MB_ICONERROR);
	}
	if(wParam & AJCSCT_EV_RXCHUNK)		{								//	●チャンクデータ受信通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: RXCHUNK   len=%5d, param=0x%08X\n"), time, len, param);
		//	バイナリチャンク
		if (param == 0) {
			AjcVthHexDump(hWndVthBinChu, (C_VOP)u.pBin, len);
			AjcVthPrintF (hWndVthBinChu, TEXT("\n"));
		}
		//	テキストチャンク
		else {
			AjcVthPutText(hWndVthTxtChu, u.pTxt, -1);
		}
	}
	if (wParam & AJCSCT_EV_RXTEXT ) {									//	●テキスト受信通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: RXTEXT    len=%5d, param=0x%08X\n"), time, len, param);
		AjcVthPrintF(hWndVthText, TEXT("%s\n"), u.pTxt);				//		テキストデータ表示
	}
	if (wParam & AJCSCT_EV_RXESC  ) {									//	●ＥＳＣコード受信通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: RXESC     len=%5d, param=0x%08X\n"), time, len, param);
		AjcVthPrintF(hWndVthEsc, TEXT("\\x1B%s\n"), u.pTxt + 1);			//		ＥＳＣデータ表示
	}
	if (wParam & AJCSCT_EV_RXCTRL ) {									//	●制御コード受信通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: RXCTRL    len=%5d, param=0x%08X, data=%02X\n"), time, len, param, *u.pBin);
		AjcVthPrintF(hWndVthCtrl, TEXT("%02X\n"), *u.pTxt);				//		制御コード表示
	}
	if (wParam & AJCSCT_EV_RXPKT  ) {									//	●パケットデータ受信通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: RXPKT     len=%5d, param=0x%08X\n"), time, len, param);
		AjcVthHexDump(hWndVthPkt, (C_VOP)u.pBin, len);
		AjcVthPrintF (hWndVthPkt, TEXT("\n"));
	}
	if (wParam & AJCSCT_EV_TXEMPTY) {									//	●送信完了通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: TXEMPTY   len=%5d, param=0x%08X\n"), time, len, param);
	}
	if (wParam & AJCSCT_EV_RXNOPKT) { 									//	●パケット外テキスト受信通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: RXNOPKT   len=%5d, param=0x%08X\n"), time, len, param);
		AjcVthPutText(hWndVthNoPkt, u.pTxt, -1);						//		パケット外テキスト表示
	}
	if (wParam & AJCSCT_EV_INVCHUNK) { 									//	●不正テキストチャンク通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: INVCHUNK  len=%5d, param=0x%08X\n"), time, len, param);
		AjcVthHexDump(hWndVthInvChu, (C_VOP)u.pBin, len);
		AjcVthPrintF (hWndVthInvChu, TEXT("\n"));
	}
	if (wParam & AJCSCT_EV_RXERR	  ) {								//	●受信エラー通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: RXERR     len=%5d, param=0x%08X\n"), time, len, param);
	}
	if (wParam & AJCSCT_EV_TXERR	  ) {								//	●送信エラー通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: TXERR     len=%5d, param=0x%08X\n"), time, len, param);
	}
	if (wParam & AJCSCT_EV_ERR		  ) {								//	●その他のエラー通知
		AjcVthPrintF(hWndVthLog, TEXT("%9d: ERR       len=%5d, param=0x%08X\n"), time, len, param);
	}
	AjcSctRelEventData(hSct, lParam);									//	イベントデータ開放

	return TRUE;
}
//----- ウインドクローズ ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//----- テキスト送信ボタン -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SNDTEXT	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		UT	txt[MAX_TXTBOX_LEN];
		UT	snd[MAX_TXTBOX_LEN];
		AjcGetDlgItemStr(hDlg, IDC_TXT_SNDTEXT, txt, AJCTSIZE(txt));
		AjcCLangStrToBin(txt, snd, AJCTSIZE(snd));
		AjcSctSendText(hSct, snd, -1);
	}
	return TRUE;
}
//----- ＥＳＣ送信ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SNDESC	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		UT	txt[MAX_TXTBOX_LEN];
		AjcGetDlgItemStr(hDlg, IDC_TXT_SNDESC, txt, AJCTSIZE(txt));
		AjcSctSendChar(hSct, 0x1B);
		AjcSctSendText(hSct, txt, -1);
	}
	return TRUE;
}
//----- バイナリ送信ボタン -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SNDBIN	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		UI	ix;
		UTP	p;
		UT	txt[MAX_TXTBOX_LEN];
		UB	bin[MAX_TXTBOX_LEN];
		ix = 0;
		AjcGetDlgItemStr(hDlg, IDC_TXT_SNDBIN, txt, AJCTSIZE(txt));
		if (p = MAjcStrTok(txt, TEXT(" "))) {
			do {
				if (AjcHexStrToUB(p, 2, &bin[ix])) {
					ix++;
				}
			} while (p = MAjcStrTok(NULL, TEXT(" ")));
		}
		if (ix != 0) {
			AjcSctSendBinData(hSct, bin, ix);
		}
	}
	return TRUE;
}
//----- パケット送信ボタン -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SNDPKT	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		UI	ix;
		UTP	p;
		UT	txt[MAX_TXTBOX_LEN];
		UB	bin[MAX_TXTBOX_LEN];
		ix = 0;
		AjcGetDlgItemStr(hDlg, IDC_TXT_SNDPKT, txt, AJCTSIZE(txt));
		if (p = MAjcStrTok(txt, TEXT(" "))) {
			do {
				if (AjcHexStrToUB(p, 2, &bin[ix])) {
					ix++;
				}
			} while (p = MAjcStrTok(NULL, TEXT(" ")));
		}
		if (ix != 0) {
			AjcSctSendPacket(hSct, bin, ix);
		}
	}
	return TRUE;
}

//----- 接続／切断 ボタン --------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_CONNECT	)
{

	if (HIWORD(wParam) == BN_CLICKED) {
		if (fConnect) {
			AjcSctDisconnect(hSct);
		}
		else {
			UT		szServ[256];
			UT		szPort[256];
			AjcGetDlgItemStr(hDlg, IDC_TXT_SERV  , szServ, AJCTSIZE(szServ));
			AjcGetDlgItemStr(hDlg, IDC_TXT_PORTNO, szPort, AJCTSIZE(szPort));
			AjcSctConnect(hSct, szServ, szPort, AF_INET, hDlg, WM_SCTEVENT);
		}
	}
	return TRUE;
}
//----- 受信テキストエンコード ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_GRP_RXTEC		)
{
	if (HIWORD(wParam) == AJCRBTN_SELECT) {
		//	受信テキストエンコード設定
		switch (lParam) {
			case 0: AjcSctSetRxTextCode(hSct, AJCSCT_TXT_SJIS);	break;
			case 1: AjcSctSetRxTextCode(hSct, AJCSCT_TXT_UTF8);	break;
			case 2: AjcSctSetRxTextCode(hSct, AJCSCT_TXT_EUC );	break;
			case 3: AjcSctSetRxTextCode(hSct, AJCSCT_TXT_AUTO);	break;
		}
		//	送信テキストエンコード設定（送信エンコードが AUTO の場合、受信エンコードと同一とするため）
		SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_GRP_TXTEC, AJCRBTN_SELECT), AjcGetDlgItemUInt(hDlg, IDC_GRP_TXTEC));
	}
	return TRUE;
}
//----- 送信テキストエンコード ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_GRP_TXTEC		)
{
	if (HIWORD(wParam) == AJCRBTN_SELECT) {
		//	送信テキストエンコード設定
		switch (lParam) {
			case 0: AjcSctSetTxTextCode(hSct, AJCSCT_TXT_SJIS);	break;
			case 1: AjcSctSetTxTextCode(hSct, AJCSCT_TXT_UTF8);	break;
			case 2: AjcSctSetTxTextCode(hSct, AJCSCT_TXT_EUC );	break;
			case 3: AjcSctSetTxTextCode(hSct, AJCSCT_TXT_AUTO);	break;
		}
	}
	return TRUE;
}
//----- 全てクリアーボタン -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_CLRALL	)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		AjcVthClear(hWndVthTxtChu	);
		AjcVthClear(hWndVthBinChu	);
		AjcVthClear(hWndVthText		);
		AjcVthClear(hWndVthCtrl		);
		AjcVthClear(hWndVthEsc		);
		AjcVthClear(hWndVthInvChu	);
		AjcVthClear(hWndVthPkt		);
		AjcVthClear(hWndVthNoPkt	);
	}
	return TRUE;
}
//----- ＶＴＨ（テキスト）からの通知 ---------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_VTH_TEXT	)
{
	if (HIWORD(wParam) == AJCVTHN_DROPFILE) {		//	ファイルドロップ
		UI		i, nFile = (UI)lParam;
		HANDLE	hFile;
		UL		bytes;
		UT		path[MAX_PATH];
		UB		buf[2014];
		for (i = 0; i < nFile; i++) {
			AjcVthGetDroppedFile(hWndVthText, path);
			if ((hFile = CreateFile(path, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, NULL)) != INVALID_HANDLE_VALUE) {
				while (ReadFile(hFile, buf, sizeof buf, &bytes, NULL) && bytes != 0) {
					AjcSctSendBinData(hSct, buf, bytes);
				}
				CloseHandle(hFile);
			}
		}
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG		)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 		)
	AJC_DLGMAP_MSG(Main, WM_SCTEVENT		)
	AJC_DLGMAP_CMD(Main, IDCANCEL			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SNDTEXT	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SNDESC		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SNDBIN		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SNDPKT		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_CONNECT 	)
	AJC_DLGMAP_CMD(Main, IDC_GRP_RXTEC	 	)
	AJC_DLGMAP_CMD(Main, IDC_GRP_TXTEC	 	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_CLRALL 	)
	AJC_DLGMAP_CMD(Main, IDC_VTH_TEXT	 	)
AJC_DLGMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	ファイル送信																								//
//--------------------------------------------------------------------------------------------------------------//
VO		SubSendFile(HWND hDlg, C_UTP pFName)
{
	HANDLE	fh;
	UL		bytes;
	UT		path[MAX_PATH];
	UT		buf[1024];

	AjcGetAppPath(path, MAX_PATH);
	MAjcStrCat(path, AJCTSIZE(path), pFName);
	fh = CreateFile(path, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (fh != INVALID_HANDLE_VALUE) {
		while (ReadFile(fh, buf, AJCTSIZE(buf), &bytes, NULL) && bytes != 0) {
			AjcSctSendBinData(hSct, buf, bytes);
		}
		CloseHandle(fh);
	}
	else {
		UT		txt[512];
		AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("'%s' open falure!"), path);
		MessageBox(hDlgMain, txt, TEXT("Error"), MB_ICONERROR);
	}
}

//--------------------------------------------------------------------------------------------------------------//
//	接続時の表示																								//
//--------------------------------------------------------------------------------------------------------------//
static	VO		ShowOnConnect(VO)
{
	AjcSetDlgItemStr (hDlgMain, IDC_CMD_CONNECT, TEXT("切 断"));		//	ボタンフェース
	AjcEnableDlgGroup(hDlgMain, IDC_GRP_SEND, TRUE, TRUE);				//	送信表示有効化
	AjcEnableDlgGroup(hDlgMain, IDC_GRP_RECV, TRUE, TRUE);				//	受信表示有効化
}
//--------------------------------------------------------------------------------------------------------------//
//	切断時の表示																								//
//--------------------------------------------------------------------------------------------------------------//
static	VO		ShowOnDisconnect(VO)
{
	AjcSetDlgItemStr (hDlgMain, IDC_CMD_CONNECT, TEXT("接 続"));		//	ボタンフェース
	AjcEnableDlgGroup(hDlgMain, IDC_GRP_SEND, FALSE, FALSE);			//	送信表示無効化
	AjcEnableDlgGroup(hDlgMain, IDC_GRP_RECV, FALSE, FALSE);			//	受信表示無効化
}
