﻿//
//	SW_SockServer2C.c
//
//	コマンド形式：	SW_SockServer2C	[/P<ポート番号>]  [/C<最大クライアント数>] [/IPV6]
//
#define AJCSERIALCOMPORT_H_
#define	AJCSOCKCLIENT_H_
#include	<AjrCstXX.h>
#include	<conio.h>

//--------------------------------------------------------------------------------------------------------------//
//	クライアント情報
#define	MAX_CLIENT	10
typedef struct {
	UT		ipaddr[256];
	UI		bytes;
} ClientsInfo, *PClientsInfo;

static	ClientsInfo	CliTbl[MAX_CLIENT] = {0};

//--------------------------------------------------------------------------------------------------------------//
//	ワーク
static	HAJCSSV 	hSsv;

//--------------------------------------------------------------------------------------------------------------//
//	コンソール強制終了ハンドラ
static BOOL CALLBACK cbConApExit(DWORD CtrlType)
{
	if (hSsv != NULL) {
		AjcSsvDelete(hSsv);
		hSsv = NULL;
	}
	return FALSE;	//	FALSE : 次のハンドラをコール
}
//--------------------------------------------------------------------------------------------------------------//
//	主制御
int  AjcMain(int argc, UTP argv[])
{
	BOOL		fEnd = FALSE;
	WPARAM		wParam;
	LPARAM		lParam;
	union {UTP pTxt; UBP pBin; VOP pVoid;} u;
	UI			len;
	UI			param;
	UTP			pPort = TEXT("14238");
	UI			MaxCli = SOMAXCONN;
	UI			Family = AF_INET;
	int			CurBaseX, CurBaseY;
	UI			bytes;
	UT			MyHostName[MAX_COMPUTERNAME_LENGTH + 1] = {0};

	AjcSetStdoutMode();

	//	コンソール強制終了ハンドラ設定
	SetConsoleCtrlHandler(cbConApExit, TRUE);

	//	初期表示
	bytes = (AJCTSIZE(MyHostName));
	GetComputerName(MyHostName, &bytes);
	AjcPrintF(TEXT("\n"));
	AjcPrintF(TEXT(" エコーサーバ \n"));
	AjcPrintF(TEXT("\n"));
	AjcPrintF(TEXT("   ホスト名　：%s\n"), MyHostName);
	AjcPrintF(TEXT("   ポート番号：14238\n"));
	AjcPrintF(TEXT("\n"));
	AjcPrintF(TEXT(" いずれかのキーを押すと、プログラムを終了します。\n"));
	AjcPrintF(TEXT("\n"));
	AjcPrintF(TEXT("      No. IP-Address      Bytes\n"));
	AjcPrintF(TEXT("\n"));
	AjcPrintF(TEXT("       1. -               -\n"));
	AjcPrintF(TEXT("       2. -               -\n"));
	AjcPrintF(TEXT("       3. -               -\n"));
	AjcPrintF(TEXT("       4. -               -\n"));
	AjcPrintF(TEXT("       5. -               -\n"));
	AjcPrintF(TEXT("       6. -               -\n"));
	AjcPrintF(TEXT("       7. -               -\n"));
	AjcPrintF(TEXT("       8. -               -\n"));
	AjcPrintF(TEXT("       9. -               -\n"));
	AjcPrintF(TEXT("      10. -               -\n"));
	//	カーソル位置取得
	AjcGetConsoleCursor(&CurBaseX, &CurBaseY);
	CurBaseY -= 10;
	//	ソケットサーバ インスタンス生成
	hSsv = AjcSsvCreate();
	//	送受信テキスト文字コード設定
	AjcSsvSetRxTextCode(hSsv, AJCSSV_TXT_AUTO);
	AjcSsvSetTxTextCode(hSsv, AJCSSV_TXT_AUTO);
	//	バイナリチャンクモード設定
	AjcSsvSetChunkMode(hSsv, AJCSSV_CM_BIN);
	//	対象とするイベントを設定
	AjcSsvSetEvtMask(hSsv, AJCSSV_EV_CONNECT | AJCSSV_EV_DISCONNECT | AJCSSV_EV_RXCHUNK | AJCSSV_EV_STOP);
	//	サーバスタート
	AjcSsvStart(hSsv, TEXT("14238"), AF_INET, 10, NULL, 0);

	while (!fEnd) {
		//	いずれかのキー押下で終了
		if (_kbhit()) {
			AjcSsvStop(hSsv, 10000);
		}

		if (AjcSsvWaitEvent(hSsv, &wParam, &lParam, 200)) { //	イベント待ち(200ms)，イベントあり？
			HAJCSSVCLI		hCli = NULL;
			UT				szIpAddr[256] = {0};
			//	イベントデータ取得
			AjcSsvGetEventData(hSsv, lParam, &u.pVoid, &len, &param);
			//	クライアント情報を取得し、クライアントのＩＰアドレスを設定
			if (AjcSsvGetClient(hSsv, lParam, &hCli)) {
				AjcSsvGetIpAddrStr(hCli, szIpAddr, AJCTSIZE(szIpAddr));
			}
			//	各イベント処理
			//	●接続通知
			if ((wParam & AJCSSV_EV_CONNECT) != 0) {
				//	クライアントインデクス取得
				UI		ix = AjcSsvGetIndex(hCli);
				//	テーブルエントリ設定
				MAjcStrCpy(CliTbl[ix].ipaddr, AJCTSIZE(CliTbl[ix].ipaddr), szIpAddr);
				CliTbl[ix].bytes  = 0;
				//	クライアント情報初期表示
				AjcSetConsoleCursor(10, CurBaseY + ix);	AjcPrintF(CliTbl[ix].ipaddr);
				AjcSetConsoleCursor(26, CurBaseY + ix);	AjcPrintF(TEXT("%d"), CliTbl[ix].bytes);
			}
			//	●切断通知
			if ((wParam & AJCSSV_EV_DISCONNECT) != 0) {
				//	クライアントインデクス取得
				UI	ix = AjcSsvGetIndex(hCli);;
				//	クライアント情報を消す
				AjcSetConsoleCursor(10, CurBaseY + (UI)ix);	AjcPrintF(TEXT("-               "));
				AjcSetConsoleCursor(26, CurBaseY + (UI)ix);	AjcPrintF(TEXT("-               "));
			}
			//	●バイナリチャンク受信通知
			if ((wParam & AJCSSV_EV_RXCHUNK) != 0) {
				//	クライアントインデクス取得
				UI	ix = AjcSsvGetIndex(hCli);;
				//	受信バイト数を表示
				CliTbl[ix].bytes += len;
				AjcSetConsoleCursor(26, (int)(CurBaseY + ix)); AjcPrintF(TEXT("%u"), CliTbl[ix].bytes);
				//	受信データを返信
				AjcSsvSendBinData(hCli, u.pBin, len);
			}
			//	●サーバ終了通知
			if ((wParam & AJCSSV_EV_STOP) != 0) {
				fEnd = TRUE;
			}
			//	イベントデータ開放
			AjcSsvRelEventData(hSsv, lParam);
		}
	}
	//	ソケットサーバ インスタンス消去
	if (hSsv != NULL) {
		AjcSsvDelete(hSsv);
		hSsv = NULL;
	}

	AjcSetConsoleCursor(0, CurBaseY + 10);
	AjcPrintF(TEXT("Hit enter key !"));
	getchar();
	return 0;
}
