﻿//
//	SW_SubClass1.c
//
#include	<AjrCstXX.h>
#include	<tchar.h>
#include	"resource.h"

#define		WM_APP_ASCII	(WM_APP + 0)
#define		WM_APP_UNICODE	(WM_APP + 1)

//----- 作業領域 -----------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;
static	HWND			hDlgMain;
static	HWND			hButton;
static	HWND			hChk1, hChk2, hChk3;
static	HWND			hVth;
static	UB				fSubClass = 0x00;

//----- 内部サブ関数 -------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
AJC_WNDPROC_DEF(SUB1);
AJC_WNDPROC_DEF(SUB2);
AJC_WNDPROC_DEF(SUB3);
static	VO	ShowButtonFace(HWND hDlg);
static	VO	ShowSubclassInfo(VO);

//--------------------------------------------------------------------------------------------------------------//
int WINAPI AjcWinMain(HINSTANCE hInstance, HINSTANCE hinstPrev, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	AjcDgcSetup();

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_MAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	hDlgMain = hDlg;
	hButton  = GetDlgItem(hDlg, IDC_BUTTON);
	hVth	 = GetDlgItem(hDlg, IDC_VTH);
	hChk1	 = GetDlgItem(hDlg, IDC_CHK_SUB1);
	hChk2	 = GetDlgItem(hDlg, IDC_CHK_SUB2);
	hChk3	 = GetDlgItem(hDlg, IDC_CHK_SUB3);

	ShowButtonFace(hDlg);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_TIMER		)
{
	KillTimer(hDlg, 1);
	AjcVthPrintF(hVth, TEXT("\n"));
	return TRUE;
}
//----- タイマ -------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	PostQuitMessage(0);
	return TRUE;
}
//----- IDC_BUTTON ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_BUTTON		)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		AjcVthPrintF(hVth, TEXT("\nIDC_BUTTON : ボタン・クリック・イベント(BN_CLICKED)が発生しました\n\n"));
	}
	return TRUE;
}
//----- サブクラス化（ SUB1 ) ----------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CHK_SUB1		)
{
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_SUB1)) {
		MAjcMmpSetSubclass(SUB1, hButton);
		AjcVthPrintF(hVth, TEXT("SUB1 - Subclassed\n"));
		AjcEnableDlgGroup(hDlg, IDC_GRP_TEST, TRUE, TRUE);
	}
	else {
		MAjcMmpClrSubclass(SUB1, hButton);
		AjcVthPrintF(hVth, TEXT("SUB1 - Un-Subclassed\n"));
		AjcEnableDlgGroup(hDlg, IDC_GRP_TEST, TRUE, FALSE);
	}
	ShowSubclassInfo();
	return TRUE;
}
//----- サブクラス化（ SUB2 ) ----------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CHK_SUB2		)
{
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_SUB2)) {
		MAjcMmpSetSubclass(SUB2, hButton);
		AjcVthPrintF(hVth, TEXT("SUB2 - Subclassed\n"));
	}
	else {
		MAjcMmpClrSubclass(SUB2, hButton);
		AjcVthPrintF(hVth, TEXT("SUB2 - Un-Subclassed\n"));
	}
	ShowSubclassInfo();
	return TRUE;
}
//----- サブクラス化（ SUB3 ) ----------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CHK_SUB3		)
{
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_SUB3)) {
		MAjcMmpSetSubclass(SUB3, hButton);
		AjcVthPrintF(hVth, TEXT("SUB3 - Subclassed\n"));
	}
	else {
		MAjcMmpClrSubclass(SUB3, hButton);
		AjcVthPrintF(hVth, TEXT("SUB3 - Un-Subclassed\n"));
	}
	ShowSubclassInfo();
	return TRUE;
}
//----- サブクラス化解除ボタン ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_CLRSUB	)
{
	MAjcMmpClrSubclass(SUB1, hButton);
	MAjcMmpClrSubclass(SUB2, hButton);
	MAjcMmpClrSubclass(SUB3, hButton);
	AjcSetDlgItemChk(hDlg, IDC_CHK_SUB1, FALSE);
	AjcSetDlgItemChk(hDlg, IDC_CHK_SUB2, FALSE);
	AjcSetDlgItemChk(hDlg, IDC_CHK_SUB3, FALSE);
	ShowSubclassInfo();
	return TRUE;
}
//----- ログ表示クリアーボタン ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_CLRLOG	)
{
	AjcVthClear(hVth);
	return TRUE;
}
//----- キャンセル ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//----- SendMessageA(hButton, WM_SETTEXT, 0, (LPARAM)"ABC");実行 -----------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SETA	)
{
	AjcVthPrintF(hVth, TEXT("SendMessageA(hButton, WM_SETTEXT, 0, (LPARAM)\"ABC\");\n"));
	SendMessageA(hButton, WM_SETTEXT, 0, (LPARAM)"ABC");
	return TRUE;
}
//----- SendMessageW(hButton, WM_SETTEXT, 0, (LPARAM)L"DEF"); --------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SETW	)
{
	AjcVthPrintF(hVth, TEXT("SendMessageW(hButton, WM_SETTEXT, 0, (LPARAM)L\"DEF\");\n"));
	SendMessageW(hButton, WM_SETTEXT, 0, (LPARAM)L"DEF");
	return TRUE;
}
//----- SendMessageA(hButton, WM_APP, 0, (LPARAM)"012");実行 ---------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_USRA	)
{
	AjcVthPrintF(hVth, TEXT("SendMessageA(hButton, WM_APP_ASCII, 0, (LPARAM)\"012\");\n"));
	SendMessageA(hButton, WM_APP_ASCII, 0, (LPARAM)"012");
	return TRUE;
}
//----- SendMessageW(hButton, WM_APP, 0, (LPARAM)"345");実行 ---------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_USRW	)
{
	AjcVthPrintF(hVth, TEXT("SendMessageW(hButton, WM_APP_UNICODE, 0, (LPARAM)L\"345\");\n"));
	SendMessageW(hButton, WM_APP_UNICODE, 0, (LPARAM)L"345");
	return TRUE;
}
//----- SendMessageA(hButton, WM_GETTEXT, n, (LPARAM)buf);実行 --^^---------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_GETA	)
{
	BC	buf[256];
	AjcVthPrintF(hVth, TEXT("SendMessageA(hButton, WM_GETTEXT, 256, (LPARAM)buf););\n"));
	SendMessageA(hButton, WM_GETTEXT, 256, (LPARAM)buf);
	AjcVthPrintFA(hVth,  "取得したテキスト：\"%s\" (ASCII)\n\n", buf);
	return TRUE;
}
//----- SendMessageW(hButton, WM_SETTEXT, n, (LPARAM)buf); -----------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_GETW	)
{
	WC	buf[256];
	AjcVthPrintF(hVth, TEXT("SendMessageW(hButton, WM_GETTEXT, 256, (LPARAM)buf);\n"));
	SendMessageW(hButton, WM_GETTEXT, 256, (LPARAM)buf);
	AjcVthPrintFW(hVth,  L"取得したテキスト：L\"%s\" (UNICODE)\n\n", buf);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	   )
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	   )
	AJC_DLGMAP_MSG(Main, WM_TIMER	 	   )
	AJC_DLGMAP_CMD(Main, IDC_BUTTON		   )
	AJC_DLGMAP_CMD(Main, IDC_CHK_SUB1	   )
	AJC_DLGMAP_CMD(Main, IDC_CHK_SUB2	   )
	AJC_DLGMAP_CMD(Main, IDC_CHK_SUB3	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_CLRSUB	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_CLRLOG	   )
	AJC_DLGMAP_CMD(Main, IDCANCEL		   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_SETA	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_SETW	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_USRA	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_USRW	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_GETA	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_GETW	   )
AJC_DLGMAP_END
//--------------------------------------------------------------------------------------------------------------//
//	サブクラス１																								//
//--------------------------------------------------------------------------------------------------------------//
//----- WM_RBUTTONDOWN -----------------------------------------------------------------------------------------//
AJC_WNDPROC(SUB1, WM_RBUTTONDOWN			)
{
	AjcVthPrintF(hVth, TEXT("SUB1 ------- 右クリックしました。\n"));
	SetTimer(hDlgMain, 1, 10, NULL);
	return MAjcMmpCallOrgWndProc(SUB1);
}
//----- WM_SETTEXT ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(SUB1, WM_SETTEXT				)
{
#ifdef UNICODE
	AjcVthPrintFW(hVth, L"  WM_SETTEXT    で通知されたテキストデータ : L\"%s\" (UNICODE)\n\n", lParam);
#else
	AjcVthPrintFA(hVth,  "  WM_SETTEXT    で通知されたテキストデータ :  \"%s\" (ASCII)\n\n"  , lParam);
#endif
	return 0;	//	インターセプト
}
//----- WM_APP_ASCII -------------------------------------------------------------------------------------------//
AJC_WNDPROC(SUB1, WM_APP_ASCII				)
{
	AjcVthPrintFA(hVth,  "  WM_APP_ASCII  で通知されたテキストデータ :  \"%s\" (ASCII)\n\n", lParam);
	return 0;	//	インターセプト
}
//----- WM_APP_UNICODE -----------------------------------------------------------------------------------------//
AJC_WNDPROC(SUB1, WM_APP_UNICODE			)
{
	AjcVthPrintFW(hVth, L"  WM_APP_UNICODEで通知されたテキストデータ : L\"%s\" (UNICODE)\n\n", lParam);
	return 0;	//	インターセプト
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SUB1)
	AJC_WNDMAP_MSG(SUB1, WM_RBUTTONDOWN	   )
	AJC_WNDMAP_MSG(SUB1, WM_SETTEXT		   )
	AJC_WNDMAP_MSG(SUB1, WM_APP_ASCII	   )
	AJC_WNDMAP_MSG(SUB1, WM_APP_UNICODE	   )
AJC_WNDMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	サブクラス２																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(SUB2, WM_RBUTTONDOWN			)
{
	AjcVthPrintF(hVth, TEXT("SUB2 ------- 右クリックしました。\n"));
	SetTimer(hDlgMain, 1, 10, NULL);
	return MAjcMmpCallOrgWndProc(SUB2);
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SUB2)
	AJC_WNDMAP_MSG(SUB2, WM_RBUTTONDOWN	   )
AJC_WNDMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	サブクラス３																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(SUB3, WM_RBUTTONDOWN			)
{
	AjcVthPrintF(hVth, TEXT("SUB3 ------- 右クリックしました。\n"));
	SetTimer(hDlgMain, 1, 10, NULL);
	return MAjcMmpCallOrgWndProc(SUB3);
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SUB3)
	AJC_WNDMAP_MSG(SUB3, WM_RBUTTONDOWN	   )
AJC_WNDMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	ボタンフェース表示																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO	ShowButtonFace(HWND hDlg)
{
	if (IsWindowUnicode(hButton)) AjcSetDlgItemStr(hDlg, IDC_LBL_CHARTYPE, TEXT("下のボタンは UNICODE Window です"));
	else						  AjcSetDlgItemStr(hDlg, IDC_LBL_CHARTYPE, TEXT("下のボタンは ASCII Window です"));
}

//--------------------------------------------------------------------------------------------------------------//
//	サブクラス情報表示																							//
//--------------------------------------------------------------------------------------------------------------//
static	UTP	WpName(WNDPROC wp)
{
	static UT txt[128];
	if		(wp == AJC_WNDPROC_NAME(SUB1)) return(TEXT("SUB1"));
	else if (wp == AJC_WNDPROC_NAME(SUB2)) return(TEXT("SUB2"));
	else if (wp == AJC_WNDPROC_NAME(SUB3)) return(TEXT("SUB3"));
	else  AjcSnPrintF(txt, 128, TEXT("%p"), wp);
	return txt;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
static	VO	ShowSubclassInfo(VO)
{
	PAJCSBCINFO pBuf = NULL;
	UI			i, n;

	if (n = AjcMmpGetSubclassInfo(hButton, NULL, 0)) {
		AjcVthPrintF(hVth, TEXT("\n--- Subclass Info. ---\n"));
		if (pBuf = (PAJCSBCINFO)malloc(sizeof(AJCSBCINFO) * n)) {
			AjcMmpGetSubclassInfo (hButton, pBuf, n);
			for (i = 0; i < n; i++) {
				AjcVthPrintFA(hVth, pBuf[i].pName);
				AjcVthPrintF(hVth, TEXT(" : wpOld = %-8s, wpNew = %-8s, WpRet=%s\n"), WpName(pBuf[i].wpOld),
																					  WpName(pBuf[i].wpNew),
																					  WpName(pBuf[i].wpRet));
			}
			free(pBuf);
		}
		AjcVthPrintF(hVth, TEXT("\n"));
	}
	else {
		AjcVthPrintF(hVth, TEXT("\n--- No Subclass Info. ---\n"));
	}
}
