﻿//
//	SW_SubClass3.c
//
#include	<AjrCstXX.h>
#include	<tchar.h>
#include	"resource.h"

//----- 作業領域 -----------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;
static	HWND			hDlgMain;
static	HWND			hButton;
static	WNDPROC			WndProcButton = NULL;

//----- 内部サブ関数 -------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
AJC_WNDPROC_DEF(SUB);

//--------------------------------------------------------------------------------------------------------------//
int WINAPI AjcWinMain(HINSTANCE hInstance, HINSTANCE hinstPrev, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;
	AjcDgcSetup();
	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_MAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	hDlgMain = hDlg;
	hButton  = GetDlgItem(hDlg, IDC_BUTTON);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	PostQuitMessage(0);
	return TRUE;
}
//----- IDC_CMD_SUBCLASS ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SUBCLASS	)
{
	//	サブクラス化
	WndProcButton = MAjcMmpSetSubclass(SUB, hButton);
	InvalidateRect(hButton, NULL, TRUE);
	//	未処理のメッセージ（AJC_WNDMAP_DEF～AJC_WNDMAP_END間で定義されていないメッセージ）はすべて、
	//	オリジナルのウインドプロシージャを実行しないようにする。（DefWindowProc()を実行するようにする）
	MAjcMmpSetDefWndProc(SUB, hButton);
	//	ボタングレー化
	AjcEnableDlgItem(hDlg, IDC_CMD_SUBCLASS  , FALSE);
	AjcEnableDlgItem(hDlg, IDC_CMD_UNSUBCLASS, TRUE);

	return TRUE;
}
//----- IDC_CMD_UNSUBCLASS -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_UNSUBCLASS)
{
	//	サブクラス化解除
	MAjcMmpClrSubclass(SUB, hButton);
	//	ボタングレー化
	AjcEnableDlgItem(hDlg, IDC_CMD_SUBCLASS  , TRUE);
	AjcEnableDlgItem(hDlg, IDC_CMD_UNSUBCLASS, FALSE);
	//	再描画
	InvalidateRect(hButton, NULL, TRUE);
	return TRUE;
}
//----- IDC_BUTTON ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_BUTTON		)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		MessageBox(hDlg, TEXT("ボタンがクリックされました。\n\n")
						 TEXT("このメッセージはオリジナルのボタンクリックイベントから表示しています。"), TEXT("SW_SubClass3"), MB_OK);
	}
	return TRUE;
}
//----- キャンセル ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SUBCLASS	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_UNSUBCLASS	)
	AJC_DLGMAP_CMD(Main, IDC_BUTTON		)
	AJC_DLGMAP_CMD(Main, IDCANCEL		)
AJC_DLGMAP_END
//--------------------------------------------------------------------------------------------------------------//
//	ボタンをサブクラス化したウインドプロシージャ																//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(SUB, WM_LBUTTONDOWN		)
{
	MessageBox(hwnd, TEXT("ボタンがクリックされました。\n\n")
					 TEXT("このメッセージはサブクラス化されたプロシージャから表示しています。"), TEXT("SW_SubClass3"), MB_OK);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(SUB, WM_PAINT			)
{
	PAINTSTRUCT	ps;
	HDC			hdc;
	HPEN		hPen;
	HBRUSH		hBru;
	RECT		r;
	UT			txt1[] = TEXT("このボタンはハイジャックされました。");
	UT			txt2[] = TEXT("クリックするとサブクラスプロシージャから");
	UT			txt3[] = TEXT("メッセージを表示します。");

	hdc	  = BeginPaint(hwnd, &ps);
	hPen = (HPEN  )SelectObject(hdc, GetStockObject(BLACK_PEN));
	hBru = (HBRUSH)SelectObject(hdc, GetStockObject(WHITE_BRUSH));
	GetClientRect(hwnd, &r);
	Rectangle(hdc, r.left, r.top, r.right, r.bottom);
	SelectObject(hdc, hPen);
	SelectObject(hdc, hBru);

	SetBkMode(hdc, TRANSPARENT);
	TextOut(hdc, 50, 20, txt1, (int)MAjcStrLen(txt1)); 
	TextOut(hdc, 50, 55, txt2, (int)MAjcStrLen(txt2)); 
	TextOut(hdc, 50, 80, txt3, (int)MAjcStrLen(txt3)); 
	EndPaint(hwnd, &ps);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SUB)
	AJC_WNDMAP_MSG(SUB, WM_LBUTTONDOWN	)
	AJC_WNDMAP_MSG(SUB, WM_PAINT		)
AJC_WNDMAP_END

