﻿//
//	SW_TextFile2.c
//
#include	<AjrCstXX.h>
#include	<tchar.h>
#include	"resource.h"

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
HWND			hDlgMain;						//	ダイアログボックスハンドル
HWND			hWndVth;						//	VT100コントロールのハンドル
HWND			hCboInp;						//	入力ファイル・コンボボックス
HICON			hIcon;							//	アイコンハンドル

BOOL			fBusy	= FALSE;				//	ファイルアクセス中フラグ
BOOL			fCancel = FALSE;				//	読み出し／書き込み中止フラグ
BOOL			fExit	= FALSE;				//	プログラム終了フラグ


const EAJCTEC	TecTbl[] = {
	AJCTEC_MBC			,		//	0: マルチバイト
	AJCTEC_UTF_8		,		//	1: ＵＴＦ－８
	AJCTEC_EUC_J		,		//	2: ＥＵＣ（日本語）
	AJCTEC_UTF_16LE 	,		//	3: ＵＴＦ－１６ＬＥ
	AJCTEC_UTF_16BE 	,		//	4: ＵＴＦ－１６ＢＥ
	AJCTEC_AUTO 		,		//	5: ＡＵＴＯ
};
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
#define		CBO_ADD		AjcSetCtrlCboAdd(hCboInp, 0, path, AJCCBF_ALL)
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 		)
{
	UT		path[MAX_PATH];

	hDlgMain = hDlg;
	hWndVth  = GetDlgItem(hDlg, IDC_VTH);
	hCboInp  = GetDlgItem(hDlg, IDC_CBO_INPFILE);

	//----- アイコン読み出し／，設定 ----------------------//
	hIcon = (HICON)LoadImage(hInst, MAKEINTRESOURCE(IDI_ICON1), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
	SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcon);
	//----- バッファサイズの単位 --------------------------//
	#ifdef UNICODE
	AjcSetDlgItemStr(hDlg, IDC_LBL_BUFSIZE, TEXT("[Chars]"));
	#endif
	//----- コンボボックスサブクラス化 --------------------//
	AjcSbcComboBoxEx(hCboInp, 20, MAX_PATH -1, AJCSBCF_DROPFILE);
	AjcSbcSetCompExact(hCboInp, FALSE);
	AjcSbcTipCtrl (hCboInp, TRUE);
	//----- テキストボックス長設定 ------------------------//
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_OUTFILE, MAX_PATH -1);
	//--- ラジオボタングループ化 --------------------------//
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_I_ENC));
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_I_ACC));
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_O_ENC));
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_O_ACC));
	//----- 出力ファイルへのドロップを可能にする ----------//
	AjcEnableDlgItemToDrop(hDlg, IDC_TXT_OUTFILE, AJCDROP_DIR_AND_FILE);
	//----- テキストボックス長設定 ------------------------//
	AjcSetDlgItemEdtLimit(hDlg, IDC_TXT_OUTFILE, MAX_PATH -1);
	//----- コントロール初期化 ----------------------------//
	AjcSetDlgItemUInt(hDlg, IDC_GRP_I_ENC, 0);
	AjcSetDlgItemUInt(hDlg, IDC_GRP_O_ENC, 0);
	AjcSetDlgItemUInt(hDlg, IDC_GRP_I_ACC, 0);
	AjcSetDlgItemUInt(hDlg, IDC_GRP_O_ACC, 0);
	AjcSetDlgItemUInt(hDlg, IDC_INP_BUFSIZE, 256);
	//----- 設定値ロード ----------------------------------//
	AjcDlgItemSetPermAtt (hDlg, IDC_CHK_1ST_LINE, AJCCTL_PSEL_NTC); // チェックイベントを発生させる
	AjcLoadAllControlSettings(hDlg, TEXT("Settings"), AJCCTL_SELACT_CHKEXCLUDE);
	//----- コンボボックスに項目なしならばデフォルト設定 --//
	if (AjcGetDlgItemCboCount(hDlg, IDC_CBO_INPFILE) == 0) {
		AjcGetAppPath(path, sizeof path);	AjcPathCat(path, TEXT("sjis.txt"	  ), MAX_PATH); CBO_ADD;
		AjcGetAppPath(path, sizeof path);	AjcPathCat(path, TEXT("euc.txt" 	  ), MAX_PATH); CBO_ADD;
		AjcGetAppPath(path, sizeof path);	AjcPathCat(path, TEXT("utf8.txt"	  ), MAX_PATH); CBO_ADD;
		AjcGetAppPath(path, sizeof path);	AjcPathCat(path, TEXT("u16LE.txt"	  ), MAX_PATH); CBO_ADD;
		AjcGetAppPath(path, sizeof path);	AjcPathCat(path, TEXT("u16BE.txt"	  ), MAX_PATH); CBO_ADD;
		AjcGetAppPath(path, sizeof path);	AjcPathCat(path, TEXT("utf8(BOM).txt" ), MAX_PATH); CBO_ADD;
		AjcGetAppPath(path, sizeof path);	AjcPathCat(path, TEXT("u16LE(BOM).txt"), MAX_PATH); CBO_ADD;
		AjcGetAppPath(path, sizeof path);	AjcPathCat(path, TEXT("u16BE(BOM).txt"), MAX_PATH); CBO_ADD;
		AjcSetCtrlCboIx(hCboInp, AjcGetCtrlCboFind(hCboInp, -1, path, TRUE));
	}

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY			)
{
	//----- 設定値セーブ ----------------------------------//
	AjcSaveAllControlSettings(hDlg);

	//	プログラム終了
	PostQuitMessage(0);

	return TRUE;
}
//----- キャンセル ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL				)
{
	//	ファイルアクセス中ならば、アクセス後プログラム終了の旨、設定
	if (fBusy) {
		fCancel = TRUE;
		fExit	= TRUE;
	}
	else {
		DestroyWindow(hDlg);
	}
	return TRUE;
}
//----- 読み出しファイル設定ボタン -----------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_INPFILE		)
{
	static UT	path[MAX_PATH] = {0};

	if (HIWORD(wParam) == BN_CLICKED) {
		if (AjcGetOpenFile(hDlg, TEXT("読み出しテキストファイル"), TEXT("TextFile(+.txt)/*.txt/AllFiles(*.*)/*.*"),
																   TEXT("txt"), path, sizeof path)) {
			//	テキストをコンボボックスに登録
			AjcSetCtrlCboAdd(hCboInp, 0, path, AJCCBF_ALL);
		}
	}
	return TRUE;
}
//----- 書き込みファイル設定ボタン -----------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_OUTFILE		)
{
	static UT	path[MAX_PATH] = {0};

	if (HIWORD(wParam) == BN_CLICKED) {
		if (AjcGetSaveFile(hDlg, TEXT("書き込みテキストファイル"), TEXT("TextFile(+.txt)/*.txt/AllFiles(*.*)/*.*"),
																   TEXT("txt"), path, sizeof path)) {
			AjcSetDlgItemStr(hDlg, IDC_TXT_OUTFILE, path);
		}
	}
	return TRUE;
}
//----- ファイル読み出しボタン ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_INPUT 		)
{
	HAJCFILE	hFile = NULL;
	UI			lBuf  = 0;
	UTP 		pBuf  =  NULL;
	UI			ix, cnt = 0;
	EAJCTEC 	tec;
	UT			path[MAX_PATH];

	if (HIWORD(wParam) == BN_CLICKED) {
		//	ファイルアクセス中以外
		if (!fBusy) {
			//	ファイルアクセス中の旨、設定
			fBusy = TRUE;
			//	画面グレー化し、中止ボタンのみ有効化
			AjcEnableCtrlsInWnd(hDlg, FALSE);
			AjcSetDlgItemStr(hDlg, IDC_CMD_INPUT, TEXT("読み出し中止"));
			AjcEnableDlgItem(hDlg, IDC_CMD_INPUT, TRUE);
			AjcEnableDlgItem(hDlg, IDC_VTH		, TRUE);
			//	読み出しファイルのテキストコード設定
			tec = TecTbl[AjcGetDlgItemUInt(hDlg, IDC_GRP_I_ENC)];
			//	テキストをコンボボックスに登録
			AjcGetCtrlStr(AjcSbcGetEditCtrlInComboBox(hCboInp), path, MAX_PATH);
			AjcSetCtrlCboAdd(hCboInp, 0, path, AJCCBF_ALL);
			//	画面クリアー
			AjcVthClearAllText(hWndVth);
			//	ファイルの読み出しと表示
			if ((ix = AjcGetDlgItemCboIx(hDlg, IDC_CBO_INPFILE)) >= 0) {
				AjcGetDlgItemCboItem(hDlg, IDC_CBO_INPFILE, ix, path, MAX_PATH);
				//	読み出しファイルオープン
				if (hFile = AjcFOpen(path, tec)) {
					//	文字列で読み出して表示
					if (AjcGetDlgItemChk(hDlg, IDC_RBT_FGETS)) {
						lBuf = AjcGetDlgItemUInt(hDlg, IDC_INP_BUFSIZE);
						if (pBuf = AjcTAlloc(lBuf)) {
							while (AjcFGetS(hFile, pBuf, lBuf) && !fCancel) {
								AjcVthPutText(hWndVth, pBuf, -1);
								if ((++cnt & 15) == 0) AjcDoEvent();
							}
							AjcTFree((VOP)pBuf);
						}
					}
					//	１文字づつ読み出して表示
					else {
						UT	c = AjcFGetC(hFile);
						while (c != (UT)-1 && !fCancel) {
							AjcVthPutChar(hWndVth, c);
							if ((++cnt & 255) == 0) AjcDoEvent();
							c = AjcFGetC(hFile);
						}
					}
					//	読み出しファイルクローズ
					AjcFClose(hFile);
				}
				else {
					MessageBox(hDlg, TEXT("読み出しファイルをオープンできません。"), TEXT("SW_TextFile2"), MB_ICONERROR);
				}
			}
			//	画面グレー化解除
			AjcEnableCtrlsInWnd(hDlg, TRUE);
			AjcSetDlgItemStr(hDlg, IDC_CMD_INPUT, TEXT("ファイル読み出し"));
			//	フラグクリアー
			fBusy	= FALSE;
			fCancel = FALSE;
			//	プログラム終了チェック
			if (fExit) DestroyWindow(hDlg);
		}
		//	ファイルアクセス中
		else {
			//	書き込み中止
			fCancel = TRUE;
		}
	}
	return TRUE;
}
//----- ファイル書き込みボタン ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_OUTPUT		)
{
	HAJCFILE	hFile = NULL;
	UTP 		pLine = NULL;
	UI			nLine;
	UI			i;
	EAJCTEC 	tec;
	UT			path[MAX_PATH];
	AJCVTHPROP	prop;

	if (HIWORD(wParam) == BN_CLICKED) {
		//	ファイルアクセス中以外
		if (!fBusy) {
			//	ファイルアクセス中の旨、設定
			fBusy = TRUE;
			//	画面グレー化し、中止ボタンのみ有効化
			AjcEnableCtrlsInWnd(hDlg, FALSE);
			AjcSetDlgItemStr(hDlg, IDC_CMD_OUTPUT, TEXT("書き込み中止"));
			AjcEnableDlgItem(hDlg, IDC_CMD_OUTPUT, TRUE);
			AjcEnableDlgItem(hDlg, IDC_VTH		 , TRUE);
			//	書き込みファイルのテキストコード設定
			tec = TecTbl[AjcGetDlgItemUInt(hDlg, IDC_GRP_O_ENC)];
			//	ファイルの書き込み
			AjcGetDlgItemStr(hDlg, IDC_TXT_OUTFILE, path, MAX_PATH);
			//	書き込みファイル作成 
			 if (AjcGetDlgItemChk(hDlg, IDC_CHK_APPEND)) hFile = AjcFAppend(path, tec, AjcGetDlgItemChk(hDlg, IDC_CHK_BOM));
			 else                                        hFile = AjcFCreate(path, tec, AjcGetDlgItemChk(hDlg, IDC_CHK_BOM));
			if (hFile != NULL) {
				AjcVthGetProp(hWndVth, &prop);
				//	ラインバッファ確保
				if (pLine = AjcTAlloc(prop.VramW + 1)) {
					//	ライン数取得
					nLine = AjcVthGetLineCount(hWndVth);
					//	ライン数だけループ
					for (i = 0; i < nLine && !fCancel; i++) {
						AjcVthGetLineText(hWndVth, i, pLine, prop.VramW + 1);
						//	行単位で書き込み
						if (AjcGetDlgItemChk(hDlg, IDC_RBT_FPUTS)) {
							AjcFPutS(hFile, pLine, -1);
						}
						//	１文字づつ書き込み
						else {
							UTP 	p = pLine;
							while (*p != 0 && !fCancel) {
								AjcFPutC(hFile, *p++);
							}
						}
						//	ＬＦ書き込み
						AjcFPutC(hFile, TEXT('\n'));
					}
					//	ラインバッファ解放
					AjcTFree(pLine);
				}
				//	書き込みファイルクローズ
				AjcFClose(hFile);
			}
			else {
				MessageBox(hDlg, TEXT("書き込みファイルを作成できません。"), TEXT("SW_TextFile2"), MB_ICONERROR);
			}
			//	画面グレー化解除
			AjcEnableCtrlsInWnd(hDlg, TRUE);
			AjcSetDlgItemStr(hDlg, IDC_CMD_OUTPUT, TEXT("ファイル書き込み"));
			//	フラグクリアー
			fBusy	= FALSE;
			fCancel = FALSE;
			//	プログラム終了チェック
			if (fExit) DestroyWindow(hDlg);
		}
		//	ファイルアクセス中
		else {
			//	書き込み中止
			fCancel = TRUE;
		}
	}
	return TRUE;
}
//----- コンボボックスのツールチップとしてファイルの先頭行を表示する -------------------------------------------//
AJC_DLGPROC(Main, IDC_CHK_1ST_LINE	   )
{
	if (HIWORD(wParam) == BN_CLICKED) {
		if (AjcGetDlgItemChk(hDlg, IDC_CHK_1ST_LINE)) {
			AjcSbcShowFirstLine(hCboInp, TEXT("/*\t "));
		}
		else {
			AjcSbcShowFirstLine(hCboInp, NULL);
		}
	}
	return TRUE;
}
//----- 入力ファイル：テキストコード ---------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_LBL_I_ENC 	   )
{
	EAJCTEC 	InpTec, OutTec;
	BOOL		fOutBom  = AjcGetDlgItemChk(hDlg, IDC_CHK_BOM);

	if (HIWORD(wParam) == BN_CLICKED) {
		InpTec = TecTbl[AjcGetDlgItemUInt(hDlg, IDC_GRP_I_ENC)];
		OutTec = TecTbl[AjcGetDlgItemUInt(hDlg, IDC_GRP_O_ENC)];
		fOutBom = AjcGetDlgItemChk(hDlg, IDC_CHK_BOM);
		if (AjcFTecDialog(hDlg, TEXT("SW_TextFile2"), hIcon, &InpTec, &OutTec, &fOutBom)) {
			AjcSetDlgItemUInt(hDlg, IDC_GRP_I_ENC, InpTec);
			AjcSetDlgItemUInt(hDlg, IDC_GRP_O_ENC, OutTec);
			AjcSetDlgItemChk (hDlg, IDC_CHK_BOM  , fOutBom);
		}
	}
	return TRUE;
}
//----- 出力ファイル：テキストコード ---------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_LBL_O_ENC 	   )
{
	if (HIWORD(wParam) == BN_CLICKED) {
		SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_LBL_I_ENC, BN_CLICKED), 0);
	}
	return TRUE;
}
//----- 入力ファイル選択コンボボックス -------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CBO_INPFILE	   )
{
	if (HIWORD(wParam) == CBN_SELENDOK) {
		//	現選択項目を最新項目として設定
		AjcSbcSetMostNew(hCboInp);
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	 )
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	 )
	AJC_DLGMAP_CMD(Main, IDCANCEL		 )
	AJC_DLGMAP_CMD(Main, IDC_CMD_INPFILE )
	AJC_DLGMAP_CMD(Main, IDC_CMD_OUTFILE )
	AJC_DLGMAP_CMD(Main, IDC_CMD_INPUT	 )
	AJC_DLGMAP_CMD(Main, IDC_CMD_OUTPUT  )
	AJC_DLGMAP_CMD(Main, IDC_CHK_1ST_LINE)
	AJC_DLGMAP_CMD(Main, IDC_LBL_I_ENC	 )
	AJC_DLGMAP_CMD(Main, IDC_LBL_O_ENC	 )
	AJC_DLGMAP_CMD(Main, IDC_CBO_INPFILE )
AJC_DLGMAP_END

