﻿//
//	
//

#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

#define	LEFT 20
#define	TOP  10

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
HWND			hWndBack;						//	バックウインドハンドル（ダイアログとVT-100の親ウインド）
HICON			hIco2Bit;
HICON			hIco4Bit;
HBITMAP			hBmpCat;
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(Back);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 		msg;
	WNDCLASS	wc;
	HBRUSH		hBru;

	hInst = hInstance;

	//	ブラシ生成
	hBru = CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
	//	バックウインド生成
	wc.style		= 0;						wc.hCursor			= LoadCursor(NULL, IDC_ARROW);
	wc.lpfnWndProc	= AJC_WNDPROC_NAME(Back);	wc.hbrBackground	= hBru;
	wc.cbClsExtra 	= 0;						wc.lpszMenuName		= NULL;
	wc.cbWndExtra 	= 0;						wc.lpszClassName	= TEXT("SW_TextOut");
	wc.hInstance	= hInst;
	wc.hIcon		= NULL;
	RegisterClass(&wc);

	hWndBack = CreateWindow(TEXT("SW_TextOut"), TEXT("SW_TextOut"),
							WS_OVERLAPPEDWINDOW,
							0, 0, 900, 600,
							NULL, NULL, hInst, NULL);

	//	ウインド表示
	ShowWindow(hWndBack, iCmdShow);

	//	メッセージループ
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
		//	if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	//	ブラシ破棄
	DeleteObject(hBru);

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	バックウインド・プロシージャ																				//
//																												//
//==============================================================================================================//
//----- WM_CREATE ----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_CREATE 		)
{
	//	アイコン読み出し
	hIco2Bit = (HICON  )LoadImage(hInst, MAKEINTRESOURCE(IDI_2BIT), IMAGE_ICON  , 16, 16, LR_DEFAULTCOLOR);
	hIco4Bit = (HICON  )LoadImage(hInst, MAKEINTRESOURCE(IDI_4BIT), IMAGE_ICON  , 16, 16, LR_DEFAULTCOLOR);
	hBmpCat  = (HBITMAP)LoadImage(hInst, MAKEINTRESOURCE(IDB_CAT ), IMAGE_BITMAP, 48, 48, LR_DEFAULTCOLOR);

	return 0;
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_DESTROY		)
{
	//	アイコン破棄
	DeleteObject(hIco2Bit);
	DeleteObject(hIco4Bit);
	//	プログラム終了
	PostQuitMessage(0);
	return 0;
}
//----- WM_SIZE ------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Back, WM_SIZE			)
{
	InvalidateRect(hwnd, NULL, TRUE);
	return 0;
}
//----- WM_PAINT -----------------------------------------------------------------------------------------------//
UT	SampleText[] =	TEXT("\x1B[Tテキスト描画機能\x1B[t\x1B[40L\n")
					TEXT("ＤＣ（デバイスコンテキスト）へテキストを描画する為の\t関数群です。\n")
					TEXT("テキストにエスケープシーケンスを含めることが\tできます。\n")
					TEXT("\x1B[1;31mここまでの矩形を算出し\t長方形で\t囲みます。\x1B[0m");

AJC_WNDPROC(Back, WM_PAINT			)
{
	PAINTSTRUCT	ps;
	HDC			hdc;
	HFONT		hFont;
	HAJCTXO		hTxo;
	AJCTXOALIGN Align;
	int			x, y, w, d, cx, cy;

	hdc	  = BeginPaint(hwnd, &ps);
	hFont = AjcGetStockFont(AJCFID_FIX16);
	hFont = SelectObject(hdc, hFont);
	if (hTxo = AjcTxoCreate(hdc, LEFT, TOP, -20)) {	//	左端=10，改行＝文字高さの２０％
		SIZE	sz = {0};
		RECT	r;
		//	ＤＣ描画域サイズとしてウインドサイズを設定
		GetClientRect(hwnd, &r);
		AjcTxoSetDcBmpSize(hTxo, r.right - r.left, r.bottom - r.top);
		//	アイコン，ビットマップ登録
		AjcTxoRegistIcon  (hIco2Bit, 1, 0, 0, 0, 0);
		AjcTxoRegistIcon  (hIco4Bit, 0, 0, 0, 0, 0);
		AjcTxoRegistBitmap(hBmpCat , 2, 0, 0, 0, 0);
		//--- テキストを描画し、テキスト部分を矩形で囲む ---//
		Align = AJCTXOALIGN_LEFT;	// AJCTXOALIGN_LEFT, AJCTXOALIGN_RIGHT, AJCTXOALIGN_CENTER or AJCTXOALIGN_TAB_RIGHT
		x = 20; y = 30; w = 600; d = w / 2;				//	描画域のＸ，Ｙ，幅，幅÷２
		AjcTxoSetAlign(hTxo, Align);					//	テキストアライン設定
		AjcTxoGetExtentEx(hTxo, x, y, SampleText, &sz);	//	テキスト描画サイズ取得
		cx = sz.cx; cy = sz.cy;
		AjcTxoTextOutExEx(hTxo, x, y, w, SampleText);	//	テキスト描画
		//	テキスト描画域の矩形表示
		SelectObject(hdc, GetStockObject(WHITE_BRUSH));
		Rectangle(hdc, LEFT + x, TOP + y, LEFT + x + w, TOP + y + sz.cy);
		AjcTxoTextOutExEx(hTxo, x, y, w, SampleText);	//	テキスト再描画
		//	テキストを矩形で囲む
		SelectObject(hdc, GetStockObject(NULL_BRUSH));
		switch (Align) {
		 case AJCTXOALIGN_LEFT: 	 Rectangle(hdc, LEFT + x				, TOP + y, LEFT + x + sz.cx 	   , TOP + y + sz.cy); break;
		 case AJCTXOALIGN_RIGHT:	 Rectangle(hdc, LEFT + x + w - sz.cx	, TOP + y, LEFT + x + w 		   , TOP + y + sz.cy); break;
		 case AJCTXOALIGN_CENTER:	 Rectangle(hdc, LEFT + x + d - sz.cx / 2, TOP + y, LEFT + x + d + sz.cx / 2, TOP + y + sz.cy); break;
		 case AJCTXOALIGN_TAB_RIGHT: Rectangle(hdc, LEFT + x				, TOP + y, LEFT + x + w 		   , TOP + y + sz.cy); break;
		}

		AjcTxoSetAlign(hTxo, AJCTXOALIGN_LEFT);	//	アライン＝左詰め

		AjcTxoTextOut(hTxo, TEXT("\r\n\r\n\x1B[Tあ\x1B[Tい\x1B[tう\x1B[tえ\x1B[Uお\x1B[Uか\x1B[uき\x1B[uくけこ\x1B[250L\r\n"));
		AjcTxoPrintF(hTxo, TEXT("\x1B[T\x1B[I\x1B[U行間＝文字高さの２５０％\x1B[t\x1B[i\x1B[u\r\n↓\r\n↓\r\n↓\r\n↓\r\n↓\r\n↓\r\n↓\r\n"));


		AjcTxoPrintF(hTxo, TEXT("\x1B[1;3;31;42m")
						   TEXT("太字＋斜字，赤字，背景＝緑")
						   TEXT("\x1B[49m")
						   TEXT("\t背景＝透明")
						   TEXT("\x1B[39m")
						   TEXT("\t文字色リセット")
						   TEXT("\x1B[0m")
						   TEXT("\t全リセット\r\n"));

		AjcTxoPrintF(hTxo, TEXT("\x1B[T\x1B[I\x1B[38;2;255;0;0;48;2;192;192;255m")
						   TEXT("太字＋斜字，赤字，背景＝青")
						   TEXT("\x1B[49m")
						   TEXT("\t背景リセット")
						   TEXT("\x1B[N")
						   TEXT("太字と斜字解除\r\n"));

		AjcTxoPrintF(hTxo, TEXT("\x1B[43m")
						   TEXT("背景＝黄色")
						   TEXT("\x1B[0m")
						   TEXT("\t全リセット\r\n"));

		AjcTxoPrintF(hTxo, TEXT("\x1B[1;3;30;46m")
						   TEXT("太字＋斜字，黒字，背景＝水色")
						   TEXT("\x1B[i")
						   TEXT("斜字解除")
						   TEXT("\x1B[0m")
						   TEXT("\t全リセット\r\n"));

		AjcTxoPrintF(hTxo, TEXT("\x1B[1;3;30;46m")
						   TEXT("太字＋斜字，黒字，背景＝水色")
						   TEXT("\x1B[t")
						   TEXT("太字解除")
						   TEXT("\x1B[0m")
						   TEXT("\t全リセット\r\n"));

		AjcTxoPrintF(hTxo, TEXT("\x1B[37;41m")
						   TEXT("文字＝白，背景＝赤")
						   TEXT("\x1B[50L\n")
						   TEXT("行間＝文字高さの５０％"));

		AjcTxoPrintF(hTxo, TEXT("\r\n行間＝デフォルトに戻る\r\n"));

		AjcTxoTextOutEx(hTxo, AJCTXO_RIGHT - 10, 0,TEXT("\x1B[37;44m")
													TEXT("このテキストは\n")
													TEXT("ウインドの右上に表示されます"));

		AjcTxoTextOutEx(hTxo, AJCTXO_RIGHT - 10, AJCTXO_BOTTOM - 10,TEXT("\x1B[31;46m")
													TEXT("このテキストはウインドの\n")
													TEXT("右下に表示されます"));

		AjcTxoTextOutEx(hTxo, AJCTXO_CENTER, AJCTXO_CENTER, TEXT("\x1B[33;45m")
													TEXT("このテキストは\n")
													TEXT("ウインドの中央に表示されます"));
		AjcTxoTextOut(hTxo, TEXT("\x1B[0m"));
		//	四隅にアイコン表示
		AjcTxoTextOut(hTxo, TEXT("\x1B[0;0;0;0;0z"));		//	左上
		AjcTxoTextOut(hTxo, TEXT("\x1B[1;0;-16;0;0z"));		//	左下
		AjcTxoTextOut(hTxo, TEXT("\x1B[0;-16;0;0;0z"));		//	右上
		AjcTxoTextOut(hTxo, TEXT("\x1B[1;-16;-16;0;0z"));	//	右下
		//	ビットマップ表示
		AjcTxoTextOut(hTxo, TEXT("\x1B[2;300;200z"));

		//	アイコン，ビットマップ登録解除
		AjcTxoUnregistImage(-1);

		//	インスタンス破棄
		AjcTxoDelete(hTxo, TRUE);

	}

	SelectObject(hdc, hFont);
	EndPaint(hwnd, &ps);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Back)
	AJC_WNDMAP_MSG(Back, WM_CREATE	   )
	AJC_WNDMAP_MSG(Back, WM_DESTROY    )
	AJC_WNDMAP_MSG(Back, WM_SIZE	   )
	AJC_WNDMAP_MSG(Back, WM_PAINT	   )
AJC_WNDMAP_END
