﻿//
//	SW_TimeChart.c
//
#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

//--------------------------------------------------------------------------------------------------------------//
//	マクロ																										//
//--------------------------------------------------------------------------------------------------------------//
//	スタイル設定チェックボックス
#define		SET_STYLE(STY)		MAjcSetWindowLong(hWndTc1, GWL_STYLE, 									\
								(int)(AjcGetDlgItemChk(hDlg, IDC_CHK_##STY) ? 							\
									(MAjcGetWindowLong(hWndTc1, GWL_STYLE) |  AJCTCS_##STY) :			\
									(MAjcGetWindowLong(hWndTc1, GWL_STYLE) & ~AJCTCS_##STY)))

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
HWND			hDlgMain;						//	ダイアログボックスハンドル
HWND			hWndTc1, hWndTc2;				//	タイムチャート・グラフコントロールのウインドハンドル
HWND			hWndVth;						//	ログ表示ウインド
double			theta	  = 0.0;				//	データ生成角度
int 			DlgWidth;						//	ダイアログボックスの幅
int 			DlgHeight;						//	ダイアログボックスの高さ
int				ySrtPos;						//	グラフ表示先頭位置
BOOL			fBusy = FALSE;					//	プロット中フラグ

//	球の中心と半径
#define		CX		0.2
#define		CY		0.4
#define		CZ		0.1
#define		R		8.0

//	プロット点演算パラメタ
//								vCent 	   radius  noise  xrot	yrot  pitch
static	AJCSPD_PARAM	prm = {{CX, CY, CZ}, R,	   7.0,   0.5,	0.8,  9.0};

//	プロット点演算インスタンス
HAJCSPD		hSpd = {NULL};

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
static	VO		NtcFromTch(HWND hTch, WPARAM wParam, LPARAM lParam);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_MAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	RECT	rd, rt;
	//----- タイムチャートコントロールのハンドル設定 -------//
	hWndTc1 = GetDlgItem(hDlg, IDC_TCH_SINCOS);
	hWndTc2 = GetDlgItem(hDlg, IDC_TCH_SAMPLE);
	hWndVth = GetDlgItem(hDlg, IDC_VTH_LOG	 );
	//----- ダイアログサイズ設定 ---------------------------//
	GetWindowRect(hDlg, &rd);
	DlgWidth  = rd.right	- rd.left;
	DlgHeight = rd.bottom - rd.top;
	//----- グラフ表示先頭位置設定 -------------------------//
	GetWindowRect(hWndTc1, &rt);
	MapWindowPoints(NULL, hDlg, (LPPOINT)&rt, 2);
	ySrtPos = rt.top;
	//----- タイトル設定 -----------------------------------//
	AjcTchSetTitleText(hWndTc1, TEXT(" 三角関数 "), -1, -1, NULL);
	AjcTchSetTitleText(hWndTc2, TEXT(" 球面座標 "), -1, -1, NULL);
	//----- 注釈テキスト描画 ---------------------------------//
	AjcTchTextOut(hWndTc1, AJCTXO_CENTER, 3, TEXT("\x1B[30mSin \x1B[31mCos \x1B[32mTan"));
	AjcTchTextOut(hWndTc2, AJCTXO_CENTER, 3, TEXT("\x1B[30mＸ \x1B[31mＹ \x1B[32mＺ"));
	//----- ツールチップ設定 -------------------------------//
	AjcTchSetTipText(hWndTc1, TEXT("三角関数(Sin, Cos, Tan)の値をチャート表示"));
	AjcTchSetTipText(hWndTc2, TEXT("球面を移動する球面座標データをチャート表示"));
	//----- プロットデータ演算初期化 -----------------------------//
	hSpd = AjcSpdCreate(0);
	AjcSpdSetParam(hSpd, &prm);
	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//	プロットデータ演算終了
	AjcSpdDelete(hSpd);
	//	プログラム終了
	PostQuitMessage(0);
	return TRUE;
}
//----- サイズ変更中 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_SIZING 		)
{
	LPRECT	p = (VOP)lParam;
		
	if (p->right - p->left < DlgWidth) {
		p->right  = p->left + DlgWidth;
	}
	if (p->bottom - p->top < DlgHeight) {
		p->bottom = p->top	+ DlgHeight;
	}

	return TRUE;
}
//----- サイズ変更 ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_SIZE			)
{
	int 	w = LOWORD(lParam);
	int 	h = HIWORD(lParam);
	int		tw, th;

	tw = w - 4;
	th = (h - ySrtPos) / 3 - 2;

	MoveWindow(hWndTc1, 2, ySrtPos				 , tw, th, FALSE);
	MoveWindow(hWndTc2, 2, ySrtPos + (th	) + 2, tw, th, FALSE);
	MoveWindow(hWndVth, 2, ySrtPos + (th * 2) + 4, tw, th, FALSE);
	InvalidateRect(hDlg, NULL, TRUE);

	return TRUE;
}
//----- タイマ -------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_TIMER			)
{
	double	val[3];

	if (wParam == 1) {
		if (!AjcGetDlgItemChk(hDlg, IDC_CHK_STOP)) {
			//	Sin, Cos, Tan 値データ生成／投与
			val[0] = sin(theta);
			val[1] = cos(theta);
			val[2] = tan(theta);
			val[2] = __min(val[2],	2.0);
			val[2] = __max(val[2], -2.0);
			AjcTchPutRealData(hWndTc1, val);
			theta += 1.0 / 180.0 * AJC_PAI;
			//	ランダムなプロットデータ生成／投与
			AjcSpdCalcV(hSpd, (PAJC3DVEC)&val);
			AjcTchPutRealData(hWndTc2, val);
			//	データをログ表示
			AjcVthPrintF(hWndVth, TEXT("x = %6.2f, y = %6.2f, z = %6.2f\n"), val[0], val[1], val[2]); 
		}
	}
	return TRUE;
}
//----- コマンド（カラー設定）----------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_COMMAND		)
{
	int 		cmd = LOWORD(wParam);
	int 		ix	= cmd - IDC_CMD_COLOR0;
	COLORREF	CustColors[16];
	CHOOSECOLOR cc;
	AJCTCPROP	prop;

	if (cmd >= IDC_CMD_COLOR0 && cmd <= IDC_CMD_COLOR7) {
		AjcTchGetProp(hWndTc1, &prop);
		memset(&cc, 0, sizeof cc);
		cc.lStructSize	= sizeof(CHOOSECOLOR);
		cc.hwndOwner	= hDlg;
		cc.lpCustColors = CustColors;
		cc.rgbResult	= prop.Item[ix].rgb;
		cc.Flags		= CC_RGBINIT;
		if (ChooseColor(&cc)) {
			prop.Item[ix].rgb = cc.rgbResult;
			AjcTchSetProp(hWndTc1, &prop);
		}
	}
	return TRUE;
}
//----- プロット開始／停止ボタン -------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_START			)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		if (!fBusy) {
			fBusy = TRUE;
			SetTimer(hDlg, 1, AjcGetDlgItemUInt(hDlg, IDC_INP_PERIOD), NULL);
			AjcSetDlgItemStr(hDlg, IDC_CMD_START, TEXT("プロット停止"));
		}
		else {
			fBusy = FALSE;
			KillTimer(hDlg, 1);
			AjcSetDlgItemStr(hDlg, IDC_CMD_START, TEXT("プロット開始"));
		}
	}
	return TRUE;
}
//----- 周期設定 -----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_INP_PERIOD		)
{
	if (HIWORD(wParam) == AJCIVN_INTVALUE) {
		if (fBusy) {
			SetTimer(hDlg, 1, (int)lParam, NULL);
		}
	}
	return TRUE;
}
//----- Get Text ボタン ----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_GETTEXT		)
{
	UT		txt[1024];

	if (HIWORD(wParam) == BN_CLICKED) {
		GetWindowText(hWndTc1, txt, AJCTSIZE(txt));
		AjcSetDlgItemStr(hDlg, IDC_TXT_GETTEXT, txt);
	}
	return TRUE;
}
//----- Set Text ボタン ----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SETTEXT		)
{
	UT		txt[1024];

	if (HIWORD(wParam) == BN_CLICKED) {
		AjcGetDlgItemStr(hDlg, IDC_TXT_GETTEXT, txt, AJCTSIZE(txt));
		SetWindowText(hWndTc1, txt);
	}
	return TRUE;
}
//----- Enable ボタン ------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_ENABLE		)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		EnableWindow(hWndTc1, TRUE);
	}
	return TRUE;
}
//----- Disable ボタン -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_DISABLE		)
{
	if (HIWORD(wParam) == BN_CLICKED) {
		EnableWindow(hWndTc1, FALSE);
	}
	return TRUE;
}
//----- スタイル設定チェックボックス ---------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CHK_NOBORDER		)	{SET_STYLE(NOBORDER		);	return TRUE;}
AJC_DLGPROC(Main, IDC_CHK_NOSCALELINE	)	{SET_STYLE(NOSCALELINE	);	return TRUE;}
AJC_DLGPROC(Main, IDC_CHK_NOSCALEVALUE	)	{SET_STYLE(NOSCALEVALUE	);	return TRUE;}
AJC_DLGPROC(Main, IDC_CHK_NOFILTER		)	{SET_STYLE(NOFILTER		);	return TRUE;}
AJC_DLGPROC(Main, IDC_CHK_NOSCROLLBAR	)	{SET_STYLE(NOSCROLLBAR	);	return TRUE;}
//----- タイムチャート・グラフ コントロール(SIN, COS波形) ------------------------------------------------------//
AJC_DLGPROC(Main, IDC_TCH_SINCOS	)
{
	if (HIWORD(wParam) == AJCTCN_SCRPOS) {
		AjcSetDlgItemChk(hDlg, IDC_CHK_STOP, TRUE);
		AjcTchSetScrollPos(hWndTc2, (UI)lParam);
	}
	else {
		NtcFromTch(hWndTc1, wParam, lParam);
	}
	return TRUE;
}
//----- タイムチャート・グラフ コントロール(サンプルデータ波形) ------------------------------------------------//
AJC_DLGPROC(Main, IDC_TCH_SAMPLE	)
{
	NtcFromTch(hWndTc2, wParam, lParam);
	return TRUE;
}
//----- 「Cancel」 ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG			)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 			)
	AJC_DLGMAP_MSG(Main, WM_SIZING				)
	AJC_DLGMAP_MSG(Main, WM_SIZE				)
	AJC_DLGMAP_MSG(Main, WM_TIMER				)
	AJC_DLGMAP_MSG(Main, WM_COMMAND				)

	AJC_DLGMAP_CMD(Main, IDC_CMD_START			)
	AJC_DLGMAP_CMD(Main, IDC_INP_PERIOD			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_GETTEXT		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SETTEXT		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_ENABLE			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_DISABLE		)
	AJC_DLGMAP_CMD(Main, IDC_CHK_NOBORDER		)
	AJC_DLGMAP_CMD(Main, IDC_CHK_NOSCALELINE	)
	AJC_DLGMAP_CMD(Main, IDC_CHK_NOSCALEVALUE	)
	AJC_DLGMAP_CMD(Main, IDC_CHK_NOFILTER		)
	AJC_DLGMAP_CMD(Main, IDC_CHK_NOSCROLLBAR	)

	AJC_DLGMAP_CMD(Main, IDC_TCH_SINCOS			)
	AJC_DLGMAP_CMD(Main, IDC_TCH_SAMPLE			)
	AJC_DLGMAP_CMD(Main, IDCANCEL				)
AJC_DLGMAP_END
//--------------------------------------------------------------------------------------------------------------//
//	タイムチャートコントロールからの通知処理																	//
//--------------------------------------------------------------------------------------------------------------//
static	VO		NtcFromTch(HWND hTch, WPARAM wParam, LPARAM lParam)
{
	UT		txt[4096] = {0};

	switch (HIWORD(wParam)) {
		case AJCTCN_RANGE:							//	●レンジ通知
		{	PAJCTC_NTC_RANGE p = (VOP)lParam;
			AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("レンジが設定されました。 (Low = %.3f, High = %.3f)"), p->RngL, p->RngH);
			break;
		}
		case AJCTCN_RCLICK:							//	●右クリック通知
		{	PAJCTCRCLK	p = (PAJCTCRCLK)lParam;
			AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("%s%s右クリック発生 (x = %d, y = %d)"), 
																				p->fShift ? TEXT("Shift + ") : TEXT(""),
																				p->fCtrl  ? TEXT("Ctrl + " ) : TEXT(""),
																				p->x, p->y);
			break;
		}
		case AJCTCN_DROPDIR:						//	●ディレクトリドロップ
		{	UT		path[MAX_PATH];
			MAjcStrCpy(txt, AJCTSIZE(txt), TEXT("ディレクトリがドロップされました。\n"));
			while (AjcTchGetDroppedDir(hTch, path)) {
				MAjcStrCat(txt, AJCTSIZE(txt), TEXT("  "));
				MAjcStrCat(txt, AJCTSIZE(txt), path);
				MAjcStrCat(txt, AJCTSIZE(txt), TEXT("\n"));
			}
			break;
		}
		case AJCTCN_DROPFILE:						//	●ファイルドロップ
		{	UT		path[MAX_PATH];
			MAjcStrCpy(txt, AJCTSIZE(txt), TEXT("ファイルがドロップされました。\n"));
			while (AjcTchGetDroppedFile(hTch, path)) {
				MAjcStrCat(txt, AJCTSIZE(txt), TEXT("  "));
				MAjcStrCat(txt, AJCTSIZE(txt), path);
				MAjcStrCat(txt, AJCTSIZE(txt), TEXT("\n"));
			}
			break;
		}
	}
	//	チップ表示
	if (txt[0] != 0) {
		SIZE	sz;
		RECT	r;
		int		w,h;
		GetWindowRect(hTch, &r);
		w = r.right - r.left;
		h = r.bottom - r.top;
		AjcTipTextGetSize(txt, NULL, TRUE, &sz);
		AjcTipTextShow(r.left + (w - sz.cx) / 2, r.top + (h - sz.cy) / 2, txt, -1, NULL);
	}
}
