﻿//
//	SW_TipText.c
//
#include	<AjrCstXX.h>
#include	<tchar.h>
#include	"resource.h"

#define	BLACK	RGB(   0	0,	 0)		//	0: 黒
#define	RED		RGB( 255,	0,	 0)		//	1: 赤
#define	GREEN	RGB(   0, 255,	 0)		//	2: 緑
#define	YELLOW	RGB( 255, 255,	 0)		//	3: 黄
#define	BLUE	RGB(   0,	0, 255)		//	4: 青
#define	MAGENTA	RGB( 255,	0, 255)		//	5: 紫
#define	SKYBLUE	RGB(   0, 255, 255)		//	6: 水色
#define	WHITE	RGB( 255, 255, 255)		//	7: 白

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
HWND			hDlgMain;						//	ダイアログボックスハンドル
HFONT			hMyFont;
HICON			hIco;
HBITMAP			hBmp;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//	カーソル位置チェック用コールバック（カーソルがテキストボックスの右半分の位置にある場合にTRUEを返す）
static	BOOL CALLBACK cbChkCursor(HWND hCtrl, LPPOINT pPt, UX cbp)
{
	BOOL	rc = FALSE;
	RECT	rect;

	GetClientRect(hCtrl, &rect);
	rect.left = (rect.left + rect.right) / 2;
	if (pPt->x >= rect.left && pPt->x < rect.right && pPt->y >= rect.top && pPt->y < rect.bottom) {
		rc = TRUE;
	}
	return rc;
}

//	チップテキスト取得用コールバック
static	C_UTP CALLBACK cbGetText(HWND hCtrl, UTP pBuf, UI lBuf, UX cbp)
{
	SYSTEMTIME		lt;

	GetLocalTime(&lt);
	AjcSnPrintF(pBuf, lBuf, TEXT("現在日時： %4d/%02d/%02d %02d:%02d:%02d.%03d"), 
							lt.wYear, lt.wMonth, lt.wDay, lt.wHour, lt.wMinute, lt.wSecond, lt.wMilliseconds);
	return pBuf;
}

//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	double	t;
	double	rdat[3];
	LOGFONT	lf;
	UTP 	pTxt1 = TEXT("AjcTipTextAdd   : コントロールに関連付けてチップテキストを表示\n")
					TEXT("  \x1B[Tボールドフォントのサンプル\x1B[t\n")
					TEXT("  \x1B[Iイタリックフォントのサンプル\x1B[i\n")
					TEXT("  \x1B[T\x1B[Iボールド＋イタリックフォントのサンプル\x1B[N\n")
					TEXT("  ノーマルフォントのサンプル")
					TEXT("\x1B[0;-20;-20;16;16z");			//	右下にアイコン表示

	UTP		pTxt2 =	TEXT("AjcTipTextAddEx : コントロールに関連付けてチップテキストを表示\x1B[50L\n")
					TEXT("                   フォント，文字色，背景色，外枠の指定が可能です。\n"
					TEXT("                   更に、\x1B[46m\x1B[34m文字列中の\x1B[31m特定部分\x1B[0mの文字色や背景色を変更可能です。"));

	//	アイコン，ビットマップ読み出し
	hIco = (HICON  )LoadImage(hInst, MAKEINTRESOURCE(IDI_ICO), IMAGE_ICON  , 16, 16, LR_DEFAULTCOLOR);
	hBmp = (HBITMAP)LoadImage(hInst, MAKEINTRESOURCE(IDB_BMP), IMAGE_BITMAP, 48, 48, LR_DEFAULTCOLOR);
	//	アイコン，ビットマップ登録
	AjcTipTextRegistIcon  (hIco, 0, 0, 0, 0, 0);
	AjcTipTextRegistBitmap(hBmp, 1, 0, 0, 0, 0);

	//	ツールチップ表示位置モード設定
//	AjcTipTextSetTipPosMode(AJCTIP_POS_UNDER_CURSOR);

	//	フォント生成
	lf.lfHeight=16;			lf.lfItalic=0;			lf.lfClipPrecision=2;
	lf.lfWidth=0;			lf.lfUnderline=0;		lf.lfQuality=1;
	lf.lfEscapement=0;		lf.lfStrikeOut=0;		lf.lfPitchAndFamily=VARIABLE_PITCH;
	lf.lfOrientation=0;		lf.lfCharSet=128;		MAjcStrCpy(lf.lfFaceName, AJCTSIZE(lf.lfFaceName), TEXT("MS UI Gothic"));
	lf.lfWeight=FW_BOLD;	lf.lfOutPrecision=3;
	hMyFont = CreateFontIndirect(&lf);

	//	ラジオボタン初期化
	AjcSetDlgItemChk(hDlg, IDC_RBT_INP0, TRUE);
	AjcSetDlgItemChk(hDlg, IDC_RBT_BAR1, TRUE);
	AjcSetDlgItemChk(hDlg, IDC_RBT_G3D1, TRUE);
	AjcSetDlgItemChk(hDlg, IDC_RBT_TCH1, TRUE);
	AjcSetDlgItemChk(hDlg, IDC_RBT_LBX1, TRUE);
	AjcSetDlgItemChk(hDlg, IDC_RBT_VTH1, TRUE);

	//	設定値ロード
	AjcLoadAllControlSettings(hDlg, TEXT("Settings"), AJCCTL_SELACT_ALL | AJCCTL_SELACT_NTCALL);

	//	ダミーデータ表示
	for (t = 0; t < 200; t++) {
		rdat[0] = AjcSin(t); rdat[1] = AjcCos(t); rdat[2] = AjcTan(t);
		AjcTchPutRealData(GetDlgItem(hDlg, IDC_TCH), rdat);
	}
	rdat[0] = 50; rdat[1] = 20; rdat[2] = 80;
	AjcBarPutRealData(GetDlgItem(hDlg, IDC_BAR), rdat, TEXT("A"));
	rdat[0] = 30; rdat[1] = 70; rdat[2] = 60;
	AjcBarPutRealData(GetDlgItem(hDlg, IDC_BAR), rdat, TEXT("B"));
	AjcLbxInsertString(GetDlgItem(hDlg, IDC_LBX), -1, TEXT("ListItem-1"));
	AjcLbxInsertString(GetDlgItem(hDlg, IDC_LBX), -1, TEXT("ListItem-2"));
	AjcVthPutText(GetDlgItem(hDlg, IDC_VTH), TEXT("VT-100コントロールのチップテキスト表示テスト\n"), -1);
	AjcVthPutText(GetDlgItem(hDlg, IDC_VTH), TEXT("右のラジオボタンをクリックしてください\n"), -1);

	//	パレット６をライトグレーに設定
	AjcTipTextSetPalette(6, RGB(224, 224, 224));

	//	テキストボックスのカーソルを通常の矢印とする
	MAjcSetClassLong(GetDlgItem(hDlg, IDC_TXT_TIP1), GCL_HCURSOR, (UX)LoadCursor(NULL, IDC_ARROW));

	//	テキストボックスタイトル
	AjcSetDlgItemStr(hDlg, IDC_TXT_TIP1, TEXT("チップテキスト表示"));
	AjcSetDlgItemStr(hDlg, IDC_TXT_TIP2, TEXT("チップテキスト表示（詳細）"));
	AjcSetDlgItemStr(hDlg, IDC_TXT_TIP3, TEXT("チップテキスト表示（現在日時）"));

	//	コントロールにチップテキストを関連付ける
	AjcTipTextAdd		   (GetDlgItem(hDlg, IDC_TXT_TIP1), pTxt1);
	AjcTipTextAddEx 	   (GetDlgItem(hDlg, IDC_TXT_TIP2), pTxt2, 2000, 10000, NULL, WHITE, MAGENTA, BLUE);
	AjcTipTextSetShowAlways(GetDlgItem(hDlg, IDC_TXT_TIP2), FALSE);	//	非アクティブ時は表示しない

	//	コールバックによる状況依存のツールチップ設定（現在日時を独自フォントで表示）
	AjcTipTextAddEx(GetDlgItem(hDlg, IDC_TXT_TIP3), NULL ,	  0,  3000, hMyFont, -1, -1, -1);
	AjcTipTextSetCallBack(GetDlgItem(hDlg, IDC_TXT_TIP3), (UX)0, cbChkCursor, cbGetText);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//	アイコン，ビットマップ登録解除
	AjcTipTextUnregistImage(-1);
	//	アイコン破棄
	DeleteObject(hIco);
	DeleteObject(hBmp);
	//	設定値セーブ
	AjcSaveAllControlSettings(hDlg);

	DeleteObject(hMyFont);
	PostQuitMessage(0);
	return TRUE;
}
//----- チップテキスト表示 -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SHOW1		)
{
	POINT	pt;
	UTP		pTxt = TEXT("AjcTipTextShow : チップテキストの表示");

	GetCursorPos(&pt);
	AjcTipTextShow(pt.x + 16,			//	チップテキストの表示位置
				   pt.y + 16,			//	・
				   pTxt,				//	表示テキスト
				   5000,				//	表示時間（ms）
				   NULL);				//	フォントハンドル（NULL:デフォルトフォント）

	return TRUE;
}
//----- チップテキスト表示（詳細）------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SHOW2		)
{
	POINT	pt;
	UTP		pTxt =	TEXT("AjcTipTextShowEx : チップテキストの表示\n")
					TEXT("                   文字色，背景色，外枠の指定が可能です。\n"
					TEXT("                   更に、\x1B[46m文字列中の\x1B[31m特定部分\x1B[0mの文字色や背景色を変更可能です。")
					TEXT("\x1B[0;-20;2;16;16z")		//	(右端-20, 2) の位置にアイコン表示
					TEXT("\x1B[1;168;60;48;48z"));	//	(168, 60)の位置にビットマップ表示

	GetCursorPos(&pt);
	AjcTipTextShowEx(pt.x + 16,				//	チップテキストの表示位置
					 pt.y + 16,				//		・
					 400,					//		テキストの幅　（400ピクセル）
					 120,					//		テキストの高さ（120ピクセル）
					 pTxt,					//		表示テキスト
					 10000,					//		表示時間（ms）
					 NULL,					//		フォントハンドル（NULL:デフォルトフォント）
					 BLUE,					//		文字色（青）
					 YELLOW,				//		背景色（黄）
					 RED);					//		外枠  （赤）
	AjcTipTextMoveCursor(AJCTIP_CM_LD);		//	カーソルをチップテキストの左下隅へ移動
				
	return TRUE;
}
//----- チップテキスト非表示 -----------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_HIDE		)
{
	AjcTipTextHide();
	return TRUE;
}
//----- AjcCtrlTmChart - AjcTchSetTipText()で設定 --------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_TCH1		)
{
	AjcTchSetTipText(GetDlgItem(hDlg, IDC_TCH), TEXT("TCH - AjcTchSetTipText()でチップテキストを設定"));
	return TRUE;
}
//----- AjcCtrlTmChart - AjcTipTextAddEx()で設定 ---------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_TCH2		)
{
	AjcTipTextAddEx(GetDlgItem(hDlg, IDC_TCH), TEXT("TCH - AjcTipTextAddEx()でチップテキストを設定"), -1, -1, hMyFont, RED, WHITE, BLUE);
	return TRUE;
}
//----- AjcCtrlInpVal - デフォルトのツールチップ --------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_INP0		)
{
	AjcIvEnaDefTipText(GetDlgItem(hDlg, IDC_INP), TRUE);
	return TRUE;
}
//----- AjcCtrlInpVal - AjcIvSetTipText()で設定 --------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_INP1		)
{
	AjcIvEnaDefTipText(GetDlgItem(hDlg, IDC_INP), FALSE);
	AjcIvSetTipText(GetDlgItem(hDlg, IDC_INP), TEXT("INP - AjcIvSetTipText()でチップテキストを設定"));
	return TRUE;
}
//----- AjcCtrlInpVal - AjcTchSetTipText()で設定 --------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_INP2		)
{
	AjcIvEnaDefTipText(GetDlgItem(hDlg, IDC_INP), FALSE);
	AjcTipTextAddEx(GetDlgItem(hDlg, IDC_INP), TEXT("INP - AjcTipTextAddEx()でチップテキストを設定"), -1, -1, hMyFont, MAGENTA, -1, BLUE);
	return TRUE;
}
//----- AjcCtrlBarGraph - AjcTchSetTipText()で設定 -------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_BAR1		)
{
	AjcBarSetTipText(GetDlgItem(hDlg, IDC_BAR), TEXT("BAR - AjcBarSetTipText()でチップテキストを設定"));
	return TRUE;
}
//----- AjcCtrlBarGraph - AjcTipTextAddEx()で設定 --------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_BAR2		)
{
	AjcTipTextAddEx(GetDlgItem(hDlg, IDC_BAR), TEXT("BAR - AjcTipTextAddEx()でチップテキストを設定"), -1, -1, hMyFont, YELLOW, MAGENTA, BLUE);
	return TRUE;
}
//----- AjcCtrl3dGraph - AjcTchSetTipText()で設定 --------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_G3D1		)
{
	AjcG3dSetTipText(GetDlgItem(hDlg, IDC_G3D), TEXT("G3D - AjcG3dSetTipText()でチップテキストを設定"));
	return TRUE;
}
//----- AjcCtrl3dGraph - AjcTipTextAddEx()で設定 ---------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_G3D2		)
{
	AjcTipTextAddEx(GetDlgItem(hDlg, IDC_G3D), TEXT("G3D - AjcTipTextAddEx()でチップテキストを設定"), -1, -1, hMyFont, MAGENTA, YELLOW, BLUE);
	return TRUE;
}
//----- AjcCtrlListBox - AjcLbxSetTipText()で設定 --------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_LBX1		)
{
	AjcLbxSetTipText(GetDlgItem(hDlg, IDC_LBX), TEXT("LBX - AjcLbxSetTipText()でチップテキストを設定"));
	return TRUE;
}
//----- AjcCtrlListBox - AjcTipTextAddEx()で設定 ---------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_LBX2		)
{
	AjcTipTextAddEx(GetDlgItem(hDlg, IDC_LBX), TEXT("LBX - AjcTipTextAddEx()でチップテキストを設定"), -1, -1, hMyFont, MAGENTA, YELLOW, BLUE);
	return TRUE;
}
//----- AjcCtrlVT100 - AjcVthSetTipText()で設定 ----------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_VTH1		)
{
	AjcVthSetTipText(GetDlgItem(hDlg, IDC_VTH), TEXT("VTH - AjcVthSetTipText()でチップテキストを設定"));
	return TRUE;
}
//----- AjcCtrlVT100 - AjcTipTextAddEx()で設定 -----------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_RBT_VTH2		)
{
	AjcTipTextAddEx(GetDlgItem(hDlg, IDC_VTH), TEXT("VTH - AjcTipTextAddEx()でチップテキストを設定"), -1, -1, hMyFont, RED, GREEN, RED);
	return TRUE;
}
//----- 全てのツールチップ表示禁止 -----------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CHK_DISABLE	)
{
	AjcTipTextEnableAll(!AjcGetDlgItemChk(hDlg, IDC_CHK_DISABLE));
	return TRUE;
}
//----- キャンセル ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG	   )
	AJC_DLGMAP_MSG(Main, WM_DESTROY 	   )

	AJC_DLGMAP_CMD(Main, IDC_CMD_SHOW1	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_SHOW2	   )
	AJC_DLGMAP_CMD(Main, IDC_CMD_HIDE	   )

	AJC_DLGMAP_CMD(Main, IDC_RBT_TCH1	   )
	AJC_DLGMAP_CMD(Main, IDC_RBT_TCH2	   )

	AJC_DLGMAP_CMD(Main, IDC_RBT_INP0	   )
	AJC_DLGMAP_CMD(Main, IDC_RBT_INP1	   )
	AJC_DLGMAP_CMD(Main, IDC_RBT_INP2	   )

	AJC_DLGMAP_CMD(Main, IDC_RBT_BAR1	   )
	AJC_DLGMAP_CMD(Main, IDC_RBT_BAR2	   )

	AJC_DLGMAP_CMD(Main, IDC_RBT_G3D1	   )
	AJC_DLGMAP_CMD(Main, IDC_RBT_G3D2	   )

	AJC_DLGMAP_CMD(Main, IDC_RBT_LBX1	   )
	AJC_DLGMAP_CMD(Main, IDC_RBT_LBX2	   )

	AJC_DLGMAP_CMD(Main, IDC_RBT_VTH1	   )
	AJC_DLGMAP_CMD(Main, IDC_RBT_VTH2	   )

	AJC_DLGMAP_CMD(Main, IDC_CHK_DISABLE   )

	AJC_DLGMAP_CMD(Main, IDCANCEL		   )
AJC_DLGMAP_END

