﻿//
//	SW_VT100_MesTime.c
//
#include	<AjrCstXX.h>
#include	<math.h>
#include	<tchar.h>
#include	"resource.h"

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
HWND			hDlgMain;						//	ダイアログボックスハンドル
HWND			hVth;							//	ＶＴ１００ウインド
HWND			hWndTxt;						//	ＶＴ１００内テキスト描画ウインド
HAJCFILE		hFile = NULL;					//	読み出しファイルハンドル
HAJCMESTIME		hMesDraw   = NULL;				//	時間計測ハンドル（ＶＲＡＭ描画）
HAJCMESTIME		hMesPaint  = NULL;				//	時間計測ハンドル（ＰＡＩＮＴ）
HAJCMESTIME		hMesPeriod = NULL;				//	時間計測ハンドル（ＰＡＩＮＴ）

UI				Count;
ULL				tmPaintCnt, tmPaintSum, tmPaintAve, tmPaintMin, tmPaintMax;
ULL				tmWriteCnt, tmWriteSum, tmWriteAve, tmWriteMin, tmWriteMax;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);
AJC_WNDPROC_DEF(SubCls);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 		msg;

	hInst = hInstance;

	//----- メイン・ダイアログ生成 -----------------------------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DLGMAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	hDlgMain = hDlg;
	hVth	 = GetDlgItem(hDlg, IDC_VTH);

	//	時間計測ハンドル生成
	hMesDraw   = AjcMesTimeCreate(FALSE);
	hMesPaint  = AjcMesTimeCreate(FALSE);
	hMesPeriod = AjcMesTimeCreate(FALSE);

	//	ＶＴ１００内テキスト描画ウインドをサブクラス化
	hWndTxt  = FindWindowEx(hVth, NULL, TEXT("AjcVT100MainClass"), NULL);
	MAjcMmpSetSubclass(SubCls, hWndTxt);

	//	テキストボックスにファイルをドロップ可能にする
	AjcEnableDlgItemToDrop(hDlg, IDC_TXT_FILE, AJCDROP_FILE);

	//	ダイアログ設定値ロード
	AjcLoadAllControlSettings(hDlg, TEXT("DlgSettings"), AJCCTL_SELACT_ALL | AJCCTL_SELACT_NTCCHK);

	//	タイマスタート
	SetTimer(hDlg, 1, AjcGetDlgItemUInt(hDlg, IDC_INP_PERIOD), NULL);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//	タイマ停止
	KillTimer(hDlg, 1);

	//	時間計測ハンドル破棄
	AjcMesTimeDelete(hMesDraw  );
	AjcMesTimeDelete(hMesPaint );
	AjcMesTimeDelete(hMesPeriod);

	//	ファイルクローズ
	if (hFile != NULL) {AjcFClose(hFile);}

	//	ダイアログ設定値セーブ
	AjcSaveAllControlSettings(hDlg);

	//	プログラム終了
	PostQuitMessage(0);

	return TRUE;
}
//----- タイマ -------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_TIMER			)
{
	ULL		tm;
	UT		path[MAX_PATH];
	UT		buf[1024] = {0};
	UI		i;
	ULL		ave;
	static	UI	ix = 0;
	static	UI	n  = 0;
	static	ULL	cyc[16];

	//	タイマ周期表示（移動平均）
	cyc[ix] = AjcMesTimeInterval(hMesPeriod);
	ix = ((ix + 1) % 16);
	if (n < 16) n++;
	ave = 0;
	for (i = 0; i < n; i++) {
		ave += cyc[i];
	}
	ave /= n;
	AjcSetDlgItemUI64(hDlg, IDC_TXT_PERIOD, ave / 1000);

	if (hFile != NULL) {
		//	ファイルを１行読み出し
		if (!AjcFGetS(hFile, buf, AJCTSIZE(buf))) {
			AjcFClose(hFile);
			AjcGetDlgItemStr(hDlg, IDC_TXT_FILE, path, MAX_PATH);
			if (hFile = AjcFOpen(path, AJCTEC_AUTO)) {
				AjcVthPrintF(hVth, TEXT("\n========== %s ==========\n"), path);
				AjcFGetS(hFile, buf, AJCTSIZE(buf));
			}
		}
		if (hFile != NULL && buf[0] != 0) {
			//	１行描画し、時間計測
			AjcMesTimeInterval(hMesDraw);
			AjcVthPrintF(hVth, TEXT("%5d : %s"), ++Count, buf);
			tm = AjcMesTimeInterval(hMesDraw);

			//	計測情報更新（ＶＲＡＭ描画時間）
			tmWriteSum += tm;
			tmWriteCnt++;
			tmWriteAve = tmWriteSum / tmWriteCnt;
			tmWriteMin = __min(tmWriteMin, tm);
			tmWriteMax = __max(tmWriteMax, tm);

			//	計測情報表示
			AjcSetDlgItemUI64(hDlg, IDC_TXT_WRITE_CNT, tmWriteCnt);
			AjcSetDlgItemUI64(hDlg, IDC_TXT_WRITE_AVE, tmWriteAve);
			AjcSetDlgItemUI64(hDlg, IDC_TXT_WRITE_MIN, tmWriteMin);
			AjcSetDlgItemUI64(hDlg, IDC_TXT_WRITE_MAX, tmWriteMax);

			AjcSetDlgItemUI64(hDlg, IDC_TXT_PAINT_CNT, tmPaintCnt);
			AjcSetDlgItemUI64(hDlg, IDC_TXT_PAINT_AVE, tmPaintAve);
			AjcSetDlgItemUI64(hDlg, IDC_TXT_PAINT_MIN, tmPaintMin);
			AjcSetDlgItemUI64(hDlg, IDC_TXT_PAINT_MAX, tmPaintMax);
		}
	}
	return TRUE;
}
//----- キャンセル ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//----- STARTボタン --------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_START		)
{
	UT		path[MAX_PATH];

	AjcGetDlgItemStr(hDlg, IDC_TXT_FILE, path, MAX_PATH);
	if (hFile = AjcFOpen(path, AJCTEC_AUTO)) {
		AjcVthPrintF(hVth, TEXT("\n========== %s ==========\n"), path);
		//	ボタン表示変更
		AjcEnableDlgItem(hDlg, IDC_CMD_START, FALSE);
		AjcEnableDlgItem(hDlg, IDC_CMD_STOP , TRUE );
		//	計測情報初期化
		Count	= 0;
		tmPaintCnt = tmPaintSum = tmPaintMax = 0; tmPaintMin = 0xFFFFFFFFFFFFFFFFULL;
		tmWriteCnt = tmWriteSum = tmWriteMax = 0; tmWriteMin = 0xFFFFFFFFFFFFFFFFULL;
	}
	else {
		MessageBox(hDlg, TEXT("ファイルをオープンできません"), TEXT("SW_VT100_MesTime"), MB_ICONERROR);
	}
	return TRUE;
}
//----- STOPボタン ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_STOP		)
{
	//	ボタン表示変更
	AjcEnableDlgItem(hDlg, IDC_CMD_START, TRUE );
	AjcEnableDlgItem(hDlg, IDC_CMD_STOP , FALSE);
	//	ファイルをクローズして表示停止
	if (hFile != NULL) {
		AjcFClose(hFile);
		hFile = NULL;
	}
	return TRUE;
}
//----- 表示一時停止 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_PAUSE		)
{
	AjcVthPause(hVth, TRUE);
	return TRUE;
}
//----- 表示再開 -----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_RESTART	)
{
	AjcVthPause(hVth, FALSE);
	return TRUE;
}
//----- キャレット表示チェックボックス -------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CHK_CARET		)
{
	AjcVthShowCaret(hVth, AjcGetDlgItemChk(hDlg, IDC_CHK_CARET));
	return TRUE;
}
//----- 固定ピッチ チェックボックス ----------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CHK_FIXEDPITCH)
{
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_FIXEDPITCH))
		MAjcSetWindowLong(hVth, GWL_STYLE, MAjcGetWindowLong(hVth, GWL_STYLE) |  AJCVTHS_FIXEDPITCH);
	else
		MAjcSetWindowLong(hVth, GWL_STYLE, MAjcGetWindowLong(hVth, GWL_STYLE) & ~AJCVTHS_FIXEDPITCH);
	return TRUE;
}
//----- 高速表示 チェックボックス ------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CHK_FAST		)
{
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_FAST))
		MAjcSetWindowLong(hVth, GWL_STYLE, MAjcGetWindowLong(hVth, GWL_STYLE) |  AJCVTHS_FAST);
	else
		MAjcSetWindowLong(hVth, GWL_STYLE, MAjcGetWindowLong(hVth, GWL_STYLE) & ~AJCVTHS_FAST);
	return TRUE;
}
//----- 表示周期 -----------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_INP_PERIOD)
{
	if (HIWORD(wParam) == AJCIVN_INTVALUE) {
		SetTimer(hDlg, 1, AjcGetDlgItemUInt(hDlg, IDC_INP_PERIOD), NULL);
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG		)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 		)
	AJC_DLGMAP_MSG(Main, WM_TIMER			)
	AJC_DLGMAP_CMD(Main, IDCANCEL			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_START		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_STOP		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_PAUSE		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_RESTART	)
	AJC_DLGMAP_CMD(Main, IDC_CHK_CARET		)
	AJC_DLGMAP_CMD(Main, IDC_CHK_FIXEDPITCH	)
	AJC_DLGMAP_CMD(Main, IDC_CHK_FAST		)
	AJC_DLGMAP_CMD(Main, IDC_INP_PERIOD		)
AJC_DLGMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	ＶＴ１００コントロール・テキスト表示ウインドプロシージャ（サブクラス）										//
//--------------------------------------------------------------------------------------------------------------//
//----- WM_PAINT -----------------------------------------------------------------------------------------------//
AJC_WNDPROC(SubCls, WM_PAINT		)
{
	LRESULT	rc;
	ULL		tm;

	//	WM_PAINT実行時間計測
	AjcMesTimeInterval(hMesPaint);
	rc = MAjcMmpCallOrgWndProc(SubCls);
	tm = AjcMesTimeInterval(hMesPaint);
	//	計測情報更新（ウインド表示時間）
	tmPaintSum += tm;
	tmPaintCnt++;
	tmPaintAve = tmPaintSum / tmPaintCnt;
	tmPaintMin = __min(tmPaintMin, tm);
	tmPaintMax = __max(tmPaintMax, tm);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SubCls)
	AJC_WNDMAP_MSG(SubCls, WM_PAINT		   )
AJC_WNDMAP_END
