﻿//
//	SW_XYMTester.c
//
#include	<AjrCstXX.h>
#include	<io.h>
#include	<tchar.h>
#include	<sys/stat.h>
#include	"resource.h"

#define WM_SCPEVENT 	(WM_USER + 100)

//--------------------------------------------------------------------------------------------------------------//
//	データレコード形式																							//
//--------------------------------------------------------------------------------------------------------------//
#pragma	pack(1)
typedef struct {
	UB		h;
	UB		bn, _bn;
	UB		dat[128];
	UB		sum;
} REC128S, *PREC128S;

typedef struct {
	UB		h;
	UB		bn, _bn;
	UB		dat[128];
	UW		crc;
} REC128C, *PREC128C;

typedef struct {
	UB		h;
	UB		bn, _bn;
	UB		dat[1024];
	UW		crc;
} REC1024, *PREC1024;

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain;						//	ダイアログボックスハンドル
static	HWND			hVthLog;

static	HAJCXYM 		hXym;
static	HAJCSCP 		hScp;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);

static	VO				ShowOnOpened(VO);
static	VO				ShowOnClosed(VO);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_MAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 		)
{
	hDlgMain = hDlg;
	hVthLog  = GetDlgItem(hDlg, IDC_VTH_LOG);

	//--- ダイアログ項目初期化 -----------------------------------//
	AjcSetDlgItemUInt(hDlg, IDC_TXT_BN, 1);
	//--- ＳＣＰインスタンス生成 ---------------------------------//
	hScp = AjcScpCreate();
	AjcScpSetMode(hScp, hDlg, WM_SCPEVENT, AJCSCP_CM_BIN);
	AjcScpSetEvtMask(hScp, AJCSCP_EV_PORTSTATE | AJCSCP_EV_RXCHUNK);
	//--- ポートオープン -----------------------------------------//
	SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_CMD_OPEN, BN_CLICKED),0);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY			)
{
	//----- インスタンス破棄 ------------------------------//
	AjcScpDelete(hScp); //	SCPインスタンス消去

	PostQuitMessage(0);
	return TRUE;
}
//----- ＳＣＰイベント通知 -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_SCPEVENT			)
{
	UI		time = GetTickCount();
	UI		len, param;
	union {UBP pBin; UTP pTxt; VOP vp;} u;
	UT		txt[128];

	AjcScpGetEventData(hScp, lParam, &u.vp, &len, &param);				//	イベントデータ取得
	if(wParam & AJCSCP_EV_PORTSTATE) {									//	●ポート状態通知
		switch (param) {
			case AJCSCP_CLOSED: ShowOnClosed(); break;					//		・クローズ状態
			case AJCSCP_OPENED: ShowOnOpened(); break;					//		・オープン状態
			case AJCSCP_OPENFAIL:										//		・オープン失敗
				AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("%s open falure!"), AjcScpGetPortPathName(hScp));
				MessageBox(hDlgMain, txt, TEXT("Error"), MB_ICONERROR);
				break;
		}
	}
	if(wParam & AJCSCP_EV_RXCHUNK ) {									//	●チャンクデータ受信通知（バイナリ）
		AjcVthPrintF(hVthLog, TEXT("> "));
		if (len <= 16) {
			AjcVthHexDump(hVthLog, u.pBin, len);
			AjcVthPrintF(hVthLog, TEXT("    (%d bytes)"), len);
		}
		else {
			AjcVthHexDump(hVthLog, u.pBin, 16);
			AjcVthPrintF(hVthLog, TEXT("... (%d bytes)"), len);
		}
		AjcVthPrintF(hVthLog, TEXT("\n"));
	}
	AjcScpRelEventData(hScp, lParam);									//	イベントデータ開放

	return TRUE;
}
//----- ウインドクローズ ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL				)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//----- オープン／クローズ ボタン ------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_OPEN			)
{
	if (AjcScpIsOpened(hScp)) {
		//----- ポートクローズ ---------------------------------------//
		AjcScpClose(hScp);
	}
	else {
		//----- ポートオープン ---------------------------------------//
		AjcScpOpenDefault(hScp);
	}
	return TRUE;
}
//----- ポート設定ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_EASY			)
{
	AjcScpDlgParamEasy(hScp, hDlg);
	return TRUE;
}
//----- 'C'送信 ------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_TX_C			)
{
	UB		d = 'C';
	AjcScpSendBinData(hScp, &d, 1);
	AjcVthPrintF(hVthLog, TEXT("< C\n"));
	return TRUE;
}
//----- 'G'送信 ------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_TX_G			)
{
	UB		d = 'G';
	AjcScpSendBinData(hScp, &d, 1);
	AjcVthPrintF(hVthLog, TEXT("< G\n"));
	return TRUE;
}
//----- NAK送信 ------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_TX_NAK		)
{
	UB		d = 0x15;
	AjcScpSendBinData(hScp, &d, 1);
	AjcVthPrintF(hVthLog, TEXT("< NAK\n"));
	return TRUE;
}
//----- ACK送信 ------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_TX_ACK		)
{
	UB		d = 0x06;
	AjcScpSendBinData(hScp, &d, 1);
	AjcVthPrintF(hVthLog, TEXT("< ACK\n"));
	return TRUE;
}
//----- EOT送信 ------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_TX_EOT		)
{
	UB		d = 0x04;
	AjcScpSendBinData(hScp, &d, 1);
	AjcVthPrintF(hVthLog, TEXT("< EOT\n"));
	return TRUE;
}
//----- データ（128Byte, SUM）送信 -----------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_TX_D128_SUM	)
{
	REC128S		d;

	memset(&d, 0, sizeof d);
	d.h   = 0x01; // SOH
	d.bn  = (UB)AjcGetDlgItemHex(hDlg, IDC_TXT_BN);
	d._bn = ~d.bn;
	AjcSetByteSum(&d.dat, 128 + 1);
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_ERR)) d.sum++;
	AjcScpSendBinData(hScp, &d, sizeof d);
	AjcVthPrintF(hVthLog, TEXT("< {DATA 128[Bytes], SUM}\n"));

	d.bn = ((d.bn == 0xFF) ? 0x01 : d.bn + 1);
	AjcSetDlgItemUInt(hDlg, IDC_TXT_BN, d.bn);

	return TRUE;
}
//----- データ（128Byte, CRC）送信 -----------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_TX_D128_CRC	)
{
	REC128C		d;

	memset(&d, 0, sizeof d);
	d.h   = 0x01; // SOH
	d.bn  = (UB)AjcGetDlgItemHex(hDlg, IDC_TXT_BN);
	d._bn = ~d.bn;
	AjcSetXMODEM_BE(&d.dat, 128 + 2);
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_ERR)) d.crc++;
	AjcScpSendBinData(hScp, &d, sizeof d);
	AjcVthPrintF(hVthLog, TEXT("< {DATA 128[Bytes], CRC}\n"));

	d.bn = ((d.bn == 0xFF) ? 0x01 : d.bn + 1);
	AjcSetDlgItemUInt(hDlg, IDC_TXT_BN, d.bn);

	return TRUE;
}
//----- データ（1024Byte）送信 ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_TX_D1024		)
{
	REC1024		d;

	memset(&d, 0, sizeof d);
	d.h   = 0x02; // STX
	d.bn  = (UB)AjcGetDlgItemHex(hDlg, IDC_TXT_BN);
	d._bn = ~d.bn;
	AjcSetXMODEM_BE(&d.dat, 1024 + 2);
	AjcScpSendBinData(hScp, &d, sizeof d);
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_ERR)) d.crc++;
	AjcVthPrintF(hVthLog, TEXT("< {DATA 1024[Bytes], CRC}\n"));

	d.bn = ((d.bn == 0xFF) ? 0x01 : d.bn + 1);
	AjcSetDlgItemUInt(hDlg, IDC_TXT_BN, d.bn);

	return TRUE;
}
//----- 属性（128Byte）送信 ------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_TX_A128		)
{
	REC128C		d;
	static BC	s[] = "x.txt\09999";

	memset(&d, 0, sizeof d);
	d.h   = 0x01; // SOH
	d.bn  = 0x00;
	d._bn = 0xFF;
	memcpy(d.dat, s, sizeof s);
	AjcSetXMODEM_BE(&d.dat, 128 + 2);
	AjcScpSendBinData(hScp, &d, sizeof d);
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_ERR)) d.crc++;
	AjcVthPrintF(hVthLog, TEXT("< {ATT  128[Bytes], CRC}\n"));

	return TRUE;
}
//----- 属性（1024Byte）送信 -----------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_TX_A1024		)
{
	REC1024		d;
	static BC	s[] = "x.txt\09999";

	memset(&d, 0, sizeof d);
	d.h   = 0x02; // STX
	d.bn  = 0x00;
	d._bn = 0xFF;
	memcpy(d.dat, s, sizeof s);
	AjcSetXMODEM_BE(&d.dat, 1024 + 2);
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_ERR)) d.crc++;
	AjcScpSendBinData(hScp, &d, sizeof d);
	AjcVthPrintF(hVthLog, TEXT("< {ATT  1024[Bytes], CRC}\n"));

	return TRUE;
}
//----- 空属性（128Byte）送信 ----------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_TX_N128		)
{
	REC128C		d;

	memset(&d, 0, sizeof d);
	d.h   = 0x01; // SOH
	d.bn  = 0x00;
	d._bn = 0xFF;
	AjcSetXMODEM_BE(&d.dat, 128 + 2);
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_ERR)) d.crc++;
	AjcScpSendBinData(hScp, &d, sizeof d);
	AjcVthPrintF(hVthLog, TEXT("< {NULL 128[Bytes], CRC}\n"));

	return TRUE;
}
//----- 空属性（1024Byte）送信 ---------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_TX_N1024		)
{
	REC1024		d;

	memset(&d, 0, sizeof d);
	d.h   = 0x02; // STX
	d.bn  = 0x00;
	d._bn = 0xFF;
	AjcSetXMODEM_BE(&d.dat, 1024 + 2);
	AjcScpSendBinData(hScp, &d, sizeof d);
	if (AjcGetDlgItemChk(hDlg, IDC_CHK_ERR)) d.crc++;
	AjcVthPrintF(hVthLog, TEXT("< {NULL 1024[Bytes], CRC}\n"));

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG			)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 			)
	AJC_DLGMAP_MSG(Main, WM_SCPEVENT			)
	AJC_DLGMAP_CMD(Main, IDCANCEL				)
	AJC_DLGMAP_CMD(Main, IDC_CMD_OPEN			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_EASY			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_TX_C			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_TX_G			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_TX_NAK			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_TX_ACK			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_TX_EOT			)
	AJC_DLGMAP_CMD(Main, IDC_CMD_TX_D128_SUM	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_TX_D128_CRC	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_TX_D1024		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_TX_A128		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_TX_A1024		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_TX_N128		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_TX_N1024		)
AJC_DLGMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	ＣＯＭポートオープン時の表示																				//
//--------------------------------------------------------------------------------------------------------------//
static	VO		ShowOnOpened(VO)
{
	UT	txt[64];

	AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("SW_XYMTester ( %s )"), AjcScpGetPortName(hScp));
	SetWindowText(hDlgMain, txt);										//	ウインドタイトル
	AjcSetDlgItemStr(hDlgMain, IDC_CMD_OPEN, TEXT("CLOSE"));			//	ボタンフェース
	AjcEnableDlgGroup(hDlgMain, IDC_GRP_BTNS, TRUE, TRUE);
}
//--------------------------------------------------------------------------------------------------------------//
//	ＣＯＭポートクローズ時の表示																				//
//--------------------------------------------------------------------------------------------------------------//
static	VO		ShowOnClosed(VO)
{
	SetWindowText(hDlgMain, TEXT("SW_XYMTester ( Disconnect )"));		 //  ウインドタイトル
	AjcSetDlgItemStr(hDlgMain, IDC_CMD_OPEN, TEXT("OPEN")); 			//	ボタンフェース
	AjcEnableDlgGroup(hDlgMain, IDC_GRP_BTNS, TRUE, FALSE);
}
