﻿//
//	SW_XYModemTx.c
//
#include	<AjrCstXX.h>
#include	<io.h>
#include	<tchar.h>
#include	<sys/stat.h>
#include	"resource.h"

#define WM_SCPEVENT 	(WM_USER + 100)

//--------------------------------------------------------------------------------------------------------------//
//	定数																										//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {COMM_232C , COMM_LAN} 				ECOMM;
typedef enum {XM_SUM, XM_CRC, XM_1K, YM_STD, YM_G}	EPROTOCOL;

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HINSTANCE		hInst;							//	ＤＬＬインスタンスハンドル
static	HWND			hDlgMain;						//	ダイアログボックスハンドル
static	HWND			hVthLog;

static	HAJCXYM 		hXym;
static	HAJCSCP 		hScp;

static	BOOL			fFindFirst		= TRUE; 		//	初回ファイル検索フラグ
static	SX				hFind			= -1;			//	ファイル検索ハンドル
static	struct _tfinddata64_t	FindData;				//	ファイル検索結果データ
static	HANDLE			hFile = INVALID_HANDLE_VALUE;	//	送信ファイルハンドル
static	SLL				TxRemBytes; 					//	送信ファイルサイズ
static	UT				DirPath [MAX_PATH]; 			//	ディレクトリ・パス名
static	UT				FilePath[MAX_PATH]; 			//	ファイルパス名
static	UT				WildCard[MAX_PATH]; 			//	ワイルドカード・パス

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(Main);

static VO CALLBACK cbGetFile(PAJCXYMFILEINFO pBuf			, UX cbp);
static VO CALLBACK cbGetData(VOP pBuf, UI len, UIP pBytes	, UX cbp);
static VO CALLBACK cbNotice (UI knd, UX Param				, UX cbp);
static VO CALLBACK cbSend	(C_VOP pTxD, UI len 			, UX cbp);

static	VO				ShowOnOpened(VO);
static	VO				ShowOnClosed(VO);
static	AJCXYMPROTOCOL	SubGetProtocol		(EPROTOCOL		protocol);
static	UTP 			SubProtocolNameByRbt(EPROTOCOL		protocol);
static	UTP 			SubProtocolNameByXym(AJCXYMPROTOCOL protocol);

//==============================================================================================================//
//																												//
//	W i n M a i n																								//
//																												//
//==============================================================================================================//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 	msg;

	hInst = hInstance;

	//----- メイン・ダイアログオープン -----------------//
	hDlgMain = CreateDialog(hInst, MAKEINTRESOURCE(IDD_MAIN), NULL, AJC_DLGPROC_NAME(Main));
	ShowWindow(hDlgMain, SW_SHOW);

	//----- メッセージループ ---------------------------//
	while (GetMessage(&msg, NULL, 0, 0)) {
		do {
			if (IsDialogMessage(hDlgMain, &msg)) break;
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		} while (0);
	}

	return (int)msg.wParam ;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_INITDIALOG 	)
{
	UI	t0, t1, r0, r1;

	hDlgMain = hDlg;
	hVthLog  = GetDlgItem(hDlg, IDC_VTH_LOG);

	//--- ツールチップ -------------------------------------------//
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_TXT_T0), TEXT("受信要求(NAK/C/G)受信待ちタイマ[ms]"));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_TXT_T1), TEXT("ＡＣＫ／ＮＡＫ受信待ちタイマ[ms]"));
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_TXT_R1), TEXT("データ／ＥＯＴ再送限度回数"));
	//--- ＳＣＰインスタンス生成 ---------------------------------//
	hScp = AjcScpCreate();
	AjcScpSetMode(hScp, hDlg, WM_SCPEVENT, AJCSCP_CM_BIN);
	AjcScpSetEvtMask(hScp, AJCSCP_EV_PORTSTATE | AJCSCP_EV_RXCHUNK | AJCSCP_EV_TXEMPTY);
	//--- テキストボックスへのドロップを許可 ---------------------//
	AjcEnableDlgItemToDrop (hDlg, IDC_TXT_XM_FILE, AJCDROP_FILE);
	AjcEnableDlgItemToDrop (hDlg, IDC_TXT_YM_DIR , AJCDROP_DIR );
	//--- ラジオボタングループ化 ---------------------------------//
	AjcSbcRadioBtns(GetDlgItem(hDlg, IDC_GRP_PROTOCOL));
	//--- X-Modem / Y-Modem インスタンス生成 ---------------------//
	hXym = AjcXymCreate(0, cbNotice, cbGetFile, cbGetData, cbSend);
	//--- ダイアログ項目の初期化 ---------------------------------//
	AjcXymGetTxTimeInfo(hXym, &t0, &r0, &t1, &r1);
	AjcSetDlgItemUInt(hDlg, IDC_GRP_PROTOCOL, XM_SUM  );
	AjcSetDlgItemStr (hDlg, IDC_TXT_XM_FILE , TEXT(""));
	AjcSetDlgItemStr (hDlg, IDC_TXT_YM_DIR	, TEXT(""));
	AjcSetDlgItemChk (hDlg, IDC_CHK_TXERR	 , FALSE  );
	AjcSetDlgItemUInt(hDlg, IDC_INP_TXERR	 , 0	  );
	AjcSetDlgItemUInt(hDlg, IDC_TXT_T0		 , t0	  );
	AjcSetDlgItemUInt(hDlg, IDC_TXT_R0		 , r0	  );
	AjcSetDlgItemUInt(hDlg, IDC_TXT_T1		 , t1	  );
	AjcSetDlgItemUInt(hDlg, IDC_TXT_R1		 , r1	  );
	//----- ダイアログ項目のロード -------------------------------//
	AjcLoadAllControlSettings (hDlg, TEXT("DlgSetting"), AJCOPT2(AJCCTL_SELACT_, ALL, NTCRBT));
	//--- ポートオープン -----------------------------------------//
	SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_CMD_OPEN, BN_CLICKED),0);

	return TRUE;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_DESTROY		)
{
	//----- インスタンス破棄 ------------------------------//
	AjcScpDelete(hScp); //	SCPインスタンス消去
	AjcXymDelete(hXym); //	X-Modem / Y-Modem インスタンス
	//----- ダイアログ項目のセーブ ------------------------//
	AjcSaveAllControlSettings(hDlg);

	PostQuitMessage(0);
	return TRUE;
}
//----- ＳＣＰイベント通知 -------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, WM_SCPEVENT		)
{
	UI		time = GetTickCount();
	UI		len, param;
	union {UBP pBin; UTP pTxt; VOP vp;} u;
	UT		txt[128];

	AjcScpGetEventData(hScp, lParam, &u.vp, &len, &param);				//	イベントデータ取得
	if(wParam & AJCSCP_EV_PORTSTATE) {									//	●ポート状態通知
		switch (param) {
			case AJCSCP_CLOSED: ShowOnClosed(); break;					//		・クローズ状態
			case AJCSCP_OPENED: ShowOnOpened(); break;					//		・オープン状態
			case AJCSCP_OPENFAIL:										//		・オープン失敗
				AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("%s open falure!"), AjcScpGetPortPathName(hScp));
				MessageBox(hDlgMain, txt, TEXT("Error"), MB_ICONERROR);
				break;
		}
	}
	if(wParam & AJCSCP_EV_RXCHUNK ) {									//	●チャンクデータ受信通知（バイナリ）
		UI		i;
		UBP 	p = u.pBin;
		for (i = 0; i < len; i++) {
			AjcXymPutRxChar(hXym, *p++);
		}
	}
	if(wParam & AJCSCP_EV_TXEMPTY) {									//	●送信完了
		if (hXym->knd == AJCXYP_YMODEM_G && TxRemBytes <= 0) {			//		YMODEM-G and 全データ送出済み？
			AjcXymTxEnd(hXym);											//			YMODEM-Gファイル送信完了を通知
		}
	}
	AjcScpRelEventData(hScp, lParam);									//	イベントデータ開放

	return TRUE;
}
//----- ウインドクローズ ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDCANCEL			)
{
	DestroyWindow(hDlg);
	return TRUE;
}
//----- オープン／クローズ ボタン ------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_OPEN		)
{
	if (AjcScpIsOpened(hScp)) {
		//	通信中ならば、中止ボタン押下
		if (AjcXymGetState(hXym) != 0) {
			SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_CMD_STOP, BN_CLICKED), (LPARAM)GetDlgItem(hDlg, IDC_CMD_OPEN));
		}
		//	ポートクローズ
		AjcScpClose(hScp);
	}
	else {
		//	ポートオープン
		AjcScpOpenDefault(hScp);
	}
	return TRUE;
}
//----- ポート設定ボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_EASY		)
{
	AjcScpDlgParamEasy(hScp, hDlg);
	return TRUE;
}
//----- プロトコルの選択 --------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_GRP_PROTOCOL	)
{
	if (HIWORD(wParam) == AJCRBTN_SELECT) {
		if (lParam <= XM_1K) {
			AjcEnableGroup(GetDlgItem(hDlg, IDC_GRP_XM_FILE), TRUE , TRUE );
			AjcEnableGroup(GetDlgItem(hDlg, IDC_GRP_YM_DIR ), FALSE, FALSE);
		}
		else {
			AjcEnableGroup(GetDlgItem(hDlg, IDC_GRP_XM_FILE), FALSE, FALSE);
			AjcEnableGroup(GetDlgItem(hDlg, IDC_GRP_YM_DIR ), TRUE , TRUE );
		}
	}
	return TRUE;
}
//----- ＸＭＯＤＥＭ送信ファイル名設定 ------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_XM_FILE	)
{
	struct __stat64 st;
	UT				drv[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], fext[_MAX_EXT];

	if (_tstat64(FilePath, &st) != 0) {
		FilePath[0] = 0;
	}
	if (AjcGetOpenFile(hDlg, TEXT("送信ファイル"), TEXT("AllFiles(*.*)/*.*"), TEXT("txt"), FilePath, MAX_PATH)) {
		AjcSetDlgItemStr(hDlg, IDC_TXT_XM_FILE, FilePath);
		MAjcSplitPath(FilePath, drv, dir, fname, fext);
		MAjcMakePath (DirPath , drv, dir, NULL , NULL);
	}

	return TRUE;
}
//----- ＹＭＯＤＥＭ送信フォルダ名設定 ------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_YM_DIR	)
{
	if (AjcGetFolderName(hDlg, TEXT("送信フォルダ"), TEXT("フォルダ内の全ファイルを送信します"), DirPath, MAX_PATH)) {
		AjcSetDlgItemStr(hDlg, IDC_TXT_YM_DIR, DirPath);
	}
	return TRUE;
}
//----- 送信開始ボタン ----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_SEND		)
{
	EPROTOCOL	protocol = (EPROTOCOL)AjcGetDlgItemUInt(hDlg, IDC_GRP_PROTOCOL);
	UI			t0 = AjcGetDlgItemUInt(hDlg, IDC_TXT_T0);
	UI			r0 = AjcGetDlgItemUInt(hDlg, IDC_TXT_R0);
	UI			t1 = AjcGetDlgItemUInt(hDlg, IDC_TXT_T1);
	UI			r1 = AjcGetDlgItemUInt(hDlg, IDC_TXT_R1);

	AjcXymSetTxTimeInfo (hXym, t0, r0, t1, r1);								//	タイマ情報設定
	do {
		if (protocol <= XM_1K) {											//	Ｘ－ＭＯＤＥＭ？
			UT		drv[_MAX_DRIVE], dir[_MAX_DIR];
			AjcGetDlgItemStr(hDlg, IDC_TXT_XM_FILE, FilePath, MAX_PATH);	//		転送ファイル名設定
			MAjcStrCpy(WildCard, AJCTSIZE(WildCard), FilePath);
			MAjcSplitPath(FilePath, drv, dir, NULL, NULL);					//		ワイルドカード設定
			MAjcMakePath (DirPath, drv, dir, NULL, NULL);					//		・
		}
		else {																//	Ｙ－ＭＯＤＥＭ？
			AjcGetDlgItemStr(hDlg, IDC_TXT_YM_DIR, DirPath, MAX_PATH);		//		転送フォルダ名設定
			MAjcStrCpy(WildCard, AJCTSIZE(WildCard), DirPath); 				//		ワイルドカード設定
			AjcPathCat(WildCard, TEXT("*.*"), MAX_PATH);					//		・
		}

		AjcEnableGroup(GetDlgItem(hDlgMain, IDC_GRP_PROTOCOL), FALSE, FALSE);
		EnableWindow(GetDlgItem(hDlgMain, IDC_CMD_SEND), FALSE);
		EnableWindow(GetDlgItem(hDlgMain, IDC_CMD_STOP), TRUE );

		AjcVthPrintF(hVthLog, TEXT("========== TRANSFER START (%s) ==========\n"), SubProtocolNameByRbt(protocol));
		fFindFirst		= TRUE; 						//	ファイル検索初回フラグ・セット
		AjcXymTxStart(hXym, SubGetProtocol(protocol));	//	送信開始
	} while(0);

	return TRUE;
}
//----- 送信中止ボタン -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Main, IDC_CMD_STOP		)
{
	AjcXymStop(hXym);
	AjcEnableGroup(GetDlgItem(hDlgMain, IDC_GRP_PROTOCOL), TRUE , TRUE );
	EnableWindow(GetDlgItem(hDlgMain, IDC_CMD_SEND	), TRUE );
	EnableWindow(GetDlgItem(hDlgMain, IDC_CMD_STOP	), FALSE);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Main)
	AJC_DLGMAP_MSG(Main, WM_INITDIALOG		)
	AJC_DLGMAP_MSG(Main, WM_DESTROY 		)
	AJC_DLGMAP_MSG(Main, WM_SCPEVENT		)
	AJC_DLGMAP_CMD(Main, IDCANCEL			)
	AJC_DLGMAP_CMD(Main, IDC_GRP_PROTOCOL	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_XM_FILE	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_YM_DIR 	)
	AJC_DLGMAP_CMD(Main, IDC_CMD_OPEN		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_EASY		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_SEND		)
	AJC_DLGMAP_CMD(Main, IDC_CMD_STOP		)
AJC_DLGMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	ファイル情報取得　コールバック関数																			//
//--------------------------------------------------------------------------------------------------------------//
static VO CALLBACK cbGetFile(PAJCXYMFILEINFO pBuf, UX cbp)
{
	BOOL	fEndOfFind	= FALSE;
	BOOL	fFileOpened = FALSE;

	while (!fEndOfFind	&&	!fFileOpened) {
		//----- ファイル検索 ------------------------------------------------------------//
		do {
			if (fFindFirst) {if ((hFind = _tfindfirst64(WildCard, &FindData)) == -1) fEndOfFind = TRUE;}
			else			{if (_tfindnext64(hFind, &FindData) 			  == -1) fEndOfFind = TRUE;}
			fFindFirst = FALSE;
		} while (!fEndOfFind && (FindData.attrib & (_A_HIDDEN | _A_SUBDIR | _A_SYSTEM)));

		//----- ファイル情報設定 --------------------------------------------------------//
		if (!fEndOfFind) {
			AjcStrCpy(FilePath,MAX_PATH, DirPath);
			AjcPathCat(FilePath, FindData.name, MAX_PATH);
			if (hFile != INVALID_HANDLE_VALUE) {
				CloseHandle(hFile);
			}
			hFile = CreateFile(FilePath, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
			if (hFile != INVALID_HANDLE_VALUE) {
				GetFileSizeEx(hFile, (LARGE_INTEGER*)&TxRemBytes);	//	ファイルバイトサイズ設定
				MAjcStrCpy(FilePath, MAX_PATH, DirPath); 			//	ファイルパス名設定
				AjcPathCat(FilePath, FindData.name, MAX_PATH);		//	・
				pBuf->pFName = FindData.name;						//	ファイル名
				GetFileSizeEx(hFile, (PLARGE_INTEGER)&pBuf->size);	//	ファイルサイズ
				pBuf->time	 = (UL)(FindData.time_write);			//	ファイル時刻（ＵＴＣ）
				AjcVthPrintF(hVthLog, TEXT("File transfer <%s>\n"), FilePath);
				fFileOpened = TRUE;
			}
			else {
				AjcVthPrintF(hVthLog, TEXT("File open failure <%s>\n"));
				fFileOpened = FALSE;
			}
		}
		else  pBuf->pFName = NULL;
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	ファイルデータ取得　コールバック関数																		//
//--------------------------------------------------------------------------------------------------------------//
static VO CALLBACK cbGetData(VOP pBuf, UI len, UIP pBytes, UX cbp)
{
	ReadFile(hFile, pBuf, len, (ULP)pBytes, NULL);			//	ファイルデータ読み出し
	TxRemBytes -= (*pBytes);								//	バイト数カウンタ更新
}
//--------------------------------------------------------------------------------------------------------------//
//	イベント通知　コールバック関数																				//
//--------------------------------------------------------------------------------------------------------------//
static VO CALLBACK cbNotice(UI knd, UX Param, UX cbp)
{
	switch (knd) {
		case AJCXYN_TXREC:		AjcVthPrintF(hVthLog, TEXT("."));						break;	//	●１レコード送信完了
		case AJCXYN_RETRY:		AjcVthPrintF(hVthLog, TEXT("R"));						break;	//	●再送発生
		case AJCXYN_EOF:		AjcVthPrintF(hVthLog, TEXT("E\n")); 					break;	//	●ファイル終端（ＥＯＦ）
		case AJCXYN_PROTOCOL:	AjcVthPrintF(hVthLog, TEXT("Protocol change to '%s'\n"),		//	●プロトコル変更
										SubProtocolNameByXym((AJCXYMPROTOCOL)Param));	break;
		case AJCXYN_COMPLETE:	AjcVthPrintF(hVthLog, TEXT("Complete.\n")); 			break;	//	●送信正常終了
		case AJCXYN_RX_CAN: 	AjcVthPrintF(hVthLog, TEXT("Stop by Received CAN\n"));	break;	//	●送信中止（ＣＡＮ受信）
		case AJCXYN_USERSTOP:	AjcVthPrintF(hVthLog, TEXT("Stop by user\n"));			break;	//	●送信中止（ユーザ停止）
		case AJCXYN_TIMEOUT:	AjcVthPrintF(hVthLog, TEXT("Stop by Timeout\n"));		break;	//	●送信中止（タイムアウト）
		case AJCXYN_ABORT:		AjcVthPrintF(hVthLog, TEXT("Stop by abort\n")); 		break;	//	●送信中止（その他）
	}
	if ((knd & AJCXYN_END) != 0) {		// 転送終了
		AjcEnableGroup(GetDlgItem(hDlgMain, IDC_GRP_PROTOCOL), TRUE , TRUE );
		EnableWindow(GetDlgItem(hDlgMain, IDC_CMD_SEND), TRUE );
		EnableWindow(GetDlgItem(hDlgMain, IDC_CMD_STOP), FALSE);
		if (hFind != -1) _findclose(hFind);
		hFind = -1;
		if (hFile != INVALID_HANDLE_VALUE)	CloseHandle(hFile);
		hFile = INVALID_HANDLE_VALUE;
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	データ送出　コールバック関数																				//
//--------------------------------------------------------------------------------------------------------------//
static VO CALLBACK cbSend(C_VOP pTxD, UI len, UX cbp)
{
	if (AjcGetDlgItemChk(hDlgMain, IDC_CHK_TXERR) && len >= 128) {
		UB sv;
		sv = *((UBP)pTxD + (len - 1));
		if (AjcGetDlgItemSInt(hDlgMain, IDC_INP_TXERR) > (rand() % 100)) {
			*((UBP)pTxD + (len - 1)) ^= 0xFF;
		}
		AjcScpSendBinData(hScp, pTxD, len);
		*((UBP)pTxD + (len - 1))  = sv;
	}
	else {
		AjcScpSendBinData(hScp, pTxD, len);
	}
}

//--------------------------------------------------------------------------------------------------------------//
//	ＣＯＭポートオープン時の表示																				//
//--------------------------------------------------------------------------------------------------------------//
static	VO		ShowOnOpened(VO)
{
	UT	txt[64];

	AjcSnPrintF(txt, AJCTSIZE(txt), TEXT("ファイル送信 SW_XYModemTx ( %s )"), AjcScpGetPortName(hScp));
	SetWindowText(hDlgMain, txt);										//	ウインドタイトル
	AjcSetDlgItemStr(hDlgMain, IDC_CMD_OPEN, TEXT("CLOSE"));			//	ボタンフェース
	EnableWindow(GetDlgItem(hDlgMain, IDC_CMD_EASY	  ), FALSE);
	EnableWindow(GetDlgItem(hDlgMain, IDC_CMD_SEND	  ), TRUE );
	EnableWindow(GetDlgItem(hDlgMain, IDC_CMD_STOP	  ), FALSE);
}
//--------------------------------------------------------------------------------------------------------------//
//	ＣＯＭポートクローズ時の表示																				//
//--------------------------------------------------------------------------------------------------------------//
static	VO		ShowOnClosed(VO)
{
	SetWindowText(hDlgMain, TEXT("ファイル送信 SW_XYModemTx ( Disconnect )"));		 //  ウインドタイトル
	AjcSetDlgItemStr(hDlgMain, IDC_CMD_OPEN, TEXT("OPEN")); 			//	ボタンフェース
	EnableWindow(GetDlgItem(hDlgMain, IDC_CMD_EASY	  ), TRUE );
	EnableWindow(GetDlgItem(hDlgMain, IDC_CMD_SEND	  ), FALSE);
	EnableWindow(GetDlgItem(hDlgMain, IDC_CMD_STOP	  ), FALSE);
}
//--------------------------------------------------------------------------------------------------------------//
//	プロトコル種別値変換																						//
//--------------------------------------------------------------------------------------------------------------//
static AJCXYMPROTOCOL SubGetProtocol(EPROTOCOL protocol)
{
	AJCXYMPROTOCOL	rc;

	switch (protocol) {
		default:
		case XM_SUM:	rc = AJCXYP_XMODEM_SUM; 	break;
		case XM_CRC:	rc = AJCXYP_XMODEM_CRC; 	break;
		case XM_1K: 	rc = AJCXYP_XMODEM_1K;		break;
		case YM_STD:	rc = AJCXYP_YMODEM_STD; 	break;
		case YM_G:		rc = AJCXYP_YMODEM_G;		break;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	プロトコル名文字列取得																						//
//--------------------------------------------------------------------------------------------------------------//
static UTP SubProtocolNameByRbt(EPROTOCOL protocol)
{
	UTP 	rc = TEXT("");

	switch (protocol) {
		case XM_SUM:	rc = TEXT("X-MODEM ( SUM )");	break;
		case XM_CRC:	rc = TEXT("X-MODEM ( CRC )");	break;
		case XM_1K: 	rc = TEXT("X-MODEM ( 1KB )");	break;
		case YM_STD:	rc = TEXT("Y-MODEM" 		);	break;
		case YM_G:		rc = TEXT("Y-MODEM-G"		);	break;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static	UTP SubProtocolNameByXym(AJCXYMPROTOCOL protocol)
{
	UTP 	rc = TEXT("");

	switch (protocol) {
		case AJCXYP_XMODEM_SUM: rc = TEXT("X-MODEM ( SUM )");	break;
		case AJCXYP_XMODEM_CRC: rc = TEXT("X-MODEM ( CRC )");	break;
		case AJCXYP_XMODEM_1K:	rc = TEXT("X-MODEM ( 1KB )");	break;
		case AJCXYP_YMODEM_STD: rc = TEXT("Y-MODEM" 		);	break;
		case AJCXYP_YMODEM_G:	rc = TEXT("Y-MODEM-G"		);	break;
	}
	return rc;
}
