﻿
// S_MFC_02Dlg.cpp : 実装ファイル
//

#include "stdafx.h"
#include "S_MFC_02.h"
#include "S_MFC_02Dlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

//	プログラムワーク
BOOL	fBusy = FALSE;



// CS_MFC_02Dlg ダイアログ




CS_MFC_02Dlg::CS_MFC_02Dlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CS_MFC_02Dlg::IDD, pParent)
	, m_fReady(false)
	, m_TickStart(0)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CS_MFC_02Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CS_MFC_02Dlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_CMD_START, &CS_MFC_02Dlg::OnBnClickedCmdStart)
	ON_BN_CLICKED(IDC_CMD_STOP, &CS_MFC_02Dlg::OnBnClickedCmdStop)
	ON_BN_CLICKED(IDC_CMD_PAUSE, &CS_MFC_02Dlg::OnBnClickedCmdPause)
	ON_BN_CLICKED(IDC_CMD_RESTART, &CS_MFC_02Dlg::OnBnClickedCmdRestart)
	ON_WM_SIZE()
	ON_WM_SIZING()
	ON_BN_CLICKED(IDC_CHK_SHOWTTL, &CS_MFC_02Dlg::OnBnClickedChkShowttl)
END_MESSAGE_MAP()


//	状況依存ツールチップ(IDC_TXT_TIME)
class CAjxTip_TEXT_TIME : public CAjxTip
{
	VO		OnNeedText (HWND hCtrl, UTP pBuf, UI lBuf) override
	{
		CTime	t = CTime::GetCurrentTime();
		CString s = t.Format("%Y/%m/%d %H:%M:%S");
		_tcscpy_s(pBuf, lBuf, (LPCTSTR)s);
	}
};

CAjxTip_TEXT_TIME	tipTextTime;


// CS_MFC_02Dlg メッセージ ハンドラー

BOOL CS_MFC_02Dlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// このダイアログのアイコンを設定します。アプリケーションのメイン ウィンドウがダイアログでない場合、
	//	Framework は、この設定を自動的に行います。
	SetIcon(m_hIcon, TRUE);			// 大きいアイコンの設定
	SetIcon(m_hIcon, FALSE);		// 小さいアイコンの設定

	// TODO: 初期化をここに追加します。
	//	ダイアログのサイズ設定
	RECT	rc;
	GetWindowRect(&rc);
	m_szDlg.cx = rc.right - rc.left;
	m_szDlg.cy = rc.bottom - rc.top;
	//	各コントロールへハンドルをアタッチ
	m_dlg .CAjxDlg	::Attach(m_hWnd);
	m_tch1.CAjxTchEx::Attach(GetDlgItem(IDC_TCH1)->m_hWnd);
	m_tch2.CAjxTchEx::Attach(GetDlgItem(IDC_TCH2)->m_hWnd);
	m_inp .CAjxInpEx::Attach(GetDlgItem(IDC_INP )->m_hWnd);
	m_vth .CAjxVthEx::Attach(GetDlgItem(IDC_VTH )->m_hWnd);
	m_g3d .CAjxG3dEx::Attach(GetDlgItem(IDC_G3D )->m_hWnd);
	//	タイムチャートコントロール初期化
	m_tch1.SetOther(&m_tch2);				//	他方のタイムチャートオブジェクト設定
	m_tch2.SetOther(&m_tch1);
	m_tch1.ShowBorder(TRUE, RGB(  0,   0, 255));
	m_tch2.ShowBorder(TRUE, RGB(255,   0,	0));
	//	３Ｄグラフィックコントロール初期化
	m_g3d.SetAngle3D();						//	視点を３Ｄイメージに設定
	m_g3d.SetPlotNumber(0, 150);			//	プロット数設定
	m_g3d.SetPlotNumber(1, 150);
	//	ログウインド初期化
	//	ツールチップテキスト設定
	m_tch1.SetTipText(TEXT("\x1B[34m\x1B[TサンプルデータＡ：\x1B[0m\x1B[t\n")
						TEXT("球の表面を示すプロットデータ (x, y, z) を生成し、その波形を表示します。\n")
						TEXT("プロットデータは、半径に±１％のノイズを加えます。\n")
						TEXT("CTRL+中ボタンでゲージ間計測モードになります。"));
	m_tch1.SetChkBoxTipText(0, TEXT("x の波形"));
	m_tch1.SetChkBoxTipText(1, TEXT("y の波形"));
	m_tch1.SetChkBoxTipText(2, TEXT("z の波形"));
	m_tch2.SetTipText(TEXT("\x1B[31m\x1B[TサンプルデータＢ：\x1B[0m\x1B[t\n")
						TEXT("球の表面を示すプロットデータ (x, y, z) を生成し、その波形を表示します。\n")
						TEXT("プロットデータは、半径に±５％のノイズを加えます。\n")
						TEXT("CTRL+中ボタンでゲージ間計測モードになります。"));
	m_tch2.SetChkBoxTipText(0, TEXT("x の波形"));
	m_tch2.SetChkBoxTipText(1, TEXT("y の波形"));
	m_tch2.SetChkBoxTipText(2, TEXT("z の波形"));
	m_vth .SetTipText(TEXT("生成した２つの座標値 (x, y, z) をログ表示します。\n")
						TEXT("\x1B[34m青は上段の波形のデータ値です。\x1B[0m\n")
						TEXT("\x1B[31m赤は下段の波形のデータ値です。\x1B[0m"));

	m_g3d .SetTipText(TEXT("２つの球面プロットデータを３Ｄイメージで表示します。\n")
						TEXT("\x1B[34m青は上段の波形に対応します。\x1B[0m\n")
						TEXT("\x1B[31m赤は下段の波形に対応します。\x1B[0m"));
	m_g3d .SetChkBoxTipText(0, TEXT("ノイズ１％データのプロット"));
	m_g3d .SetChkBoxTipText(1, TEXT("ノイズ５％データのプロット"));

	SAjxTip::Add(GetDlgItem(IDC_CMD_START  )->m_hWnd, TEXT("テストデータの生成とプロット表示を開始します。"));
	SAjxTip::Add(GetDlgItem(IDC_CMD_STOP   )->m_hWnd, TEXT("テストデータの生成とプロット表示を停止します。"));
	SAjxTip::Add(GetDlgItem(IDC_CMD_PAUSE  )->m_hWnd, TEXT("各グラフやログの表示を停止します。\n")
													  TEXT("表示は停止しますが、データは更新を続けます。"));
	SAjxTip::Add(GetDlgItem(IDC_CMD_RESTART)->m_hWnd, TEXT("各グラフやログの表示を再開します。\n")
													  TEXT("蓄積されているデータの末尾から表示します。"));
	//	状況依存ツールチップテキスト設定（現在時刻）
	m_dlg.SetDlgItemStr(IDC_TXT_TIME, TEXT("現在時刻"));
	tipTextTime.Attach(GetDlgItem(IDC_TXT_TIME)->m_hWnd);

	//	テストデータ生成条件を設定
	AJCSPD_PARAM prm1, prm2;
	m_spd1.GetParam(&prm1);							m_spd2.GetParam(&prm2);
	prm1.noise = 1; prm1.xrot = prm1.yrot = 10;		prm2.noise = 5;
	m_spd1.SetParam(&prm1);							m_spd2.SetParam(&prm2);

	//	各コントロール設定値読み出し
	m_dlg.LoadAllControlSettings(TEXT("Settings_*"));

	m_fReady = TRUE;
	ArrengeControls();

	return TRUE;  // フォーカスをコントロールに設定した場合を除き、TRUE を返します。
}

// ダイアログに最小化ボタンを追加する場合、アイコンを描画するための
//	下のコードが必要です。ドキュメント/ビュー モデルを使う MFC アプリケーションの場合、
//	これは、Framework によって自動的に設定されます。

void CS_MFC_02Dlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // 描画のデバイス コンテキスト

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// クライアントの四角形領域内の中央
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// アイコンの描画
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// ユーザーが最小化したウィンドウをドラッグしているときに表示するカーソルを取得するために、
//	システムがこの関数を呼び出します。
HCURSOR CS_MFC_02Dlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



//----- キャンセル ---------------------------------------------------------------------------------------------//
void CS_MFC_02Dlg::OnCancel()
{
	// TODO: ここに特定なコードを追加するか、もしくは基本クラスを呼び出してください。

	//	各コントロール設定値書き込み
	m_dlg.SaveAllControlSettings();

	CDialogEx::OnCancel();
}


//----- タイマ -------------------------------------------------------------------------------------------------//
void CS_MFC_02Dlg::OnTimer(UINT_PTR nIDEvent)
{
	// TODO: ここにメッセージ ハンドラー コードを追加するか、既定の処理を呼び出します。
	double	x1, y1, z1, x2, y2, z2;
	m_vth.TimeStamp();

	m_spd1.Calc		(&x1, &y1, &z1);
	m_tch1.PutData	( x1,  y1,	z1);
	m_g3d.PutPlotData (0,  x1,	y1,  z1);
	m_vth.PrintF(TEXT(" : \x1B[34mA(%5.2f, %5.2f,%5.2f)"), x1, y1, z1);

	m_spd2.Calc		(&x2, &y2, &z2);
	m_tch2.PutData	( x2,  y2,	z2);
	m_g3d.PutPlotData (1,  x2,	y2,  z2);
	m_vth.PrintF(TEXT("\x1B[31m B(%5.2f, %5.2f,%5.2f)\x1B[0m\n"), x2, y2, z2);

//	CDialogEx::OnTimer(nIDEvent);
}
//----- ダイアログサイズ変更中 ---------------------------------------------------------------------------------//
void CS_MFC_02Dlg::OnSizing(UINT fwSide, LPRECT pRect)
{
	CDialogEx::OnSizing(fwSide, pRect);

	// TODO: ここにメッセージ ハンドラー コードを追加します。
	int	cx = pRect->right - pRect->left;
	int	cy = pRect->bottom - pRect->top;

	if (cx < m_szDlg.cx) pRect->right  = pRect->left + m_szDlg.cx;
	if (cy < m_szDlg.cy) pRect->bottom = pRect->top  + m_szDlg.cy;
}
//----- ダイアログサイズ変更 -----------------------------------------------------------------------------------//
void CS_MFC_02Dlg::OnSize(UINT nType, int cx, int cy)
{
	CDialogEx::OnSize(nType, cx, cy);

	// TODO: ここにメッセージ ハンドラー コードを追加します。
	if (m_fReady) {
		ArrengeControls();
	}
}

//----- 開始ボタン ---------------------------------------------------------------------------------------------//
void CS_MFC_02Dlg::OnBnClickedCmdStart()
{
	// TODO: ここにコントロール通知ハンドラー コードを追加します。
	SetTimer(1, m_inp.GetValueInt(), NULL);
	GetDlgItem(IDC_CMD_START  )->EnableWindow(FALSE); 
	GetDlgItem(IDC_CMD_STOP   )->EnableWindow(TRUE ); 
	GetDlgItem(IDC_CMD_PAUSE  )->EnableWindow(TRUE ); 
	GetDlgItem(IDC_CMD_RESTART)->EnableWindow(FALSE);
	fBusy = TRUE;
	m_TickStart = GetTickCount();
}


//----- 停止ボタン ---------------------------------------------------------------------------------------------//
void CS_MFC_02Dlg::OnBnClickedCmdStop()
{
	// TODO: ここにコントロール通知ハンドラー コードを追加します。
	KillTimer(1);
	m_tch1.Pause(FALSE);
	m_tch2.Pause(FALSE);
	m_vth .Pause(FALSE);
	m_g3d .Pause(FALSE);
	GetDlgItem(IDC_CMD_START  )->EnableWindow(TRUE); 
	GetDlgItem(IDC_CMD_STOP   )->EnableWindow(FALSE); 
	GetDlgItem(IDC_CMD_PAUSE  )->EnableWindow(FALSE); 
	GetDlgItem(IDC_CMD_RESTART)->EnableWindow(FALSE);
	fBusy = FALSE;
}


//----- 一時停止ボタン -----------------------------------------------------------------------------------------//
void CS_MFC_02Dlg::OnBnClickedCmdPause()
{
	// TODO: ここにコントロール通知ハンドラー コードを追加します。
	m_tch1.Pause(TRUE);
	m_tch2.Pause(TRUE);
	m_vth .Pause(TRUE);
	m_g3d .Pause(TRUE);
	GetDlgItem(IDC_CMD_START  )->EnableWindow(FALSE); 
	GetDlgItem(IDC_CMD_STOP   )->EnableWindow(TRUE ); 
	GetDlgItem(IDC_CMD_PAUSE  )->EnableWindow(FALSE); 
	GetDlgItem(IDC_CMD_RESTART)->EnableWindow(TRUE );
}


//----- 再開ボタン ---------------------------------------------------------------------------------------------//
void CS_MFC_02Dlg::OnBnClickedCmdRestart()
{
	// TODO: ここにコントロール通知ハンドラー コードを追加します。
	m_tch1.Pause(FALSE);
	m_tch2.Pause(FALSE);
	m_vth .Pause(FALSE);
	m_g3d .Pause(FALSE);
	GetDlgItem(IDC_CMD_START  )->EnableWindow(FALSE); 
	GetDlgItem(IDC_CMD_STOP   )->EnableWindow(TRUE ); 
	GetDlgItem(IDC_CMD_PAUSE  )->EnableWindow(TRUE ); 
	GetDlgItem(IDC_CMD_RESTART)->EnableWindow(FALSE);
}
//----- チェックボックス（各ウインドのタイトルを表示する）------------------------------------------------------------//
void CS_MFC_02Dlg::OnBnClickedChkShowttl()
{
	// TODO: ここにコントロール通知ハンドラー コードを追加します。
//	if (IsDlgButtonChecked(IDC_CHK_SHOWTTL)) {
	if (m_dlg.GetDlgItemChk(IDC_CHK_SHOWTTL)) {
		m_tch1.SetTitleText(TEXT("A: ノイズ１％"));
		m_tch2.SetTitleText(TEXT("B: ノイズ５％"));
		m_vth .SetTitleText(TEXT("ログ表示"));
		m_g3d .SetTitleText(TEXT("２つのデータの３Ｄプロット"));
	}
	else {
		m_tch1.SetTitleText("");
		m_tch2.SetTitleText("");
		m_vth .SetTitleText("");
		m_g3d .SetTitleText("");
	}
}
//----- 各コントロールの配置 -----------------------------------------------------------------------------------//
void CS_MFC_02Dlg::ArrengeControls(void)
{
	POINT		ptB;				//	コントロール表示域のベース位置
	int			dhL;				//	左側表示域の高さ
	int			chL;				//	左側各コントロールの高さ
	SIZE		szCur;				//	ダイアログのサイズ
	RECT		rc;
	int			x, y, cx, cy;

	GetClientRect(&rc);
	szCur.cx = rc.right - rc.left;
	szCur.cy = rc.bottom - rc.top;

	m_tch1.GetWindowRect(&rc);
	::MapWindowPoints(NULL, m_hWnd, (LPPOINT)&rc, 2);
	ptB.x = rc.left;  ptB.y = rc.top;

	cx	= rc.right - rc.left;
	dhL = szCur.cy - ptB.y;
	chL = dhL / 3;
	cy	= chL - 2;

	x  = ptB.x; y = ptB.y;
	m_tch1.SetWindowPos(NULL, x, y, cx, cy, SWP_NOZORDER); y += chL;
	m_tch2.SetWindowPos(NULL, x, y, cx, cy, SWP_NOZORDER); y += chL;
	m_vth .SetWindowPos(NULL, x, y, cx, cy, SWP_NOZORDER);

	m_g3d.GetWindowRect(&rc);
	::MapWindowPoints(NULL, m_hWnd, (LPPOINT)&rc, 2);
	ptB.x = rc.left;  ptB.y = rc.top;
	cx = szCur.cx - ptB.x - 2;	cy = szCur.cy - ptB.y - 2;
	m_g3d.SetWindowPos(NULL, 0, 0, cx, cy, SWP_NOMOVE);
}


