﻿using System;
using System.IO;
using System.Reflection;
using System.Collections.Generic;
using System.Diagnostics;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using CAjrCustCtrl;

namespace Sil_CPrePro
{
	public partial class Form1 : Form
	{
		const string MySect = "MainSect";
		TextBox[]	m_FPath;
		string		m_SvFileName = "";
		bool		m_fBusy 	 = false;
		bool		m_fExit 	 = false;
		int 		m_CurNest	 = 0;

		public Form1()
		{
			InitializeComponent();
		}
		//	フォームのロード（プログラム開始）
		private void Form1_Load(object sender, EventArgs e)
		{
			m_FPath = new TextBox[]  {txtF0, txtF1, txtF2, txtF3, txtF4, txtF5, txtF6, txtF7};
			LoadProfile();
			lblWild.Visible = chkAutoSrh.Checked;
			//	ツールチップ設定
			SAjrTip.Add(txtBase			,	"インクルードファイルのベースフォルダ\n" +
											"「インクルードファイル自動検索」をチェックした場合、" + 
															"このフォルダ下からもインクルードファイルを検索します\n" +
											"フォルダをドロップするか、右の「...」ボタンで設定します");
			SAjrTip.Add(cmdBase			,	"ダイアログにより、ベースパスを設定します");
			SAjrTip.Add(txtSrc 			,	"入力ソースプログラムファイル\n" +
											"ファイルをドロップするか、右の「...」ボタンで設定します");
			SAjrTip.Add(cmdSrc 			,	"ダイアログにより、ソースファイルを設定します");
			SAjrTip.Add(txtOut 			,	"プリコンパイル結果の出力ファイル\n" +
											"ファイルをドロップするか、右の「...」ボタンで設定します");
			SAjrTip.Add(txtOptSym		,	"オプションシンボルを入力します");
			SAjrTip.Add(cmdOptSymSet	,	"オプションシンボルへ、左のテキストを追加します");
			SAjrTip.Add(cmdOptSymPaste	,	"クリップボード・テキストをオプションシンボルへ追加");
			SAjrTip.Add(lbxOptSym		,	"プリコンパイル用オプションシンボル群，Delキーで選択項目削除");
			SAjrTip.Add(cmdIncPathSet	,	"左のテキストをインクルードパスに追加");
			SAjrTip.Add(cmdIncPathPaste	,	"クリップボード・テキストをインクルードパスに追加");
			SAjrTip.Add(lbxIncPath		,	"設定するインクルードパスをドロップしてください，Delキーで選択項目を削除");
		}
		//	フォームのクロージング
		private void Form1_FormClosing(object sender, FormClosingEventArgs e)
		{
			SaveProfile();

			if (m_fBusy) {			//	プリコンパイル実行中？
				ppc.Stop(); 		//		プリコンパイル中止
				m_fExit  = true;	//		プログラム終了する旨、設定
				e.Cancel = true;	//		フォームのクローズ中止
			}
		}
		//	ベースパス設定ボタン
		private void cmdBase_Click(object sender, EventArgs e)
		{
			string s = SAjrGsr.GetFolder("ベースパスの設定", txtBase.Text);
			if (s != "") txtBase.Text = s;
		}
		//	ベースパス(DragEnter)
		private void txtBase_DragEnter(object sender, DragEventArgs e)
		{
			if (e.Data.GetDataPresent(DataFormats.FileDrop)) e.Effect = DragDropEffects.All;
			else											 e.Effect = DragDropEffects.None;
		}
		//	ベースパス(DragDrop)
		private void txtBase_DragDrop(object sender, DragEventArgs e)
		{
			string[] files	= (string[])e.Data.GetData(DataFormats.FileDrop, false );
			string fileName = files[0];
			txtBase.Text	= fileName+"\r\n";
		}
		//	ソースファイル設定ボタン
		private void cmdSrc_Click(object sender, EventArgs e)
		{
			string s = SAjrGsr.GetOpenFile(txtSrc.Text, "ソースファイルの設定", "AllFiles(*.*)/*.*/CLangFiles(*.c)/*.c", "c");
			if (s != "") txtSrc.Text = s;
		}
		//	 ソースファイル(DragEnter)
		private void txtSrc_DragEnter(object sender, DragEventArgs e)
		{
			if (e.Data.GetDataPresent(DataFormats.FileDrop)) e.Effect = DragDropEffects.All;
			else											 e.Effect = DragDropEffects.None;
		}
		//	 ソースファイル(DragDrop)
		private void txtSrc_DragDrop(object sender, DragEventArgs e)
		{
			string[] files	= (string[])e.Data.GetData(DataFormats.FileDrop, false );
			string fileName = files[0];
			txtSrc.Text 	= fileName;
		}
		//	出力ファイル設定ボタン
		private void cmdOut_Click(object sender, EventArgs e)
		{
			string s = SAjrGsr.GetSaveFile(txtOut.Text, "出力ファイルの設定", "AllFiles(*.*)/*.*/TextFiles(*.txt)/*.txt", "txt");
			if (s != "") txtOut.Text = s;
		}
		//	 出力ファイル(DragEnter)
		private void txtOut_DragEnter(object sender, DragEventArgs e)
		{
			if (e.Data.GetDataPresent(DataFormats.FileDrop)) e.Effect = DragDropEffects.All;
			else											 e.Effect = DragDropEffects.None;
		}
		//	 出力ファイル(DragDrop)
		private void txtOut_DragDrop(object sender, DragEventArgs e)
		{
			string[] files	= (string[])e.Data.GetData(DataFormats.FileDrop, false );
			string fileName = files[0];
			txtOut.Text 	= fileName;
		}
		//	オプションシンボル追加ボタン（↓）
		private void cmdOptSymSet_Click(object sender, EventArgs e)
		{
			lbxOptSym.Items.Add(txtOptSym.Text);
		}
		//	オプションシンボル貼り付けボタン
		private void cmdOptSymPaste_Click(object sender, EventArgs e)
		{
			IDataObject ClipboardData = Clipboard.GetDataObject();
			if (ClipboardData.GetDataPresent(DataFormats.Text))
			{
				char[] sep = new char[] {'\r', '\n'};
				string[] txts = ((string)ClipboardData.GetData(DataFormats.Text)).Split(sep, StringSplitOptions.RemoveEmptyEntries);
				for (int i = 0; i < txts.Length; i++) {
					lbxOptSym.Items.Add(txts[i]);
				}
			}
		}
		//	オプションシンボル・リストボックス(KeyDown)
		private void lbxOptSym_KeyDown(object sender, KeyEventArgs e)
		{
			int 	ix;
			if ((ix = lbxOptSym.SelectedIndex) != -1 && e.KeyData == Keys.Delete) {
				lbxOptSym.Items.RemoveAt(ix);
			}
		}
		//	インクルードパス追加ボタン（↓）
		private void cmdIncPathSet_Click(object sender, EventArgs e)
		{
			lbxIncPath.Items.Add(txtIncPath.Text);
		}
		//	インクルードパス貼り付けボタン
		private void cmdIncPathPaste_Click(object sender, EventArgs e)
		{
			IDataObject ClipboardData = Clipboard.GetDataObject();
			if (ClipboardData.GetDataPresent(DataFormats.Text))
			{
				char[] sep = new char[] {'\r', '\n'};
				string[] txts = ((string)ClipboardData.GetData(DataFormats.Text)).Split(sep, StringSplitOptions.RemoveEmptyEntries);
				for (int i = 0; i < txts.Length; i++) {
					lbxIncPath.Items.Add(txts[i]);
				}
			}
		}
		//	インクルードパス・リストボックス（DragEnter）
		private void lbxIncPath_DragEnter(object sender, DragEventArgs e)
		{
			if (e.Data.GetDataPresent(DataFormats.FileDrop)) e.Effect = DragDropEffects.All;
			else											 e.Effect = DragDropEffects.None;
		}
		//	インクルードパス・リストボックス（DragDrop）
		private void lbxIncPath_DragDrop(object sender, DragEventArgs e)
		{
			string[] files = (string[])e.Data.GetData(DataFormats.FileDrop, false );
			for (int i = 0; i < files.Length; i++) {
				lbxIncPath.Items.Add(files[i]);
			}
		}
		//	インクルードパス・リストボックス(KeyDown)
		private void lbxIncPath_KeyDown(object sender, KeyEventArgs e)
		{
			int 	ix;
			if ((ix = lbxIncPath.SelectedIndex) != -1 && e.KeyData == Keys.Delete) {
				lbxIncPath.Items.RemoveAt(ix);
			}
		}
		//	いずれかのイベント発生通知
		private void ppc_OnNtcAnyEvt(object sender, PpcArgNtcAnyEvt e)
		{
			//	キャンセルチェック（システムのイベント処理）
			Application.DoEvents();
		}
		//	プリコンパイル　エラー通知
		private void ppc_OnNtcError(object sender, CAjrCustCtrl.PpcArgNtcError e)
		{
			vthLog.PutText("\r\x1B[2K");
			vthLog.PutText("\x1B[31m");
			vthLog.PutText(ppc.ErrorMessaageText);
			vthLog.PutText("\x1B[0m\n");
		}
		//	プリコンパイル 現在処理中のファイル／行番号通知
		private void ppc_OnNtcFileLno(object sender, CAjrCustCtrl.PpcArgNtcFileLno e)
		{
			//	現在処理中のファイル名とネスト値表示
			if (e.FileName != m_SvFileName) {
				if (e.nest < 8) {
					if (e.nest < m_CurNest) m_FPath[m_CurNest].Text = "";
					m_FPath[e.nest].Text	= e.FileName;
				    m_CurNest = e.nest;
				}
				m_SvFileName = e.FileName;
			}
            lblLno.Text = "L#: " + e.lno.ToString();
		}
		//	インクルードファイル検索開始通知
		private void ppc_OnNtcSrhStart(object sender, PpcArgNtcSrhStart e)
		{
			if (chkIncSrh.Checked) {
			}
		}
		//	インクルードファイル検索フォルダ通知
		private void ppc_OnNtcSrhDir(object sender, PpcArgNtcSrhDir e)
		{
			if (chkIncSrh.Checked) {
				vthLog.PutText("\r\x1B[2K\r");
				vthLog.PutText("Search " + e.IncName + " in " + e.DirPath);
			}
		}
		//	インクルードファイル検索終了通知
		private void ppc_OnNtcSrhEnd(object sender, PpcArgNtcSrhEnd e)
		{
			if (chkIncSrh.Checked) {
				vthLog.PutText(e.fFind ? "  - Find\n" : "  - NotFound\n");
			}
		}
		//	プリコンパイル ファイル出力中通知
		private void ppc_OnNtcOutput(object sender, CAjrCustCtrl.PpcArgNtcOutput e)
		{
		}
		//	プリコンパイル ソースファイルテキストエンコード通知
		private void ppc_OnNtcSrcTec(object sender, CAjrCustCtrl.PpcArgNtcSrcTec e)
		{
			vthLog.PutText("\r\x1B[2K");
			vthLog.PutText("入力ファイルのテキストエンコード：" + e.tec.ToString() + "\n");
		}
		//	プリコンパイル マクロ定義通知
		private void ppc_OnNtcMacDef(object sender, CAjrCustCtrl.PpcArgNtcMacDef e)
		{
			if (!(chkMacDef.Checked && e.MacName.StartsWith("_"))) {
				vthMacDef.PutText(e.MacName.PadRight(20) + " : " + "\"" + e.FilePath + "\" < " + e.lno.ToString() + ">\n");
			}
		}
		//	プリコンパイル マクロ参照通知
		private void ppc_OnNtcMacRef(object sender, CAjrCustCtrl.PpcArgNtcMacRef e)
		{
			if (!(chkMacRef.Checked && e.MacName.StartsWith("_"))) {
				vthMacRef.PutText(e.MacName.PadRight(20) + " : " + "\"" + e.FilePath + "\" < " + e.lno.ToString() + ">\n");
			}
		}
		//	プリコンパイル オプションシンボル参照通知
		private void ppc_OnNtcOptSym(object sender, CAjrCustCtrl.PpcArgNtcOptSym e)
		{
			if (!(chkOptSym.Checked && e.OptSym.StartsWith("_"))) {
				vthOptSym.PutText(e.OptSym.PadRight(20) + " : " + "\"" + e.FilePath + "\" < " + e.lno.ToString() + ">\n");
			}
		}
		//	インクルードファイルを自動検索・チェックボックス
		private void chkAutoSrh_CheckedChanged(object sender, EventArgs e)
		{
			lblWild.Visible = chkAutoSrh.Checked;
		}
		//	実行ボタン
		private void cmdExec_Click(object sender, EventArgs e)
		{
			EPpcResult rsu = EPpcResult.OK;
            DateTime dt;
			//	ログクリアー
			vthLog.Purge();
			vthMacDef.Purge();
			vthMacRef.Purge();
			vthOptSym.Purge();
			//	プリプロセス実行中の旨、設定
			m_fBusy = true;
			//	インクルードネスト値クリアー
			m_CurNest = 0;
			//	全コントロールを禁止状態とする（キャンセルボタンを除く）
			SAjrGsr.EnableAllControls(this, false);
			cmdCancel.Enabled = true;
			//	ログ全体を許可状態とする
			SAjrGsr.EnableGroup(grpLog, true, true);

			//	ベースパス設定
			ppc.SetBasePath(txtBase.Text);
			//	オプションシンボル設定
			string[] sOptSym  = lbxOptSym.Items.Cast<string>().ToArray();
			ppc.SetOptSym(sOptSym);
			//	インクルードパス設定
			string[] sIncPath = lbxIncPath.Items.Cast<string>().ToArray();
			ppc.SetIncPath(sIncPath);
			//	プリコンパイル実行
			ppc.fExpInc =  chkExpInc .Checked;
			ppc.Option = ((chkAutoSrh.Checked ? EPpcOption.AUTOSRH : EPpcOption.NONE) |
						  (chkOnce	 .Checked ? EPpcOption.ONCE    : EPpcOption.NONE) |
						  (chkGenAll .Checked ? EPpcOption.GENALL  : EPpcOption.NONE));
            dt = DateTime.Now;
			vthLog.PutText(dt.ToString("HH:mm:ss") + "プリコンパイル開始\n");
			rsu = ppc.PreCompile(txtSrc.Text, txtOut.Text);
            lblLno .Text = "";
            if (rsu != EPpcResult.OK) vthLog.PutText("\x1B[31m");
			vthLog.PutText("\r\x1B[2K");
            dt = DateTime.Now;
            vthLog.PutText(dt.ToString("HH:mm:ss"));
			switch (rsu) {
				case EPpcResult.OK: 	 vthLog.PutText("プリコンパイル終了\n"	  ); break;
				case EPpcResult.NOFILE:  vthLog.PutText("ソースファイルなし\n"	  ); break;
				case EPpcResult.MEMERR:  vthLog.PutText("メモリエラー\n"		  ); break;
				case EPpcResult.STOP:	 vthLog.PutText("中止しました\n"		  ); break;
				case EPpcResult.NOTOKEN: vthLog.PutText("内容がありません\n"	  ); break;
				case EPpcResult.PARAM:	 vthLog.PutText("パラメタエラー\n"		  ); break;
				case EPpcResult.OUTFILE: vthLog.PutText("出力ファイル生成失敗\n"  ); break;
			}
            if (rsu != EPpcResult.OK) vthLog.PutText("\x1B[0m");
			//	プリコンパイル実行中解除
			m_fBusy = false;
			//	出力ファイルを開く
			if (rsu == EPpcResult.OK && chkOpenOutFile.Checked) {
				try {Process.Start(txtOut.Text);}
				catch (Exception ex) {vthLog.PutText("\x1B31m" + ex.ToString() + "\x1B[0m\n");}
			}
			//	全コントロール禁止状態を解除
			SAjrGsr.EnableAllControls(this, true);
			cmdCancel.Enabled = false;
			//	処理中のファイル名クリアー
			for (int i = 0; i < 8; i++) {
				m_FPath[i].Text = "";
			}
			//	フォームクローズならば、プログラム終了
			if (m_fExit) {
				this.Close();
			}
		}
		//	中止ボタン
		private void cmdCancel_Click(object sender, EventArgs e)
		{
			cmdCancel.Enabled = false;
			ppc.Stop();
		}
		//	ログウインド　ダブルクリック
		private void vthLog_OnNtcDblClk(object sender, VthArgDblClk e)
		{
			string line = vthLog.GetDblCkickedLineText();
			TagJump(line);
		}
		//	オプションシンボル参照ウインド　ダブルクリック
		private void vthOptSym_OnNtcDblClk(object sender, VthArgDblClk e)
		{
			string line = vthOptSym.GetDblCkickedLineText();
			TagJump(line);
		}
		//	マクロ定義ウインド　ダブルクリック
		private void vthMacDef_OnNtcDblClk(object sender, VthArgDblClk e)
		{
			string line = vthMacDef.GetDblCkickedLineText();
			TagJump(line);
		}
		//	マクロ参照ウインド　ダブルクリック
		private void vthMacRef_OnNtcDblClk(object sender, VthArgDblClk e)
		{
			string line = vthMacRef.GetDblCkickedLineText();
			TagJump(line);
		}
		//	タグジャンプ
		private void TagJump(string line)
		{
			int sPath = line.IndexOf('"');
			int ePath = line.IndexOf('"', sPath + 1);
			int sLno  = line.IndexOf('<');
			int eLno  = line.IndexOf('>', sLno	+ 1);
			int lno   = 0;
			if (sPath >= 0 && ePath >= 0 && sLno >= 0 && eLno >= 0) {
				string path = line.Substring(sPath	  , ePath - sPath + 1);
				string lStr = line.Substring(sLno  + 1, eLno  - sLno  - 1);
				int.TryParse(lStr, out lno);
				if (path != "" && lno > 0) {
					ProcessStartInfo pInfo = new ProcessStartInfo();
					pInfo.WorkingDirectory = @"C:\Program Files (x86)\Hidemaru\";
					pInfo.FileName = "Hidemaru.exe";
					pInfo.Arguments = @"/J" + lno.ToString() + " /m4 " + path;
					try {Process.Start(pInfo);}
					catch (Exception e) {vthLog.PutText("\x1B31m" + e.ToString() + "\x1B[0m\n");}
				}
			}
		}
		//	設定値ロード
		void LoadProfile()
		{
			//	デフォルト値設定
			//		・ベースパス（自プログラムフォルダの２つ上）
			txtBase.Text =	SAjrGsr.GetAppPath();
			txtSrc .Text =	@"..\SampleInp.c";
			txtOut .Text =	@"..\SampleOut.txt";
			//		・オプションシンボル
			lbxOptSym.Items.Add("_MSC_VER=1400"				);
			lbxOptSym.Items.Add("_MSC_FULL_VER=140050727"	);
			lbxOptSym.Items.Add("_INTEGRAL_MAX_BITS=64"		);
			lbxOptSym.Items.Add("_WIN32"					);
			lbxOptSym.Items.Add("_MBCS"						);
			lbxOptSym.Items.Add("_CRTBLD"					);
			lbxOptSym.Items.Add("_M_IX86"					);
			lbxOptSym.Items.Add("__STDC__=0"				);
			lbxOptSym.Items.Add("__STDC_WANT_SECURE_LIB__=0");
			//		・インクルードパス・リストボックス
			lbxIncPath.Items.Add(@"C:\Program Files (x86)\Microsoft Visual Studio*.*");
			lbxIncPath.Items.Add(@"C:\Program Files (x86)\Microsoft SDKs\*.*");
			//	設定値ロード
			SAjrReg.LoadAllCtrls(this);

		}
		//	設定値セーブ
		void SaveProfile()
		{
			SAjrReg.SaveAllCtrls(this);
		}
	}
}
