﻿//
//	Sil_CTokenC
//
using System;
using System.IO;
using System.Reflection;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;
using CAjrCustCtrl;

namespace Sil_CTokenC
{
	class Program
	{
		static CAjrTextFile	txfInp = new CAjrTextFile();
		static CAjrCToken	ctk    = new CAjrCToken();
        static string       InpFile;
		static CAjrStatic	sta    = new CAjrStatic();
		static CtkCbkGetS	m_CtkCbkGetS;

		static void Main(string[] args)
		{
			string s;
			int		 lno, svLno = 0;
			ECtkCode tkn, SvTkn = (ECtkCode)0;
			ECtkFlg  flg, SvFlg = (ECtkFlg )0;

			//	コンソールアプリ終了ハンドラ登録
			m_CbkConApExit = new CbkConApExit(SsvConApExit);
			SetConsoleCtrlHandler(m_CbkConApExit, true);

			//	コンソールサイズ設定
			SAjrCon.SetBufSize(128, 100);
			SAjrCon.SetWndRect(0, 0, 127, 60);

			//	コールバックメソッド設定
			m_CtkCbkGetS = new CtkCbkGetS(cbGetS);
			ctk.SetCallBack(m_CtkCbkGetS);
            //  入力ソースのフルパス名設定
			Assembly myAssembly = Assembly.GetEntryAssembly();
            InpFile = Path.GetFullPath(Path.GetDirectoryName(myAssembly.Location) + @"\..\Sample.c");
			//	入力ファイルエンコード設定
			txfInp.TextEncodeAtRead  = ETextEncode.TEC_AUTO;
            //  開始メッセージ
            Console.WriteLine("\nＣ言語ソース(" + InpFile + ")からコメントを削除して表示します。\nEnterキーを押すと開始します。");
            Console.ReadLine();
			do {
				//	ファイルオープン
				try {txfInp.Open(InpFile);}
				catch (Exception e) {Console.WriteLine(e.ToString() + "\n"); break;}
				//	トークン入力ループ
				while (ctk.GetToken(out s)) {
					//	行番号，トークンコード，フラグ情報設定
					lno = ctk.CurLineNumber;
					tkn = ctk.CurToken;
					flg = ctk.CurFlag;
					//	行番号が変わったら改行する
					if (lno != svLno) {
						for (int i = svLno; i < lno; i++) {
							//	改行
							if (i != 0) Console.WriteLine("");
							//	行番号表示
							Console.Write((i+1).ToString().PadLeft(5) + " : ");
						}
						// 行頭合わせ
						int pos = ctk.CurPosition;
						Console.Write("".PadLeft((int)pos));
					}
					//	行番号が同じならば、語句を表示
					else {
						//	語句間空白（連続したシンボル／数値定数 or マクロボディ先頭）
						if (ctk.IsValSym(SvTkn) && ctk.IsValSym(tkn) ||
							((SvFlg & ECtkFlg.MACBODY) == 0 && (flg & ECtkFlg.MACBODY) != 0)) {
							Console.Write(" ");
						}
					}
					//	語句表示
					Console.Write(s);
					//	行番号，トークンコード，フラグ情報退避
					svLno = lno;
					SvTkn = tkn;
					SvFlg = flg;
				}
				//	ファイルクローズ
				txfInp.Close();
			} while(false);

			//	インスタンス消去
			ctk.Delete();

			Console.Write("\n\nHit Enter key -");
			Console.ReadLine();
		}
		//	コールバック（１行入力）
		static private bool cbGetS(IntPtr pBuf, int lBuf, IntPtr cbp)
		{
			bool rc;
			rc = txfInp.GetS(pBuf, lBuf);
			return rc;
		}
		//	コンソールアプリ終了ハンドラ用デリゲート
		[DllImport("Kernel32")]
		static extern bool SetConsoleCtrlHandler(CbkConApExit Handler, bool Add);
		delegate bool	CbkConApExit(EAJCEXITTYPE ExitType);
		static CbkConApExit  m_CbkConApExit;
		//	コンソールアプリ終了ハンドラ
		static bool SsvConApExit(EAJCEXITTYPE ExitType)
		{
			//	インスタンス消去
			ctk.Delete();
			//	false : 次のイベントハンドラへリンクする
			return false;
		}
	}
}
