﻿#pragma warning(disable:4996)
#include	<AjrCstXX.h>
//
//	先頭フォルダ下にある <削除フォルダ>下の全ファイルを削除する>
//
//	DelUnderDir  <先頭フォルダ>   <削除フォルダ名> ・・・
//
//	フォルダ名の末尾が、削除フォルダと等しいフォルダ下の全ファイルを削除します。
//	
//		ex.  DelUnderDir  d:\work  sub1  sub2
//
//			→「d:\work」下のサブフォルダ「sub1」と「sub2」内の全ファイルを削除する
//
BOOL CALLBACK cbFind(UI nest, BCP pPath, BCP pName, UI attrib, UI wtime, UX cbp)
{
	BCP		pDelDir = (BCP)cbp;

	if (!(attrib & _A_SUBDIR)) {
		UI	lCur, lDel;
		BC	CurDir[MAX_PATH];
		BC	DelDir[MAX_PATH];

		//	削除するDIRの末尾文字列と長さ設定
		AjcSnPrintF(DelDir, sizeof DelDir, "\\%s\\", pDelDir);
		lDel = strlen(DelDir);
		//	検索したDIRの文字列と長さ設定
		_splitpath(pPath, NULL, CurDir, NULL, NULL);
		lCur = (UI)strlen(CurDir);

		if (lCur > lDel && stricmp(&CurDir[lCur - lDel], DelDir) == 0) {
			DeleteFile(pPath);
			printf("Delete %s\n", pPath);
		}
	}
	return TRUE;
}



int main(int argc, char *argv[])
{
	int		i;

	if (argc >= 3) {
		for (i = 2; i < argc; i++) {
			AjcSearchFiles(argv[1], "*.*", TRUE, (UX)argv[i], cbFind);
		}
	}

	return 0;
}
