﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using CAjrCustCtrl;

namespace Sil_FileDir
{
	public partial class Form1 : Form
	{

		FopCbkScpNtc m_CbkScpNtc;	FopCbkFcpNtc m_CbkFcpNtc;
		FopCbkScpQry m_CbkScpQry;	FopCbkFcpQry m_CbkFcpQry;
		FopCbkRmvDir m_CbkRmvDir;

		public Form1()
		{
			InitializeComponent();
		}
		//	フォーム開始
		private void Form1_Load(object sender, EventArgs e)
		{
            //  テキストボックスへのファイル／ディレクトリ ドロップ許可
            SAjrGsr.EnableDropToTextBox(this);

			//	設定値ロード
			SAjrReg.LoadAllCtrls(this);
			//	コールバック設定
			m_CbkScpNtc = new FopCbkScpNtc(cbScpNtc );		//	フォルダコピー通知
			m_CbkScpQry = new FopCbkScpQry(cbScpQry );		//	フォルダコピー／名称変更問い合わせ
			m_CbkFcpNtc = new FopCbkFcpNtc(cbFcpNtc );		//	ファイルコピー通知
			m_CbkFcpQry = new FopCbkFcpQry(cbFcpQry );		//	ファイルコピー／名称変更問い合わせ
			m_CbkRmvDir = new FopCbkRmvDir(cbRmvPath);		//	フォルダ／ファイル削除通知
			//	ツールチップ
			SAjrTip.Add(cmdCpy	 , "指定フォルダ下のディレクトリ構造をコピーします。\n" +
								   "「すべてのファイルもコピーする」を選択すると、ファイルもコピーします。");
			SAjrTip.Add(cmdRmv	 , "指定ディレクトリとその下の全フォルダ，ファイルを削除します。");
			SAjrTip.Add(cmdCln	 , "指定フォルダ下の全ディレクトリ，ファイルを削除します。");
			SAjrTip.Add(cmdIsPath, "指定したパスが存在するかチェックします。");
			SAjrTip.Add(cmdIsDir , "指定したパスがディレクトリかチェックします。");
			SAjrTip.Add(cmdIsFile, "指定したパスがファイルかチェックします。");
			SAjrTip.Add(cmdFSize , "指定したファイルのサイズを表示します。");
			SAjrTip.Add(cmdFTime , "指定したファイルの更新日時を表示します。");
			SAjrTip.Add(cmdFCmp  , "指定した２つのファイルを比較します。");

			//	初期表示
			ShowCopy();
		}
		//	フォーム終了
		private void Form1_FormClosed(object sender, FormClosedEventArgs e)
		{
			//	設定値セーブ
			SAjrReg.SaveAllCtrls(this);
		}
		//	コールバック（フォルダ作成可否／フォルダ名変更の問い合わせ）
		private string cbScpQry(string DirFront, string DirNew, IntPtr cbp)
		{
			string s = DirNew;
			int 	len = txtDirOld.Text.Length;
			if (chkDirRen.Checked && len != 0) {
				if (DirNew.Length >= len && DirNew.Substring(0, len) == txtDirOld.Text) {
					s = txtDirNew.Text + DirNew.Substring(len);
				}
			}
			return s;
		}
		//	コールバック（フォルダ構造コピー通知）
		private bool cbScpNtc(string DirFrom, string DirTo, ENtcDirCopy ntc, IntPtr cbp)
		{
            //  コピー結果ログ表示
			vth.PutText("Copy From " + DirFrom + "\n" +
						"     to   " + DirTo + " --- " + ntc.ToString() + "\n");
			if (rbtAllFiles.Checked) {
                //  このフォルダ下のファイルコピー
				SAjrFop.CopyFiles(DirFrom, DirTo, "*.*", ECpyfOpt.CREATEALWAYS, m_CbkFcpNtc, m_CbkFcpQry);
			}
			Application.DoEvents();
			return true;
		}
		//	コールバック（ファイルコピー可否／ファイル名変更の問い合わせ）
		private string cbFcpQry(string FileFrom, string FileTo, string FileName, ref EFileAtt att, IntPtr cbp)
		{
			string s = FileName;
			int 	len = txtFileOld.Text.Length;
			if (chkFileRen.Checked && len != 0) {
				if (FileName.Length >= len && FileName.Substring(0, len) == txtFileOld.Text) {
					s = txtFileNew.Text + FileName.Substring(len);
				}
			}
			return s;
		}
		//	コールバック（ファイルコピー通知）
		private bool cbFcpNtc(string FileFrom, string FileTo, ENtcFileCopy ntc, IntPtr cbp)
		{
			vth.PutText("File Copy " + FileFrom + " To " + FileTo + " --- " + ntc.ToString() + "\n");
			Application.DoEvents();
			return true;
		}
		//	コールバック（フォルダ／ファイル削除通知）
		private bool cbRmvPath(string PathName, uint ntc, IntPtr cbp)
		{
			if ((ntc & 0x01) != 0) vth.PutText("Removed Dir  " + PathName + "\n");
			else	               vth.PutText("Removed File " + PathName + "\n");
			Application.DoEvents();
			return true;
		}
		//	フォルダ構造コピー ボタン
		private void cmdCpy_Click(object sender, EventArgs e)
		{
			bool	rsu;
			vth.PutText("フォルダ構造コピー 開始\n");
			lblCpy.Text = "";
			if (rsu = SAjrFop.CopyFolderStruct(txtCpyFrom.Text, txtCpyTo.Text, m_CbkScpNtc, m_CbkScpQry)) lblCpy.Text = "OK";
			else																						  lblCpy.Text = "Error";
			//	最上位フォルダ下のファイルコピー
			if (rbtAllFiles.Checked && rsu) {
				SAjrFop.CopyFiles(txtCpyFrom.Text, txtCpyTo.Text, "*.*", ECpyfOpt.CREATEALWAYS, m_CbkFcpNtc, m_CbkFcpQry);
			}
			vth.PutText("フォルダ構造コピー 終了\n\n");
		}
		//	フォルダ構造だけをコピー ラジオボタン
		private void rbtStruct_Click(object sender, EventArgs e)	{ShowCopy();}
		//	全てのファイルもコピーする ラジオボタン
		private void rbtAllFiles_Click(object sender, EventArgs e)	{ShowCopy();}
		//	フォルダ名を変更する チェックボックス
		private void chkDirRen_Click(object sender, EventArgs e)	{ShowCopy();}
		//	ファイル名を変更する チェックボックス
		private void chkFilrRen_Click(object sender, EventArgs e)	{ShowCopy();}
		//	フォルダ構造コピー部分の表示設定
		private void ShowCopy()
		{
			lblDirCpy1.Enabled = lblDirCpy2.Enabled = lblDirCpy3.Enabled = txtDirOld.Enabled = txtDirNew.Enabled = chkDirRen.Checked;
			if (rbtAllFiles.Checked) {
				chkFileRen.Enabled = true;
				lblFileCpy1.Enabled = lblFileCpy2.Enabled = lblFileCpy3.Enabled =
									  txtFileOld.Enabled  = txtFileNew.Enabled	= chkFileRen.Checked;
			}
			else {
				chkFileRen.Enabled = false;
				lblFileCpy1.Enabled = lblFileCpy2.Enabled = lblFileCpy3.Enabled = txtFileOld.Enabled = txtFileNew.Enabled = false;
			}
		}
		//	フォルダ削除 ボタン
		private void cmdRmv_Click(object sender, EventArgs e)
		{
			vth.PutText("フォルダ削除 開始\n");
			lblRmv.Text = "";
			if (SAjrFop.RemoveFolder(txtRmv.Text, m_CbkRmvDir)) lblRmv.Text = "OK";
			else												lblRmv.Text = "Error";
			vth.PutText("フォルダ削除 終了\n\n");
		}
		//	フォルダ クリーンアップ ボタン
		private void cmdCln_Click(object sender, EventArgs e)
		{
			vth.PutText("フォルダ クリーンアップ 開始\n");
			lblCln.Text = "";
			if (SAjrFop.CleanFolder(txtCln.Text, m_CbkRmvDir)) lblCln.Text = "OK";
			else											   lblCln.Text = "Error";
			vth.PutText("フォルダ クリーンアップ 終了\n\n");
		}
		//	パスの存在チェック ボタン
		private void cmdIsPath_Click(object sender, EventArgs e)
		{
			if (SAjrFop.IsExistsPath(txtIsPath.Text)) lblIsPath.Text = "Exist";
			else										 lblIsPath.Text = "Not Exist";
		}
		//	フォルダかのチェック ボタン
		private void cmdIsDir_Click(object sender, EventArgs e)
		{
			if (SAjrFop.IsPathDirectory(txtIsDir.Text)) lblIsDir.Text = "Folder";
			else										lblIsDir.Text = "Not Folder";
		}
		//	ファイルかのチェック ボタン
		private void cmdIsFile_Click(object sender, EventArgs e)
		{
			if (SAjrFop.IsPathFile(txIsFile.Text)) lblIsFile.Text = "File";
			else								   lblIsFile.Text = "Not File";
		}
		//	ファイルサイズ取得 ボタン
		private void cmdFSize_Click(object sender, EventArgs e)
		{
			long sz = SAjrFop.GetFileSize(txtFSize.Text);
			if (sz != -1) lblFSize.Text = sz.ToString();
			else		  lblFSize.Text = "Error";
		}
		//	ファイルタイム取得 ボタン
		private void cmdFTime_Click(object sender, EventArgs e)
		{
			uint tm = SAjrFop.GetFileTime1970(txtFTime.Text);
			if (tm != 0xFFFFFFFF) {
				DateTime dt = SAjrGsr.Time1970ToDateAndTime(tm);
				dt = SAjrGsr.UtcTimeToLocalTime(dt);
				lblFTime.Text = dt.ToString();
			}
			else lblFTime.Text = "Error";
		}
		//	ファイル比較ボタン
		private void cmdFCmp_Click(object sender, EventArgs e)
		{
			bool rsu = SAjrFop.FileCompare(txtFCmp1.Text, txtFCmp2.Text);
			if (rsu) lblFCmp.Text = "Match";
			else	 lblFCmp.Text = "Unmatch";
		}
	}
}
