﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using CAjrCustCtrl;

namespace Sil_SerialComPort2
{
	public partial class Form1 : Form
	{
		int m_ByteCount = 0;

		public Form1()
		{
			InitializeComponent();
		}
		//----- 起動時初期設定 -------------------------------------------------//
		private void Form1_Load(object sender, EventArgs e)
		{
			//	ＳＣＰ初期化
			scp.Init();
			//  ウインド位置ロード
			SAjrReg.LoadWndPos(this);
			//	ポート名表示
			ShowPortName(scp.GetPortName());
		}
		//----- 終了時後処理 ---------------------------------------------------//
        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
			//  ウインド位置セーブ
			SAjrReg.SaveWndPos(this);
        }
		//----- ＯＰＥＮボタン -------------------------------------------------//
		private void btnOpen_Click(object sender, EventArgs e)
		{
			if (scp.IsOpened) {
				scp.Close();
			}
			else {
				scp.Open();
			}
		}
		//----- 通信パラメタボタン ---------------------------------------------//
		private void btnParam_Click(object sender, EventArgs e)
		{
			scp.SetParamByDialog(this.Handle);
		}
		//----- ＳＣＰポート状態通知 -------------------------------------------//
		private void scp_OnPortState(object sender, CAjrCustCtrl.ScpArgPortState e)
		{
			ShowPortName(e.name);
			if (e.state == EScpPortState.Opened) {
				lblPortState.Text = "Opened ( " + e.name + " )";
				btnOpen.Text = "Close";
				m_ByteCount = 0;
			}
			else if (e.state == EScpPortState.Closed) {
				lblPortState.Text = "Closed";
				btnOpen.Text = "Open";
			}
			else if (e.state == EScpPortState.OpenFailure) {
				SAjrTip.ShowCenter(this, "\x1B[31m" + "Port(" + e.name + ") Open failure");
			}
			else if (e.state == EScpPortState.MySlotFail) {
				SAjrTip.ShowCenter(this, "\x1B[31m" + "MySlot(" + e.name + ") Creation failure");
			}
		}
		//----- ＳＣＰバイナリデータ受信通知 -----------------------------------//
		private void scp_OnRxChunkBin(object sender, CAjrCustCtrl.ScpArgRxChunkBin e)
		{
			m_ByteCount += e.bin.Length;
			txtBytes.Text = m_ByteCount.ToString();
			scp.SendBinary(e.bin);
		}
		//----- ポート名表示 ---------------------------------------------------//
		private bool ShowPortName(string name)
		{
			bool	rc = false;
			lblPortName.Text = name;
			string pn = scp.GetPortDevName(name);
			if (pn != "") {
				lblDevName.Text  = "(" + pn + ")";
			}
			else {
				lblDevName.Text  = "";
			}
			return rc;
		}
	}
}
