﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Runtime.InteropServices;
using CAjrCustCtrl;

namespace Sil_SerialComPort5A
{
	public partial class Form1 : Form
	{
		//	サブフォーム
		FormCmd m_FormCmd;
		//	通信パケットコマンド
		byte CMD_REQ_START = 0x01;	//	グラフデータ送信開始要求
		byte CMD_RSP_START = 0x11;	//			〃			応答
		byte CMD_REQ_STOP  = 0x02;	//	グラフデータ送信停止要求
		byte CMD_RSP_STOP  = 0x12;	//			〃			応答
		byte CMD_DATA 	   = 0x40;	//	グラフデータ
		//	グラフデータ形式
		[StructLayout(LayoutKind.Sequential, Pack=1)]
		struct CMDDATA {
			public byte		cmd;			//	コマンドコード
			public byte		f1, f2, f3;		//	－
			public AJC3DVEC	vec;			//	グラフデータ
		}

		System.Threading.Mutex m_Mut5A = new System.Threading.Mutex(true, "Sil_SerialComPort5A");
		System.Threading.Mutex m_Mut5B;

		public Form1()
		{
			InitializeComponent();
		}

		private void Form1_Load(object sender, EventArgs e)
		{
			this.Text = this.Text + (IntPtr.Size == 4 ? " (WIN32)" : " (WIN64)");
			//	サイズ変更禁止
			this.FormBorderStyle = FormBorderStyle.FixedSingle;
			//	コマンドフォーム表示
			m_FormCmd = new FormCmd();
			m_FormCmd.StartPosition = FormStartPosition.Manual;
			m_FormCmd.Left = this.Left;
			m_FormCmd.Top  = this.Top + this.Height;
			m_FormCmd.Show();
			//	ＳＣＰ初期化
			scp.Init();
			//	相手プログラム起動
			bool fCreateNew;
			m_Mut5B = new System.Threading.Mutex(false, "Sil_SerialComPort5B", out fCreateNew);
			m_Mut5B.Close();
			if (fCreateNew) {
				System.Diagnostics.Process.Start("Sil_SerialComPort5B.exe");
			}
			m_FormCmd.Focus();
		}
		//----- 終了時後処理 -----------------------------------------------------------------------------------//
		private void Form1_FormClosed(object sender, FormClosedEventArgs e)
		{
		}
		//----- グラフ表示開始ボタン ---------------------------------------------------------------------------//
		private unsafe void btnStart_Click(object sender, EventArgs e)
		{
			fixed (byte* p = &CMD_REQ_START) {
				scp.SendPacket(p, 1);
			}
			m_FormCmd.Focus();
		}
		//----- グラフ表示停止ボタン ---------------------------------------------------------------------------//
		private unsafe void btnStop_Click(object sender, EventArgs e)
		{
			fixed (byte* p = &CMD_REQ_STOP) {
				scp.SendPacket(p, 1);
			}
			m_FormCmd.Focus();
		}
		//----- ポート設定ボタン -------------------------------------------------------------------------------//
		private void btnSetPort_Click(object sender, EventArgs e)
		{
			scp.SetParamByDialog(this.Handle);
			m_FormCmd.Focus();
		}
		//----- ＯＰＥＮ／ＣＬＯＳＥボタン ---------------------------------------------------------------------//
		private void btnOpenClose_Click(object sender, EventArgs e)
		{
			if (scp.IsOpened) scp.Close();
			else			  scp.Open();
			m_FormCmd.Focus();
		}
		//----- SCP : シリアルポート状態通知 -------------------------------------------------------------------//
		private void scp_OnPortState(object sender, ScpArgPortState e)
		{
			if		(e.state == EScpPortState.Opened	 ) btnOpenClose.Text = "CLOSE";
			else if (e.state == EScpPortState.Closed	 ) btnOpenClose.Text = "OPEN";
			else if (e.state == EScpPortState.OpenFailure) {
				SAjrTip.ShowCenter(this, "\x1B[31m'" + scp.GetPortPathName() + "' Open failure.");
			}
			else if (e.state == EScpPortState.MySlotFail) {
				SAjrTip.ShowCenter(this, "\x1B[31m'" + scp.GetMySlotPathName() + "' Creation failure.");
			}
		}
		//----- SCP : パケットデータ受信通知 -------------------------------------------------------------------//
		private unsafe void scp_OnRxPacket(object sender, ScpArgRxPacket e)
		{
			if		(e.bin[0] == CMD_RSP_START) {
			}
			else if (e.bin[0] == CMD_RSP_STOP) {
			}
			else if (e.bin[0] == CMD_DATA) {
				CMDDATA dat = new CMDDATA();
				CMDDATA *p = &dat;
				fixed (byte *q = &e.bin[0]) {
					SAjrBin.MemCopy(p, q, sizeof(CMDDATA));
				}
				tch.PutData(dat.vec.x, dat.vec.y, dat.vec.z);
			}
		}
		//----- SCP : パケット外テキスト受信通知 ---------------------------------------------------------------//
		private void scp_OnRxNoPkt(object sender, ScpArgRxNoPkt e)
		{
			m_FormCmd.ShowText(e.text);
		}
		//----- １文字送信 -------------------------------------------------------------------------------------//
		public void SendChar(char c)
		{
			scp.SendChar(c);
		}
	}
}
