﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;
using CAjrCustCtrl;

namespace Sil_SockClient2C
{
	class Program
	{
		static CAjrSockClient sct = new CAjrSockClient();
		static string		  ServName = "MIZUIRO";
		static uint 		  bytes    = 0;

		static void Main(string[] args)
		{
			ESctEvt evt;			//	イベントマスク
			object	obj;			//	イベントデータ

			//	コンソールキーオブジェクト生成
			ConsoleKeyInfo c   = new ConsoleKeyInfo();

			//	コンソールアプリ終了ハンドラ登録
			m_CbkConApExit = new CbkConApExit(SsvConApExit);
			SetConsoleCtrlHandler(m_CbkConApExit, true);

			//	初期表示
			Console.Clear();
			Console.WriteLine("");
			Console.WriteLine(" エコークライアント (" + (IntPtr.Size == 4 ? "WIN32" : "WIN64") + ")");
			Console.WriteLine("");
			Console.WriteLine("   サーバ名　：" + ServName);
			Console.WriteLine("   ポート番号：14238");
			Console.WriteLine("");
			Console.WriteLine(" ＥＳＣキーを押すと、プログラムを終了します。");
			Console.WriteLine("");
			//	実行モード設定（イベントを「WaitEvent」で待つ）
			sct._SctMode = ESctMode.WaitingForEvent;
			//	対象とするイベントを設定
			sct.SetEvtMask(ESctEvt.EV_CONNECT | ESctEvt.EV_DISCONNECT | ESctEvt.EV_CNFAIL | ESctEvt.EV_RXCHUNK);
			//	接続
			sct.Connect(ServName, 14238);
			//	ループ
			while (true) {
				//	ＥＳＣキー入力で回線切断
				if (c.Key == ConsoleKey.Escape) {
					sct.Disconnect();
				}
				//	イベント待ち
				obj = null;
				if ((evt = sct.WaitEvent(out obj, 1000)) != ESctEvt.EV_NOEVENT) {
					//	各イベント処理
					//	●接続通知
					if ((evt & ESctEvt.EV_CONNECT) != 0) {
						Console.WriteLine(" 回線を接続しました。\n");
					}
					//	●切断通知
					if ((evt & ESctEvt.EV_DISCONNECT) != 0) {
						break;
					}
					//	●接続失敗通知
					if ((evt & ESctEvt.EV_CNFAIL) != 0) {
						Console.Write(" 接続を失敗しました。 ENTERキーを押してください。");
						Console.ReadLine();
						break;
					}
					//	●バイナリチャンク受信通知
					if ((evt & ESctEvt.EV_RXCHUNK) != 0) {
						Byte[] rxd = (Byte[])obj;
						//	受信バイト数を表示
						bytes += (uint)rxd.Length;
						Console.Write("    " + bytes.ToString() + "\r");
						//	受信データを返信
						sct.SendBinary((byte[])obj);
					}
				}
				//	キー入力
				if (Console.KeyAvailable) c = Console.ReadKey(true);
			}
			//	ソケットクライアント消去
			sct.Delete();
	   }
		//	コンソールアプリ終了ハンドラ用デリゲート
		[DllImport("Kernel32")]
		static extern bool SetConsoleCtrlHandler(CbkConApExit Handler, bool Add);
		delegate bool	CbkConApExit(EAJCEXITTYPE ExitType);
		static CbkConApExit  m_CbkConApExit;
		//	コンソールアプリ終了ハンドラ
		static bool SsvConApExit(EAJCEXITTYPE ExitType)
		{
			//	ソケットクライアント消去
			sct.Delete();
			//	false : 次のイベントハンドラへリンクする
			return false;
		}
	}
}
