﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using CAjrCustCtrl;

namespace Sil_VT100
{
	public partial class Form1 : Form
	{
		int  count = 0;
		public Form1()
		{
			InitializeComponent();
		}
		//----- フォーム初期化 -------------------------------------------------------------//
		private void Form1_Load(object sender, EventArgs e)
		{
			//	スタイル設定チェックボックス初期化
			chkEnableLogFile.Checked	= vth.EnableLogFile;
			chkFixedPitch.Checked		= vth.FixedPitch;
			chkFast.Checked				= vth.Fast;
			chkFixedFont.Checked		= vth.FixedFont;
			chkFixedLF.Checked			= vth.FixedLF;
			chkShowVScroll.Checked		= vth.ShowVScroll;
			chkShowHScroll.Checked		= vth.ShowHScroll;
			chkEnableAutoScroll.Checked	= vth.EnableAutoScroll;
			chkShowBorder.Checked		= vth.ShowBorder;
			chkEnableScrollOut.Checked	= vth.EnableScrollOut;
			chkLineFeedByCR.Checked		= vth.LineFeedByCR;
			chkLineFeedByLF.Checked		= vth.LineFeedByLF;
			chkSeparate.Checked			= vth.Separate;
			//	 設定値ロード
			SAjrReg.LoadAllCtrls(this);
			//	ウインド位置とサイズロード
			SAjrReg.LoadWndRect(this);
			//	初期メッセージ表示
			vth.PutText("\x1B[35;46m");
			vth.PutText("      【 ＶＴ－１００エミュレーション ウインド 】                                        \n");
			vth.PutText("\x1B[0m");
			vth.PutText("                                                                                         \n");
			vth.PutText("\x1B[34;47m");
			vth.PutText("    ・右クリックでポップアップメニューを表示します                                       \n");
			vth.PutText("    ・↑↓←→キーでカーソルを移動します                                                 \n");
			vth.PutText("    ・任意の文字キーを押すとその文字を描画します                                         \n");
			vth.PutText("    ・テキストファイルをドロップすると、そのファイル名に続いてファイルの内容を描画します \n");
			vth.PutText("    ・フォルダをドロップすると、そのフォルダ名を表示します                               \n");
			vth.PutText("    ・ダブルクリックで、仮想ＶＲＡＭに合わせてウインドサイズを調整します                 \n");
			vth.PutText("    ・仮想ＶＲＡＭは、２５行×１２０桁に設定されています                                 \n");
			vth.PutText("                                                                                         \n");
			vth.PutText("\x1B[0m\r\n");
		}
		//----- フォーム終了 ---------------------------------------------------------------//
		private void Form1_FormClosed(object sender, FormClosedEventArgs e)
		{
			//	設定値セーブ
			SAjrReg.SaveAllCtrls(this);
			//	ウインド位置とサイズセーブ
			SAjrReg.SaveWndRect(this);
		}
		//----- VT100 キー入力 -------------------------------------------------------------//
		private void vth_OnNtcKeyIn(object sender, VthArgNtcKeyIn e)
		{
			vth.PutChar(e.key);
		}
		//----- VT100 拡張キー押下 ---------------------------------------------------------//
		private void vth_OnNtcVKeyIn(object sender, VthArgNtcVKeyIn e)
		{
			if (e.rep == 0) { // キー押し続けによる繰り返し以外？
				if (e.vkey != Keys.F3) { //  F3(検索キー)は除外する
					Point pt = SAjrGsr.GetWindowPos(vth);
					SAjrTip.Show(pt.X + 2, pt.Y + 2, "\x1B[34m キーが押されました（ " + e.vkey.ToString() + " ）", 1000);
				}
			}
		}
		//----- VT100 キー離し通知 ---------------------------------------------------------//
		private void vth_OnNtcVKeyOut(object sender, VthArgNtcVKeyOut e)
		{
			if (e.vkey != Keys.F3) { //  F3(検索キー)は除外する
				Point pt = SAjrGsr.GetWindowPos(vth);
				SAjrTip.Show(pt.X + 2, pt.Y + 2, "\x1B[35m キーが離されました（ " + e.vkey.ToString() + " ）", 1000);
			}
		}
		//----- VT100 ファイルドロップ -----------------------------------------------------//
		private void vth_OnFileDrop(object sender, VthArgFileDrop e)
		{
			for (int i = 0; i < e.n; i++) {
				string path = vth.GetDroppedFile();
				vth.PutText("\n[[[ FILE = " + path + " ]]]\n\n");
				try {
					txf.Open(path, ETextEncode.TEC_AUTO);
				}
				catch (Exception exc) {
					vth.PutText(exc.ToString() + "\n");
					break;
				}
				string txt;
				while ((txt = txf.GetS()) != null) {
					vth.PutText(txt);
				}
				txf.Close();
			}	
		}
		//----- VT100 ディレクトリドロップ -------------------------------------------------//
		private void vth_OnDirDrop(object sender, VthArgDirDrop e)
		{
			string txt = "ディレクトリがドロップされました\n";
			for (int i = 0; i < e.n; i++) {
				txt += ("  " + vth.GetDroppedDir() + "\n");
			}
			SAjrTip.ShowCenter(vth, txt);
		}
		//----- VT100 右クリック -----------------------------------------------------------//
		private void vth_OnRClick(object sender, VthArgRClick e)
		{
			SAjrTip.ShowCenter(vth, "\n 右クリックしました（x=" + e.x.ToString() + ", y=" + e.y.ToString() + "）\n");
		}
		//----- VT100 ダブルクリック -------------------------------------------------------//
		private void vth_OnNtcDblClk(object sender, VthArgDblClk e)
		{
			SAjrTip.ShowCenter(vth, "\n ダブルクリックしました\n"); 
		}
		//----- タイマ ---------------------------------------------------------------------//
		private void tim_Tick(object sender, EventArgs e)
		{
			count++;
			//	カーソル移動
			if (chkFixedPos.Checked) {
				int line = int.Parse(txtLine.Text);
				int col  = int.Parse(txtCol.Text);
				vth.Locate(line, col);
			}
			//	タイムスタンプログ表示
			DateTime dt = DateTime.Now;
			vth.PutText(string.Format("{0,4} : {1:D2}:{2:D2}:{3:D2}.{4:D3}", count,
											 dt.Hour, dt.Minute, dt.Second, dt.Millisecond));
			//	改行，行クリアー
			if (!chkFixedPos.Checked) {
				vth.PutText("\n\x1B[K");
			}
		}
		//----- テキスト描画ボタン ---------------------------------------------------------//
		private void btnPutText_Click(object sender, EventArgs e)
		{
			vth.PutText(txtPutText.Text + "\n");
		}
		//----- 「タイムスタンプ ログ開始／停止」ボタン ------------------------------------//
		private void btnLog_Click(object sender, EventArgs e)
		{
			if (tim.Enabled) {
				tim.Enabled = false;
				btnLog.Text = "タイムスタンプ ログ開始";
			}
			else {
				tim.Enabled = true;
				btnLog.Text = "タイムスタンプ ログ停止";
			}
		}
		//----- 「文字色」入力 -------------------------------------------------------------//
		private void InpTextColor_OnNtcIntValue(object sender, IvArgNtcIntValue e)
		{
			vth.ForegroundColor = e.value;
			InpTextColor.BorderColor = vth.GetPaletteColor(e.value);
		}
		//----- 「背景色」入力 -------------------------------------------------------------//
		private void inpBkColor_OnNtcIntValue(object sender, IvArgNtcIntValue e)
		{
			vth.BackgroundColor = e.value;
			inpBkColor.BorderColor = vth.GetPaletteColor(e.value);
		}
		//----- 「ウインド背景色」入力 -----------------------------------------------------//
		private void inpWndBkColor_OnNtcIntValue(object sender, IvArgNtcIntValue e)
		{
			vth.WndBkColor = e.value;
			inpWndBkColor.BorderColor = vth.GetPaletteColor(e.value);
		}
		//----- 「Enable」ボタン -----------------------------------------------------------//
		private void btnEnable_Click(object sender, EventArgs e)
		{
			vth.Enabled = true;
		}
		//----- 「Disable」ボタン ----------------------------------------------------------//
		private void btnDisable_Click(object sender, EventArgs e)
		{
			vth.Enabled = false;
		}
		//----- スタイル設定チェックボックス -----------------------------------------------//
		private void chkEnableLogFile_CheckedChanged	(object sender, EventArgs e) {vth.EnableLogFile    = chkEnableLogFile.Checked;}
		private void chkFixedPitch_CheckedChanged		(object sender, EventArgs e) {vth.FixedPitch	   = chkFixedPitch.Checked;}
		private void chkFast_CheckedChanged				(object sender, EventArgs e) {vth.Fast			   = chkFast.Checked;}
		private void chkFixedFont_CheckedChanged		(object sender, EventArgs e) {vth.FixedFont 	   = chkFixedFont.Checked;}
		private void chkFixedLF_CheckedChanged			(object sender, EventArgs e) {vth.FixedLF		   = chkFixedLF.Checked;}
		private void chkShowVScroll_CheckedChanged		(object sender, EventArgs e) {vth.ShowVScroll	   = chkShowVScroll.Checked;}
		private void chkShowHScroll_CheckedChanged		(object sender, EventArgs e) {vth.ShowHScroll	   = chkShowHScroll.Checked;}
		private void chkEnableAutoScroll_CheckedChanged	(object sender, EventArgs e) {vth.EnableAutoScroll = chkEnableAutoScroll.Checked;}
		private void chkShowBorder_CheckedChanged		(object sender, EventArgs e) {vth.ShowBorder	   = chkShowBorder.Checked;}
		private void chkEnableScrollOut_CheckedChanged	(object sender, EventArgs e) {vth.EnableScrollOut  = chkEnableScrollOut.Checked;}
		private void chkLineFeedByCR_CheckedChanged		(object sender, EventArgs e) {vth.LineFeedByCR	   = chkLineFeedByCR.Checked;}
		private void chkLineFeedByLF_CheckedChanged		(object sender, EventArgs e) {vth.LineFeedByLF	   = chkLineFeedByLF.Checked;}
		private void chkSeparate_CheckedChanged			(object sender, EventArgs e) {vth.Separate		   = chkSeparate.Checked;}


	}
}
