﻿//
//	SP_AVL.cpp
//
#include	<AjxCpp.h>
#include	<tchar.h>
using namespace AjxControl;

//	ノードデータ形式
typedef struct {
	UTP 	pTimStr;			//	ヒープ上の時刻文字列へのポインタ
} NODEDATA, *PNODEDATA;

//----- CAjxAvl, CAjxCon の派生クラス --------------------------------------------------------------------------//
class CAjxAvlEx : public CAjxAvl, public CAjxCon
{
private:
	NODEDATA	m_Node;
public:
	//	コンストラクタ（初期ノード登録）
	CAjxAvlEx()
	{
		_tcscpy_s((m_Node.pTimStr = AjcTAlloc(16)), 16, TEXT("Pre-Inited  50")); InsNode( 50, &m_Node, sizeof m_Node);
		_tcscpy_s((m_Node.pTimStr = AjcTAlloc(16)), 16, TEXT("Pre-Inited  60")); InsNode( 60, &m_Node, sizeof m_Node);
		_tcscpy_s((m_Node.pTimStr = AjcTAlloc(16)), 16, TEXT("Pre-Inited  70")); InsNode( 70, &m_Node, sizeof m_Node);
		_tcscpy_s((m_Node.pTimStr = AjcTAlloc(16)), 16, TEXT("Pre-Inited  80")); InsNode( 80, &m_Node, sizeof m_Node);
		_tcscpy_s((m_Node.pTimStr = AjcTAlloc(16)), 16, TEXT("Pre-Inited  90")); InsNode( 90, &m_Node, sizeof m_Node);
		_tcscpy_s((m_Node.pTimStr = AjcTAlloc(16)), 16, TEXT("Pre-Inited 100")); InsNode(100, &m_Node, sizeof m_Node);
	}
	//	デストラクタ
	~CAjxAvlEx()
	{
		//	デストラクト中に OnNtcRemove() を発生させるには DelAllNodes() メソッドを実行します
		DelAllNodes();
	}
	//	ノード削除通知
	VO OnNtcRemove (UX key, VOP pNodeData, UI len, UI nest) override
	{
		SAjxCon::PrintF(TEXT("ノードが削除されました - key=%4u, len=%d, nest=%d, data='%s'\n"), (UI)key, len, nest, ((PNODEDATA)pNodeData)->pTimStr);
		AjcTFree(((PNODEDATA)pNodeData)->pTimStr);
	}

	//	ノード列挙通知
	BOOL OnNtcNode	(UX key, VOP pNodeData, UI len, UI nest) override
	{
		PAJCAVLNODE pNode = ((PAJCAVLNODE)pNodeData) - 1;
		SAjxCon::PrintF(TEXT("%-26s:%*u, %d\n"), ((PNODEDATA)pNodeData)->pTimStr, nest * 6, (UI)key, pNode->bal);
		return TRUE;
	}
	//	入力テキスト通知(ASCII)
	VO		OnNtcStr(int argc, UT *argv[], C_UTP pTxt) override
	{
		//	入力テキスト表示
		SAjxCon::PrintF(TEXT("%s\n"), pTxt);
		//	コマンド実行
		if (argc >= 1) {
			//	ノード挿入
			if		(_tcsicmp(argv[0], TEXT("I")) == 0) {
				if (argc == 2) {
					if (!InsNode(_ttoi(argv[1]), &(m_Node.pTimStr = GetTimeStr()), sizeof m_Node)) {
						if (m_Node.pTimStr != NULL) AjcTFree(m_Node.pTimStr); m_Node.pTimStr = NULL;
						SAjxCon::PrintF(TEXT("ノードの挿入を失敗しました。\n"));
					}
				}
				else SAjxCon::PrintF(TEXT("*** Invalid parameter.\n"));
			}
			//	ノード置換
			else if (_tcsicmp(argv[0], TEXT("R")) == 0) {
				if (argc == 2) {
					if (!RepNode(_ttoi(argv[1]), &(m_Node.pTimStr = GetTimeStr()), sizeof m_Node)) {
						if (m_Node.pTimStr != NULL) AjcTFree(m_Node.pTimStr); m_Node.pTimStr = NULL;
						SAjxCon::PrintF(TEXT("ノードの置換を失敗しました。\n"));
					}
				}
				else SAjxCon::PrintF(TEXT("*** Invalid parameter.\n"));
			}
			//	ノードの挿入／置換
			else if (_tcsicmp(argv[0], TEXT("X")) == 0) {
				if (argc == 2) {
					if (!InsOrRepNode(_ttoi(argv[1]), &(m_Node.pTimStr = GetTimeStr()), sizeof m_Node)) {
						if (m_Node.pTimStr != NULL) AjcTFree(m_Node.pTimStr); m_Node.pTimStr = NULL;
						SAjxCon::PrintF(TEXT("ノードの挿入／置換を失敗しました。\n"));
					}
				}
				else SAjxCon::PrintF(TEXT("*** Invalid parameter.\n"));
			}
			//	ノード削除
			else if (_tcsicmp(argv[0], TEXT("D"))  == 0) {
				if (argc == 2) {
					if (!DelNode(_ttoi(argv[1]))) {
						SAjxCon::PrintF(TEXT("ノードの削除を失敗しました。\n"));
					}
				}
				else SAjxCon::PrintF(TEXT("*** Invalid parameter.\n"));
			}
			//	全ノード破棄
			else if (_tcsicmp(argv[0], TEXT("A"))  == 0) {
				if (!DelAllNodes()) {
					SAjxCon::PrintF(TEXT("全ノードの削除を失敗しました。\n"));
				}
			}
			//	全ノード表示
			else if (_tcsicmp(argv[0], TEXT("P"))  == 0) {
				EnumNodes(TRUE);
			}
			//	その他
			else {
				SAjxCon::PrintF(TEXT("*** Invalid command.\n"));
			}
		}
	}

private:
	//	現在時刻文字列生成（現在時刻文字列を格納した、動的メモリへのポインタを返す）
	UTP		GetTimeStr()
	{
		UTP			rc;
		SYSTEMTIME	st;
		UI			len;
		UT			szTim[64];

		GetLocalTime(&st);
		AjcSnPrintF(szTim, AJCTSIZE(szTim), TEXT("%02d:%02d:%02d.%03d"), st.wHour, st.wMinute, st.wSecond, st.wMilliseconds);
		len = (UI)_tcslen(szTim) + 1;
		MAjcStrCpy(rc = AjcTAlloc(len), len, szTim);
		return rc;
	}
};

//----- m a i n ------------------------------------------------------------------------------------------------//
int AjcMain()
{
	CAjxAvlEx avl;

	SAjxCon::SetStdMode();

	//	コマンドメニュー
	SAjxCon::PrintF(TEXT("\n 以下のコマンドを入力してください。\n\n"));
	SAjxCon::PrintF(TEXT("  I   nnn     : ノード挿入, key=nnn\n"));
	SAjxCon::PrintF(TEXT("  R   nnn     : ノード置換, key=nnn\n"));
	SAjxCon::PrintF(TEXT("  X   nnn     : ノードの挿入／置換, key=nnn\n"));
	SAjxCon::PrintF(TEXT("  D   nnn     : ノード削除, key=nnn\n"));
	SAjxCon::PrintF(TEXT("  A           : 全ノードを破棄\n"));
	SAjxCon::PrintF(TEXT("  P           : 全ノード表示"));
	SAjxCon::PrintF(TEXT("  <ESC>キー   : 終了\n"));
	SAjxCon::PrintF(TEXT("\n"));

	//	初期ノード表示
	avl.EnumNodes(TRUE);
	//	コマンドを入力しメニュー処理実行
	SAjxCon::PrintF(TEXT("Input(%3u) - "), avl.GetCount());
	while (avl.Input(TEXT(""))) {
		SAjxCon::PrintF(TEXT("Input(%3u) - "), avl.GetCount());
	}
	return 0;
}
