﻿//
//	SP_LZH.cpp
//
#include	<AjxCpp.h>
#include	<tchar.h>
#include	<direct.h>
using namespace AjxControl;

//----- CAjxLzhの派生クラス ------------------------------------------------------------------------------------//
class CAjxLzhEx : public CAjxLzh
{
public:
	FILE*	m_hFileLzh;
	//	コンストラクタ
	CAjxLzhEx()
	{
		m_hFileLzh = NULL;
	}
	//	LZHファイルオープン
	errno_t OpenLzhFile(UTP pPath)
	{
		return _tfopen_s(&m_hFileLzh, pPath, TEXT("rb"));
	}
	//	LZHファイルクローズ
	VO		CloseLzhFile()
	{
		if (m_hFileLzh != NULL) {
			fclose(m_hFileLzh);
			m_hFileLzh = NULL;
		}
	}
	//	ファイル読み出し要求
	UI		OnRead		(VOP pBuf, UI lBuf) override
	{
		return (UI)fread(pBuf, 1, lBuf, m_hFileLzh);
	}
	//	ファイル読み出し位置設定要求
	VO		OnSeek		(UL  ofs)	override
	{
		fseek(m_hFileLzh, ofs, SEEK_SET);
	}
};

CAjxLzhEx	lzh;

//----- m a i n ------------------------------------------------------------------------------------------------//
int AjcMain(int argc, UTP argv[])
{
	UW			crc;						//	ＣＲＣ算出ワーク
	AJCLZHERR	err;						//	ＬＺＨデコード エラーコード
	HAJCLZH 	hLzhSearch = NULL;			//	ＬＺＨハンドル（検索用）
	HAJCLZH 	hLzhRead   = NULL;			//	ＬＺＨハンドル（読出用）
	FILE		*hFileLzh  = NULL;			//	ＬＺＨ書庫ファイル・ハンドル
	FILE		*hFileOut  = NULL;			//	出力ファイルハンドル
	UT			szPath	  [MAX_PATH];		//	パス編集ワーク
	UT			szTopDir  [MAX_PATH];		//	先頭フォルダパス
	BOOL		fIgnoreDir = TRUE;			//	ディレクトリ無視フラグ
	AJCLZHFILEINFO	FInfo;					//	ファイル情報
	UT			drv[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], fext[_MAX_EXT];
	UI			rbytes; 					//	読み出したバイト数
	UB			buf[1024];					//	読み出しバッファ

	SAjxCon::SetStdMode();

	//	ＬＺＨ書庫(.lzh)ファイルオープン
	if (argc >= 2 && lzh.OpenLzhFile(argv[1]) == 0) {
		//	トップフォルダ名設定
		MAjcSplitPath(argv[1] , drv, dir, fname, fext);
		MAjcMakePath (szTopDir, drv, dir, NULL , NULL);
		//	書庫内のファイル検索初期化
		if ((hLzhSearch = lzh.FindFirst(TEXT("*.*"))) != NULL) {
			//	書庫内の全ファイルループ
			do {
				//----- ファイル情報取得 ---------------------------------------------------------------------------//
				lzh.GetFileInfo(hLzhSearch, &FInfo);
				//----- フォルダ作成 -------------------------------------------------------------------------------//
				if (FInfo.szDirName[0] != 0) {
					UTP 	p;
					UT		tmp [MAX_PATH];
					MAjcStrCpy(szPath, AJCTSIZE(szPath), szTopDir);
					MAjcStrCpy(tmp, AJCTSIZE(tmp), FInfo.szDirName);
					if (p = MAjcStrTok(tmp, TEXT("\\"))) {
						do {
							AjcPathCat(szPath, p, MAX_PATH);
							 _tmkdir(szPath);
						} while (p = MAjcStrTok(NULL, TEXT("\\")));
					}
				}
				//----- ファイル出力 -------------------------------------------------------------------------------//
				if (hLzhRead = lzh.Open(FInfo.szPathName, 0)) {
					SAjxCon::PrintF(TEXT("Extracting %s - "), FInfo.szFileName);
					MAjcStrCpy(szPath, MAX_PATH, szTopDir);
					AjcPathCat(szPath, FInfo.szPathName, MAX_PATH);
					if (_tfopen_s(&hFileOut, szPath, TEXT("wb")) == 0) {
						//	ファイル出力とＣＲＣ算出
						crc = 0;
						while (rbytes = lzh.Read(hLzhRead, buf, sizeof buf)) {
							crc = AjcPartCrc16R(buf, rbytes, crc);
							fwrite(buf, 1, rbytes, hFileOut);
						}
						//	ＣＲＣチェック
						if ((err = lzh.GetLastError()) == AJCLZHERR_OK) {
							if (crc == hLzhRead->crc) SAjxCon::PrintF(TEXT("OK\n"));
							else					  SAjxCon::PrintF(TEXT("NG (CRC error)\n"));
						}
						else {
							SAjxCon::PrintF(TEXT("NG (err = 0x%04X)\n"), err);
						}
						//	出力ファイル・クローズ
						fclose(hFileOut);
					}
					else {
						SAjxCon::PrintF(TEXT("NG (Creation failure)\n"));
					}
					// ＬＺＨ読み出しハンドル・クローズ
					lzh.Close(hLzhRead);
				}
				else {
					SAjxCon::PrintF(TEXT("File not found (%s)\n"), FInfo.szPathName);
				}
			} while(lzh.FindNext(hLzhSearch));
			// ＬＺＨ検索ハンドル・クローズ
			lzh.Close(hLzhSearch);
		}
		else {
			SAjxCon::PrintF(TEXT("ＬＺＨ書庫内にファイルが見つかりません\n"));
		}
		//	ＬＺＨ書庫(.lzh)ファイル クローズ
		lzh.CloseLzhFile();
	}
	else {
		SAjxCon::PrintF(TEXT("ＬＺＨ書庫ファイルのオープン失敗\n"));
	}

	SAjxCon::PrintF(TEXT("Hit Enter Key!!"));
	getchar();
	return 0;
}
