﻿//
//	SP_MBX.cpp
//
#include	<AjxCpp.h>
#include	<tchar.h>
#include	<process.h>

using namespace AjxControl;

static const UTP pTxt[] = {TEXT("北海道"), TEXT("宮城県"), TEXT("東京都"), TEXT("大阪府"), TEXT("鹿児島県")};
static	BOOL	fThreadBusy = FALSE;
static	CRITICAL_SECTION	cs;

//	ノードデータ
typedef struct {
	UT		str[32];
} NODE, *PNODE;

//	CAjxMbxの派生クラス
class CAjxMbxEx : public CAjxMbx
{
	//	ノード消去通知
	VO OnNtcRemove	(VOP pNodeData) override
	{	PNODE pNode = (PNODE)pNodeData;
		SAjxCon::PrintF(TEXT(" Removed %s\n"), pNode->str);
	}
};

//----- メールデータ表示 ---------------------------------------------------------------------------------------//
VO		PrintData(PNODE pNode, C_UTP pAct, C_UTP pName)
{
	EnterCriticalSection(&cs);
	SAjxCon::PrintF(TEXT(" %s %s by %s.\n"), pAct, pNode->str, pName);
	LeaveCriticalSection(&cs);
}

//----- サブスレッド -------------------------------------------------------------------------------------------//
VO		SubThread(VOP vop)
{
	CAjxMbx* p = (CAjxMbx*)vop;
	NODE	node;

	for (;;) {
		//	メインスレッドからの通知データを表示
		if (p->Deque(&node)) {
			PrintData(&node, TEXT("Deque"), TEXT("Sub-thread\n"));
			//	データが "東京都" ならば、スレッド終了
			if (_tcscmp(node.str, TEXT("東京都")) == 0) {
				break;
			}
		}
	}
	//	サブスレッド終了
	fThreadBusy = FALSE;
	_endthread();
}


//----- m a i n ------------------------------------------------------------------------------------------------//
int AjcMain()
{
	CAjxMbxEx	mbx;

	SAjxCon::SetStdMode();

	InitializeCriticalSection(&cs);

	//	サブスレッド生成
	fThreadBusy = TRUE;
	_beginthread(SubThread, 0, (VOP)&mbx);
	//	ノードのデフォルトサイズ設定
	mbx.SetDefSize(sizeof(NODE));
	//	ノード挿入
	for (int i = 0; i < 5; i++) {
		NODE		node;
		_tcscpy_s(node.str, 32, pTxt[i]);
		mbx.Enque(&node);
		PrintData(&node, TEXT("Enque"), TEXT("Main"));
		Sleep(100);
	}
	SAjxCon::PrintF(TEXT("\n"));
	//	サブスレッドの終了待ち
	while (fThreadBusy) Sleep(1);
	//	残ノード消去
	mbx.Purge();

	DeleteCriticalSection(&cs);

	SAjxCon::PrintF(TEXT("\nHit Enter Key"));
	getchar();
	return 0;
}
