﻿//
//	SP_PRN.cpp
//
#include	<AjxCpp.h>
#include	<tchar.h>
#include	"..\src\resource.h"
using namespace AjxControl;

static	HINSTANCE		hInst	 = NULL;
static	HWND			hWndMain = NULL;
static	HMENU			hMenu	 = NULL;
static	HBITMAP			hPrn	 = NULL;
static	AJC_IMGINFO		ImgInf	 = {0};
AJC_WNDPROC_DEF(Main);

//----- AjxPrn の派生クラス ------------------------------------------------------------------------------------//
class CAjxPrnEx : public CAjxPrn
{
	public:
		//	ページ印刷開始通知
		BOOL	OnQueryPage				(PCAJCPRN_INFO pPrnInfo, PAJCPRN_PGINFO pPageInfo)			override {
			return TRUE;
		}
		//	ＤＩＢセクション・ビットマップによる描画
		BOOL	OnDrawByDibSectDC		(HDC hdc, PCAJCPRN_INFO pPrnInfo, PCAJCDIBINFO pDibInfo)	override {
			RECT	ir, pr;
			int		x, y;
			SetRect(&ir, 0, 0, ImgInf.width, ImgInf.height);
			x = (pDibInfo->width  - ImgInf.width ) / 2;
			y = (pDibInfo->height - ImgInf.height) / 2;
			SetRect(&pr, x, y, x + ImgInf.width, y + ImgInf.height);
			AjcImgFuncDraw(&ImgInf, &ir, hdc, &pr);
			return FALSE;
		}
		//	プリンタＤＣによる描画
		BOOL	OnDrawByPrinterDC		(HDC hdc, PCAJCPRN_INFO pPrnInfo)							override {
			RECT	ir, pr;
			int		x, y;
			SetRect(&ir, 0, 0, ImgInf.width, ImgInf.height);
			x = pPrnInfo->x + (pPrnInfo->cx - ImgInf.width ) / 2;
			y = pPrnInfo->y + (pPrnInfo->cy - ImgInf.height) / 2;
			SetRect(&pr, x, y, x + ImgInf.width, y + ImgInf.height);
			AjcImgFuncDraw(&ImgInf, &ir, hdc, &pr);
			return FALSE;
		}
};

CAjxPrnEx prn;

//----- AjcWinMain ------------------------------------------------------------------------------------------------//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 		msg = {0};
	WNDCLASS	wc	= {0};

	hInst = hInstance;
	//	ウインド生成
	wc.style		 = 0;							wc.hCursor		 = LoadCursor(NULL, IDC_ARROW);	
	wc.lpfnWndProc	 = AJC_WNDPROC_NAME(Main);		wc.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
	wc.hInstance	 = hInstance;					wc.lpszClassName = TEXT("SP_PRN");
	RegisterClass(&wc);
	hMenu = LoadMenu(hInst, MAKEINTRESOURCE(IDR_MENU1));
	hWndMain = CreateWindowEx(WS_EX_ACCEPTFILES,			// extend style
				TEXT("SP_PRN"),	TEXT("SP_PRN"),				// window class name, caption
				WS_OVERLAPPEDWINDOW,						// window style
				CW_USEDEFAULT, CW_USEDEFAULT, 500, 300,		// position, size
				NULL, hMenu, hInstance, NULL);				// parent, menu, instance, param
	ShowWindow(hWndMain, iCmdShow);
	//	メッセージループ
	while (GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage (&msg);
	}
	DeleteObject(hMenu);
	return (int)msg.wParam ;
}
//----- WM_CREATE ----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_CREATE 	)
{
	return 0;
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_DESTROY	)
{
	AjcImgFuncRelease(&ImgInf);			//	イメージデータ破棄
	PostQuitMessage(0);					//	プログラム終了
	return 0;
}
//----- WM_DROPFILES -------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_DROPFILES	)
{
	HDROP		hDrop;
	UT			path[MAX_PATH];

	hDrop = (HDROP)wParam;									//	ドロップハンドル設定
	if (DragQueryFile(hDrop, 0, path, MAX_PATH)) {
		if (AjcPathIsFile(path)) {
			AjcImgFuncRelease(&ImgInf);						//	前イメージデータ破棄
			AjcImgFuncRead(&ImgInf, path);					//	イメージデータ読み出し
			InvalidateRect(hwnd, NULL, TRUE);				//	再描画
		}
	}
	DragFinish(hDrop);										//	ドロップ終了
	return 0;
}
//----- WM_SIZE ------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_SIZE		)
{
	InvalidateRect(hwnd, NULL, TRUE);
	return 0;
}
//----- WM_PAINT -----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_PAINT		)
{
	PAINTSTRUCT ps;
	HDC 		hdc;
	RECT		wr, ir;
	int			ww, wh;

	hdc   = BeginPaint(hwnd, &ps);
	if (ImgInf.fValid) {
		GetClientRect(hwnd, &wr);
		ww = wr.right - wr.left;  wh = wr.bottom - wr.top;
		if (ImgInf.height >= ImgInf.width) {
			SetRect(&wr, 0, 0, ImgInf.width * wh / ImgInf.height, wh								);
		}
		else {
			SetRect(&wr, 0, 0, ww								, ImgInf.height * ww / ImgInf.width );
		}
		SetRect(&ir, 0, 0, ImgInf.width, ImgInf.height);
		AjcImgFuncDraw(&ImgInf, &ir, hdc, &wr);
	}
	EndPaint(hwnd, &ps);
	return 0;
}
//----- WM_INITMENU --------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_INITMENU	)
{
	EnableMenuItem(hMenu, ID_PRINT_DIB, MF_BYCOMMAND | (ImgInf.fValid ? MF_ENABLED : MF_GRAYED));
	EnableMenuItem(hMenu, ID_PRINT_PRN, MF_BYCOMMAND | (ImgInf.fValid ? MF_ENABLED : MF_GRAYED));
	return 0;
}
//----- ファイル→イメージファイル選択 -------------------------------------------------------------------------//
AJC_WNDPROC(Main, ID_FILE		)
{
	static UT	path[MAX_PATH] = {0};
	if (AjcGetOpenFile(hwnd, TEXT("イメージファイルの選択"), 
			TEXT("All Files (*.*)/*.*/Bitmap File (*.bmp)/*.bmp/.jpg File/*.jpg/.png File/*.png/.gif File/*.gif"), TEXT("bmp"),
			path, MAX_PATH)) {
		AjcImgFuncRelease(&ImgInf);				//	前イメージデータ破棄
		AjcImgFuncRead(&ImgInf, path);			//	イメージデータ読み出し
		InvalidateRect(hwnd, NULL, TRUE);		//	再描画
	}
	return 0;
}
//----- ファイル→終了 -----------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, ID_EXIT		)
{
	DestroyWindow(hwnd);
	return 0;
}
//----- 印刷→プリンタ選択 -------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, ID_SELPRN		)
{
	prn.SelectDialog(NULL, AJCPRNF_NONETWORKBUTTON, hwnd);
	return 0;
}
//----- 印刷→印刷(Use DIB Section) ----------------------------------------------------------------------------//
AJC_WNDPROC(Main, ID_PRINT_DIB	)
{
	AJCPRN_OPT opt = {AJCPRNF_DISABLECOPIES | AJCPRNF_DISABLEPAGEINFO, 1, 1, 1, 1, 1};
	if (prn.PrintDialog(NULL, &opt, hwnd)) {
		prn.Start(TRUE);
	}
	return 0;
}
//----- 印刷→印刷(Use Printer DC) -----------------------------------------------------------------------------//
AJC_WNDPROC(Main, ID_PRINT_PRN	)
{
	AJCPRN_OPT opt = {AJCPRNF_DISABLECOPIES | AJCPRNF_DISABLEPAGEINFO, 1, 1, 1, 1, 1};
	if (prn.PrintDialog(NULL, &opt, hwnd)) {
		prn.Start(FALSE);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Main)
	AJC_WNDMAP_MSG(Main, WM_CREATE		)
	AJC_WNDMAP_MSG(Main, WM_DESTROY		)
	AJC_WNDMAP_MSG(Main, WM_DROPFILES	)
	AJC_WNDMAP_MSG(Main, WM_SIZE		)
	AJC_WNDMAP_MSG(Main, WM_PAINT		)
	AJC_WNDMAP_MSG(Main, WM_INITMENU	)
	AJC_WNDMAP_CMD(Main, ID_FILE		)
	AJC_WNDMAP_CMD(Main, ID_EXIT		)
	AJC_WNDMAP_CMD(Main, ID_SELPRN		)
	AJC_WNDMAP_CMD(Main, ID_PRINT_DIB	)
	AJC_WNDMAP_CMD(Main, ID_PRINT_PRN	)
AJC_WNDMAP_END
