﻿//
//	SP_SCP2.cpp
//
#include	<AjxCpp.h>
#include	<tchar.h>
#include	<conio.h>
using namespace AjxControl;

//----- CAjxScpの派生クラス ------------------------------------------------------------------------------------//
class CAjxScpEx : public CAjxScp
{
public:
	CAjxScpEx() {												//	コンストラクタ
		Init(TEXT("MyScpSect"), AJCSCP_CM_TEXT);
	}
	VO	OnNtcPortState(C_UTP pPortName, UI Param) override {	//	ポート状態通知
		SAjxCon::PrintF(TEXT("ポート名：%s\n"), pPortName);
		switch (Param) {
			case AJCSCP_CLOSED:		SAjxCon::PrintF(TEXT("- ポートをクローズしました。\n\n"));		break;
			case AJCSCP_OPENED:		SAjxCon::PrintF(TEXT("- ポートをオープンしました。\n\n"));		break;
			case AJCSCP_OPENFAIL:	SAjxCon::PrintF(TEXT("- ポートのオープンを失敗しました\n\n"));	break;
			case AJCSCP_PORTCHG:	SAjxCon::PrintF(TEXT("- 通信ポートが変更されました\n\n"));		break;
		}
	}
	VO	OnNtcRxTextChunk(C_UTP pText) override {				//	テキストチャンク受信通知
		SAjxCon::PrintF(pText);
	}
};
static CAjxScpEx	scp;


int  AjcMain(int argc, UTP argv[])
{
	SAjxCon::SetStdMode();

	//----- コマンドガイド表示 ---------------------------------------------------------------------------------//
	SAjxCon::PrintF(TEXT("\n"));
	SAjxCon::PrintF(TEXT(" 通信ポートから受信したテキストデータを表示します。\n"));
	SAjxCon::PrintF(TEXT(" いずれかのキーを押すとプログラムを終了します。\n\n"));

	//	イベントマスク設定
	scp.SetEvtMask(AJCSCP_EV_PORTSTATE | AJCSCP_EV_RXCHUNK);
	//	ポートパラメタ設定
	UT WndTxt[256];
	GetConsoleTitle(WndTxt, 256);
	scp.DlgParamEasy(FindWindow(NULL, WndTxt));
	//	ポートオープン
	scp.Open();

	while (!_kbhit()) {
		//	ＳＣＰイベント待ち
		scp.WaitEvent(100);
	}

	//	ポートクローズ
	scp.Close();

	return 0;
}

