﻿//
//	SP_SSV1.cpp
//
#include	<AjxCpp.h>
#include	<tchar.h>
using namespace AjxControl;

#define	IDC_VTH		5001
#define	MY_WS		(WS_OVERLAPPEDWINDOW & ~(WS_THICKFRAME | WS_MAXIMIZEBOX))

static	HINSTANCE	hInst	  = NULL;
static	HWND		hWndMain  = NULL;
static	HWND		hWndVth   = NULL;

AJC_WNDPROC_DEF(Main);
//----- クライアント制御テーブル -------------------------------------------------------------------------------//
#define	MAX_CLITBL	2		/*	最大クライアント数	*/
typedef struct {
	HAJCSSVCLI	hCli;
	UX			Bytes;
	UI			SeqNo;
	UI			line;
} CLITBL, *PCLITBL;

//----- 個々のクライアント処理クラス（CAjxSsvCliの派生クラス） -------------------------------------------------//
class CAjxSsvCliEx : public CAjxSsvCli, public CAjxVth {
	HAJCSSVCLI	m_hCli;
	UI			m_line;
	ULL			m_Bytes;
	UI			m_SeqNo;
public:
	//	コンストラクタ
	CAjxSsvCliEx(HAJCSSVCLI hCli = NULL)	{
		CAjxSsvCli::SetCliHandle(m_hCli = hCli);
		Attach(hWndVth);
		m_line =  0;
		m_Bytes = 0;
		m_SeqNo = GetSeqNo();
	}
	//	クライアント接続通知
	VO	OnNtcConnect	()	override {
		UT	szIpAddr[64];
		UI	ix = GetIndex();
		m_line = 10 + ix * 2;
		GetIpAddrStr(szIpAddr, 64);
		Locate(m_line, 15);	PrintF(szIpAddr);
		Locate(m_line, 31);	PrintF(TEXT("%d"), m_Bytes);
		Locate(m_line, 48);	PrintF(TEXT("%d"), m_SeqNo);
	}
	//	クライアント切断通知
	VO	OnNtcDisconnect	()		override {
		UT	szIpAddr[64];
		UI	ix = GetIndex();
		Locate(m_line, 15);	PrintF(TEXT("\x1b[K"));
		GetIpAddrStr(szIpAddr, 64);
		Locate(m_line, 15);	PrintF(TEXT("-"));
		Locate(m_line, 31);	PrintF(TEXT("-"));
		Locate(m_line, 48);	PrintF(TEXT("-"));
	}
	//	バイナリチャンク受信通知
	VO	OnNtcRxBinChunk	(C_VOP pData, UI Bytes)		override {
		UI	ix = GetIndex();
		SendBinData(pData, Bytes);
		m_Bytes += Bytes;
		Locate(m_line, 31);	PrintF(TEXT("%lld"), m_Bytes);
	}
};

//----- サーバ処理クラス（CAjxSsvSvr + CAjxVthの派生クラス） ---------------------------------------------------//
class CAjxSsvEx : public CAjxSsvSvr, public CAjxVth {
	CLITBL		m_CliTbl[MAX_CLITBL];
public:
	//----- サーバイベント ---------------------------------------------------------------------//
	//	サーバ開始通知
	VO		OnNtcStart				()			override {
		Locate(5, 0);
		PrintF(TEXT("\r\x1b[2K"));
		PrintF(TEXT("- サーバを開始しました。\n"));
		//	クライアント制御テーブル初期化
		int		line = 10;
		memset(m_CliTbl, 0, sizeof m_CliTbl);
		for (int i = 0; i < MAX_CLITBL; i++) {
			m_CliTbl[i].line = line;
			line += 2;
		}
	}
	//	サーバ停止通知
	VO		OnNtcStop				()			override {
		Locate(14, 0);
		PrintF(TEXT("\r\x1b[2K"));
		PrintF(TEXT("- サーバを停止しました。３秒後にプログラムを終了します。\n"));
		SetTimer(hWndMain, 1, 3000, NULL);
	}
	//	エラー通知
	VO		OnNtcError				(UI err)	override {
		Locate(6, 0);
		PrintF(TEXT("\r\x1b[2K"));
		PrintF(TEXT("\x1b[31m- エラー発生(%d)\x1b[0m\n"), err);
	}
	//----- クライアントイベント ---------------------------------------------------------------//
	//	クライアント接続通知
	CAjxSsvCli*	OnNtcConnect	(HAJCSSVCLI hCli)					override {
		//	クライアント処理クラス生成
		CAjxSsvCliEx* pCli = new CAjxSsvCliEx(hCli);
		return pCli;
	}
	//	クライアント切断通知
	VO	OnNtcDisconnect	(HAJCSSVCLI hCli, CAjxSsvCli* pCli)	override {
		//	クライアント処理クラス消去
		delete (CAjxSsvCliEx*)pCli;
	}
};
static	CAjxSsvEx	ssv_vth;

//----- AjcWinMain ------------------------------------------------------------------------------------------------//
int WINAPI AjcWinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, UTP szCmdLine, int iCmdShow)
{
	MSG 		msg = {0};
	WNDCLASS	wc	= {0};
	ATOM		atm = 0;

	hInst = hInstance;

	//	ウインド生成
	wc.style		 = 0;							wc.hCursor		 = LoadCursor(NULL, IDC_ARROW);	
	wc.lpfnWndProc	 = AJC_WNDPROC_NAME(Main);		wc.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
	wc.hInstance	 = hInstance;					wc.lpszClassName = TEXT("SP_SSV");
	atm = RegisterClass(&wc);
	hWndMain = CreateWindowEx(0,
				TEXT("SP_SSV"),	TEXT("SP_SSV"),				// window class name, caption
				MY_WS,										// window style
				CW_USEDEFAULT, CW_USEDEFAULT, 800, 400,		// position, size
				NULL, NULL, hInstance, NULL);				// parent, menu, instance, param
	ShowWindow(hWndMain, iCmdShow);
	//	メッセージループ
	while (GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage (&msg);
	}
	UnregisterClass((UTP)atm, hInstance);
	return (int)msg.wParam ;
}
//----- WM_CREATE ----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_CREATE 	)
{
	//	ＶＴ１００ウインド生成
	RECT	r;
	GetClientRect(hwnd, &r);
	hWndVth = CreateWindowEx(WS_EX_ACCEPTFILES,
							 TEXT("AjcCtrlVT100"), 					// window class
							 TEXT("P: VW=80, VH=16, TS=4, LS=3, FN=ＭＳ ゴシック, LF=12"),	// window caption
							 WS_CHILD | AJCVTHS_NOBORDER,			// window style
							 0, 0, r.right, r.bottom, 				// position, size
							 hwnd, (HMENU)IDC_VTH, hInst, NULL);	// parent, menu, instance, param
	//	VT100ウインドハンドル割り当て
	ssv_vth.Attach(hWndVth);
	//	VT100ウインドサイズ設定
	UI		w, h;
	ssv_vth.GetVramFitSize(&w, &h);
	GetWindowRect(hwnd, &r);
	r.right  = r.left + w;
	r.bottom = r.top  + h;
	AdjustWindowRect(&r, MY_WS, FALSE);
	SetWindowPos(hwnd, NULL, r.left, r.top, r.right - r.left, r.bottom - r.top, SWP_NOZORDER);
	//	ガイドメッセージ表示
	DWORD	bytes;
	UT		szHostName[256];
	bytes = (sizeof szHostName);
	GetComputerName(szHostName, &bytes);
	ssv_vth.PrintF(TEXT("TCP/IP エコー・サーバ機能を実行します。(%s:14238)\n")
				   TEXT("クライアントから受信したデータをそのまま返信します。\n")
				   TEXT("クライアントは %d 個まで接続できます。\n"), szHostName, MAX_CLITBL);
	//	タイトル表示
	ssv_vth.Locate( 8, 10); ssv_vth.PrintF(TEXT("No.  Client          Bytes            SeqNo"));
	ssv_vth.Locate(10, 10); ssv_vth.PrintF(TEXT("1    -               -                -"));
	ssv_vth.Locate(12, 10); ssv_vth.PrintF(TEXT("2    -               -                -"));
	//	VT100キャレット非表示
	ssv_vth.ShowCaret(FALSE);
	//	VT100ウインド表示
	ShowWindow(hWndVth, SW_SHOW);			//	VT100ウインド表示
	//	サーバ開始
	ssv_vth.Start	(TEXT("14238"), MAX_CLITBL);
	ssv_vth.SetEvtMask(AJCSSV_EV_GENERAL | AJCSSV_EV_RXCHUNK | AJCSSV_EV_ERR);
	ssv_vth.SetChunkMode(AJCSSV_CM_BIN);
	return 0;
}
//----- WM_CLOSE ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_CLOSE		)
{
	ssv_vth.Stop();
	return 0;
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_DESTROY	)
{
	PostQuitMessage(0);
	return 0;
}
//----- WM_SIZE ------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_SIZE		)
{
	MoveWindow(hWndVth, 0, 0, LOWORD(lParam), HIWORD(lParam), FALSE);
	return 0;
}
//----- WM_TIMER -----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Main, WM_TIMER		)
{
	DestroyWindow(hwnd);
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Main)
	AJC_WNDMAP_MSG(Main, WM_CREATE		)
	AJC_WNDMAP_MSG(Main, WM_CLOSE		)
	AJC_WNDMAP_MSG(Main, WM_DESTROY		)
	AJC_WNDMAP_MSG(Main, WM_SIZE		)
	AJC_WNDMAP_MSG(Main, WM_TIMER		)
AJC_WNDMAP_END
