﻿//
//	SP_SSV2.cpp
//
#include	<AjxCpp.h>
#include	<stdio.h>
#include	<conio.h>
#include	<time.h>
#include	<tchar.h>
using namespace AjxControl;

//----- ワーク -------------------------------------------------------------------------------------------------//
static	BOOL	fServEnd = FALSE;		//	サーバ停止フラグ

//----- 個々のクライアント処理クラス（CAjxSsvCliの派生クラス） -------------------------------------------------//
class CAjxSsvCliEx : public CAjxSsvCli {
	HAJCSSVCLI	m_hCli;
	UI			m_line;
	ULL			m_Bytes;
	UI			m_SeqNo;
public:
	//	コンストラクタ
	CAjxSsvCliEx(HAJCSSVCLI hCli = NULL)	{
		CAjxSsvCli::SetCliHandle(m_hCli = hCli);
		m_line =  0;
		m_Bytes = 0;
		m_SeqNo = GetSeqNo();
	}
	//	クライアント接続通知
	VO	OnNtcConnect	()	override {
		UT	szAddr[128];
		GetIpAddrStr(szAddr, 128);
		SAjxCon::PrintF(TEXT("- %-16s : 接続しました。\n"), szAddr);
	}
	//	クライアント切断通知
	VO	OnNtcDisconnect	()		override {
		UT	szAddr[128];
		GetIpAddrStr(szAddr, 128);
		SAjxCon::PrintF(TEXT("- %-16s : 切断しました。\n"), szAddr);
	}
	//	バイナリチャンク受信通知
	VO	OnNtcRxBinChunk	(C_VOP pData, UI Bytes)		override {
		SendBinData(pData, Bytes); // そのまま返信
	}
};
//----- サーバ処理クラス（CAjxSsvSvrの派生クラス） -------------------------------------------------------------//
class CAjxSsvEx : public CAjxSsvSvr {
public:
	//----- サーバイベント ---------------------------------------------------------------------//
	//	サーバ開始通知
	VO		OnNtcStart				()			override {
		SAjxCon::PrintF(TEXT("- サーバを開始しました。\n"));
	}
	//	サーバ停止通知
	VO		OnNtcStop				()			override {
		SAjxCon::PrintF(TEXT("- サーバを停止しました。\n"));
		fServEnd = TRUE;
	}
	//	エラー通知
	VO		OnNtcError				(UI err)	override {
		SAjxCon::PrintF(TEXT("*** エラー発生(%d) ***\n"), err);
	}
	//	クライアント列挙通知
	BOOL		OnNtcClients	(HAJCSSVCLI hCli, CAjxSsvCli* pCli)
	{
		pCli->Disconnect();
		return TRUE;  // TRUE:列挙継続
	}
	//----- クライアントイベント ---------------------------------------------------------------//
	//	クライアント接続通知
	CAjxSsvCli*	OnNtcConnect	(HAJCSSVCLI hCli)						override {
		//	クライアント処理クラス生成
		CAjxSsvCliEx* pCli = new CAjxSsvCliEx(hCli);
		return pCli;
	}
	//	クライアント切断通知
	VO			OnNtcDisconnect	(HAJCSSVCLI hCli, CAjxSsvCli* pCli)		override {
		//	クライアント処理クラス消去
		delete (CAjxSsvCliEx*)pCli;
	}
};
static	CAjxSsvEx	ssv;

//==============================================================================================================//
int  AjcMain(int argc, UTP argv[])
{
	SAjxCon::SetStdMode();

	//	ガイドメッセージ表示
	DWORD	bytes;
	UT		szHostName[256];
	bytes = (sizeof szHostName);
	GetComputerName(szHostName, &bytes);
	SAjxCon::PrintF(TEXT("TCP/IP エコー・サーバ機能を実行します。(%s:14238)\n")
					TEXT("クライアントから受信したデータをそのまま返信します。\n")
					TEXT("クライアントは２個まで接続できます。")
					TEXT("いずれかのキーを押すと終了します。\n\n"), szHostName);

	//	サーバ開始
	ssv.Start	(TEXT("14238"), 2);
	ssv.SetEvtMask(AJCSSV_EV_GENERAL | AJCSSV_EV_RXCHUNK | AJCSSV_EV_ERR);
	ssv.SetChunkMode(AJCSSV_CM_BIN);

	//	サーバ停止までイベント待ちループ
	BOOL	fStop = FALSE;
	while (!fServEnd) {
		//	いずれかのキー押下でサーバ停止
		if (_kbhit() && !fStop) {
			ssv.EnumClients();	//	クライアント列挙（接続中のクライアント切断）
								//	この処理は特に実行しなくてもＯＫです（サーバ停止で全クライアントは切断されます）

			ssv.Stop();			//	サーバ停止
			fStop = TRUE;
		}
		//	イベント発生待ち(100ms)
		ssv.WaitEvent(100);
	}

	SAjxCon::PrintF(TEXT("Hit Enter Key!!"));
	while (_kbhit()) _getch();
	getchar();

	return 0;
}

