﻿//
//	SP_XYM.cpp
//
#include	<AjxCpp.h>
#include	<tchar.h>
#include	<direct.h>
#include	<conio.h>
using namespace AjxControl;

//----- CAjxXym, CAjxScp, CAjxCon の派生クラス ------------------------------------------------------------------//
class CAjxXymEx : public CAjxXym, public CAjxScp, public CAjxCon
{
	AJCXYMPROTOCOL			m_Protocol;				//	通信プロトコル
	BOOL					m_fBusy;				//	ファイル転送中フラグ
	HANDLE					m_hFile;				//	ファイルハンドル
	SX						m_hFind;				//	ファイル検索ハンドル
	BOOL					m_fFindFirst;			//	ファイル検索初回フラグ
	struct _tfinddata64_t	m_FindData;				//	ファイル検索結果
	BOOL					m_fReceiving;			//	ファイル受信中を示すフラグ
	ULL						m_RxBytes;				//	ファイル受信サイズ（残受信バイト数）
	ULL						m_TxBytes;				//	ファイル送信サイズ（残送信バイト数）
	UT						m_Path[MAX_PATH];		//	送信ファイル／ディレクトリ
	UT						m_drv[_MAX_DRIVE];		//	ドライブ名
	UT						m_dir[_MAX_DIR];		//	ディレクトリパス名

	//----- ファイル転送終了待ち -----------------------------------------------//
	VO	WaitForEnd() {
		m_fBusy = TRUE;
		while (m_fBusy) {
			//	終了チェック（ESCキー入力チェック）
			if (_kbhit()) {
				int c = _getch();
				if (c == 0x1B) Stop();
			}
			//	ＳＣＰイベント待ち
			WaitEvent(100);
			//	システムメッセージ処理
			AjcDoEvent();
		}
	}

public:
	//	コンストラクタ
	CAjxXymEx()
	{
		m_Protocol	 = AJCXYP_XMODEM_SUM;
		m_fBusy 	 = FALSE;
		m_hFile 	 = NULL;
		m_hFind 	 = -1;
		m_fFindFirst = TRUE;
		//	ＳＣＰ初期化
		Init(TEXT("MyScpSect"), AJCSCP_CM_BIN);
		SetEvtMask(AJCSCP_EV_PORTSTATE | AJCSCP_EV_RXCHUNK | AJCSCP_EV_TXEMPTY);
	}
	//----- ファイル送信 -------------------------------------------------------//
	VO	SendFile()
	{
		m_fReceiving = FALSE;
		m_fFindFirst = TRUE;
		if (TxStart(m_Protocol)) {
			WaitForEnd();
		}
	}
	//----- ファイル受信 -------------------------------------------------------//
	VO	RecvFile()
	{
		m_fReceiving = TRUE;
		if (RxStart(m_Protocol)) {
			WaitForEnd();
		}
	}
	//----- 受信ファイル書き込み -----------------------------------------------//
	VO	SubWrite(VOP pDat, ULL len) {
		UL	bytes;
		if (m_hFile != INVALID_HANDLE_VALUE) {
			if (m_RxBytes > len) {WriteFile(m_hFile, pDat, (UI)len		, &bytes, NULL); m_RxBytes -= len;}
			else				 {WriteFile(m_hFile, pDat, (UI)m_RxBytes, &bytes, NULL); m_RxBytes	= 0;  }
		}
	}
	//----- XYM Override -------------------------------------------------------//
	//	イベント通知
	VO	OnNotice (UI knd, UX Param				)	override {
		PCAJCXYMFILEINFO pfi;
		UT		path[MAX_PATH];
		//	イベントアクション
		switch (knd) {
			//	受信ファイル情報通知（ファイル受信時）
			case AJCXYN_RXFILEINFO:		pfi = (PCAJCXYMFILEINFO)Param;
										MAjcMakePath(path, m_drv, m_dir, pfi->pFName, NULL);
										SAjxCon::PrintF(TEXT("File receive '%s'\n"), path);
										m_RxBytes = pfi->size;
										if ((m_hFile = CreateFile(path, GENERIC_WRITE, 0, NULL,
											CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL)) == INVALID_HANDLE_VALUE) {
											SAjxCon::PrintF(TEXT("File creation failure <%s>\n"), path);
										}
										break;
			//	１レコード送信完了
			case AJCXYN_TXREC:			SAjxCon::PrintF(TEXT("."));
										break;
			//	１レコード受信（１２８バイトレコード）
			case AJCXYN_RXREC_128:		SAjxCon::PrintF(TEXT(".")); SubWrite((VO*)Param, 128);
										break;
			//	１レコード受信（１ＫＢレコード）
			case AJCXYN_RXREC_1K:		SAjxCon::PrintF(TEXT(".")); SubWrite((VO*)Param, 1024);
										break;
			//	再送発生
			case AJCXYN_RETRY:			SAjxCon::PrintF(TEXT("R"));
										break;
			//	ＥＯＦ通知
			case AJCXYN_EOF:			SAjxCon::PrintF(TEXT("E\n"));
										if (m_hFile != INVALID_HANDLE_VALUE) {
											CloseHandle(m_hFile); 
											m_hFile = INVALID_HANDLE_VALUE;
										}
										break;
			//	通信プロトコル変更通知
			case AJCXYN_PROTOCOL:		SAjxCon::PrintF(TEXT("Protocol change.\n"));
										break;
			//	ファイル転送完了
			case AJCXYN_COMPLETE:		SAjxCon::PrintF(TEXT("Complete.\n"));
										break;
			//	ファイル転送中止（ＣＡＮ受信			）
			case AJCXYN_RX_CAN:			SAjxCon::PrintF(TEXT("Stop by Received CAN\n"));
										break;
			//	ファイル転送中止（ユーザからの中止要求	）
			case AJCXYN_USERSTOP:		SAjxCon::PrintF(TEXT("Stop by user\n"));
										break;
			//	ファイル転送中止（タイムアウト			）
			case AJCXYN_TIMEOUT:		SAjxCon::PrintF(TEXT("Stop by Timeout\n"));
										break;
		}
		//	転送終了
		if ((knd & AJCXYN_END) != 0) {
			if (m_hFind != -1				   ) {_findclose (m_hFind);	m_hFind = -1;				   }
			if (m_hFile != INVALID_HANDLE_VALUE) {CloseHandle(m_hFile);	m_hFile = INVALID_HANDLE_VALUE;}
			m_fBusy = FALSE;
		}
	}
	//	ファイル情報取得要求（ファイル送信時）
	VO	OnGetFile(PAJCXYMFILEINFO pBuf			)	override {
		BOOL	fEndOfFind	= FALSE;
		//----- XMODEM の場合、指定ファイルオープン -----------------------------//
		if (m_Protocol & AJCXYP_XMODEM) {
			m_hFind  = -1;
			//	送信ファイルオープン
			if ((m_hFile = CreateFile(m_Path, GENERIC_READ, FILE_SHARE_READ, NULL,
									OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)) != INVALID_HANDLE_VALUE) {
				//	送信ファイルサイズ設定
				m_TxBytes = AjcGetFileSize(m_Path);
				//	ファイル情報設定
				pBuf->pFName = m_Path;
				pBuf->size	 = AjcGetFileSize	 (m_Path);
				pBuf->time	 = AjcGetFileTime1970(m_Path);
				SAjxCon::PrintF(TEXT("File transfer <%s>\n"), m_Path);
			}
			else {
				SAjxCon::PrintF(TEXT("File open failure <%s>\n"), m_Path);
			}
		}
		//----- YMODEM の場合、ディレクトリ下のファイル検索 ---------------------//
		else {
			//	前回のファイルクローズ
			if (m_hFile != INVALID_HANDLE_VALUE) {
				CloseHandle(m_hFile);
				m_hFile = INVALID_HANDLE_VALUE;
			}
			//	次の送信ファイル設定
			while (!fEndOfFind	&&	m_hFile == INVALID_HANDLE_VALUE) {
				//	次のファイル検索
				do {
					UT wild[MAX_PATH];
					MAjcMakePath(wild, m_drv, m_dir, TEXT("*"), TEXT(".*"));
					if (m_fFindFirst) {if ((m_hFind = _tfindfirst64(wild, &m_FindData)) == -1) fEndOfFind = TRUE;}
					else			  {if (_tfindnext64(m_hFind, &m_FindData)				   == -1) fEndOfFind = TRUE;}
					m_fFindFirst = FALSE;
				} while (!fEndOfFind && (m_FindData.attrib & (_A_HIDDEN | _A_SUBDIR | _A_SYSTEM)));
				//	ファイルデータ／ＥＯＦ設定
				if (!fEndOfFind) {
					//	送信ファイルサイズ設定
					m_TxBytes = m_FindData.size;
					//	送信ファイルオープン
					UT		path[MAX_PATH];
					MAjcMakePath(path, m_drv, m_dir, m_FindData.name, NULL);
					if ((m_hFile = CreateFile(path, GENERIC_READ, FILE_SHARE_READ, NULL,
											OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)) != INVALID_HANDLE_VALUE) {
						//	ファイル情報設定
						pBuf->pFName = m_FindData.name;
						pBuf->size	 = m_FindData.size;
						pBuf->time	 = (UL)(m_FindData.time_write);
						SAjxCon::PrintF(TEXT("File transfer <%s>\n"), path);
					}
					else {
						SAjxCon::PrintF(TEXT("File open failure <%s>\n"), path);
					}
				}
				else {
					//	ファイル検索終了
					_findclose(m_hFind);
					m_hFind = -1;
					//	EOF設定
					pBuf->pFName = NULL;
				}
			}
		}
	}
	//	ファイルデータ取得要求（ファイル送信時）
	VO	OnGetData(VOP pBuf, UI lBuf, UIP pBytes	)	override {
		ReadFile(m_hFile, pBuf, lBuf, (ULP)pBytes, NULL);
		if (m_TxBytes >= *pBytes) m_TxBytes -= *pBytes;
		else					  m_TxBytes  = 0;
	}
	//	データ送出要求（ファイル送信時）
	VO	OnSend	 (C_VOP pTxD, UI lTxD			)	override {
		SendBinData(pTxD, lTxD);
	}
	//----- SCP Override -------------------------------------------------------//
	//	ポート状態通知
	VO	OnNtcPortState	(C_BCP pPortName, UI Param)	override {
	}
	//	バイナリチャンク受信通知
	VO	OnNtcRxBinChunk	(C_VOP pData, UI Bytes)		override {
		UBP	p = (UBP)pData;
		while (Bytes--) {
			PutRxChar(*p++);
		}
	}
	//	送信完了通知
	VO	OnNtcTxEmpty	()							override {
		//	YMODEM-G の場合、送信完了を通知
		if (m_Protocol == AJCXYP_YMODEM_G && !m_fReceiving && m_TxBytes == 0) {
			TxEnd();
		}
	}
	//----- コマンドパラメタ通知 -----------------------------------------------//
	VO	OnNtcStr(int argc, UT *argv[], C_UTP pTxt) override {
		SAjxCon::PrintF(TEXT("Input = '%s'\n\n"), pTxt);
		if		(argc == 1) {
			if		(_tcsicmp(argv[0], TEXT("XS")) == 0) {m_Protocol = AJCXYP_XMODEM_SUM;}
			else if (_tcsicmp(argv[0], TEXT("XC")) == 0) {m_Protocol = AJCXYP_XMODEM_CRC;}
			else if (_tcsicmp(argv[0], TEXT("X1")) == 0) {m_Protocol = AJCXYP_XMODEM_1K; }
			else if (_tcsicmp(argv[0], TEXT("YM")) == 0) {m_Protocol = AJCXYP_YMODEM_STD;}
			else if (_tcsicmp(argv[0], TEXT("YG")) == 0) {m_Protocol = AJCXYP_YMODEM_G;  }
			else  SAjxCon::PrintF(TEXT(" *** Invalid directory '%s'.\n"), argv[0]);
		}
		else if (argc == 2) {
			if (((m_Protocol &AJCXYP_XMODEM) && AjcPathIsFile	  (argv[1])) ||
				((m_Protocol &AJCXYP_YMODEM) && AjcPathIsDirectory(argv[1]))) {
				//	パス名設定
				_tcscpy_s(m_Path, AJCTSIZE(m_Path), argv[1]);
				if (m_Protocol &AJCXYP_YMODEM) {
					AjcPathCat(m_Path, TEXT(""), AJCTSIZE(m_Path));
					MAjcSplitPath(m_Path, m_drv, m_dir, NULL, NULL);
				}
				//	コマンド実行
				if		(_tcsicmp(argv[0], TEXT("TX")) == 0) {SendFile();}
				else if (_tcsicmp(argv[0], TEXT("RX")) == 0) {RecvFile();}
				else SAjxCon::PrintF(TEXT(" *** Invalid parameter '%s'.\n"), argv[0]);
			}
			else SAjxCon::PrintF(TEXT(" *** Invalid directory '%s'.\n"), argv[1]);
		}
		else SAjxCon::PrintF(TEXT(" *** missing number of parameters.\n"));
	}
};

CAjxXymEx	xym_scp;

//----- m a i n ------------------------------------------------------------------------------------------------//
int AjcMain(int argc, UTP argv[])
{
	SAjxCon::SetStdMode();

	//	ポートパラメタ設定
	UT WndTxt[256];
	GetConsoleTitle(WndTxt, 256);
	xym_scp.DlgParamEasy(FindWindow(NULL, WndTxt));
	//	ポートオープン
	xym_scp.Open();

	if (xym_scp.IsOpened()) {
		//コマンド入力ループ
		do {
			SAjxCon::PrintF(TEXT("\n"));
			SAjxCon::PrintF(TEXT(" XS ------------- 通信プロトコル設定(XMODEM(SUM))\n"));
			SAjxCon::PrintF(TEXT(" XC ------------- 通信プロトコル設定( 〃   (CRC))\n"));
			SAjxCon::PrintF(TEXT(" X1 ------------- 通信プロトコル設定( 〃   (1KB))\n"));
			SAjxCon::PrintF(TEXT(" YM ------------- 通信プロトコル設定(YMODEM)\n"	  ));
			SAjxCon::PrintF(TEXT(" YG ------------- 通信プロトコル設定(YMODEM-G)\n"	  ));
			SAjxCon::PrintF(TEXT(" TX <FilePath> -- ファイル送信  (XMODEM時)\n"));
			SAjxCon::PrintF(TEXT(" RX <FilePath> -- ファイル受信  (XMODEM時)\n"));
			SAjxCon::PrintF(TEXT(" TX <DirPath> --- <DirPath>下の全ファイル送信      (YMODEM時)\n"));
			SAjxCon::PrintF(TEXT(" RX <DirPath> --- 受信したファイルを<DirPath>に格納(YMODEM時)\n"));
			SAjxCon::PrintF(TEXT(" ESCキー押下で終了\n"));
		} while (xym_scp.Input(TEXT("")));
	}
	else {
		SAjxCon::PrintF(TEXT(" ポートをオープンできません。\n"));
		SAjxCon::PrintF(TEXT(" Hit Enter Key!!\n"));
		getchar();
	}

	return 0;
}
