﻿#ifndef	AJCCTRL3DGRAPHIC_H_
#define	AJCCTRL3DGRAPHIC_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define	AjcG3dLoadProp			AjcG3dLoadPropW
	#define	AjcG3dSaveProp			AjcG3dSavePropW
	#define	AjcG2dLoadProp			AjcG2dLoadPropW
	#define	AjcG2dSaveProp			AjcG2dSavePropW

	#define	AjcG3dLoadPropEx		AjcG3dLoadPropExW
	#define	AjcG3dSavePropEx		AjcG3dSavePropExW
	#define	AjcG2dLoadPropEx		AjcG2dLoadPropExW
	#define	AjcG2dSavePropEx		AjcG2dSavePropExW

	#define	AjcG3dSetTipText		AjcG3dSetTipTextW
	#define	AjcG3dGetTipText		AjcG3dGetTipTextW

	#define	AjcG3dSetChkBoxTipText	AjcG3dSetChkBoxTipTextW
	#define	AjcG3dGetChkBoxTipText	AjcG3dGetChkBoxTipTextW

	#define	AjcG3dGetDroppedFile	AjcG3dGetDroppedFileW
	#define	AjcG3dGetDroppedDir		AjcG3dGetDroppedDirW
	#define	AjcG3dGetDroppedDirEx	AjcG3dGetDroppedDirExW

	#define	AjcG3dSetTitleText		AjcG3dSetTitleTextW

	#define	AjcG3dTextOut			AjcG3dTextOutW
	#define	AjcG3dPrintF			AjcG3dPrintFW
	#define	AjcG3dTextOutV			AjcG3dTextOutVW
	#define	AjcG3dPrintFV			AjcG3dPrintFVW
	#define	AjcG3dGetText			AjcG3dGetTextW

	#define	AjcG2dTextOut			AjcG2dTextOutW
	#define	AjcG2dPrintF			AjcG2dPrintFW
	#define	AjcG2dTextOutV			AjcG2dTextOutVW
	#define	AjcG2dPrintFV			AjcG2dPrintFVW
	#define	AjcG2dGetText			AjcG2dGetTextW

#else
	#define	AjcG3dLoadProp			AjcG3dLoadPropA
	#define	AjcG3dSaveProp			AjcG3dSavePropA
	#define	AjcG2dLoadProp			AjcG2dLoadPropA
	#define	AjcG2dSaveProp			AjcG2dSavePropA

	#define	AjcG3dLoadPropEx		AjcG3dLoadPropExA
	#define	AjcG3dSavePropEx		AjcG3dSavePropExA
	#define	AjcG2dLoadPropEx		AjcG2dLoadPropExA
	#define	AjcG2dSavePropEx		AjcG2dSavePropExA

	#define	AjcG3dSetTipText		AjcG3dSetTipTextA
	#define	AjcG3dGetTipText		AjcG3dGetTipTextA

	#define	AjcG3dSetChkBoxTipText	AjcG3dSetChkBoxTipTextA
	#define	AjcG3dGetChkBoxTipText	AjcG3dGetChkBoxTipTextA

	#define	AjcG3dGetDroppedFile	AjcG3dGetDroppedFileA
	#define	AjcG3dGetDroppedDir		AjcG3dGetDroppedDirA
	#define	AjcG3dGetDroppedDirEx	AjcG3dGetDroppedDirExA

	#define	AjcG3dSetTitleText		AjcG3dSetTitleTextA

	#define	AjcG3dTextOut			AjcG3dTextOutA
	#define	AjcG3dPrintF			AjcG3dPrintFA
	#define	AjcG3dTextOutV			AjcG3dTextOutVA
	#define	AjcG3dPrintFV			AjcG3dPrintFVA
	#define	AjcG3dGetText			AjcG3dGetTextA

	#define	AjcG2dTextOut			AjcG2dTextOutA
	#define	AjcG2dPrintF			AjcG2dPrintFA
	#define	AjcG2dTextOutV			AjcG2dTextOutVA
	#define	AjcG2dPrintFV			AjcG2dPrintFVA
	#define	AjcG2dGetText			AjcG2dGetTextA

#endif
//--------------------------------------------------------------------------------------------------------------//
//	コントロールのスタイル																						//
//--------------------------------------------------------------------------------------------------------------//
#define	AJC3DGS_RECTSCALE		0x8000			//	Bit15  : 方眼スケール表示
#define	AJC3DGS_SCALEVALUE_X	0x4000			//	Bit14  : Ｘ軸スケール値表示
#define	AJC3DGS_SCALEVALUE_Y	0x2000			//	Bit13  : Ｙ軸スケール値表示
#define	AJC3DGS_SCALEVALUE_Z	0x1000			//	Bit12  : Ｚ軸スケール値表示

#define	AJC3DGS_ELPSSCALE		0x0800			//	Bit11  : 同心円スケール
#define	AJC3DGS_SCALE_XY		0x0400			//	Bit10  : ＸＹ平面スケール表示
#define	AJC3DGS_SCALE_XZ		0x0200			//	Bit9   : ＸＺ平面スケール表示
#define	AJC3DGS_SCALE_YZ		0x0100			//	Bit8   : ＹＺ平面スケール表示

#define	AJC3DGS_NODEPTHCTRL		0x0080			//	Bit7   : 奥行き表現禁止
#define	AJC3DGS_NOBORDER		0x0040			//	Bit6   : 外枠非表示
#define	AJC3DGS_NOFILTER		0x0020			//	Bit5   : フィルタ非表示
#define	AJC3DGS_NOANGLE			0x0010			//	Bit4   : 視点設定／ドラッグ禁止

#define	AJC3DGS_SHPERESCALE		0x0008			//	Bit3   : 球形スケール表示
#define	AJC3DGS_SPHERESCALE		0x0008
#define	AJC3DGS_SHOWAXIS_X		0x0004			//	Bit2   : Ｘ軸表示
#define	AJC3DGS_SHOWAXIS_Y		0x0002			//	Bit1   : Ｙ軸表示
#define	AJC3DGS_SHOWAXIS_Z		0x0001			//	Bit0   : Ｚ軸表示

#define	AJC3DGS_SCALEVALUE_XY	(AJC3DGS_SCALEVALUE_X | AJC3DGS_SCALEVALUE_Y)
#define	AJC3DGS_AXIS_XY			(AJC3DGS_SHOWAXIS_X   | AJC3DGS_SHOWAXIS_Y	)

#define	AJC3DGS_SCALEVALUE		(AJC3DGS_SCALEVALUE_X | AJC3DGS_SCALEVALUE_Y | AJC3DGS_SCALEVALUE_Z)
#define	AJC3DGS_SCALELINE		(AJC3DGS_SCALE_XY	  | AJC3DGS_SCALE_XZ	 | AJC3DGS_SCALE_YZ)
#define	AJC3DGS_SCALE			(AJC3DGS_SCALEVALUE   | AJC3DGS_SCALELINE)
#define	AJC3DGS_AXIS			(AJC3DGS_SHOWAXIS_X   | AJC3DGS_SHOWAXIS_Y	 | AJC3DGS_SHOWAXIS_Z)

#define	AJC3DGS_3DMODE			(AJC3DGS_SCALEVALUE    | AJC3DGS_SHPERESCALE | AJC3DGS_AXIS)
#define	AJC3DGS_2DMODE			(AJC3DGS_SCALEVALUE_XY | AJC3DGS_SCALE_XY	 | AJC3DGS_RECTSCALE)


//--------------------------------------------------------------------------------------------------------------//
//	コントロールのプロパティ																					//
//--------------------------------------------------------------------------------------------------------------//
//----- アイテム情報 -------------------------------------------------------------------------------------------//
#define	AJC3DG_MAXITEM		16

typedef struct {
	UI			MaxPlot;				//	最大プロット数
	COLORREF	rgbP, rgbN;				//	表示色
} AJCG3DITEM, *PAJCG3DITEM;

//----- 軸描画情報 ---------------------------------------------------------------------------------------------//
#define	AJC3DG_MAXAXIS		3
typedef struct {
	COLORREF	rgbP, rgbN;				//	表示色
} AJC3DGAXIS, *PAJC3DGAXIS;

//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	AJC3DVEC	Rot;					//	回転角度[度]
	AJC3DVEC	Cent;					//	中心位置
	double		xr, yr, zr;				//	各軸の半径
	double		ratio;					//	視野に対する半径の割合
	UI			PlotSize;				//	プロット点の大きさ
	UI			PlotSizeE;				//	プロット最終点の大きさ
	BOOL		fPlotLine;				//	プロット線描画フラグ
	BOOL		fAspect1;				//	アスペクト比を１に保つ
	AJC3DGAXIS	axis[AJC3DG_MAXAXIS];	//	軸描画情報
	AJCG3DITEM	Item[AJC3DG_MAXITEM];	//	各アイテムの情報
} AJC3DGPROP, *PAJC3DGPROP;
typedef const AJC3DGPROP *PCAJC3DGPROP;

typedef AJC3DGPROP	 AJC2DGPROP;
typedef PAJC3DGPROP  PAJC2DGPROP;
typedef PCAJC3DGPROP PCAJC2DGPROP;


//--------------------------------------------------------------------------------------------------------------//
//	プロットリスト通知情報																						//
//--------------------------------------------------------------------------------------------------------------//
#define	AJC3DGMAX_PLOTLIST	64		// 最大プロット情報通知数

typedef struct {
	UI			id;		//	ＩＤ＃
	UI			ix;		//	バッファ先頭からの位置（０～）
	AJC3DVEC	vec;	//	３Ｄベクトル値
} AJC3DGPLITEM, *PAJC3DGPLITEM;
typedef const AJC3DGPLITEM *PCAJC3DGPLITEM;

typedef struct {
	UI		max;	//	実際のプロット情報の個数
	UI		num;	//	通知するプロット情報の個数（１～AJC3DGMAX_PLOTLIST）
	AJC3DGPLITEM	lst[AJC3DGMAX_PLOTLIST];
} AJC3DGPLOTLIST, *PAJC3DGPLOTLIST;
typedef const AJC3DGPLOTLIST *PCAJC3DGPLOTLIST;

//--------------------------------------------------------------------------------------------------------------//
//	右クリック通知情報																							//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	int			x;									//	カーソルｘ座標
	int			y;									//	カーソルｙ座標
	BOOL		fShift;								//	SHIFTキー押下フラグ
	BOOL		fCtrl;								//	CTRL キー押下フラグ
} AJC3DGRCLK, *PAJC3DGRCLK;
typedef const AJC3DGRCLK *PCAJC3DGRCLK;

//--------------------------------------------------------------------------------------------------------------//
//	コントロールのメッセージ																					//
//--------------------------------------------------------------------------------------------------------------//
#define	AJC3DGM_NEEDNTC_ANGLE 	(WM_APP + 90)	//	アングル通知要（内部使用）

//--------------------------------------------------------------------------------------------------------------//
//	コントロールの通知コード(WM_COMMAND)																		//
//--------------------------------------------------------------------------------------------------------------//
#define	AJC3DGN_ROTTHETA	(WM_APP + 20)		//	視点角度通知			－					PAJC3DVEC
#define	AJC3DGN_PLOTLIST	(WM_APP + 21)		//	プロットリスト通知		－					PAJC3DGPLOTLIST
#define	AJC3DGN_CLEAR		(WM_APP + 22)		//	データクリアー通知		－					クリアーした内容
	#define	AJC3DG_CLEAR_PLOT	0x01			//												・プロットデータクリアー
	#define	AJC3DG_CLEAR_DATA	0x02			//												・描画データクリアー
#define	AJC3DGN_DBLCLK		(WM_APP + 23)		//	ダブルクリック通知		－					－
#define	AJC3DGN_DROPFILE	(WM_APP + 24)		//	ファイルドロップ通知	－					ファイル数
#define	AJC3DGN_DROPDIR		(WM_APP + 25)		//	フォルダドロップ通知	－					ディレクトリ数
#define	AJC3DGN_RCLICK		(WM_APP + 26)		//	右クリック通知			－					PAJC3DGRCLK

//--------------------------------------------------------------------------------------------------------------//
//	３Ｄ平面アングル（マッピングする軸と、値の昇順／降順）														//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCG3DAXIS_DIR_XP,		//	Ｘ軸昇順
	AJCG3DAXIS_DIR_YP,		//	Ｙ軸 〃 
	AJCG3DAXIS_DIR_ZP,		//	Ｚ軸 〃 
	AJCG3DAXIS_DIR_XM,		//	Ｘ軸降順
	AJCG3DAXIS_DIR_YM,		//	Ｙ軸 〃 
	AJCG3DAXIS_DIR_ZM,		//	Ｚ軸 〃 
} AJCG3DAXIS_DIR;

//--------------------------------------------------------------------------------------------------------------//
//	２Ｄ平面アングル（マッピングする軸と、値の昇順／降順）														//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCG2DAXIS_DIR_XP	= AJCG3DAXIS_DIR_XP,		//	Ｘ軸昇順
	AJCG2DAXIS_DIR_YP	= AJCG3DAXIS_DIR_YP,		//	Ｙ軸 〃 
	AJCG2DAXIS_DIR_XM	= AJCG3DAXIS_DIR_XM,		//	Ｘ軸降順
	AJCG2DAXIS_DIR_YM	= AJCG3DAXIS_DIR_YM,		//	Ｙ軸 〃 
} AJCG2DAXIS_DIR;

//--------------------------------------------------------------------------------------------------------------//
//	テキスト描画方法																							//
//--------------------------------------------------------------------------------------------------------------//
//----- ３Ｄ ---------------------------------------------------------------------------------------------------//
typedef enum {
	AJCG3DTXOMD_RIGHT			,		//	点の右側
	AJCG3DTXOMD_LEFT			,		//	 〃 左側
	AJCG3DTXOMD_CENTER			,		//	 〃 中央
	AJCG3DTXOMD_BELLOW_RIGHT	,		//	点の下の右側
	AJCG3DTXOMD_BELLOW_LEFT		,		//	 〃     左側
	AJCG3DTXOMD_BELLOW_CENTER	,		//	 〃     中央
	AJCG3DTXOMD_ABOVE_RIGHT		,		//	点の上の右側
	AJCG3DTXOMD_ABOVE_LEFT		,		//	 〃     左側
	AJCG3DTXOMD_ABOVE_CENTER	,		//	 〃     中央
} AJCG3DTXOMD;
//----- ２Ｄ ---------------------------------------------------------------------------------------------------//
typedef enum {
	AJCG2DTXOMD_RIGHT			=	AJCG3DTXOMD_RIGHT			,	//	点の右側
	AJCG2DTXOMD_LEFT			=	AJCG3DTXOMD_LEFT			,	//	 〃 左側
	AJCG2DTXOMD_CENTER			=	AJCG3DTXOMD_CENTER			,	//	 〃 中央
	AJCG2DTXOMD_BELLOW_RIGHT	=	AJCG3DTXOMD_BELLOW_RIGHT	,	//	点の下の右側
	AJCG2DTXOMD_BELLOW_LEFT		=	AJCG3DTXOMD_BELLOW_LEFT		,	//	  〃    左側
	AJCG2DTXOMD_BELLOW_CENTER	=	AJCG3DTXOMD_BELLOW_CENTER	,	//	  〃    中央
	AJCG2DTXOMD_ABOVE_RIGHT		=	AJCG3DTXOMD_ABOVE_RIGHT		,	//	点の上の右側
	AJCG2DTXOMD_ABOVE_LEFT		=	AJCG3DTXOMD_ABOVE_LEFT		,	//	  〃    左側
	AJCG2DTXOMD_ABOVE_CENTER	=	AJCG3DTXOMD_ABOVE_CENTER	,	//	  〃    中央
} AJCG2DTXOMD;


//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
//----- 旧名称と互換維持 ---------------------------------------------------------------------------------------//
#define		AjcG3dClearAll		AjcG3dClearAllData
#define		AjcG2dClearAll		AjcG2dClearAllData

//----- ３Ｄファンクション -------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI		AjcG3dInit		   (HWND hwnd, double x1, double y1, double z1, double x2, double y2, double z2, UI style);
AJCEXPORT	BOOL	WINAPI		AjcG3dInitV		   (HWND hwnd, PCAJC3DVEC pLo, PAJC3DVEC pHi, PAJC3DVEC pRot, UI style);
AJCEXPORT	BOOL	WINAPI		AjcG3dSetProp	   (HWND hwnd, PCAJC3DGPROP pProp);
AJCEXPORT	BOOL	WINAPI		AjcG3dGetProp	   (HWND hwnd, PAJC3DGPROP	pBuf);

AJCEXPORT	BOOL	WINAPI		AjcG3dAdjustRange  (HWND hwnd);
AJCEXPORT	BOOL	WINAPI		AjcG3dSetRange	   (HWND hwnd, double x1, double y1, double z1, double x2, double y2, double z2);
AJCEXPORT	BOOL	WINAPI		AjcG3dSetCenter    (HWND hwnd, double xc, double yc, double zc);
AJCEXPORT	BOOL	WINAPI		AjcG3dSetWidth	   (HWND hwnd, double xr, double yr, double zr);
AJCEXPORT	BOOL	WINAPI		AjcG3dSetSameRangeWidth(HWND hwnd);
AJCEXPORT	BOOL	WINAPI		AjcG3dSetFixedAspect   (HWND hwnd, BOOL fFixed);

AJCEXPORT	BOOL	WINAPI		AjcG3dSetColor	   (HWND hwnd, UI id, COLORREF rgbP, COLORREF rgbN);
AJCEXPORT	BOOL	WINAPI		AjcG3dSetPlotNumber(HWND hwnd, UI id, UI PlotNumber);
AJCEXPORT	BOOL	WINAPI		AjcG3dSetPlotSize  (HWND hwnd, UI id, UI PixelSize, UI PixelSizeE);

AJCEXPORT	BOOL	WINAPI		AjcG3dPutPlotData  (HWND hwnd, UI id, double x, double y, double z);
AJCEXPORT	BOOL	WINAPI		AjcG3dPutPlotDataV (HWND hwnd, UI id, PCAJC3DVEC pPoint);
AJCEXPORT	BOOL	WINAPI		AjcG3dPixel 	   (HWND hwnd, UI id, double x , double y , double z , UI PixelSize);
AJCEXPORT	BOOL	WINAPI		AjcG3dPixelV 	   (HWND hwnd, UI id, PCAJC3DVEC pPoint, UI PixelSize);
AJCEXPORT	BOOL	WINAPI		AjcG3dLine		   (HWND hwnd, UI id, double x1, double y1, double z1, double x2, double y2, double z2);
AJCEXPORT	BOOL	WINAPI		AjcG3dLineV		   (HWND hwnd, UI id, PCAJC3DVEC p1, PCAJC3DVEC p2);
AJCEXPORT	BOOL	WINAPI		AjcG3dMoveTo	   (HWND hwnd, UI id, double x, double y, double z);
AJCEXPORT	BOOL	WINAPI		AjcG3dMoveToV	   (HWND hwnd, UI id, PCAJC3DVEC ps);
AJCEXPORT	BOOL	WINAPI		AjcG3dLineTo	   (HWND hwnd, UI id, double x, double y, double z);
AJCEXPORT	BOOL	WINAPI		AjcG3dLineToV	   (HWND hwnd, UI id, PCAJC3DVEC pe);
AJCEXPORT	BOOL	WINAPI		AjcG3dArrow		   (HWND hwnd, UI id, double x1, double y1, double z1, double x2, double y2, double z2);
AJCEXPORT	BOOL	WINAPI		AjcG3dArrowV	   (HWND hwnd, UI id, PCAJC3DVEC p1, PCAJC3DVEC p2);
AJCEXPORT	BOOL	WINAPI		AjcG3dArrowTo	   (HWND hwnd, UI id, double x, double y, double z);
AJCEXPORT	BOOL	WINAPI		AjcG3dArrowToV	   (HWND hwnd, UI id, PCAJC3DVEC pe);
AJCEXPORT	BOOL	WINAPI		AjcG3dTriangle	   (HWND hwnd, UI id, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3);
AJCEXPORT	BOOL	WINAPI		AjcG3dTriangleV	   (HWND hwnd, UI id, PCAJC3DVEC p1, PCAJC3DVEC p2, PCAJC3DVEC p3);
AJCEXPORT	BOOL	WINAPI		AjcG3dSquare	   (HWND hwnd, UI id, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4);
AJCEXPORT	BOOL	WINAPI		AjcG3dSquareV	   (HWND hwnd, UI id, PCAJC3DVEC p1, PCAJC3DVEC p2, PCAJC3DVEC p3, PCAJC3DVEC p4);
AJCEXPORT	BOOL	WINAPI		AjcG3dCube		   (HWND hwnd, UI id, double xc, double yc, double zc, double xr, double yr, double zr, UI division);
AJCEXPORT	BOOL	WINAPI		AjcG3dCubeV		   (HWND hwnd, UI id, PCAJC3DVEC pCent, double xr, double yr, double zr, UI division);
AJCEXPORT	BOOL	WINAPI		AjcG3dSphere	   (HWND hwnd, UI id, double xc, double yc, double zc, double xr, double yr, double zr, UI slice, UI stack);
AJCEXPORT	BOOL	WINAPI		AjcG3dSphereV	   (HWND hwnd, UI id, PCAJC3DVEC pCent, double rx, double ry, double rz, UI slice, UI stack);
AJCEXPORT	BOOL	WINAPI		AjcG3dDefPlane	   (HWND hwnd, UI id, double xc, double yc, double zc, double xv, double yv, double zv, double xo, double yo, double zo);
AJCEXPORT	BOOL	WINAPI		AjcG3dDefPlaneV	   (HWND hwnd, UI id, PCAJC3DLVEC pLVec, PCAJC3DVEC pVOrg);

AJCEXPORT	BOOL	WINAPI		AjcG3dSetAngle	   (HWND hwnd, double rtx, double rty, double rtz);
AJCEXPORT	BOOL	WINAPI		AjcG3dSetAngleV	   (HWND hwnd, PCAJC3DVEC pVSiten);

AJCEXPORT	BOOL	WINAPI		AjcG3dSetAngleXY   (HWND hwnd);
AJCEXPORT	BOOL	WINAPI		AjcG3dSetAngleXZ   (HWND hwnd);
AJCEXPORT	BOOL	WINAPI		AjcG3dSetAngleYZ   (HWND hwnd);
AJCEXPORT	BOOL	WINAPI		AjcG3dSetAngle3D   (HWND hwnd);
AJCEXPORT	BOOL	WINAPI		AjcG3dSetPlane	   (HWND hwnd, AJCG3DAXIS_DIR HoriAxis, AJCG3DAXIS_DIR VertAxis);

AJCEXPORT	HBITMAP	WINAPI		AjcG3dGetBitmap    (HWND hwnd);

AJCEXPORT	BOOL	WINAPI		AjcG3dLoadPropA 	(HWND hwnd, C_BCP pProfileSect, PCAJC3DGPROP pDefProp);
AJCEXPORT	BOOL	WINAPI		AjcG3dLoadPropW 	(HWND hwnd, C_WCP pProfileSect, PCAJC3DGPROP pDefProp);

AJCEXPORT	BOOL	WINAPI		AjcG3dSavePropA 	(HWND hwnd, C_BCP pProfileSect);
AJCEXPORT	BOOL	WINAPI		AjcG3dSavePropW 	(HWND hwnd, C_WCP pProfileSect);

AJCEXPORT	BOOL	WINAPI		AjcG3dLoadPropExA	(HWND hwnd, C_BCP pProfileSect, PCAJC3DGPROP pDefProp);
AJCEXPORT	BOOL	WINAPI		AjcG3dLoadPropExW	(HWND hwnd, C_WCP pProfileSect, PCAJC3DGPROP pDefProp);

AJCEXPORT	BOOL	WINAPI		AjcG3dSavePropExA	(HWND hwnd, C_BCP pProfileSect);
AJCEXPORT	BOOL	WINAPI		AjcG3dSavePropExW	(HWND hwnd, C_WCP pProfileSect);


AJCEXPORT	HFONT	WINAPI		AjcG3dSetTextFont	(HWND hwnd, HFONT hFont);

AJCEXPORT	UI		WINAPI		AjcG3dTextOutA		(HWND hwnd, int x, int y, C_BCP pTxt);
AJCEXPORT	UI		WINAPI		AjcG3dTextOutW		(HWND hwnd, int x, int y, C_WCP pTxt);

AJCEXPORT	UI		WINAPI		AjcG3dPrintFA		(HWND hwnd, int x, int y, C_BCP pFmt, ...);
AJCEXPORT	UI		WINAPI		AjcG3dPrintFW		(HWND hwnd, int x, int y, C_WCP pFmt, ...);

AJCEXPORT	UI		WINAPI		AjcG3dTextOutVA		(HWND hwnd, AJCG3DTXOMD md, PCAJC3DVEC pV, C_BCP pTxt);
AJCEXPORT	UI		WINAPI		AjcG3dTextOutVW		(HWND hwnd, AJCG3DTXOMD md, PCAJC3DVEC pV, C_WCP pTxt);

AJCEXPORT	UI		WINAPI		AjcG3dPrintFVA		(HWND hwnd, AJCG3DTXOMD md, PCAJC3DVEC pV, C_BCP pFmt, ...);
AJCEXPORT	UI		WINAPI		AjcG3dPrintFVW		(HWND hwnd, AJCG3DTXOMD md, PCAJC3DVEC pV, C_WCP pFmt, ...);

AJCEXPORT	UI		WINAPI		AjcG3dGetTextA		(HWND hwnd, UI key, BCP pBuf, UI lBuf);
AJCEXPORT	UI		WINAPI		AjcG3dGetTextW		(HWND hwnd, UI key, WCP pBuf, UI lBuf);

AJCEXPORT	BOOL	WINAPI		AjcG3dClearShape	(HWND hwnd, UI id);
AJCEXPORT	BOOL	WINAPI		AjcG3dClearAllShape	(HWND hwnd);
AJCEXPORT	BOOL	WINAPI		AjcG3dClearPlot		(HWND hwnd, UI id);
AJCEXPORT	BOOL	WINAPI		AjcG3dClearAllPlot	(HWND hwnd);
AJCEXPORT	BOOL	WINAPI		AjcG3dClearText		(HWND hwnd, UI key);
AJCEXPORT	BOOL	WINAPI		AjcG3dClearAllText	(HWND hwnd);
AJCEXPORT	BOOL	WINAPI		AjcG3dClearData		(HWND hwnd, UI id);
AJCEXPORT	BOOL	WINAPI		AjcG3dClearAllData	(HWND hwnd);
AJCEXPORT	BOOL	WINAPI		AjcG3dClear			(HWND hwnd);


//----- ２Ｄファンクション -------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI		AjcG2dInit		   (HWND hwnd, double x1, double y1, double x2, double y2, UI style);
AJCEXPORT	BOOL	WINAPI		AjcG2dInitV		   (HWND hwnd, PCAJC2DVEC pLo, PCAJC2DVEC pHi, UI style);
AJCEXPORT	BOOL	WINAPI		AjcG2dSetPlane	   (HWND hwnd, AJCG2DAXIS_DIR HoriAxis, AJCG2DAXIS_DIR VertAxis);
AJCEXPORT	BOOL	WINAPI		AjcG2dSetProp	   (HWND hwnd, PCAJC2DGPROP pProp);
AJCEXPORT	BOOL	WINAPI		AjcG2dGetProp	   (HWND hwnd, PAJC2DGPROP	pBuf);

AJCEXPORT	BOOL	WINAPI		AjcG2dAdjustRange  (HWND hwnd);
AJCEXPORT	BOOL	WINAPI		AjcG2dSetRange	   (HWND hwnd, double x1, double y1, double x2, double y2);
AJCEXPORT	BOOL	WINAPI		AjcG2dSetCenter    (HWND hwnd, double xc, double yc);
AJCEXPORT	BOOL	WINAPI		AjcG2dSetWidth	   (HWND hwnd, double xr, double yr);
AJCEXPORT	BOOL	WINAPI		AjcG2dSetSameRangeWidth(HWND hwnd);
AJCEXPORT	BOOL	WINAPI		AjcG2dSetFixedAspect   (HWND hwnd, BOOL fFixed);

AJCEXPORT	BOOL	WINAPI		AjcG2dSetColor	   (HWND hwnd, UI id, COLORREF rgb);
AJCEXPORT	BOOL	WINAPI		AjcG2dSetPlotNumber(HWND hwnd, UI id, UI PlotNumber);
AJCEXPORT	BOOL	WINAPI		AjcG2dSetPlotSize  (HWND hwnd, UI id, UI PixelSize, UI PixelSizeE);

AJCEXPORT	BOOL	WINAPI		AjcG2dPutPlotData  (HWND hwnd, UI id, double x, double y);
AJCEXPORT	BOOL	WINAPI		AjcG2dPutPlotDataV (HWND hwnd, UI id, PCAJC2DVEC pPoint);

AJCEXPORT	HBITMAP	WINAPI		AjcG2dGetBitmap    (HWND hwnd);

AJCEXPORT	BOOL	WINAPI		AjcG2dLoadPropA 	(HWND hwnd, C_BCP pProfileSect, PCAJC2DGPROP pDefProp);
AJCEXPORT	BOOL	WINAPI		AjcG2dLoadPropW 	(HWND hwnd, C_WCP pProfileSect, PCAJC2DGPROP pDefProp);

AJCEXPORT	BOOL	WINAPI		AjcG2dSavePropA 	(HWND hwnd, C_BCP pProfileSect);
AJCEXPORT	BOOL	WINAPI		AjcG2dSavePropW 	(HWND hwnd, C_WCP pProfileSect);

AJCEXPORT	BOOL	WINAPI		AjcG2dLoadPropExA	(HWND hwnd, C_BCP pProfileSect, PCAJC2DGPROP pDefProp);
AJCEXPORT	BOOL	WINAPI		AjcG2dLoadPropExW	(HWND hwnd, C_WCP pProfileSect, PCAJC2DGPROP pDefProp);

AJCEXPORT	BOOL	WINAPI		AjcG2dSavePropExA	(HWND hwnd, C_BCP pProfileSect);
AJCEXPORT	BOOL	WINAPI		AjcG2dSavePropExW	(HWND hwnd, C_WCP pProfileSect);

AJCEXPORT	BOOL	WINAPI		AjcG2dFillB  		(HWND hwnd, UI idFill, UI idBorder, double x, double y);
AJCEXPORT	BOOL	WINAPI		AjcG2dFillBV		(HWND hwnd, UI idFill, UI idBorder, PCAJC2DVEC pPoint);
AJCEXPORT	BOOL	WINAPI		AjcG2dFillS			(HWND hwnd, UI idFill, double x, double y);
AJCEXPORT	BOOL	WINAPI		AjcG2dFillSV		(HWND hwnd, UI idFill, PCAJC2DVEC pPoint);

AJCEXPORT	COLORREF WINAPI		AjcG2dGetPixel		(HWND hwnd, double x, double y);
AJCEXPORT	COLORREF WINAPI		AjcG2dGetPixelV		(HWND hwnd, PCAJC2DVEC pPoint);


AJCEXPORT	HFONT	WINAPI		AjcG2dSetTextFont	(HWND hwnd, HFONT hFont);

AJCEXPORT	UI		WINAPI		AjcG2dTextOutA		(HWND hwnd, int x, int y, C_BCP pTxt);
AJCEXPORT	UI		WINAPI		AjcG2dTextOutW		(HWND hwnd, int x, int y, C_WCP pTxt);

AJCEXPORT	UI		WINAPI		AjcG2dPrintFA		(HWND hwnd, int x, int y, C_BCP pFmt, ...);
AJCEXPORT	UI		WINAPI		AjcG2dPrintFW		(HWND hwnd, int x, int y, C_WCP pFmt, ...);

AJCEXPORT	UI		WINAPI		AjcG2dTextOutVA		(HWND hwnd, AJCG2DTXOMD md, PCAJC2DVEC pV, C_BCP pTxt);
AJCEXPORT	UI		WINAPI		AjcG2dTextOutVW		(HWND hwnd, AJCG2DTXOMD md, PCAJC2DVEC pV, C_WCP pTxt);

AJCEXPORT	UI		WINAPI		AjcG2dPrintFVA		(HWND hwnd, AJCG2DTXOMD md, PCAJC2DVEC pV, C_BCP pFmt, ...);
AJCEXPORT	UI		WINAPI		AjcG2dPrintFVW		(HWND hwnd, AJCG2DTXOMD md, PCAJC2DVEC pV, C_WCP pFmt, ...);

AJCEXPORT	UI		WINAPI		AjcG2dGetTextA		(HWND hwnd, UI key, BCP pBuf, UI lBuf);
AJCEXPORT	UI		WINAPI		AjcG2dGetTextW		(HWND hwnd, UI key, WCP pBuf, UI lBuf);

AJCEXPORT	BOOL	WINAPI		AjcG2dClearShape	(HWND hwnd, UI id);
AJCEXPORT	BOOL	WINAPI		AjcG2dClearAllShape	(HWND hwnd);
AJCEXPORT	BOOL	WINAPI		AjcG2dClearPlot		(HWND hwnd, UI id);
AJCEXPORT	BOOL	WINAPI		AjcG2dClearAllPlot	(HWND hwnd);
AJCEXPORT	BOOL	WINAPI		AjcG2dClearText		(HWND hwnd, UI key);
AJCEXPORT	BOOL	WINAPI		AjcG2dClearAllText	(HWND hwnd);
AJCEXPORT	BOOL	WINAPI		AjcG2dClearData		(HWND hwnd, UI id);
AJCEXPORT	BOOL	WINAPI		AjcG2dClearAllData	(HWND hwnd);
AJCEXPORT	BOOL	WINAPI		AjcG2dClear			(HWND hwnd);


//----- 平面描画ファンクション（２Ｄ／３Ｄ共通） ---------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI		AjcG2dPixel  	   (HWND hwnd, UI id, double x, double y, UI PixelSize);
AJCEXPORT	BOOL	WINAPI		AjcG2dPixelV  	   (HWND hwnd, UI id, PCAJC2DVEC pPoint, UI PixelSize);
AJCEXPORT	BOOL	WINAPI		AjcG2dLine		   (HWND hwnd, UI id, double x1, double y1, double x2, double y2);
AJCEXPORT	BOOL	WINAPI		AjcG2dLineV		   (HWND hwnd, UI id, PCAJC2DVEC p1, PCAJC2DVEC p2);
AJCEXPORT	BOOL	WINAPI		AjcG2dMoveTo	   (HWND hwnd, UI id, double x, double y);
AJCEXPORT	BOOL	WINAPI		AjcG2dMoveToV	   (HWND hwnd, UI id, PCAJC2DVEC ps);
AJCEXPORT	BOOL	WINAPI		AjcG2dLineTo	   (HWND hwnd, UI id, double x, double y);
AJCEXPORT	BOOL	WINAPI		AjcG2dLineToV	   (HWND hwnd, UI id, PCAJC2DVEC pe);
AJCEXPORT	BOOL	WINAPI		AjcG2dArrow		   (HWND hwnd, UI id, double x1, double y1, double x2, double y2);
AJCEXPORT	BOOL	WINAPI		AjcG2dArrowV	   (HWND hwnd, UI id, PCAJC2DVEC p1, PCAJC2DVEC p2);
AJCEXPORT	BOOL	WINAPI		AjcG2dArrowTo	   (HWND hwnd, UI id, double x, double y);
AJCEXPORT	BOOL	WINAPI		AjcG2dArrowToV	   (HWND hwnd, UI id, PCAJC2DVEC pe);
AJCEXPORT	BOOL	WINAPI		AjcG2dTriangle	   (HWND hwnd, UI id, double x1, double y1, double x2, double y2, double x3, double y3);
AJCEXPORT	BOOL	WINAPI		AjcG2dTriangleV	   (HWND hwnd, UI id, PCAJC2DVEC p1, PCAJC2DVEC p2, PCAJC2DVEC p3);
AJCEXPORT	BOOL	WINAPI		AjcG2dSquare	   (HWND hwnd, UI id, double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4);
AJCEXPORT	BOOL	WINAPI		AjcG2dSquareV	   (HWND hwnd, UI id, PCAJC2DVEC p1, PCAJC2DVEC p2, PCAJC2DVEC p3, PCAJC2DVEC p4);
AJCEXPORT	BOOL	WINAPI		AjcG2dRectangle    (HWND hwnd, UI id, double x1, double y1, double x2, double y2);
AJCEXPORT	BOOL	WINAPI		AjcG2dRectangleV   (HWND hwnd, UI id, PCAJC2DVEC p1, PCAJC2DVEC p2);
AJCEXPORT	BOOL	WINAPI		AjcG2dEllipse	   (HWND hwnd, UI id, double xc, double yc, double rx, double ry);
AJCEXPORT	BOOL	WINAPI		AjcG2dEllipseV	   (HWND hwnd, UI id, PCAJC2DVEC pCent, double rx, double ry);
AJCEXPORT	BOOL	WINAPI		AjcG2dStar         (HWND hwnd, UI id, double xc, double yc, double r);
AJCEXPORT	BOOL	WINAPI		AjcG2dStarV        (HWND hwnd, UI id, PCAJC2DVEC pCent    , double r);
AJCEXPORT	BOOL	WINAPI		AjcG2dStarEx       (HWND hwnd, UI id, double xc, double yc, double r1, double r2, UI nVertex, double rot, BOOL fInscribedLine);
AJCEXPORT	BOOL	WINAPI		AjcG2dStarVEx	   (HWND hwnd, UI id, PCAJC2DVEC pCent    , double r1, double r2, UI nVertex, double rot, BOOL fInscribedLine);

//----- ２Ｄ／３Ｄ共通ファンクション ---------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI		AjcG3dEnablePopupMenu(HWND hwnd, BOOL fEnable);		//	非公開
AJCEXPORT	BOOL	WINAPI		AjcG3dSetNtcRClk	 (HWND hwnd, BOOL fNtcRClk, UI MsgRBDown, UI MsgRBUp);

AJCEXPORT	BOOL	WINAPI		AjcG3dSetTipTextA	(HWND hwnd, C_BCP pTxt);
AJCEXPORT	BOOL	WINAPI		AjcG3dSetTipTextW	(HWND hwnd, C_WCP pTxt);

AJCEXPORT	UI		WINAPI		AjcG3dGetTipTextA	(HWND hwnd, BCP pBuf, UI lBuf);
AJCEXPORT	UI		WINAPI		AjcG3dGetTipTextW	(HWND hwnd, WCP pBuf, UI lBuf);

AJCEXPORT	BOOL	WINAPI		AjcG3dSetChkBoxTipTextA(HWND hwnd, UI n, C_BCP pTxt);
AJCEXPORT	BOOL	WINAPI		AjcG3dSetChkBoxTipTextW(HWND hwnd, UI n, C_WCP pTxt);

AJCEXPORT	UI		WINAPI		AjcG3dGetChkBoxTipTextA(HWND hwnd, UI n, BCP pBuf, UI lBuf);
AJCEXPORT	UI		WINAPI		AjcG3dGetChkBoxTipTextW(HWND hwnd, UI n, WCP pBuf, UI lBuf);

AJCEXPORT	BOOL	WINAPI		AjcG3dSetTipShowAlways(HWND hwnd, BOOL fShowAlways);
AJCEXPORT	BOOL	WINAPI		AjcG3dGetTipShowAlways(HWND hwnd);

AJCEXPORT	BOOL	WINAPI		AjcG3dSetChkBoxTipShowAlways(HWND hwnd, UI n, BOOL fShowAlways);
AJCEXPORT	BOOL	WINAPI		AjcG3dGetChkBoxTipShowAlways(HWND hwnd, UI n);

AJCEXPORT	BOOL	WINAPI		AjcG3dSetTipShowAlwaysAll(HWND hwnd, BOOL fShowAlways);

AJCEXPORT	BOOL	WINAPI		AjcG3dSetFilter 	(HWND hwnd, UI n, BOOL state);
AJCEXPORT	BOOL	WINAPI		AjcG3dGetFilter 	(HWND hwnd, UI n);

AJCEXPORT	BOOL	WINAPI		AjcG3dGetDroppedFileA(HWND hwnd, BC buf[MAX_PATH]);
AJCEXPORT	BOOL	WINAPI		AjcG3dGetDroppedFileW (HWND hwnd, WC buf[MAX_PATH]);

AJCEXPORT	BOOL	WINAPI		AjcG3dGetDroppedDirA  (HWND hwnd, BC buf[MAX_PATH]);
AJCEXPORT	BOOL	WINAPI		AjcG3dGetDroppedDirW  (HWND hwnd, WC buf[MAX_PATH]);

AJCEXPORT	BOOL	WINAPI		AjcG3dGetDroppedDirExA(HWND hwnd, BC buf[MAX_PATH], BOOL fTailIsDelimiter);
AJCEXPORT	BOOL	WINAPI		AjcG3dGetDroppedDirExW(HWND hwnd, WC buf[MAX_PATH], BOOL fTailIsDelimiter);

AJCEXPORT	BOOL	WINAPI		AjcG3dSetTitleTextA(HWND hwnd, C_BCP pTitleText, COLORREF TextColor, COLORREF BackColor, HFONT hFont);
AJCEXPORT	BOOL	WINAPI		AjcG3dSetTitleTextW(HWND hwnd, C_WCP pTitleText, COLORREF TextColor, COLORREF BackColor, HFONT hFont);

AJCEXPORT	BOOL	WINAPI		AjcG3dPause(HWND hwnd, BOOL fPause);

AJCEXPORT	BOOL	WINAPI		AjcG3dEnableMesDraw(HWND hwnd, BOOL fEnable);

AJCEXPORT	HWND	WINAPI		AjcG3dGetMainWindow(HWND hwnd, COLORREF *pBkGnd);


//----- 通知情報取得 -------------------------------------------------------------------------------------------//
AJCEXPORT	PAJC3DVEC		WINAPI		AjcG3dGetNtcRotTheta(HWND hwnd);
AJCEXPORT	PAJC3DGRCLK		WINAPI		AjcG3dGetNtcRClk	(HWND hwnd);
AJCEXPORT	UI				WINAPI		AjcG3dGetNtcClrFact	(HWND hwnd);
AJCEXPORT	UI				WINAPI		AjcG3dGetNtcDirs	(HWND hwnd);
AJCEXPORT	UI				WINAPI		AjcG3dGetNtcFiles	(HWND hwnd);
AJCEXPORT	PAJC3DGPLOTLIST	WINAPI		AjcG3dGetNtcList	(HWND hwnd);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用ウインド生成																						//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJCEXPORT HWND WINAPI AjcG3dCreateForMSIL(HWND hOwner,	VO (CALLBACK *cbFileDrop)(UI n	 ),
														VO (CALLBACK *cbDirDrop )(UI n	 ),
														VO (CALLBACK *cbRClick	)(int x, int y, BOOL shift, BOOL ctrl),
														VO (CALLBACK *cbPltLst	)(int max, int num, PAJC3DGPLITEM pItem));

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用スタイルの設定／取得関数																			//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//----- 方眼スケール表示					(AJC3DGS_RECTSCALE) ------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcG3dGetSty_RECTSCALE	(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcG3dSetSty_RECTSCALE	(HWND hwnd, BOOL f);

//----- Ｘ軸スケール値表示					(AJC3DGS_SCALEVALUE_X) ---------------------------------------------//
AJCEXPORT BOOL WINAPI AjcG3dGetSty_SCALEVALUE_X (HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcG3dSetSty_SCALEVALUE_X	(HWND hwnd, BOOL f);

//----- Ｙ軸スケール値表示					(AJC3DGS_SCALEVALUE_Y) ---------------------------------------------//
AJCEXPORT BOOL WINAPI AjcG3dGetSty_SCALEVALUE_Y (HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcG3dSetSty_SCALEVALUE_Y	(HWND hwnd, BOOL f);

//----- Ｚ軸スケール値表示					(AJC3DGS_SCALEVALUE_Z) ---------------------------------------------//
AJCEXPORT BOOL WINAPI AjcG3dGetSty_SCALEVALUE_Z (HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcG3dSetSty_SCALEVALUE_Z	(HWND hwnd, BOOL f);

//----- 同心円スケール表示					(AJC3DGS_ELPSSCALE) ------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcG3dGetSty_ELPSSCALE	(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcG3dSetSty_ELPSSCALE	(HWND hwnd, BOOL f);

//----- ＸＹ平面スケール表示				(AJC3DGS_SCALE_XY) -------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcG3dGetSty_SCALE_XY		(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcG3dSetSty_SCALE_XY		(HWND hwnd, BOOL f);

//----- ＸＺ平面スケール表示				(AJC3DGS_SCALE_XZ) -------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcG3dGetSty_SCALE_XZ		(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcG3dSetSty_SCALE_XZ		(HWND hwnd, BOOL f);

//----- ＹＺ平面スケール表示				(AJC3DGS_SCALE_YZ) -------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcG3dGetSty_SCALE_YZ		(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcG3dSetSty_SCALE_YZ		(HWND hwnd, BOOL f);


//----- 奥行表現の許可／禁止				(AJC3DGS_NODEPTHCTRL) ----------------------------------------------//
AJCEXPORT BOOL WINAPI AjcG3dGetSty_NODEPTHCTRL	(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcG3dSetSty_NODEPTHCTRL	(HWND hwnd, BOOL f);

//----- コントロールの外枠・非表示／表示	(AJC3DGS_NOBORDER) -------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcG3dGetSty_NOBORDER		(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcG3dSetSty_NOBORDER		(HWND hwnd, BOOL f);

//----- フィルタ非表示／表示				(AJC3DGS_NOFILTER) -------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcG3dGetSty_NOFILTER		(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcG3dSetSty_NOFILTER		(HWND hwnd, BOOL f);

//----- 視点設定／ドラッグ　許可／禁止		(AJC3DGS_NOANGLE) --------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcG3dGetSty_NOANGLE		(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcG3dSetSty_NOANGLE		(HWND hwnd, BOOL f);


//----- 球体スケール表示					(AJC3DGS_SPHERESCALE) ----------------------------------------------//
AJCEXPORT BOOL WINAPI AjcG3dGetSty_SPHERESCALE	(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcG3dSetSty_SPHERESCALE	(HWND hwnd, BOOL f);

//----- Ｘ軸表示							(AJC3DGS_SHOWAXIS_X) -----------------------------------------------//
AJCEXPORT BOOL WINAPI AjcG3dGetSty_SHOWAXIS_X	(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcG3dSetSty_SHOWAXIS_X	(HWND hwnd, BOOL f);

//----- Ｙ軸表示							(AJC3DGS_SHOWAXIS_Y) -----------------------------------------------//
AJCEXPORT BOOL WINAPI AjcG3dGetSty_SHOWAXIS_Y	(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcG3dSetSty_SHOWAXIS_Y	(HWND hwnd, BOOL f);

//----- Ｚ軸表示							(AJC3DGS_SHOWAXIS_Z) -----------------------------------------------//
AJCEXPORT BOOL WINAPI AjcG3dGetSty_SHOWAXIS_Z	(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcG3dSetSty_SHOWAXIS_Z	(HWND hwnd, BOOL f);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用プロパティの設定／取得関数																		//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//----- 回転角度Ｘ 							(Rot.x) ------------------------------------------------------------//
AJCEXPORT double WINAPI AjcG3dGetProp_Rot_x		(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcG3dSetProp_Rot_x		(HWND hwnd, double n);

//----- 回転角度Ｙ 							(Rot.y) ------------------------------------------------------------//
AJCEXPORT double WINAPI AjcG3dGetProp_Rot_y		(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcG3dSetProp_Rot_y		(HWND hwnd, double n);

//----- 回転角度Ｚ 							(Rot.z) ------------------------------------------------------------//
AJCEXPORT double WINAPI AjcG3dGetProp_Rot_z		(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcG3dSetProp_Rot_z		(HWND hwnd, double n);

//----- 中心位置Ｘ 							(Cent.x) -----------------------------------------------------------//
AJCEXPORT double WINAPI AjcG3dGetProp_Cent_x	(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcG3dSetProp_Cent_x	(HWND hwnd, double n);

//----- 中心位置Ｙ 							(Cent.y) -----------------------------------------------------------//
AJCEXPORT double WINAPI AjcG3dGetProp_Cent_y	(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcG3dSetProp_Cent_y	(HWND hwnd, double n);

//----- 中心位置Ｚ 							(Cent.z) -----------------------------------------------------------//
AJCEXPORT double WINAPI AjcG3dGetProp_Cent_z	(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcG3dSetProp_Cent_z	(HWND hwnd, double n);

//----- 半径Ｘ 								(xr) ---------------------------------------------------------------//
AJCEXPORT double WINAPI AjcG3dGetProp_xr		(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcG3dSetProp_xr		(HWND hwnd, double n);

//----- 半径Ｙ 								(yr) ---------------------------------------------------------------//
AJCEXPORT double WINAPI AjcG3dGetProp_yr		(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcG3dSetProp_yr		(HWND hwnd, double n);

//----- 半径Ｚ 								(zr) ---------------------------------------------------------------//
AJCEXPORT double WINAPI AjcG3dGetProp_zr		(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcG3dSetProp_zr		(HWND hwnd, double n);

//----- ビューボリュームの割合 				(ratio) ------------------------------------------------------------//
AJCEXPORT double WINAPI AjcG3dGetProp_ratio		(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcG3dSetProp_ratio		(HWND hwnd, double n);

//----- プロットデータのピクセルサイズ		(PlotSize) ---------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcG3dGetProp_PlotSize	(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcG3dSetProp_PlotSize	(HWND hwnd, UI n);

//----- 最終プロットデータのピクセルサイズ	(PlotSizeE) --------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcG3dGetProp_PlotSizeE	(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcG3dSetProp_PlotSizeE	(HWND hwnd, UI n);

//----- プロットデータの結線				(PlotLine) ---------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcG3dGetProp_fPlotLine	(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcG3dSetProp_fPlotLine	(HWND hwnd, BOOL n);

//----- アスペクト１保持					(fAspect1) ---------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcG3dGetProp_fAspect1	(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcG3dSetProp_fAspect1	(HWND hwnd, BOOL n);

//----- 最大プロット数						(MaxPlot) ----------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcG3dGetProp_MaxPlot	(HWND hwnd, UI ix);
AJCEXPORT VO	 WINAPI AjcG3dSetProp_MaxPlot	(HWND hwnd, UI ix, UI n);

//----- 前面側プロット表示色				(rgbP) -------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcG3dGetProp_rgbP		(HWND hwnd, UI ix);
AJCEXPORT VO	 WINAPI AjcG3dSetProp_rgbP		(HWND hwnd, UI ix, UI n);

//----- 後面側プロット表示色				(rgbN) -------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcG3dGetProp_rgbN		(HWND hwnd, UI ix);
AJCEXPORT VO	 WINAPI AjcG3dSetProp_rgbN		(HWND hwnd, UI ix, UI n);

//----- ウインドサイズ -----------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcG3dSetProp_WndSize(HWND hwnd, UI width, UI height);

//----- ２Ｄモード設定 -----------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcG3dSetProp_Set2dMode(HWND hwnd);

//----- ファイル，フォルダ ドロップの許可／禁止 ----------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcG3dSetProp_AcceptFiles(HWND hwnd, BOOL fEnable);
AJCEXPORT BOOL WINAPI AjcG3dGetProp_AcceptFiles(HWND hwnd);

//----- AJC3DGN_PLOTLISTイベントにおけるプロット点情報取得 -----------------------------------------------------//
AJCEXPORT int WINAPI AjcG3dGetPlotEvtInfo(PAJC3DGPLITEM pItem, int ix, double *pX, double *pY, double *pZ);

//----- チップテキスト設定／取得 -------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcG3dSetTipTextForMSIL(HWND hwnd, C_WCP pTxt);
AJCEXPORT	UI		WINAPI	AjcG3dGetTipTextForMSIL(HWND hwnd, WCP pBuf, UI lBuf);
AJCEXPORT	BOOL	WINAPI	AjcG3dSetChkBoxTipTextForMSIL(HWND hwnd, UI n, C_WCP pTxt);
AJCEXPORT	UI		WINAPI	AjcG3dGetChkBoxTipTextForMSIL(HWND hwnd, UI n, WCP pBuf, UI lBuf);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬメソッド用関数																						//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//----- ２Ｄテキスト描画 ---------------------------------------------------------------------------------------//
AJCEXPORT	UI	WINAPI	AjcG3dTextOut2DForMSIL(HWND hwnd, AJCG2DTXOMD md, double x, double y, C_WCP pTxt);
//----- ３Ｄテキスト描画 ---------------------------------------------------------------------------------------//
AJCEXPORT	UI	WINAPI	AjcG3dTextOut3DForMSIL(HWND hwnd, AJCG3DTXOMD md, double x, double y, double z, C_WCP pTxt);

/****************************************************************************************************************/
#endif
