﻿#ifndef	AJCCTRLINPVAL_H_
#define	AJCCTRLINPVAL_H_
/****************************************************************************************************************/

//--------------------------------------------------------------------------------------------------------------//
//	コントロールのスタイル																						//
//--------------------------------------------------------------------------------------------------------------//
//							0x8000			//	Bit15  : -
//							0x4000			//	Bit14  : -
//							0x2000			//	Bit13  : -
#define	AJCIVS_DEFTIP		0x1000			//	Bit12  : デフォルトツールチップ表示

//							0x0800			//	Bit11  : -
#define	AJCIVS_AUTOEDIT		0x0400			//	Bit10  : フォーカスによる自動エディットモード
#define	AJCIVS_SHOWHEX		0x0200			//	Bit9   : １６進表示
#define	AJCIVS_NOBLINK		0x0100			//	Bit8   : ブリンクなし

#define	AJCIVS_NOBORDER		0x0080			//	Bit7   : 外枠非表示
#define	AJCIVS_NOSLD		0x0040			//	Bit6   : スライダ非表示
#define	AJCIVS_NOBTN		0x0020			//	Bit5   : ボタン非表示
#define	AJCIVS_NOSPN		0x0010			//	Bit4   : スピン非表示

#define	AJCIVS_SEPARATE		0x0008			//	Bit3   : 区切り記号挿入
#define	AJCIVS_REALMODE		0x0004			//	Bit2   : 実数モード

#define	AJCIVS_ALIGN		0x0003			//	Bit1-0 : テキストアライン
#define		AJCIVS_CENTER	0x0000			//				中央
#define		AJCIVS_LEFT		0x0001			//				左揃え
#define		AJCIVS_RIGHT	0x0002			//				右揃え

#define	AJCIVS_NOALL		(AJCIVS_NOSLD | AJCIVS_NOBTN | AJCIVS_NOSPN)
#define	AJCIVS_SLDONLY		(				AJCIVS_NOBTN | AJCIVS_NOSPN)
#define	AJCIVS_BTNONLY		(AJCIVS_NOSLD | 			   AJCIVS_NOSPN)
#define	AJCIVS_SPNONLY		(AJCIVS_NOSLD | AJCIVS_NOBTN			   )

//--------------------------------------------------------------------------------------------------------------//
//	コントロールのプロパティ																					//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	double	min;			//	レンジ最小値
	double	max;			//	レンジ最大値
	double	SldUnit;		//	数値の最小単位
	double	SldPage;		//	スライダのページサイズ
	double	SpnStep;		//	スピンボタンのステップ数
	UI		TextLen;		//	テキストの桁数
	SW		Precision;		//	小数部の桁数（負数の場合は有効桁数）
	SW		HexLen;			//	１６進数表示桁数
} AJCIVPROP, *PAJCIVPROP;
typedef const AJCIVPROP *PCAJCIVPROP;

//--------------------------------------------------------------------------------------------------------------//
//	コントロールのメッセージ																					//
//--------------------------------------------------------------------------------------------------------------//
//																		wParam				lParam
#define	AJCIVM_SETTEXTFORMAT	(WM_APP + 1)	//	書式設定			テキスト長			小数部の桁数
#define	AJCIVM_GETPROP			(WM_APP + 2)	//	プロパティ取得		PAJCIVPROP			－
#define	AJCIVM_SETPROP			(WM_APP + 3)	//	プロパティ設定		PAJCIVPROP			－
#define	AJCIVM_GETBORDERCOLOR	(WM_APP + 4)	//	ボーダー色取得		－					－
#define	AJCIVM_SETBORDERCOLOR	(WM_APP + 5)	//	ボーダー色設定		色コード			－
#define	AJCIVM_GETBLINKCOLOR	(WM_APP + 6)	//	ブリンク色取得		－					－
#define	AJCIVM_SETBLINKCOLOR	(WM_APP + 7)	//	ブリンク色設定		色コード			－
#define	AJCIVM_GETSLDHANDLE		(WM_APP + 8)	//	スライダハンドル	－					－
#define	AJCIVM_GETTXTHANDLE		(WM_APP + 9)	//	テキストハンドル	－					－
#define	AJCIVM_GETBTNHANDLE		(WM_APP +10)	//	ボタンハンドル		－					－
#define	AJCIVM_GETSPNHANDLE		(WM_APP +11)	//	スピンハンドル		－					－
#define	AJCIVM_GETTXTLEN		(WM_APP +12)	//	テキスト長取得		－					－
#define	AJCIVM_SETTXTLEN		(WM_APP +13)	//	テキスト長設定		テキスト長			－
#define	AJCIVM_SETTIPTEXTA		(WM_APP +14)	//	ツールチップ設定	テキストアドレス	－
#define	AJCIVM_SETTIPTEXTW		(WM_APP +15)	//	ツールチップ設定	テキストアドレス	－
#define	AJCIVM_GETTIPTEXTA		(WM_APP +16)	//	ツールチップ取得	バッファアドレス	バッファの文字数
#define	AJCIVM_GETTIPTEXTW		(WM_APP +17)	//	ツールチップ取得	バッファアドレス	バッファの文字数

//----- 整数設定 -----------------------------------------------------------------------------------------------//
#define	AJCIVM_I_GETVALUE		(WM_APP + 20)	//	整数値取得			－					－
#define	AJCIVM_I_SETVALUE		(WM_APP + 21)	//	整数値設定			整数				イベント発生フラグ
#define	AJCIVM_I_SETRANGE		(WM_APP + 22)	//	レンジ設定			最小値				最大値
#define	AJCIVM_I_SETSLDPAGE		(WM_APP + 23)	//	スライダページ		ページサイズ		－
#define	AJCIVM_I_SETSPNSTEP		(WM_APP + 24)	//	スピンのステップ	ステップサイズ		－
#define	AJCIVM_I_SETSLDUNIT		(WM_APP + 25)	//	スライダの解像度	数値の最小単位		－	(Add by V1.2.2)


//----- 実数設定 -----------------------------------------------------------------------------------------------//
#define	AJCIVM_R_GETVALUE		(WM_APP + 30)	//	実数値取得			&実数				－
#define	AJCIVM_R_SETVALUE		(WM_APP + 31)	//	実数値設定			&実数				イベント発生フラグ
#define	AJCIVM_R_SETRANGE		(WM_APP + 32)	//	レンジ設定			&最小値				&最大値
#define	AJCIVM_R_SETSLDUNIT		(WM_APP + 33)	//	スライダの解像度	&数値の最小単位		－
#define	AJCIVM_R_SETSLDPAGE		(WM_APP + 34)	//	スライダページ		&ページサイズ		－
#define	AJCIVM_R_SETSPNSTEP		(WM_APP + 35)	//	スピンのステップ	&ステップサイズ		－
#define	AJCIVM_R_SETPREC		(WM_APP + 36)	//	数値の精度設定		精度				－

//----- 右クリック通知設定 -------------------------------------------------------------------------------------//
#define	AJCIVM_SETNTCRCLK		(WM_APP + 40)	//	右クリック通知		許可フラグ			H:ﾎﾞﾀﾝUp時ﾒｯｾｰｼﾞｺｰﾄﾞ
												//											L:ﾎﾞﾀﾝDown時ﾒｯｾｰｼﾞｺｰﾄﾞ

//----- 内部使用メッセージ -------------------------------------------------------------------------------------//
#define	AJCIVM_NEEDNTC_INTVALUE		(WM_APP + 90)	//	整数値通知要
#define	AJCIVM_NEEDNTC_REALVALUE	(WM_APP + 91)	//	実数値通知要

//----- チップテキスト設定からのメッセージ ---------------------------------------------------------------------//
#define	AJCIVN_TIP_SUBCLASS		(WM_APP + 200)	//	サブクラス通知	TRUE:サブクラス化		－
												//					ALSE:サブクラス化解除

//-----	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ -----------------------------------------------------------------------------//
#ifdef	UNICODE
	#define	AjcIvSetTipText		AjcIvSetTipTextW
	#define	AjcIvGetTipText		AjcIvGetTipTextW
	#define	AjcIvLoadPermInfo	AjcIvLoadPermInfoW
	#define	AjcIvSavePermInfoEx	AjcIvSavePermInfoExW
	#define	AjcIvSetPermAtt		AjcIvSetPermAttW

	#define	AJCIVM_SETTIPTEXT	AJCIVM_SETTIPTEXTW
	#define	AJCIVM_GETTIPTEXT	AJCIVM_GETTIPTEXTW
#else
	#define	AjcIvSetTipText		AjcIvSetTipTextA
	#define	AjcIvGetTipText		AjcIvGetTipTextA
	#define	AjcIvLoadPermInfo	AjcIvLoadPermInfoA
	#define	AjcIvSavePermInfoEx	AjcIvSavePermInfoExA
	#define	AjcIvSetPermAtt		AjcIvSetPermAttA

	#define	AJCIVM_SETTIPTEXT	AJCIVM_SETTIPTEXTA
	#define	AJCIVM_GETTIPTEXT	AJCIVM_GETTIPTEXTA
#endif

//--------------------------------------------------------------------------------------------------------------//
//	右クリック通知情報																							//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	int			x;									//	カーソルｘ座標
	int			y;									//	カーソルｙ座標
	BOOL		fShift;								//	SHIFTキー押下フラグ
	BOOL		fCtrl;								//	CTRL キー押下フラグ
} AJCIVRCLK, *PAJCIVRCLK;
typedef const AJCIVRCLK *PCAJCIVRCLK;

//--------------------------------------------------------------------------------------------------------------//
//	コントロールの通知コード(WM_COMMAND)																		//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCIVN_INTVALUE		1					//	整数値が変化した	－					整数値
#define	AJCIVN_REALVALUE	2					//	実数値が変化した	－					実数値のアドレス
#define	AJCIVN_RCLICK		3					//	右クリック通知		－					PAJCIVRCLK

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI AjcIvSetTextFormat	(HWND hwnd, int width, UI precision);
AJCEXPORT	BOOL		WINAPI AjcIvGetProp			(HWND hwnd, PAJCIVPROP	pBuf);
AJCEXPORT	BOOL		WINAPI AjcIvSetProp			(HWND hwnd, PCAJCIVPROP pProp);
AJCEXPORT	COLORREF	WINAPI AjcIvGetBorderColor	(HWND hwnd);
AJCEXPORT	BOOL		WINAPI AjcIvSetBorderColor	(HWND hwnd, COLORREF color);
AJCEXPORT	COLORREF	WINAPI AjcIvGetBlinkColor	(HWND hwnd);
AJCEXPORT	BOOL		WINAPI AjcIvSetBlinkColor	(HWND hwnd, COLORREF color);
AJCEXPORT	HWND		WINAPI AjcIvGetSilderHandle	(HWND hwnd);
AJCEXPORT	HWND		WINAPI AjcIvGetBtnHandle	(HWND hwnd);
AJCEXPORT	HWND		WINAPI AjcIvGetTxtHandle	(HWND hwnd);
AJCEXPORT	HWND		WINAPI AjcIvGetSpnHandle	(HWND hwnd);
AJCEXPORT	UI			WINAPI AjcIvGetTxtLen		(HWND hwnd);
AJCEXPORT	BOOL		WINAPI AjcIvSetTxtLen		(HWND hwnd, UI len);
AJCEXPORT	BOOL		WINAPI AjcIvSetNtcRClk		(HWND hwnd, BOOL fNtcRClk, UI msgRBtnDown, UI msgRBtnUp);
AJCEXPORT	double		WINAPI AjcIvGetValue		(HWND hwnd);
AJCEXPORT	int			WINAPI AjcIvGetValueInt		(HWND hwnd);
AJCEXPORT	BOOL		WINAPI AjcIvSetValue		(HWND hwnd, double value);
AJCEXPORT	BOOL		WINAPI AjcIvSetValueEx		(HWND hwnd, double value, BOOL fNtc);
AJCEXPORT	BOOL		WINAPI AjcIvSetRange		(HWND hwnd, double minValue, double maxValue);
AJCEXPORT	BOOL		WINAPI AjcIvSetSldUnit		(HWND hwnd, double unit);
AJCEXPORT	BOOL		WINAPI AjcIvSetSldPage		(HWND hwnd, double unit);
AJCEXPORT	BOOL		WINAPI AjcIvSetSpnStep		(HWND hwnd, double step);
AJCEXPORT	BOOL		WINAPI AjcIvSetPrecision	(HWND hwnd, int prec);

AJCEXPORT	BOOL		WINAPI AjcIvSetTipTextA		(HWND hwnd, C_BCP pTipTxt);
AJCEXPORT	BOOL		WINAPI AjcIvSetTipTextW		(HWND hwnd, C_WCP pTipTxt);

AJCEXPORT	UI			WINAPI AjcIvGetTipTextA		(HWND hwnd, BCP pBuf, UI lBuf);
AJCEXPORT	UI			WINAPI AjcIvGetTipTextW		(HWND hwnd, WCP pBuf, UI lBuf);

AJCEXPORT	BOOL		WINAPI	AjcIvSetTipShowAlways(HWND hwnd, BOOL fShowAlways);
AJCEXPORT	BOOL		WINAPI	AjcIvGetTipShowAlways(HWND hwnd);


AJCEXPORT	BOOL		WINAPI AjcIvEnaDefTipText	(HWND hwnd, BOOL fEnable);

AJCEXPORT	BOOL		WINAPI AjcIvGetEditState	(HWND hwnd);

AJCEXPORT	BOOL		WINAPI	AjcIvLoadPermInfoA	(HWND hwnd, C_BCP pProfileSect, C_BCP pKey, BOOL fNtc);
AJCEXPORT	BOOL		WINAPI	AjcIvLoadPermInfoW	(HWND hwnd, C_WCP pProfileSect, C_WCP pKey, BOOL fNtc);

AJCEXPORT	BOOL		WINAPI	AjcIvSavePermInfo	(HWND hwnd);

AJCEXPORT	BOOL		WINAPI	AjcIvSavePermInfoExA(HWND hwnd, C_BCP pProfileSect, C_BCP pKey);
AJCEXPORT	BOOL		WINAPI	AjcIvSavePermInfoExW(HWND hwnd, C_WCP pProfileSect, C_WCP pKey);


AJCEXPORT	BOOL		WINAPI	AjcIvSetPermAttA	(HWND hwnd, C_BCP pProfileSect, C_BCP pKey);
AJCEXPORT	BOOL		WINAPI	AjcIvSetPermAttW	(HWND hwnd, C_WCP pProfileSect, C_WCP pKey);

AJCEXPORT	HWND		WINAPI	AjcIvGetMainWindow	(HWND hwnd, COLORREF *pBkGnd);

//----- 通知情報取得 -------------------------------------------------------------------------------------------//
AJCEXPORT	PAJCIVRCLK	WINAPI	AjcIvGetNtcRClk	(HWND hwnd);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用ウインド生成																						//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJCEXPORT HWND WINAPI AjcIvCreateForMSIL(HWND hOwner, VO (CALLBACK *cbNtcIntValue )(int value),
													  VO (CALLBACK *cbNtcRealValue)(double value),
													  VO (CALLBACK *cbRClick)(int x, int y, BOOL shift, BOOL ctrl));
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用スタイルの設定／取得関数																			//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//----- フォーカスによる自動編集			(AJCIVS_AUTOEDIT) --------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcIvGetSty_AUTOEDIT	(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcIvSetSty_AUTOEDIT	(HWND hwnd, BOOL f);

//----- １６進表示							(AJCIVS_SHOWHEX)- --------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcIvGetSty_SHOWHEX	(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcIvSetSty_SHOWHEX	(HWND hwnd, BOOL f);

//----- 数値の入力時にブリンクしない		(AJCIVS_NOBLINK) ---------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcIvGetSty_NOBLINK	(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcIvSetSty_NOBLINK	(HWND hwnd, BOOL f);

//----- コントロール外枠非表示				(AJCTCS_NOBORDER) --------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcIvGetSty_NOBORDER	(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcIvSetSty_NOBORDER	(HWND hwnd, BOOL f);

//----- スライダ非表示						(AJCIVS_NOSLD) -----------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcIvGetSty_NOSLD		(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcIvSetSty_NOSLD		(HWND hwnd, BOOL f);

//----- ボタン非表示						(AJCIVS_NOBTN) -----------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcIvGetSty_NOBTN		(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcIvSetSty_NOBTN		(HWND hwnd, BOOL f);

//----- スピンボタン非表示					(AJCIVS_NOSPN) -----------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcIvGetSty_NOSPN		(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcIvSetSty_NOSPN		(HWND hwnd, BOOL f);

//----- 整数部を３桁毎にカンマで区切る		(AJCIVS_SEPARATE) --------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcIvGetSty_SEPARATE	(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcIvSetSty_SEPARATE	(HWND hwnd, BOOL f);

//----- 実数モード							(AJCIVS_REALMODE) --------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcIvGetSty_REALMODE	(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcIvSetSty_REALMODE	(HWND hwnd, BOOL f);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用プロパティの設定／取得関数																		//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//----- 数値の最少値	 		(min) --------------------------------------------------------------------------//
AJCEXPORT double WINAPI AjcIvGetProp_min(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcIvSetProp_min(HWND hwnd, double value);

//----- 数値の最大値 			(max) --------------------------------------------------------------------------//
AJCEXPORT double WINAPI AjcIvGetProp_max(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcIvSetProp_max(HWND hwnd, double value);

//----- 数値の最小単位			(SldUnit) ----------------------------------------------------------------------//
AJCEXPORT double WINAPI AjcIvGetProp_SldUnit(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcIvSetProp_SldUnit(HWND hwnd, double value);

//----- スライダのページサイズ 	(SldPage) ----------------------------------------------------------------------//
AJCEXPORT double WINAPI AjcIvGetProp_SldPage(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcIvSetProp_SldPage(HWND hwnd, double value);

//----- スピンボタンの増減値 	(SpnStep) ----------------------------------------------------------------------//
AJCEXPORT double WINAPI AjcIvGetProp_SpnStep(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcIvSetProp_SpnStep(HWND hwnd, double value);

//----- テキストの桁数 			(TextLen) ----------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcIvGetProp_TextLen(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcIvSetProp_TextLen(HWND hwnd, UI value);

//----- 少数部の桁数			(Precision) --------------------------------------------------------------------//
AJCEXPORT SI	 WINAPI AjcIvGetProp_Precision(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcIvSetProp_Precision(HWND hwnd, SI value);

//----- 16進数の桁数			(HexLen) -----------------------------------------------------------------------//
AJCEXPORT SI	 WINAPI AjcIvGetProp_HexLen(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcIvSetProp_HexLen(HWND hwnd, SI value);

//----- ウインドサイズ -----------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcIvSetProp_WndSize(HWND hwnd, UI width, UI height);

//----- コントロール外枠の表示色取得 ---------------------------------------------------------------------------//
AJCEXPORT int WINAPI AjcIvGetProp_BorderColor(HWND hwnd);

//----- コントロール外枠の表示色設定 ---------------------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcIvSetProp_BorderColor(HWND hwnd, int rgb);

//----- 整数値取得 ---------------------------------------------------------------------------------------------//
AJCEXPORT int WINAPI	AjcIvGetIntValue	(HWND hwnd);

//----- 整数値設定 ---------------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI		AjcIvSetIntValue	(HWND hwnd, int value, BOOL fNtc);

//----- 実数値取得 ---------------------------------------------------------------------------------------------//
AJCEXPORT double WINAPI	AjcIvGetRealValue	(HWND hwnd);

//----- 実数値設定 ---------------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI		AjcIvSetRealValue	(HWND hwnd, double value, BOOL fNtc);

//----- テキストの取得 -----------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI	AjcIvGetText		(HWND hwnd, WCP pText, int lText);

//----- テキストの設定 -----------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI	AjcIvSetText		(HWND hwnd, C_WCP pText);

//----- ツールチップ文字列の設定 -------------------------------------------------------------------------------//
AJCEXPORT BOOL	WINAPI	AjcIvSetTipTextForMSIL	(HWND hwnd, C_WCP pTxt);

//----- ツールチップ文字列の取得 -------------------------------------------------------------------------------//
AJCEXPORT UI	WINAPI	AjcIvGetTipTextForMSIL	(HWND hwnd, WCP pBuf, int lBuf);

//----- 実数精度と１６進数桁数 取得ダイアログ　-----------------------------------------------------------------//
AJCEXPORT int WINAPI AjcIvGetProp_PrecisionDlg(int value);

/****************************************************************************************************************/
#endif
