﻿#ifndef	AJCCTRLVT100_H_
#define	AJCCTRLVT100_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define	AjcVthSetProp				AjcVthSetPropW
	#define	AjcVthGetProp				AjcVthGetPropW
	#define	AjcVthPutChar				AjcVthPutCharW
	#define	AjcVthPutTextAuto			AjcVthPutTextAutoW
	#define	AjcVthPutTextUTF8			AjcVthPutTextUTF8W
	#define	AjcVthPutText				AjcVthPutTextW
	#define	AjcVthPrintF				AjcVthPrintFW
	#define	AjcVthGetDroppedFile		AjcVthGetDroppedFileW
	#define	AjcVthGetDroppedDir			AjcVthGetDroppedDirW
	#define	AjcVthGetDroppedDirEx		AjcVthGetDroppedDirExW
	#define	AjcVthLoadProp				AjcVthLoadPropW
	#define	AjcVthSaveProp				AjcVthSavePropW
	#define	AjcVthLoadPermInfo			AjcVthLoadPermInfoW
	#define	AjcVthLoadPermInfoEx		AjcVthLoadPermInfoExW
	#define	AjcVthSavePermInfoEx		AjcVthSavePermInfoExW
	#define	AjcVthSetPermAtt			AjcVthSetPermAttW
	#define	AjcVthSetPermAttEx			AjcVthSetPermAttExW
	#define	AjcVthGetText				AjcVthGetTextW
	#define	AjcVthSetFontInfo			AjcVthSetFontInfoW
	#define	AjcVthGetFontInfo			AjcVthGetFontInfoW
	#define	AjcVthGetSelectedText		AjcVthGetSelectedTextW
	#define	AjcVthGetDblClickedLine		AjcVthGetDblClickedLineW
	#define	AjcVthGetDblClickedLineEx	AjcVthGetDblClickedLineExW
	#define	AjcVthSetTipText			AjcVthSetTipTextW
	#define	AjcVthGetTipText			AjcVthGetTipTextW
	#define	AjcVthSetTitleText			AjcVthSetTitleTextW
	#define	AjcVthSaveTextToFile		AjcVthSaveTextToFileW
	#define	AjcVthSaveHtmlToFile		AjcVthSaveHtmlToFileW
	#define	AjcVthSaveAllTextWithEsc	AjcVthSaveAllTextWithEscW
	#define	AjcVthGetLineText			AjcVthGetLineTextW
	#define	AjcVthSetFindProfileSect	AjcVthSetFindProfileSectW
	#define	AjcVthSearchBelow			AjcVthSearchBelowW
	#define	AjcVthSearchBelowEx			AjcVthSearchBelowExW
	#define	AjcVthSearchAbove			AjcVthSearchAboveW
	#define	AjcVthSearchAboveEx			AjcVthSearchAboveExW

	#define	AjcVthIdxToCPos				AjcVthIdxToCPosW
	#define	AjcVthIdxToCPos				AjcVthIdxToCPosW

	#define	AJCVTHPROP					AJCVTHPROPW
	#define	PAJCVTHPROP					PAJCVTHPROPW
	#define	PCAJCVTHPROP				PCAJCVTHPROPW

#else
	#define	AjcVthSetProp				AjcVthSetPropA
	#define	AjcVthGetProp				AjcVthGetPropA
	#define	AjcVthPutChar				AjcVthPutCharA
	#define	AjcVthPutTextAuto			AjcVthPutTextAutoA
	#define	AjcVthPutTextUTF8			AjcVthPutTextUTF8A
	#define	AjcVthPutText				AjcVthPutTextA
	#define	AjcVthPrintF				AjcVthPrintFA
	#define	AjcVthGetDroppedFile		AjcVthGetDroppedFileA
	#define	AjcVthGetDroppedDir			AjcVthGetDroppedDirA
	#define	AjcVthGetDroppedDirEx		AjcVthGetDroppedDirExA
	#define	AjcVthLoadProp				AjcVthLoadPropA
	#define	AjcVthSaveProp				AjcVthSavePropA
	#define	AjcVthLoadPermInfo			AjcVthLoadPermInfoA
	#define	AjcVthLoadPermInfoEx		AjcVthLoadPermInfoExA
	#define	AjcVthSavePermInfoEx		AjcVthSavePermInfoExA
	#define	AjcVthSetPermAtt			AjcVthSetPermAttA
	#define	AjcVthSetPermAttEx			AjcVthSetPermAttExA
	#define	AjcVthGetText				AjcVthGetTextA
	#define	AjcVthGetSelectedText		AjcVthGetSelectedTextA
	#define	AjcVthGetDblClickedLine		AjcVthGetDblClickedLineA
	#define	AjcVthGetDblClickedLineEx	AjcVthGetDblClickedLineExA
	#define	AjcVthSetTipText			AjcVthSetTipTextA
	#define	AjcVthGetTipText			AjcVthGetTipTextA
	#define	AjcVthSetFontInfo			AjcVthSetFontInfoA
	#define	AjcVthGetFontInfo			AjcVthGetFontInfoA
	#define	AjcVthSetTitleText			AjcVthSetTitleTextA
	#define	AjcVthSaveTextToFile		AjcVthSaveTextToFileA
	#define	AjcVthSaveHtmlToFile		AjcVthSaveHtmlToFileA
	#define	AjcVthSaveAllTextWithEsc	AjcVthSaveAllTextWithEscA
	#define	AjcVthSaveAllTextWithEsc	AjcVthSaveAllTextWithEscA
	#define	AjcVthGetLineText			AjcVthGetLineTextA
	#define	AjcVthSetFindProfileSect	AjcVthSetFindProfileSectA
	#define	AjcVthSearchBelow			AjcVthSearchBelowA
	#define	AjcVthSearchBelowEx			AjcVthSearchBelowExA
	#define	AjcVthSearchAbove			AjcVthSearchAboveA
	#define	AjcVthSearchAboveEx			AjcVthSearchAboveExA

	#define	AjcVthIdxToCPos				AjcVthIdxToCPosA
	#define	AjcVthIdxToCPos				AjcVthIdxToCPosA

	#define	AJCVTHPROP					AJCVTHPROPA
	#define	PAJCVTHPROP					PAJCVTHPROPA
	#define	PCAJCVTHPROP				PCAJCVTHPROPA

#endif
//--------------------------------------------------------------------------------------------------------------//
//	コントロールのスタイル																						//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCVTHS_LOGFILE			0x8000				//	Bit15 : ログファイル出力コントロール表示
#define	AJCVTHS_FIXEDPITCH		0x4000				//	Bit14 : 固定ピッチ
#define	AJCVTHS_FAST			0x2000				//	Bit13 : 高速表示モード
#define	AJCVTHS_NOCLSBTN		0x1000				//	Bit12 : 画面クリアーボタン無効
#define	AJCVTHS_FIXEDFONT		0x0800				//	Bit11 : フォント固定（ポップアップメニューから除外）
#define	AJCVTHS_FIXEDLF			0x0400				//	Bit10 : 改行動作固定（ポップアップメニューから除外）
#define	AJCVTHS_NOVSCROLL		0x0200				//	Bit9  : 縦スクロールバー非表示
#define	AJCVTHS_NOHSCROLL		0x0100				//	Bit8  : 横スクロールバー非表示

#define	AJCVTHS_NOSCRL			0x0080				//	Bit7  : 自動スクロール禁止（ＶＲＡＭへ描画時、最終行へ移動しない）
#define	AJCVTHS_NOBORDER		0x0040				//	Bit6  : 外枠非表示
#define	AJCVTHS_NOSCRLOUT		0x0020				//	Bit5  : スクロールアウト禁止
#define	AJCVTHS_CRLFCTRL		0x0010				//	Bit4  : Ｃ／Ｒ＝復帰，Ｌ／Ｆ＝改行
#define	AJCVTHS_CRCTRL			0x0008				//	Bit3  : Ｃ／Ｒ＝復帰改行
#define	AJCVTHS_LFCTRL			0x0004				//	Bit2  : Ｌ／Ｆ＝復帰改行
#define	AJCVTHS_SEPARATE		0x0002				//	Bit1  : ＶＲＡＭとその他の表示を分ける（ＶＲＡＭ以外を暗くする）
//								0x0001				//	Bit0  : -

#define	AJCVTHS_LFACT_MASK	(AJCVTHS_CRLFCTRL | AJCVTHS_CRCTRL | AJCVTHS_LFCTRL)

//--------------------------------------------------------------------------------------------------------------//
//	コントロールのプロパティ																					//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
typedef struct {
	UI			VramW;								//	ＶＲＡＭ桁数
	UI			VramH;								//	ＶＲＡＭ行数
	UI			CaretH;								//	キャレットの高さ（未使用）
	UI			MaxLines;							//	最大行数
	UI			TabStep;							//	ＴＡＢステップ数
	UI			LSpace;								//	行間スペース
	UI			PendSize;							//	最大表示保留サイズ
	COLORREF	rgb[8];								//	ＲＧＢ色コードテーブル
	LOGFONTA	LogFont;							//	フォント情報
} AJCVTHPROPA, *PAJCVTHPROPA;
typedef const AJCVTHPROPA *PCAJCVTHPROPA;

//----- ワイド文字 ---------------------------------------------------------------------------------------------//
typedef struct {
	UI			VramW;								//	ＶＲＡＭ桁数
	UI			VramH;								//	ＶＲＡＭ行数
	UI			CaretH;								//	キャレットの高さ（未使用）
	UI			MaxLines;							//	最大行数
	UI			TabStep;							//	ＴＡＢステップ数
	UI			LSpace;								//	行間スペース
	UI			PendSize;							//	最大表示保留サイズ
	COLORREF	rgb[8];								//	ＲＧＢ色コードテーブル
	LOGFONTW	LogFont;							//	フォント情報
} AJCVTHPROPW, *PAJCVTHPROPW;
typedef const AJCVTHPROPW *PCAJCVTHPROPW;

//--------------------------------------------------------------------------------------------------------------//
//	ダブルクリック通知情報																						//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	int			x;									//	カーソルｘ座標
	int			y;									//	カーソルｙ座標
	BOOL		fShift;								//	SHIFTキー押下フラグ
	BOOL		fCtrl;								//	CTRL キー押下フラグ
} AJCVTHDBLCLK, *PAJCVTHDBLCLK;
typedef const AJCVTHDBLCLK *PCAJCVTHDBLCLK;

//--------------------------------------------------------------------------------------------------------------//
//	右クリック通知情報																							//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	int			x;									//	カーソルｘ座標
	int			y;									//	カーソルｙ座標
	BOOL		fShift;								//	SHIFTキー押下フラグ
	BOOL		fCtrl;								//	CTRL キー押下フラグ
} AJCVTHRCLK, *PAJCVTHRCLK;
typedef const AJCVTHRCLK *PCAJCVTHRCLK;

//--------------------------------------------------------------------------------------------------------------//
//	ポップアップメニューのマスク																				//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCVTHMM_SELALL			0x00000001		//	全て選択
#define	AJCVTHMM_COPYTXT		0x00000002		//	コピー
#define	AJCVTHMM_CLEAR			0x00000004		//	クリアー
#define	AJCVTHMM_FIND			0x00000008		//	文字列検索
#define	AJCVTHMM_LINEFEED		0x00000040		//	復帰改行
#define	AJCVTHMM_CARET			0x00000080		//	キャレット表示
#define	AJCVTHMM_SAVE			0x00000100		//	ファイルへセーブ
#define	AJCVTHMM_SETFONT		0x00000200		//	フォント設定
#define	AJCVTHMM_SETDEFFONT		0x00000400		//	デフォルトフォント設定
#define	AJCVTHMM_COPYFONT		0x00000800		//	フォント行間スペース コピー
#define	AJCVTHMM_PASTEFONT		0x00001000		//	フォント行間スペース 貼り付け
#define	AJCVTHMM_THROWFONT		0x00002000		//	フォントを全スレッドウインド／兄弟ウインドに適用
#define	AJCVTHMM_SETOTHER		0x40000000		//	その他の設定

#define	AJCVTHMM_SELCPYFONT		(AJCVTHMM_COPYFONT | AJCVTHMM_PASTEFONT)

#define	AJCVTHMM_ALL			0x40003FFF		//	全て

//--------------------------------------------------------------------------------------------------------------//
//	コントロールのメッセージ																					//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCVTHM_SETFONT				(WM_APP + 10)	//	フォント設定		HFONT				LSPACE

//--------------------------------------------------------------------------------------------------------------//
//	コントロールの通知コード(WM_COMMAND)																		//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCVTHN_KEYIN 				(WM_APP +	90)	//	キー入力通知
#define	AJCVTHN_VKEYIN 				(WM_APP +	91)	//	拡張キー押下通知
#define	AJCVTHN_VKEYOUT				(WM_APP +	92)	//	拡張キー離し通知
#define	AJCVTHN_DBLCLK				(WM_APP +	93)	//	ダブルクリック通知
#define	AJCVTHN_DROPFILE			(WM_APP +	94)	//	ファイルドロップ通知
#define	AJCVTHN_DROPDIR				(WM_APP +	95)	//	フォルダドロップ通知
#define AJCVTHN_CHARINFO			(WM_APP +	96)	//	文字情報変化通知
#define AJCVTHN_HSCROLL				(WM_APP +	97)	//	横スクロール通知
#define AJCVTHN_VSCROLL				(WM_APP +	98)	//	縦スクロール通知
#define	AJCVTHN_RCLICK				(WM_APP +	99)	//	右クリック通知
#define	AJCVTHN_CLEAR				(WM_APP +  100)	//	画面クリアー通知

//--------------------------------------------------------------------------------------------------------------//
//	テキスト・コード																							//
//--------------------------------------------------------------------------------------------------------------//
typedef enum {
	AJCVTH_TXT_SJIS	=	1	,				//	シフトＪＩＳ
	AJCVTH_TXT_EUC	=	2	,				//	ＥＵＣ　　　
	AJCVTH_TXT_UTF8	=	3	,				//	ＵＴＦ－８　
} AJCVTH_TEXTCODE;

//--------------------------------------------------------------------------------------------------------------//
//	永続化項目																									//
//--------------------------------------------------------------------------------------------------------------//
#define	AJCVTH_PERM_LFACT		0x0001
#define	AJCVTH_PERM_FONT		0x0002			//	フォント情報
#define	AJCVTH_PERM_VRAM		0x0004			//	ＶＲＡＭサイズ
#define	AJCVTH_PERM_OTHER		0x0080			//	その他

#define	AJCVTH_PERM_ALL			0x00FF			//	上記全て

#define	AJCVTH_PERM_BYLOAD		0x8000			//	ロード時に指定された値を仮定（セーブ時のみ）

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	  WINAPI AjcVthSetFocus	   	  (HWND hwnd);

AJCEXPORT BOOL	   WINAPI AjcVthSetPropA 	  (HWND hwnd, PCAJCVTHPROPA pProp);
AJCEXPORT BOOL	   WINAPI AjcVthSetPropW 	  (HWND hwnd, PCAJCVTHPROPW pProp);

AJCEXPORT BOOL	   WINAPI AjcVthGetPropA 	  (HWND hwnd, PAJCVTHPROPA	pBuf );
AJCEXPORT BOOL	   WINAPI AjcVthGetPropW 	  (HWND hwnd, PAJCVTHPROPW	pBuf );

AJCEXPORT BOOL	   WINAPI AjcVthResetProp	  (HWND hwnd);

AJCEXPORT BOOL	   WINAPI AjcVthGetVramFitSize(HWND hwnd, UIP pWidth, UIP pHeight);

AJCEXPORT BOOL	   WINAPI AjcVthPutCharA	   (HWND hwnd, UI c);
AJCEXPORT BOOL	   WINAPI AjcVthPutCharW	   (HWND hwnd, UI c);

AJCEXPORT BOOL	   WINAPI AjcVthPutTextAutoA(HWND hwnd, C_BCP pTxt, UI lTxt);	//	S-JISに変換して描画
AJCEXPORT BOOL	   WINAPI AjcVthPutTextAutoW(HWND hwnd, C_BCP pTxt, UI lTxt);	//	他国文字も描画

AJCEXPORT BOOL	   WINAPI AjcVthPutTextEUC	(HWND hwnd, C_BCP pTxt, UI lTxt);

AJCEXPORT BOOL	   WINAPI AjcVthPutTextUTF8A(HWND hwnd, C_BCP pTxt, UI lTxt);	//	S-JISに変換して描画
AJCEXPORT BOOL	   WINAPI AjcVthPutTextUTF8W(HWND hwnd, C_BCP pTxt, UI lTxt);	//	他国文字も描画

AJCEXPORT BOOL	   WINAPI AjcVthPutTextA	(HWND hwnd, C_BCP pTxt, UI lTxt);
AJCEXPORT BOOL	   WINAPI AjcVthPutTextW	(HWND hwnd, C_WCP pTxt, UI lTxt);

AJCEXPORT BOOL	   WINAPI AjcVthPrintFA 	(HWND hwnd, C_BCP pFmt, ...);
AJCEXPORT BOOL	   WINAPI AjcVthPrintFW 	(HWND hwnd, C_WCP pFmt, ...);

AJCEXPORT BOOL	   WINAPI AjcVthTimeStamp	(HWND hwnd);
AJCEXPORT BOOL	   WINAPI AjcVthHexDump 	(HWND hwnd, C_VOP pDat, UI lDat);

AJCEXPORT BOOL	   WINAPI AjcVthLocate		  (HWND hwnd, UI line, UI col);
AJCEXPORT UI	   WINAPI AjcVthGetCursorPos  (HWND hwnd, UIP pLine, UIP pCol);

AJCEXPORT BOOL	   WINAPI AjcVthSetColor	  (HWND hwnd, UI PaletteNo);
AJCEXPORT UI	   WINAPI AjcVthGetColor	  (HWND hwnd);

AJCEXPORT BOOL	   WINAPI AjcVthSetBkColor	  (HWND hwnd, UI PaletteNo);
AJCEXPORT UI	   WINAPI AjcVthGetBkColor	  (HWND hwnd);

AJCEXPORT BOOL	   WINAPI AjcVthSetWndBkColor(HWND hwnd, UI PaletteNo);
AJCEXPORT UI	   WINAPI AjcVthGetWndBkColor(HWND hwnd);

AJCEXPORT BOOL	   WINAPI AjcVthSetPalette	  (HWND hwnd, UI PaletteNo, COLORREF rgb);
AJCEXPORT COLORREF WINAPI AjcVthGetPalette	  (HWND hwnd, UI PaletteNo);

AJCEXPORT BOOL	   WINAPI AjcVthSelect		(HWND hwnd, UI slp, UI scp, UI elp, UI ecp);
AJCEXPORT BOOL	   WINAPI AjcVthSelectAll	(HWND hwnd);
AJCEXPORT BOOL	   WINAPI AjcVthCopyText	(HWND hwnd);
AJCEXPORT BOOL	   WINAPI AjcVthSetFont 	(HWND hwnd);
AJCEXPORT BOOL	   WINAPI AjcVthShowCaret	(HWND hwnd, BOOL fShow);
AJCEXPORT BOOL	   WINAPI AjcVthClear		(HWND hwnd);
AJCEXPORT BOOL	   WINAPI AjcVthClearAllText(HWND hwnd);

AJCEXPORT BOOL	   WINAPI AjcVthGetDroppedFileA (HWND hwnd, BC buf[MAX_PATH]);
AJCEXPORT BOOL 	   WINAPI AjcVthGetDroppedFileW (HWND hwnd, WC buf[MAX_PATH]);

AJCEXPORT BOOL 	   WINAPI AjcVthGetDroppedDirA	(HWND hwnd, BC buf[MAX_PATH]);
AJCEXPORT BOOL 	   WINAPI AjcVthGetDroppedDirW	(HWND hwnd, WC buf[MAX_PATH]);

AJCEXPORT BOOL	   WINAPI AjcVthGetDroppedDirExA(HWND hwnd, BC buf[MAX_PATH], BOOL fTailIsDelimiter);
AJCEXPORT BOOL	   WINAPI AjcVthGetDroppedDirExW(HWND hwnd, WC buf[MAX_PATH], BOOL fTailIsDelimiter);

AJCEXPORT BOOL	   WINAPI AjcVthLoadPropA		(HWND hwnd, C_BCP pProfileSect, PCAJCVTHPROPA pDefProp);
AJCEXPORT BOOL	   WINAPI AjcVthLoadPropW		(HWND hwnd, C_WCP pProfileSect, PCAJCVTHPROPW pDefProp);

AJCEXPORT BOOL	   WINAPI AjcVthSavePropA		(HWND hwnd, C_BCP pProfileSect);
AJCEXPORT BOOL	   WINAPI AjcVthSavePropW		(HWND hwnd, C_WCP pProfileSect);

AJCEXPORT BOOL	   WINAPI AjcVthLoadPermInfoA		(HWND hwnd, C_BCP pProfileSect, C_BCP pKeyPrefix);
AJCEXPORT BOOL	   WINAPI AjcVthLoadPermInfoW		(HWND hwnd, C_WCP pProfileSect, C_WCP pKeyPrefix);

AJCEXPORT BOOL	   WINAPI AjcVthLoadPermInfoExA		(HWND hwnd, C_BCP pProfileSect, C_BCP pKeyPrefix, UI PermItem);
AJCEXPORT BOOL	   WINAPI AjcVthLoadPermInfoExW		(HWND hwnd, C_WCP pProfileSect, C_WCP pKeyPrefix, UI PermItem);

AJCEXPORT BOOL	   WINAPI AjcVthSavePermInfo		(HWND hwnd);

AJCEXPORT BOOL	   WINAPI AjcVthSavePermInfoExA		(HWND hwnd, C_BCP pSect, C_BCP pKeyPrefix, UI PermItem);
AJCEXPORT BOOL	   WINAPI AjcVthSavePermInfoExW		(HWND hwnd, C_WCP pSect, C_WCP pKeyPrefix, UI PermItem);

AJCEXPORT BOOL	   WINAPI AjcVthSetPermAttA			(HWND hwnd, C_BCP pProfileSect, C_BCP pKeyPrefix);
AJCEXPORT BOOL	   WINAPI AjcVthSetPermAttW			(HWND hwnd, C_WCP pProfileSect, C_WCP pKeyPrefix);

AJCEXPORT BOOL	   WINAPI AjcVthSetPermAttExA	(HWND hwnd, C_BCP pProfileSect, C_BCP pKeyPrefix, UI PermItem);
AJCEXPORT BOOL	   WINAPI AjcVthSetPermAttExW	(HWND hwnd, C_WCP pProfileSect, C_WCP pKeyPrefix, UI PermItem);

AJCEXPORT BOOL	   WINAPI AjcVthSelMenuItems(HWND hwnd, UI sel);
AJCEXPORT BOOL	   WINAPI AjcVthExcMenuItems(HWND hwnd, UI exc);

AJCEXPORT BOOL	   WINAPI AjcVthEnablePopupMenu	(HWND hwnd, BOOL fEnable);
AJCEXPORT BOOL	   WINAPI AjcVthSetNtcRClk	   	(HWND hwnd, BOOL fNtcRClk, UI MsgRBDown, UI MsgRBUp);

AJCEXPORT UI	   WINAPI AjcVthGetTextA		(HWND hwnd, BCP pBuf, UI lBuf);
AJCEXPORT UI	   WINAPI AjcVthGetTextW		(HWND hwnd, WCP pBuf, UI lBuf);

AJCEXPORT UI	   WINAPI AjcVthGetSelectedTextA(HWND hwnd, BCP pBuf, UI lBuf);
AJCEXPORT UI	   WINAPI AjcVthGetSelectedTextW(HWND hwnd, WCP pBuf, UI lBuf);

AJCEXPORT UI	   WINAPI AjcVthGetDblClickedLineA	(HWND hwnd, BCP pBuf, UI lBuf);
AJCEXPORT UI	   WINAPI AjcVthGetDblClickedLineW	(HWND hwnd, WCP pBuf, UI lBuf);

AJCEXPORT UI	   WINAPI AjcVthGetDblClickedLineExA(HWND hwnd, BCP pBuf, UI lBuf, UIP pLine, UIP pCol);
AJCEXPORT UI	   WINAPI AjcVthGetDblClickedLineExW(HWND hwnd, WCP pBuf, UI lBuf, UIP pLine, UIP pCol);

AJCEXPORT BOOL	   WINAPI AjcVthSetTipTextA		(HWND hwnd, C_BCP pTxt);
AJCEXPORT BOOL	   WINAPI AjcVthSetTipTextW		(HWND hwnd, C_WCP pTxt);

AJCEXPORT BOOL	   WINAPI AjcVthGetTipTextA		(HWND hwnd, BCP pBuf, UI lBuf);
AJCEXPORT BOOL	   WINAPI AjcVthGetTipTextW		(HWND hwnd, WCP pBuf, UI lBuf);

AJCEXPORT BOOL	   WINAPI AjcVthSetTipShowAlways(HWND hwnd, BOOL fShowAlways);
AJCEXPORT BOOL	   WINAPI AjcVthGetTipShowAlways(HWND hwnd);

AJCEXPORT BOOL	   WINAPI AjcVthSetFontInfoA(HWND hwnd, const LOGFONTA *pLogFont, UI LSpace);
AJCEXPORT BOOL	   WINAPI AjcVthSetFontInfoW(HWND hwnd, const LOGFONTW *pLogFont, UI LSpace);

AJCEXPORT BOOL	   WINAPI AjcVthGetFontInfoA(HWND hwnd, LPLOGFONTA *pBuf, UIP pLSpace);
AJCEXPORT BOOL	   WINAPI AjcVthGetFontInfoW(HWND hwnd, LPLOGFONTW *pBuf, UIP pLSpace);

AJCEXPORT BOOL	   WINAPI AjcVthGetCharInfo 	 (HWND hwnd, UIP pCx, UIP pCy, UIP pLy);
AJCEXPORT UI	   WINAPI AjcVthGetLinesPerWindow(HWND hwnd);
AJCEXPORT UI	   WINAPI AjcVthGetValidLines	 (HWND hwnd);
AJCEXPORT UI	   WINAPI AjcVthGetIxOfWndTopLine(HWND hwnd);

AJCEXPORT BOOL	   WINAPI AjcVthSetTitleTextA	(HWND hwnd, C_BCP pTitleText, COLORREF TextColor, COLORREF BackColor, HFONT hFont);
AJCEXPORT BOOL	   WINAPI AjcVthSetTitleTextW	(HWND hwnd, C_WCP pTitleText, COLORREF TextColor, COLORREF BackColor, HFONT hFont);

AJCEXPORT BOOL	   WINAPI AjcVthSaveTextToFileA	(HWND hwnd, C_BCP pPath, BOOL fAllText, EAJCTEC tec, BOOL fBom);
AJCEXPORT BOOL	   WINAPI AjcVthSaveTextToFileW	(HWND hwnd, C_WCP pPath, BOOL fAllText, EAJCTEC tec, BOOL fBom);

AJCEXPORT BOOL	   WINAPI AjcVthSaveHtmlToFileA	(HWND hwnd, C_BCP pPath, BOOL fAllText, UI FontSize);
AJCEXPORT BOOL	   WINAPI AjcVthSaveHtmlToFileW	(HWND hwnd, C_WCP pPath, BOOL fAllText, UI FontSize);

AJCEXPORT BOOL	   WINAPI AjcVthSaveAllTextWithEscA(HWND hwnd, C_BCP pPath, EAJCTEC tec, BOOL fBom);
AJCEXPORT BOOL	   WINAPI AjcVthSaveAllTextWithEscW(HWND hwnd, C_WCP pPath, EAJCTEC tec, BOOL fBom);

AJCEXPORT	UI	   WINAPI AjcVthGetLineCount	(HWND hwnd);

AJCEXPORT	BOOL   WINAPI AjcVthGetCursorPosInfo(HWND hwnd, UIP pLine, UIP pCol);

AJCEXPORT	UI	   WINAPI AjcVthGetLineTextA	(HWND hwnd, UI pos, BCP pBuf, UI lBuf);
AJCEXPORT	UI	   WINAPI AjcVthGetLineTextW	(HWND hwnd, UI pos, WCP pBuf, UI lBuf);

AJCEXPORT	UI	   WINAPI AjcVthGetVScrollPos	(HWND hwnd);
AJCEXPORT	UI	   WINAPI AjcVthGetHScrollPos	(HWND hwnd);

AJCEXPORT	BOOL   WINAPI AjcVthSetVScrollPos	(HWND hwnd, UI pos);
AJCEXPORT	BOOL   WINAPI AjcVthSetHScrollPos	(HWND hwnd, UI pos);

AJCEXPORT	BOOL   WINAPI AjcVthGetWindowSize	(HWND hwnd, LPSIZE pSize);

AJCEXPORT	UI		WINAPI	AjcVthSetFindProfileSectA(HWND hwnd, C_BCP pSect);
AJCEXPORT	UI		WINAPI	AjcVthSetFindProfileSectW(HWND hwnd, C_WCP pSect);

AJCEXPORT	UI		WINAPI	AjcVthSetFindKey(HWND hwnd, UI key);

AJCEXPORT	UI		WINAPI	AjcVthSearchBelowA(HWND hwnd, C_BCP pStr, BC delimiter);
AJCEXPORT	UI		WINAPI	AjcVthSearchBelowW(HWND hwnd, C_WCP pStr, WC delimiter);

AJCEXPORT	UI		WINAPI	AjcVthSearchBelowExA(HWND hwnd, C_BCP pStr, C_BCP pDim, C_BCP pAny, C_BCP pEnc, BOOL fTrim, BOOL fIgnoreWidth);
AJCEXPORT	UI		WINAPI	AjcVthSearchBelowExW(HWND hwnd, C_WCP pStr, C_WCP pDim, C_WCP pAny, C_WCP pEnc, BOOL fTrim, BOOL fIgnoreWidth);

AJCEXPORT	UI		WINAPI	AjcVthSearchAboveA(HWND hwnd, C_BCP pStr, BC delimiter);
AJCEXPORT	UI		WINAPI	AjcVthSearchAboveW(HWND hwnd, C_WCP pStr, WC delimiter);

AJCEXPORT	UI		WINAPI	AjcVthSearchAboveExA(HWND hwnd, C_BCP pStr, C_BCP pDim, C_BCP pAny, C_BCP pEnc, BOOL fTrim, BOOL fIgnoreWidth);
AJCEXPORT	UI		WINAPI	AjcVthSearchAboveExW(HWND hwnd, C_WCP pStr, C_WCP pDim, C_WCP pAny, C_WCP pEnc, BOOL fTrim, BOOL fIgnoreWidth);

AJCEXPORT	BOOL	WINAPI	AjcVthPause(HWND hwnd, BOOL fPause);

AJCEXPORT	BOOL	WINAPI	AjcVthSetLFActInPopupMenu(HWND hwnd, BOOL flag);
AJCEXPORT	BOOL	WINAPI	AjcVthGetLFActInPopupMenu(HWND hwnd);


AJCEXPORT	UI		WINAPI AjcVthIdxToCPosA(HWND hwnd, C_BCP pTxt, UI idx);
AJCEXPORT	UI		WINAPI AjcVthIdxToCPosW(HWND hwnd, C_WCP pTxt, UI idx);

AJCEXPORT	UI		WINAPI AjcVthCPosToIdxA(HWND hwnd, C_BCP pTxt, UI pos);
AJCEXPORT	UI		WINAPI AjcVthCPosToIdxW(HWND hwnd, C_WCP pTxt, UI pos);

AJCEXPORT	HWND	WINAPI AjcVthGetMainWindow (HWND hwnd, COLORREF *pBkGnd);

//----- 通知情報取得 --------------------------------------------------------------------------------------------//
AJCEXPORT	PAJCVTHRCLK	WINAPI AjcVthGetNtcRClk		(HWND hwnd);
AJCEXPORT	UI			WINAPI AjcVthGetNtcDblClk	(HWND hwnd);
AJCEXPORT	UI			WINAPI AjcVthGetNtcDirs		(HWND hwnd);
AJCEXPORT	UI			WINAPI AjcVthGetNtcFiles	(HWND hwnd);
AJCEXPORT	UI			WINAPI AjcVthGetNtcKey		(HWND hwnd);
AJCEXPORT	UI			WINAPI AjcVthGetNtcKeyRep	(HWND hwnd);
AJCEXPORT	UI			WINAPI AjcVthGetNtcKeyFlg	(HWND hwnd);
AJCEXPORT	UI			WINAPI AjcVthGetNtcCyLine	(HWND hwnd);
AJCEXPORT	UI			WINAPI AjcVthGetNtcLeft		(HWND hwnd);
AJCEXPORT	UI			WINAPI AjcVthGetNtcTop		(HWND hwnd);

//----- デバッグ用 ----------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI AjcVthGetMode(HWND hwnd);
AJCEXPORT	BOOL	WINAPI AjcVthSetDefFont(HWND hwnd, HFONT hFont);

//	ＶＲＡＭ情報取得
typedef struct {
	VOP		pVram;			//	ＶＲＡＭ先頭アドレス
	UI		ltop;			//	ＶＲＡＭ最上行の行インデクス
	UI		width;			//	１行当たりの文字数
	UI		height;			//	行数
	UI		LineBytes;		//	ＶＲＡＭ１行のバイト数
	UI		lp;				//	カーソル行位置
	UI		cp;				//	カーソル桁位置
	UI		ix;				//	カーソル位置に対応するテキストインデクス
} AJCVTHVRAMINFO, *PAJCVTHVRAMINFO;

AJCEXPORT	BOOL	WINAPI AjcVthGetVramInfo(HWND hwnd, PAJCVTHVRAMINFO pBuf);


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用ウインド生成																						//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJCEXPORT HWND WINAPI AjcVthCreateForMSIL(HWND hOwner,	VO (CALLBACK *cbNtcDblClk )(BOOL shift, BOOL ctrl),
														VO (CALLBACK *cbNtcKeyIn  )(UI key , UI RepCnt),
														VO (CALLBACK *cbNtcVKeyIn )(UI vkey, UI RepCnt),
														VO (CALLBACK *cbNtcVKeyOut)(UI key ),
														VO (CALLBACK *cbFileDrop  )(UI n   ),
														VO (CALLBACK *cbDirDrop   )(UI n   ),
														VO (CALLBACK *cbCharInfo  )(UI LineHeight),
														VO (CALLBACK *cbRClick)(int x, int y, BOOL shift, BOOL ctrl));

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用スタイルの設定／取得関数																			//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//----- ファイル出力コントロール表示／非表示 -------------------------------------------------------------------//
AJCEXPORT BOOL WINAPI AjcVthGetSty_LOGFILE	(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcVthSetSty_LOGFILE	(HWND hwnd, BOOL f);

//----- 固定ピッチ							(AJCVTHS_FIXEDPITCH	) ----------------------------------------------//
AJCEXPORT BOOL WINAPI AjcVthGetSty_FIXEDPITCH(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcVthSetSty_FIXEDPITCH(HWND hwnd, BOOL f);

//----- 高速表示							(AJCVTHS_FAST		) ----------------------------------------------//
AJCEXPORT BOOL WINAPI AjcVthGetSty_FAST(HWND hwnd		 );
AJCEXPORT VO   WINAPI AjcVthSetSty_FAST(HWND hwnd, BOOL f);

//----- 画面クリアーボタン無効				(AJCVTHS_NOCLSBTN	) ----------------------------------------------//
AJCEXPORT BOOL WINAPI AjcVthGetSty_NOCLSBTN(HWND hwnd		 );
AJCEXPORT VO   WINAPI AjcVthSetSty_NOCLSBTN(HWND hwnd, BOOL f);

//----- フォント固定						(AJCVTHS_FIXEDFONT	) ----------------------------------------------//
AJCEXPORT BOOL WINAPI AjcVthGetSty_FIXEDFONT(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcVthSetSty_FIXEDFONT(HWND hwnd, BOOL f);

//----- 改行動作固定						(AJCVTHS_FIXEDLF	) ----------------------------------------------//
AJCEXPORT BOOL WINAPI AjcVthGetSty_FIXEDLF	(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcVthSetSty_FIXEDLF	(HWND hwnd, BOOL f);

//----- 縦スクロールバー非表示				(AJCVTHS_NOVSCROLL	) ----------------------------------------------//
AJCEXPORT BOOL WINAPI AjcVthGetSty_NOVSCROLL(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcVthSetSty_NOVSCROLL(HWND hwnd, BOOL f);

//----- 横スクロールバー非表示				(AJCVTHS_NOHSCROLL	) ----------------------------------------------//
AJCEXPORT BOOL WINAPI AjcVthGetSty_NOHSCROLL(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcVthSetSty_NOHSCROLL(HWND hwnd, BOOL f);

//----- 自動スクロールの許可／禁止			(AJCVTHS_NOSCRL		) ----------------------------------------------//
AJCEXPORT BOOL WINAPI AjcVthGetSty_NOSCRL	(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcVthSetSty_NOSCRL	(HWND hwnd, BOOL f);

//----- コントロール外枠の非表示／表示		(AJCVTHS_NOBORDER	) ----------------------------------------------//
AJCEXPORT BOOL WINAPI AjcVthGetSty_NOBORDER	(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcVthSetSty_NOBORDER	(HWND hwnd, BOOL f);

//----- スクロールアウト許可／禁止			(AJCVTHS_NOSCRLOUT	) ----------------------------------------------//
AJCEXPORT BOOL WINAPI AjcVthGetSty_NOSCRLOUT(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcVthSetSty_NOSCRLOUT(HWND hwnd, BOOL f);

//----- ＣＲで改行							(AJCVTHS_CRCTL		) ----------------------------------------------//
AJCEXPORT BOOL WINAPI AjcVthGetSty_CRCTRL	(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcVthSetSty_CRCTRL	(HWND hwnd, BOOL f);

//----- ＬＦで改行							(AJCVTHS_LFCTL		) ----------------------------------------------//
AJCEXPORT BOOL WINAPI AjcVthGetSty_LFCTRL	(HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcVthSetSty_LFCTRL	(HWND hwnd, BOOL f);

//----- ＶＲＡＭとその他の領域分離			(AJCVTHS_SEPARATE	) ----------------------------------------------//
AJCEXPORT BOOL WINAPI AjcVthGetSty_SEPARATE (HWND hwnd		  );
AJCEXPORT VO   WINAPI AjcVthSetSty_SEPARATE (HWND hwnd, BOOL f);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用プロパティの設定／取得関数																		//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//----- ＶＲＡＭ桁数 		(VramW) ----------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcVthGetProp_VramW(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcVthSetProp_VramW(HWND hwnd, UI n);

//----- ＶＲＡＭ行数		(VramH) ----------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcVthGetProp_VramH(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcVthSetProp_VramH(HWND hwnd, UI n);

//----- キャレットの高さ	(CaretH) ---------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcVthGetProp_CaretH(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcVthSetProp_CaretH(HWND hwnd, UI n);

//----- 最大行数			(MaxLines) -------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcVthGetProp_MaxLines(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcVthSetProp_MaxLines(HWND hwnd, UI n);

//----- タブ・スキップ数	(TabStep) --------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcVthGetProp_TabStep(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcVthSetProp_TabStep(HWND hwnd, UI n);

//----- 行間スペース		(LSpace) ---------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcVthGetProp_LSpace(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcVthSetProp_LSpace(HWND hwnd, UI n);

//----- 一時保留サイズ		(PendSize) -------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcVthGetProp_PendSize(HWND hwnd);
AJCEXPORT VO	 WINAPI AjcVthSetProp_PendSize(HWND hwnd, UI n);

//----- 表示色				(rgb[]) ----------------------------------------------------------------------------//
AJCEXPORT UI	 WINAPI AjcVthGetProp_rgb(HWND hwnd, UI ix);
AJCEXPORT VO	 WINAPI AjcVthSetProp_rgb(HWND hwnd, UI ix, UI n);

//----- 文字の幅 -----------------------------------------------------------------------------------------------//
AJCEXPORT UI WINAPI AjcVthGetProp_CharWidth(HWND hwnd);

//----- 文字の高さ ---------------------------------------------------------------------------------------------//
AJCEXPORT UI WINAPI AjcVthGetProp_CharHeight(HWND hwnd);

//----- 行の高さ -----------------------------------------------------------------------------------------------//
AJCEXPORT UI WINAPI AjcVthGetProp_LineHeight(HWND hwnd);

//----- ウインドサイズ -----------------------------------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcVthSetProp_WndSize(HWND hwnd, UI width, UI height);

//----- フォント表現文字列取得 ---------------------------------------------------------------------------------//
AJCEXPORT int WINAPI AjcVthGetProp_Font(C_WCP pS, WCP pD, int len);

//----- フォント表現文字列によるフォント設定 -------------------------------------------------------------------//
AJCEXPORT VO WINAPI AjcVthSetProp_Font(HWND hwnd, C_WCP pText);

//----- ファイル，フォルダ ドロップの許可／禁止 ----------------------------------------------------------------//
AJCEXPORT VO   WINAPI AjcVthSetProp_AcceptFiles(HWND hwnd, BOOL fEnable);
AJCEXPORT BOOL WINAPI AjcVthGetProp_AcceptFiles(HWND hwnd);

//----- 表示ウインドの行数，桁数 -------------------------------------------------------------------------------//
AJCEXPORT int WINAPI AjcVthGetProp_WndHeight(HWND hwnd);
AJCEXPORT int WINAPI AjcVthGetProp_WndWidth (HWND hwnd);

//----- チップテキスト設定／取得 -------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcVthSetTipTextForMSIL(HWND hwnd, C_WCP pTxt);
AJCEXPORT	UI		WINAPI	AjcVthGetTipTextForMSIL(HWND hwnd, WCP pBuf, UI lBuf);

//----- 初期プロパティ退避 -------------------------------------------------------------------------------------//
AJCEXPORT	VO	WINAPI	AjcVthSaveIniPropForMSIL(HWND hwnd);

/****************************************************************************************************************/
#endif
