﻿#ifndef	AJCDIBSECT_H_
#define	AJCDIBSECT_H_
/****************************************************************************************************************/
/*--------------------------------------------------------------------------------------------------------------*/
/*	ＤＩＢセクションの情報																						*/
/*--------------------------------------------------------------------------------------------------------------*/
typedef struct {
	HBITMAP		hBmp;					//	ビットマップハンドル
	int			BitCount;				//	イメージのビット数(24 or 32)
	int			width;					//	ビットマップの幅　（横ピクセル数）
	int			height;					//	ビットマップの高さ（縦ピクセル数）
	int			PixelSize;				//	１ピクセル当たりのバイト数
	int			LineSize;				//	１ライン当たりのバイト数
	UBP			pImage;					//	イメージデータの先頭アドレス
} AJCDIBINFO, *PAJCDIBINFO;
typedef const AJCDIBINFO  *PCAJCDIBINFO;

/*--------------------------------------------------------------------------------------------------------------*/
/*	ＤＩＢセクションコピー時の選択／除外																		*/
/*--------------------------------------------------------------------------------------------------------------*/
#define		AJCDIBSEL_MASK		0x00FF
#define		AJCDIBSEL_CORRECT	0x0000
#define		AJCDIBSEL_EXCLUDE	0x0001

#define		AJCDIBOPE_MASK		0xFF00
#define		AJCDIBOPE_COPY		0x0000
#define		AJCDIBOPE_OR		0x1000
#define		AJCDIBOPE_AND		0x2000
#define		AJCDIBOPE_XOR		0x3000

#define		AJCDIBOPE_CORRECT	(AJCDIBSEL_CORRECT | AJCDIBOPE_COPY)
#define		AJCDIBOPE_COR_OR	(AJCDIBSEL_CORRECT | AJCDIBOPE_OR  )
#define		AJCDIBOPE_COR_AND	(AJCDIBSEL_CORRECT | AJCDIBOPE_AND )
#define		AJCDIBOPE_COR_XOR	(AJCDIBSEL_CORRECT | AJCDIBOPE_XOR )

#define		AJCDIBOPE_EXCLUDE	(AJCDIBSEL_EXCLUDE | AJCDIBOPE_COPY)
#define		AJCDIBOPE_EXC_OR	(AJCDIBSEL_EXCLUDE | AJCDIBOPE_OR  )
#define		AJCDIBOPE_EXC_AND	(AJCDIBSEL_EXCLUDE | AJCDIBOPE_AND )
#define		AJCDIBOPE_EXC_XOR	(AJCDIBSEL_EXCLUDE | AJCDIBOPE_XOR )

/*--------------------------------------------------------------------------------------------------------------*/
/*	ＵＮＩＣＯＤＥ／ＡＳＣＩＩ																					*/
/*--------------------------------------------------------------------------------------------------------------*/
#ifdef	UNICODE
	#define	AjcDibReadFileAndCreate	AjcDibReadFileAndCreateW
#else
	#define	AjcDibReadFileAndCreate	AjcDibReadFileAndCreateA
#endif

/*--------------------------------------------------------------------------------------------------------------*/
/*	プロトタイプ																								*/
/*--------------------------------------------------------------------------------------------------------------*/
AJCEXPORT HBITMAP	WINAPI	AjcDibCreate		(int width, int height, int BitCount, PAJCDIBINFO pBuf);
AJCEXPORT BOOL		WINAPI	AjcDibClear			(PAJCDIBINFO pDibInfo, COLORREF rgb);

AJCEXPORT BOOL		WINAPI	AjcDibCopyBitmap	(PAJCDIBINFO pDibInfo, int dpx, int dpy, int dcx, int dcy, HBITMAP hBitmap , int spx, int spy, int scx, int scy, int rop);
AJCEXPORT BOOL		WINAPI	AjcDibCopyBitmapV	(PAJCDIBINFO pDibInfo, const RECT *rcDest				 , HBITMAP hBitmap , const RECT *rcSrc				   , int rop);

AJCEXPORT BOOL		WINAPI	AjcDibCorrectedCopy	(PAJCDIBINFO pDibDest, int dpx, int dpy, int dcx, int dcy, PAJCDIBINFO pDibSrc , int spx, int spy  , COLORREF rgbBase, double distance);
AJCEXPORT BOOL		WINAPI	AjcDibCorrectedCopyV(PAJCDIBINFO pDibDest, const RECT *rcDest				 , PAJCDIBINFO pDibSrc , const POINT *ptSrc, COLORREF rgbBase, double distance);

AJCEXPORT BOOL		WINAPI	AjcDibExcludedCopy 	(PAJCDIBINFO pDibDest, int dpx, int dpy, int dcx, int dcy, PAJCDIBINFO pDibSrc , int spx, int spy  , COLORREF rgbBase, double distance);
AJCEXPORT BOOL		WINAPI	AjcDibExcludedCopyV (PAJCDIBINFO pDibDest, const RECT *rcDest				 , PAJCDIBINFO pDibSrc , const POINT *ptSrc, COLORREF rgbBase, double distance);

AJCEXPORT BOOL		WINAPI	AjcDibSelectedCopy 	(PAJCDIBINFO pDibDest, int dpx, int dpy, int dcx, int dcy, PAJCDIBINFO pDibSrc , int spx, int spy, int OpeNum, ...);
#define AjcDibSelectedCopyV(pDibDest, rcDest, pDibSrc , ptSrc, OpeNum, ...)												\
	AjcDibSelectedCopy(pDibDest, rcDest->left, rcDest->top, rcDest->right - rcDest->left, rcDest->bottom - rcDest->top,	\
					   pDibSrc , ptSrc ->x	 , ptSrc ->y  , OpeNum, __VA_ARGS__)

AJCEXPORT int		WINAPI	AjcDibColorCount	(PAJCDIBINFO pDibDest, int x, int y, int cx, int cy, COLORREF rgbBase, double distance);
AJCEXPORT int		WINAPI	AjcDibColorCountV	(PAJCDIBINFO pDibInfo, const RECT *rcArea		   , COLORREF rgbBase, double distance);

AJCEXPORT HBITMAP 	WINAPI	AjcDibReadFileAndCreateA(C_BCP pFilePath, PAJCDIBINFO pBuf);
AJCEXPORT HBITMAP 	WINAPI	AjcDibReadFileAndCreateW(C_WCP pPilePath, PAJCDIBINFO pBuf);

AJCEXPORT BOOL		WINAPI	AjcDibFillRect		(PAJCDIBINFO pDibInfo, int x, int y, int cx, int cy, COLORREF rgb);
AJCEXPORT BOOL		WINAPI	AjcDibFillRectV		(PAJCDIBINFO pDibInfo, const RECT *pRect           , COLORREF rgb);

AJCEXPORT COLORREF	WINAPI	AjcDibGetPixel		(PAJCDIBINFO pDibInfo, int x, int y);
AJCEXPORT COLORREF	WINAPI	AjcDibGetPixelV		(PAJCDIBINFO pDibInfo, const POINT *pt);

AJCEXPORT BOOL		WINAPI	AjcDibSetPixel		(PAJCDIBINFO pDibInfo, int x, int y   , COLORREF rgb);
AJCEXPORT BOOL		WINAPI	AjcDibSetPixelV		(PAJCDIBINFO pDibInfo, const POINT *pt, COLORREF rgb);

AJCEXPORT UBP		WINAPI	AjcDibGetLinrPtr	(PAJCDIBINFO pDibInfo, int y);

/****************************************************************************************************************/
#endif

