﻿#ifndef	AJCDLGCOLOR_H_
#define	AJCDLGCOLOR_H_
/****************************************************************************************************************/

//--------------------------------------------------------------------------------------------------------------//
//	ダイアログ，コントロール群の描画色																			//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	COLORREF	ccBkGnd;			//	ウインド背景色
	COLORREF	ccTextColor;		//	テキスト色
	COLORREF	ccGrayText;			//	無効テキスト色
	COLORREF	ccLtGray;			//	薄い影
	COLORREF	ccGray;				//	通常影
	COLORREF	ccDark;				//	暗い影
	COLORREF	ccBright;			//	明るい色
	COLORREF	ccHatch;			//	ハッチ模様（BS_PUSHLIKEスタイル時のハッチ色）
	COLORREF	ccDefOutL;			//	デフォルトプッシュボタンの外枠
} AJCDLGCOLORS, *PAJCDLGCOLORS;
typedef const AJCDLGCOLORS *PCAJCDLGCOLORS;

//--------------------------------------------------------------------------------------------------------------//
//	メニューの描画色																							//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	COLORREF	std;	//	通常色
	COLORREF	sel;	//	選択時の色
	COLORREF	dis;	//	無効時の色
	COLORREF	both;	//	無効＆選択時の色
} AJCSTACOLORS, *PAJCSTACOLORS;
typedef const AJCSTACOLORS *PCAJCSTACOLORS;

typedef struct {
	AJCSTACOLORS	ccBkColor;		//	背景色
	AJCSTACOLORS	ccBkOnBar;		//	メニューバー項目の背景色
	AJCSTACOLORS	ccTextColor;	//	テキスト色
	AJCSTACOLORS	ccChkMark;		//	チェックマーク／ラジオボタン色
	AJCSTACOLORS	ccChkBack;		//	チェックマーク／ラジオボタンの背景色
	AJCSTACOLORS	ccBitmap;		//	ビットマップ色
	AJCSTACOLORS	ccTriangle;		//	サブメニューインジケータ（三角マーク）の色
	COLORREF		ccSepLine;		//	セパレータラインの色
	COLORREF		ccUnderLine;	//	ウインドメニューの下線色（-1:下線非表示）
} AJCMENUCOLORS, *PAJCMENUCOLORS;
typedef const AJCMENUCOLORS *PCAJCMENUCOLORS;

//--------------------------------------------------------------------------------------------------------------//
//	個別のウインド描画色（AJCM_CTLCOLOR_{BTN / ANY / LSI} / AJCM_CTLDRAW_LSI メッセージのwParam）				//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	HBRUSH		hBrush;			//	背景のブラシハンドル
	COLORREF	TextColor;		//	テキスト色
	COLORREF	BkColor;		//	文字背景色（-1:透明）
} AJCDGCCTLCOLOR, *PAJCDGCCTLCOLOR;
typedef const AJCDGCCTLCOLOR *PCAJCDGCCTLCOLOR;

//--------------------------------------------------------------------------------------------------------------//
//	描画情報（AJCM_CTLCOLOR_LSI / AJCM_CTLDRAW_LSI メッセージのlParam）											//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	UI		kind;				//	コントロール種別(ODT_XXXXX)
	UI		id;					//	コントロールのＩＤ(IDC_XXXXX)
	UI		ix;					//	リストボックス／コンボボックス項目のインデクス（０～）
	UI		act;				//	必要な描画アクション(ODA_XXXXX)
	UI		state;				//	現在の描画アクションが実行された後のアイテムの表示状態(ODS_XXXXX)
	HWND	hWnd;				//	リストボックス／コンボボックスのウインドハンドル
	HDC		hDC;				//	デバイス コンテキストへのハンドル
	RECT	rect;				//	描画するコントロールの境界を定義する四角形
	UX		data;				//	リストボックス／コンボボックス項目に関連つけられたデータ
	HWND	hLbx;				//	拡張リストボックスコントロールのハンドル
	UI		idLbx;				//	拡張リストボックスコントロールのＩＤ
	BOOL	fDrawn;				//	描画済フラグ（AJCM_CTLDRAW_LSIメッセージ時のみ有効）
} AJCDGCDRAWITEM, *PAJCDGCDRAWITEM;
typedef const AJCDGCDRAWITEM *PCAJCDGCDRAWITEM;

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcDgcSetup(VO);

AJCEXPORT BOOL	 WINAPI AjcDgcSetColors  (COLORREF BkGround, COLORREF TextColor);

AJCEXPORT BOOL	 WINAPI AjcDgcSetColors(COLORREF BkColor, COLORREF TextColor);
AJCEXPORT BOOL	 WINAPI AjcDgcGetColorInfo(PAJCDLGCOLORS  pCtlColors, PAJCMENUCOLORS pMnuColors);
AJCEXPORT BOOL	 WINAPI AjcDgcSetColorInfo(PCAJCDLGCOLORS pCtlColors, PCAJCMENUCOLORS pMnuColors);
AJCEXPORT BOOL	 WINAPI AjcDgcGetShowFocus(VO);
AJCEXPORT BOOL	 WINAPI AjcDgcSetShowFocus(BOOL fShow);
AJCEXPORT HFONT	 WINAPI AjcDgcGetMenuFont(VO);
AJCEXPORT BOOL	 WINAPI AjcDgcSetMenuFont(HFONT hFont);

AJCEXPORT BOOL	 WINAPI AjcDgcSubclass	(HWND hDlg);
AJCEXPORT BOOL	 WINAPI AjcDgcSubclassEx(HWND hDlg, COLORREF ccBmpTransparent);
AJCEXPORT BOOL	 WINAPI AjcDgcSuppressSubclassing(HWND hDlg);

AJCEXPORT BOOL	 WINAPI AjcDgcMakeMenuOwnerDraw(HMENU hMenu, HWND hOwner);
AJCEXPORT BOOL	 WINAPI AjcDgcTrackPopupMenu  (HMENU hMenu, UI uFlags, int x, int y, int nReserved, HWND hWnd, const RECT *prcRect);
AJCEXPORT BOOL	 WINAPI AjcDgcTrackPopupMenuEx(HMENU hMenu, UI uFlags, int x, int y, HWND hWnd, LPTPMPARAMS lptpm);


AJCEXPORT BOOL	 WINAPI AjcDgcGetSbcButtonStyle(HWND hwnd, UIP pStyle);
AJCEXPORT BOOL	 WINAPI AjcDgcSetSbcButtonStyle(HWND hwnd, UI style);

AJCEXPORT UI	 WINAPI AjcDgcIsSubclassed(HWND hwnd);


/****************************************************************************************************************/
#endif
