﻿#ifndef	AJCFFT_H_
#define	AJCFFT_H_
/****************************************************************************************************************/
//--------------------------------------------------------------------------------------------------------------//
//	インスタンスワーク																							//
//--------------------------------------------------------------------------------------------------------------//
typedef  struct {
	UI					InstID;				//	インスタンス識別ＩＤ
	int					n;					//	サンプルデータ数
	double				*pSinTbl;			//	ＦＦＴ計算用三角関数表のアドレス
	int					*pRevTbl;			//	ＦＦＴ計算用ビット反転票のアドレス
} AJCFFT, *HAJCFFT;

//--------------------------------------------------------------------------------------------------------------//
//	プロトタイプ																								//
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	HAJCFFT		WINAPI	AjcFftCreate(int n);
AJCEXPORT	BOOL		WINAPI	AjcFftDelete(HAJCFFT hFft);
AJCEXPORT	BOOL		WINAPI	AjcFftCalc  (HAJCFFT hFft, PAJCCOMPLEX pData, BOOL fInverse);

AJCEXPORT	BOOL		WINAPI	AjcFftMakeTable  (double *pSinTbl, int *pRevTbl, int n);
AJCEXPORT	BOOL		WINAPI	AjcFftCalcByTbl  (PAJCCOMPLEX pData, int n, const double *pSinTbl, const int *pRevTbl, BOOL fInverse);


/****************************************************************************************************************/
#endif
